/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class NamingConventions {
    public static boolean VERBOSE = false;
    private static HashMap extensionMapper;
    private String id;

    public NamingConventions(String id) {
        this.id = id;
        NamingConventions.addExtensionMapping("tar.gz", "tgz");
        NamingConventions.addExtensionMapping("tar.bz2", "tbz");
    }

    public String getID() {
        return this.id;
    }

    public static void addExtensionMapping(String extension, String mapping) {
        if (extensionMapper == null) {
            extensionMapper = new HashMap();
        }
        if (!extensionMapper.containsKey(extension)) {
            extensionMapper.put(extension, mapping);
        }
    }

    public static String getExtensionMapping(String extension) {
        if (extensionMapper == null) {
            return null;
        }
        return (String)extensionMapper.get(extension);
    }

    public void startRenaming(ISO9660Directory dir2) {
        if (VERBOSE) {
            System.out.print(String.valueOf(this.id) + ": Renamed directory " + dir2.getISOPath());
        }
    }

    public void startRenaming(ISO9660File file) {
        if (VERBOSE) {
            System.out.print(String.valueOf(this.id) + ": Renamed file " + file.getISOPath());
        }
    }

    public void endRenaming(ISO9660Directory dir2) {
        if (VERBOSE) {
            System.out.println(" to " + dir2.getName());
        }
    }

    public void endRenaming(ISO9660File file) {
        if (VERBOSE) {
            System.out.println(" to " + file.getFullName());
        }
    }

    public void setFilename(ISO9660Directory dir2, String filename) {
        if (!filename.equals(dir2.getName())) {
            this.startRenaming(dir2);
            dir2.setName(filename);
            this.endRenaming(dir2);
        }
    }

    public void setFilename(ISO9660File file, String filename) {
        if (!filename.equals(file.getFilename())) {
            this.startRenaming(file);
            file.setFilename(filename);
            this.endRenaming(file);
        }
    }

    public void setFilename(ISO9660File file, String filename, String extension) {
        if (!filename.equals(file.getFilename()) || !extension.equals(file.getExtension())) {
            this.startRenaming(file);
            file.setFilename(filename);
            file.setExtension(extension);
            this.endRenaming(file);
        }
    }

    public void incrementFilename(ISO9660Directory dir2) throws HandlerException {
        String filename = dir2.getName();
        if (filename.length() > 0) {
            int position;
            int number = -1;
            for (position = filename.length() - 1; position >= 0; --position) {
                try {
                    number = Integer.parseInt(filename.substring(position, filename.length()));
                    continue;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            if (number >= 0) {
                filename = position > 0 ? filename.substring(0, position + 1) : "";
                filename = String.valueOf(filename) + ++number;
            } else {
                ISO9660Directory copy = new ISO9660Directory(String.valueOf(filename) + "2");
                this.apply(copy);
                filename = this.checkFilenameEquality(copy.getName(), filename) ? String.valueOf(filename.substring(0, filename.length())) + "2" : copy.getName();
            }
        } else {
            filename = "2";
        }
        this.setFilename(dir2, filename);
    }

    public void incrementFilename(ISO9660File file) throws HandlerException {
        String filename = file.getFilename();
        if (filename.length() > 0) {
            int position;
            int number = -1;
            for (position = filename.length() - 1; position >= 0; --position) {
                try {
                    number = Integer.parseInt(filename.substring(position, filename.length()));
                    continue;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            if (number >= 0) {
                filename = position > 0 ? filename.substring(0, position + 1) : "";
                filename = String.valueOf(filename) + ++number;
            } else {
                ISO9660File copy = null;
                try {
                    copy = new ISO9660File(file);
                }
                catch (HandlerException e) {
                    e.printStackTrace();
                }
                this.apply(copy);
                filename = this.checkFilenameEquality(copy.getFilename(), filename) ? String.valueOf(filename.substring(0, filename.length())) + "2" : copy.getFilename();
            }
        } else {
            filename = "2";
        }
        this.setFilename(file, filename);
    }

    public boolean checkFilenameEquality(String name1, String name2) {
        return name1.equals(name2);
    }

    public void processDirectory(ISO9660Directory dir2) throws HandlerException {
        Vector duplicates = new Vector();
        Vector contents = new Vector();
        contents.addAll(dir2.getDirectories());
        contents.addAll(dir2.getFiles());
        Collections.sort(contents);
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            boolean duplicate = false;
            Object object = it.next();
            if (object instanceof ISO9660Directory) {
                ISO9660Directory subdir = (ISO9660Directory)object;
                this.apply(subdir);
                while (this.checkDuplicate(duplicates, subdir.getName(), -1)) {
                    this.incrementFilename(subdir);
                    duplicate = true;
                }
                if (!duplicate) {
                    duplicates.clear();
                }
                this.addDuplicate(duplicates, subdir.getName(), -1);
                this.checkPathLength(subdir.getISOPath());
                continue;
            }
            if (object instanceof ISO9660File) {
                ISO9660File file = (ISO9660File)object;
                this.apply(file);
                while (this.checkDuplicate(duplicates, file.getName(), file.getVersion())) {
                    this.incrementFilename(file);
                    duplicate = true;
                }
                if (!duplicate) {
                    duplicates.clear();
                }
                this.addDuplicate(duplicates, file.getName(), file.getVersion());
                this.checkPathLength(file.getISOPath());
                continue;
            }
            throw new HandlerException("Neither file nor directory: " + object);
        }
    }

    public boolean checkDuplicate(Vector duplicates, String name, int version) {
        return this.checkDuplicate(duplicates, name, version, true);
    }

    public boolean checkDuplicate(Vector duplicates, String name, int version, boolean checkVersion) {
        int i = 0;
        while (i < duplicates.size()) {
            String[] data = (String[])duplicates.get(i);
            if (this.checkFilenameEquality(data[0], name)) {
                int aVersion = Integer.parseInt(data[1]);
                if (!checkVersion || aVersion == -1 || version == aVersion) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void addDuplicate(Vector duplicates, String name, int version) {
        String[] data = new String[]{name, String.valueOf(version)};
        duplicates.add(data);
    }

    public abstract void apply(ISO9660Directory var1) throws HandlerException;

    public abstract void apply(ISO9660File var1) throws HandlerException;

    public abstract void checkPathLength(String var1);
}

