/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660HierarchyObject;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISO9660File
extends File
implements ISO9660HierarchyObject {
    public static final Pattern FILEPATTERN = Pattern.compile("^([^.]+)\\.(.+)$");
    private boolean enforceDotDelimiter = false;
    private static final long serialVersionUID = 1L;
    private String filename;
    private String extension;
    private int version;
    private boolean enforce8plus3;
    private boolean isMovedDirectory;
    private ISO9660Directory parent;
    private Object id;

    public ISO9660File(File file, int version) throws HandlerException {
        super(file.getPath());
        this.setName(file.getName());
        this.setVersion(version);
        this.id = new Object();
        this.enforce8plus3 = false;
        this.isMovedDirectory = false;
        if (this.isDirectory()) {
            throw new HandlerException("Cannot wrap a directory in " + this.getClass());
        }
    }

    public ISO9660File(String pathname, int version) throws HandlerException {
        super(pathname);
        this.setName(super.getName());
        this.setVersion(version);
        this.id = new Object();
        this.enforce8plus3 = false;
        this.isMovedDirectory = false;
        if (this.isDirectory()) {
            throw new HandlerException("Cannot wrap a directory in " + this.getClass());
        }
    }

    public ISO9660File(File file) throws HandlerException {
        this(file, 1);
    }

    public ISO9660File(String pathname) throws HandlerException {
        this(pathname, 1);
    }

    public String getFilename() {
        if (this.enforce8plus3) {
            return this.filename.substring(0, 8);
        }
        return this.filename;
    }

    public String getExtension() {
        if (this.enforce8plus3) {
            return this.extension.substring(0, 3);
        }
        return this.extension;
    }

    public String getName() {
        if (this.isMovedDirectory()) {
            return this.filename;
        }
        if (!this.extension.equals("") || this.enforceDotDelimiter) {
            return String.valueOf(this.filename) + "." + this.extension;
        }
        return this.filename;
    }

    public void setIsMovedDirectory() {
        this.isMovedDirectory = true;
    }

    public boolean isMovedDirectory() {
        return this.isMovedDirectory;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        if (this.parent != null) {
            this.parent.forceSort();
        }
    }

    public void setExtension(String extension) {
        this.extension = extension;
        if (this.parent != null) {
            this.parent.forceSort();
        }
    }

    public void setName(String name) {
        Matcher m = FILEPATTERN.matcher(name);
        if (m.matches()) {
            this.filename = m.group(1);
            this.extension = m.group(2);
        } else {
            this.filename = name;
            this.extension = "";
        }
        if (this.parent != null) {
            this.parent.forceSort();
        }
    }

    public String getFullName() {
        if (this.isMovedDirectory()) {
            return this.filename;
        }
        return String.valueOf(this.getName()) + ";" + this.getVersion();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) throws HandlerException {
        if (version < 1 || version > Short.MAX_VALUE) {
            throw new HandlerException("Invalid file version: " + version);
        }
        this.version = version;
        if (this.parent != null) {
            this.parent.forceSort();
        }
    }

    public boolean enforces8plus3() {
        return this.enforce8plus3;
    }

    public void enforce8plus3(boolean force) {
        this.enforce8plus3 = force;
    }

    public boolean enforcesDotDelimiter() {
        return this.enforceDotDelimiter;
    }

    public void enforceDotDelimiter(boolean force) {
        this.enforceDotDelimiter = force;
    }

    public int compareTo(Object object) throws ClassCastException, NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof ISO9660File) {
            int test;
            ISO9660File file = (ISO9660File)object;
            if (this.getName().equalsIgnoreCase(file.getName())) {
                if (this.version > file.getVersion()) {
                    return -1;
                }
                if (this.version < file.getVersion()) {
                    return 1;
                }
            }
            if ((test = this.getFilename().toUpperCase().compareTo(file.getFilename().toUpperCase())) != 0) {
                return test;
            }
            return this.getExtension().toUpperCase().compareTo(file.getExtension().toUpperCase());
        }
        if (object instanceof ISO9660Directory) {
            ISO9660Directory dir2 = (ISO9660Directory)object;
            return this.getFullName().toUpperCase().compareTo(dir2.getName().toUpperCase());
        }
        throw new ClassCastException();
    }

    public boolean equals(Object toCompare) {
        if (toCompare instanceof ISO9660File) {
            return ((ISO9660File)toCompare).getContentID().equals(this.getContentID());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    void setParentDirectory(ISO9660Directory parent) {
        this.parent = parent;
    }

    public ISO9660Directory getParentDirectory() {
        return this.parent;
    }

    public String getISOPath() throws NullPointerException {
        if (this.parent == null) {
            throw new NullPointerException("Cannot determine path without parent directory.");
        }
        return String.valueOf(this.parent.getISOPath()) + File.separator + this.getFullName();
    }

    public Object getID() {
        return this.id;
    }

    public Object getContentID() {
        return new Integer(this.hashCode());
    }

    public ISO9660RootDirectory getRoot() throws NullPointerException {
        if (this.getParentDirectory() == null) {
            throw new NullPointerException("Cannot determine root without parent directory.");
        }
        return this.getParentDirectory().getRoot();
    }

    public Object clone() {
        ISO9660File clone = null;
        try {
            clone = (ISO9660File)super.clone();
            clone.id = this.id;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

