/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class ISO9660DirectoryIterator
implements Iterator {
    private Vector dirCollection = new Vector();
    private Iterator dirCollectionIterator;

    public ISO9660DirectoryIterator(ISO9660Directory start, boolean sort) {
        if (sort) {
            this.setupSorted(start);
        } else {
            this.setupUnsorted(start);
        }
        this.reset();
    }

    public ISO9660DirectoryIterator(ISO9660Directory start) {
        this(start, true);
    }

    private void setupSorted(ISO9660Directory start) {
        Vector dirs = start.getDirectories();
        if (dirs.size() > 0) {
            LinkedList queue = new LinkedList();
            this.dirCollection.addAll(dirs);
            queue.addAll(dirs);
            while (!queue.isEmpty()) {
                ISO9660Directory dir2 = (ISO9660Directory)queue.removeFirst();
                dirs = dir2 == dir2.getRoot().getMovedDirectoriesStore() ? dir2.getDirectories() : this.checkMoved(dir2.getDirectories());
                this.dirCollection.addAll(dirs);
                queue.addAll(dirs);
            }
        }
    }

    private Vector checkMoved(Vector dirs) {
        Vector copy = new Vector(dirs);
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            if (!dir2.isMoved()) continue;
            copy.remove(dir2);
        }
        return copy;
    }

    private void setupUnsorted(ISO9660Directory start) {
        Iterator it = start.getDirectories().iterator();
        while (it.hasNext()) {
            this.setupUnsorted((ISO9660Directory)it.next());
        }
        this.dirCollection.add(start);
    }

    public boolean hasNext() {
        return this.dirCollectionIterator.hasNext();
    }

    public Object next() {
        return this.dirCollectionIterator.next();
    }

    public void remove() {
        this.dirCollectionIterator.remove();
    }

    public void reset() {
        this.dirCollectionIterator = this.dirCollection.iterator();
    }
}

