/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660DirectoryIterator;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660HierarchyObject;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class ISO9660Directory
implements ISO9660HierarchyObject {
    private String name;
    private int level;
    private Vector files;
    private Vector directories;
    private ISO9660Directory parent;
    private ISO9660RootDirectory root;
    private long lastModified;
    private boolean sorted;
    private Object id;
    ISO9660DirectoryIterator sortedIterator;
    ISO9660DirectoryIterator unsortedIterator;

    public ISO9660Directory(String name) {
        this.init();
        this.name = name;
    }

    public ISO9660Directory(File file) throws HandlerException {
        this.init();
        if (!file.isDirectory()) {
            throw new HandlerException("Not a directory: " + file);
        }
        this.name = file.getName();
        this.lastModified = file.lastModified();
    }

    private void init() {
        this.files = new Vector();
        this.directories = new Vector();
        this.level = 1;
        this.parent = this;
        this.name = "";
        this.lastModified = new Date().getTime();
        this.sorted = false;
        this.id = new Object();
    }

    public void setName(String name) {
        this.name = name;
        if (this.parent != this) {
            this.parent.forceSort();
        }
    }

    public String getName() {
        return this.name;
    }

    private void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    void setRoot(ISO9660RootDirectory root) {
        this.root = root;
    }

    public ISO9660RootDirectory getRoot() {
        return this.root;
    }

    public ISO9660Directory getParentDirectory() {
        return this.parent;
    }

    void setParentDirectory(ISO9660Directory parent) {
        this.parent = parent;
    }

    public Vector getFiles() {
        if (!this.sorted) {
            this.sort();
        }
        return this.files;
    }

    public Vector getDirectories() {
        if (!this.sorted) {
            this.sort();
        }
        return this.directories;
    }

    public boolean hasSubDirs() {
        return this.directories.size() > 0;
    }

    public String getISOPath() {
        StringBuffer buf = new StringBuffer();
        this.getISOPath(buf);
        return buf.toString();
    }

    private void getISOPath(StringBuffer buf) {
        ISO9660Directory parent = this.getParentDirectory();
        if (parent == this) {
            return;
        }
        parent.getISOPath(buf);
        buf.append(File.separator);
        buf.append(this.getName());
    }

    int deepLevelCount() {
        int count = this.level;
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            count = Math.max(count, dir2.deepLevelCount());
        }
        return count;
    }

    int deepFileCount() {
        int count = this.files.size();
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            count += dir2.deepFileCount();
        }
        return count;
    }

    int deepDirCount() {
        int count = this.directories.size();
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            count += dir2.deepDirCount();
        }
        return count;
    }

    public ISO9660Directory addDirectory(ISO9660Directory dir2) {
        dir2.setLevel(this.level + 1);
        dir2.setParentDirectory(this);
        dir2.setRoot(this.root);
        this.directories.add(dir2);
        this.sorted = false;
        return dir2;
    }

    public ISO9660Directory addDirectory(File file) throws HandlerException {
        ISO9660Directory dir2 = new ISO9660Directory(file);
        return this.addDirectory(dir2);
    }

    public ISO9660Directory addDirectory(String name) {
        ISO9660Directory dir2 = new ISO9660Directory(name);
        return this.addDirectory(dir2);
    }

    public ISO9660Directory addPath(String path) throws HandlerException {
        ISO9660Directory dir2 = null;
        if (path.indexOf(File.separator) == -1) {
            return this.checkDirectory(path);
        }
        int frontSeparatorIndex = path.indexOf(File.separator);
        String dirName = path.substring(0, frontSeparatorIndex);
        dir2 = this.checkDirectory(dirName);
        String rest = path.substring(frontSeparatorIndex + 1);
        dir2 = dir2.addPath(rest);
        return dir2;
    }

    private ISO9660Directory checkDirectory(String name) throws HandlerException {
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            if (!dir2.getName().equals(name)) continue;
            return dir2;
        }
        return this.addDirectory(name);
    }

    public void forceSort() {
        this.sorted = false;
    }

    private void sort() {
        Collections.sort(this.files);
        Collections.sort(this.directories);
        this.sorted = true;
    }

    public void addFile(ISO9660File file) {
        file.setParentDirectory(this);
        this.files.add(file);
        this.sorted = false;
    }

    public void addFile(File file, int version) throws HandlerException {
        this.addFile(new ISO9660File(file, version));
    }

    public void addFile(File file) throws HandlerException {
        this.addFile(new ISO9660File(file));
    }

    public void addFile(String pathname, int version) throws HandlerException {
        this.addFile(new ISO9660File(pathname, version));
    }

    public void addFile(String pathname) throws HandlerException {
        this.addFile(new ISO9660File(pathname));
    }

    public void addRecursively(File file) throws HandlerException {
        this.addRecursively(file, true, this);
    }

    public void addContentsRecursively(File file) throws HandlerException {
        this.addRecursively(file, false, this);
    }

    private void addRecursively(File file, boolean addItself, ISO9660Directory parent) throws HandlerException {
        if (!file.isDirectory() && addItself) {
            parent.addFile(file);
            return;
        }
        ISO9660Directory dir2 = parent;
        if (addItself) {
            dir2 = parent.addDirectory(file);
        }
        File[] files2 = file.listFiles();
        int i = 0;
        while (i < files2.length) {
            this.addRecursively(files2[i], true, dir2);
            ++i;
        }
    }

    public int compareTo(Object object) throws ClassCastException, NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object.equals(this)) {
            return 0;
        }
        if (object instanceof ISO9660Directory) {
            ISO9660Directory dir2 = (ISO9660Directory)object;
            return this.getName().toUpperCase().compareTo(dir2.getName().toUpperCase());
        }
        if (object instanceof ISO9660File) {
            ISO9660File file = (ISO9660File)object;
            return this.getName().toUpperCase().compareTo(file.getFullName().toUpperCase());
        }
        throw new ClassCastException();
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isMoved() {
        return this.parent == this.root.getMovedDirectoriesStore();
    }

    public ISO9660Directory relocate() {
        ISO9660Directory movedDirectoriesStore = this.root.getMovedDirectoriesStore();
        ISO9660Directory oldParent = this.parent;
        int oldLevel = this.level;
        movedDirectoriesStore.addDirectory(this);
        int difference = oldLevel - this.getLevel();
        Iterator it = this.unsortedIterator();
        while (it.hasNext()) {
            ISO9660Directory subdir = (ISO9660Directory)it.next();
            subdir.setLevel(subdir.getLevel() - difference);
        }
        return oldParent;
    }

    public Object getID() {
        return this.id;
    }

    public Object clone() {
        ISO9660Directory clone = null;
        try {
            clone = (ISO9660Directory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.level = this.level;
        clone.directories = new Vector();
        clone.files = new Vector();
        clone.id = this.id;
        clone.sortedIterator = null;
        clone.sorted = false;
        Iterator dit = this.directories.iterator();
        while (dit.hasNext()) {
            ISO9660Directory subdir = (ISO9660Directory)dit.next();
            ISO9660Directory subdirClone = (ISO9660Directory)subdir.clone();
            subdirClone.setParentDirectory(clone);
            subdirClone.setLevel(this.level + 1);
            subdirClone.id = subdir.id;
            subdirClone.sortedIterator = null;
            subdirClone.sorted = false;
            clone.directories.add(subdirClone);
        }
        Iterator fit = this.files.iterator();
        while (fit.hasNext()) {
            ISO9660File file = (ISO9660File)fit.next();
            ISO9660File fileClone = (ISO9660File)file.clone();
            fileClone.setParentDirectory(clone);
            clone.files.add(fileClone);
        }
        return clone;
    }

    public Iterator sortedIterator() {
        if (this.sortedIterator == null) {
            this.sortedIterator = new ISO9660DirectoryIterator(this, true);
        }
        this.sortedIterator.reset();
        return this.sortedIterator;
    }

    public Iterator unsortedIterator() {
        if (this.unsortedIterator == null) {
            this.unsortedIterator = new ISO9660DirectoryIterator(this, false);
        }
        this.unsortedIterator.reset();
        return this.unsortedIterator;
    }
}

