/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.eltorito.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.eltorito.impl.ElToritoConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.eltorito.impl.ElToritoFactory;
import de.tu_darmstadt.informatik.rbg.hatlak.eltorito.impl.ElToritoLayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Element;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.LogicalSectorElement;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors.BootRecord;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Element;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ChainingStreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.FileDataReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ElToritoHandler
extends ChainingStreamHandler {
    private ElToritoConfig config;
    private Fixup bootCatalogLocation;
    private Fixup bootImageLocation;

    public ElToritoHandler(StreamHandler streamHandler, ElToritoConfig config) {
        super(streamHandler, streamHandler);
        this.config = config;
    }

    public void startElement(Element element) throws HandlerException {
        if (element instanceof ISO9660Element) {
            String id = (String)element.getId();
            this.process(id);
        }
        super.startElement(element);
    }

    private void process(String id) throws HandlerException {
        if (id.equals("VDS")) {
            this.doBVD();
        } else if (id.equals("BIA")) {
            this.doCatalog();
        }
        if (id.equals("BDA")) {
            this.doImage();
        }
    }

    private void doBVD() throws HandlerException {
        super.startElement(new LogicalSectorElement("BR"));
        ElToritoLayoutHelper helper = new ElToritoLayoutHelper(this);
        BootRecord br = new BootRecord(this, helper);
        br.setMetadata(this.config);
        br.doBR();
        this.bootCatalogLocation = this.fixup(new LSBFWordDataReference(0L));
        super.endElement();
    }

    private void doCatalog() throws HandlerException {
        super.startElement(new LogicalSectorElement("BCAT"));
        long position = this.mark();
        int location = (int)(position / 2048L);
        this.bootCatalogLocation.data(new LSBFWordDataReference(location));
        this.bootCatalogLocation.close();
        ElToritoFactory etf = new ElToritoFactory(this);
        int platformID = this.config.getPlatformID();
        String idString = this.config.getIDString();
        etf.doValidationEntry(platformID, idString);
        boolean bootable = this.config.getBootable();
        int bootMediaType = this.config.getBootMediaType();
        int loadSegment = this.config.getLoadSegment();
        int systemType = this.config.getSystemType();
        int sectorCount = this.config.getSectorCount();
        this.bootImageLocation = etf.doDefaultEntry(bootable, bootMediaType, loadSegment, systemType, sectorCount);
        super.endElement();
    }

    private void doImage() throws HandlerException {
        super.startElement(new LogicalSectorElement("BIMG"));
        long position = this.mark();
        int location = (int)(position / 2048L);
        this.bootImageLocation.data(new LSBFWordDataReference(location));
        this.bootImageLocation.close();
        if (this.config.getGenBootInfoTable()) {
            this.genBootInfoTable(location);
        }
        FileDataReference fdr = new FileDataReference(this.config.getBootImage());
        this.data(fdr);
        super.endElement();
    }

    private void genBootInfoTable(int lba) throws HandlerException {
        try {
            String orgName = this.config.getBootImage().getAbsolutePath();
            File orgFile = new File(orgName);
            FileInputStream fis = new FileInputStream(orgFile);
            fis.skip(64L);
            long checksum = 0L;
            byte[] buffer = new byte[8192];
            while (fis.available() > 0) {
                int len = fis.read(buffer);
                int i = 0;
                while (i < len) {
                    long temp = buffer[i++] & 0xFF;
                    temp |= (long)(buffer[i++] << 8 & 0xFF00);
                    temp |= (long)(buffer[i++] << 16 & 0xFF0000);
                    checksum += (temp |= (long)(buffer[i++] << 24) & 0xFF000000L);
                }
            }
            fis.close();
            fis = new FileInputStream(orgFile);
            File patchedFile = new File(String.valueOf(orgName) + ".mod");
            FileOutputStream fos = new FileOutputStream(patchedFile);
            buffer = new byte[8];
            fis.read(buffer);
            fos.write(buffer);
            buffer = new byte[56];
            fis.read(buffer);
            Arrays.fill(buffer, (byte)0);
            int i = 0;
            int pvd = 16;
            buffer[i++] = (byte)(pvd & 0xFF);
            buffer[i++] = (byte)(pvd >> 8 & 0xFF);
            buffer[i++] = (byte)(pvd >> 16 & 0xFF);
            buffer[i++] = (byte)(pvd >> 24 & 0xFF);
            buffer[i++] = (byte)(lba & 0xFF);
            buffer[i++] = (byte)(lba >> 8 & 0xFF);
            buffer[i++] = (byte)(lba >> 16 & 0xFF);
            buffer[i++] = (byte)(lba >> 24 & 0xFF);
            int len = (int)this.config.getBootImage().getAbsoluteFile().length();
            buffer[i++] = (byte)(len & 0xFF);
            buffer[i++] = (byte)(len >> 8 & 0xFF);
            buffer[i++] = (byte)(len >> 16 & 0xFF);
            buffer[i++] = (byte)(len >> 24 & 0xFF);
            buffer[i++] = (byte)(checksum & 0xFFL);
            buffer[i++] = (byte)(checksum >> 8 & 0xFFL);
            buffer[i++] = (byte)(checksum >> 16 & 0xFFL);
            buffer[i++] = (byte)(checksum >> 24 & 0xFFL);
            fos.write(buffer);
            buffer = new byte[8192];
            while (fis.available() > 0) {
                len = fis.read(buffer);
                fos.write(buffer, 0, len);
            }
            fis.close();
            fos.close();
            orgFile.delete();
            orgFile = new File(orgName);
            patchedFile.renameTo(orgFile);
            this.config.setBootImage(new ISO9660File(orgFile));
            System.out.println("Patched boot image at " + orgFile.getPath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

