/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.eltorito.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.EmptyByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFShortDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;

public class ElToritoFactory {
    private StreamHandler streamHandler;

    public ElToritoFactory(StreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    public void doValidationEntry(int platformID, String idString) throws HandlerException {
        int sum = 0;
        this.streamHandler.data(new ByteDataReference(1L));
        ++sum;
        this.streamHandler.data(new ByteDataReference(platformID));
        sum += platformID << 8;
        this.streamHandler.data(new EmptyByteArrayDataReference(2));
        byte[] idStringData = this.pad(idString, 24);
        this.streamHandler.data(new ByteArrayDataReference(idStringData));
        sum += this.stringWordSum(idStringData);
        int checksum = 65536 - (sum += 43605);
        this.streamHandler.data(new LSBFShortDataReference(checksum));
        this.streamHandler.data(new ByteDataReference(85L));
        this.streamHandler.data(new ByteDataReference(170L));
    }

    public Fixup doDefaultEntry(boolean bootable, int bootMediaType, int loadSegment, int systemType, int sectorCount) throws HandlerException {
        if (bootable) {
            this.streamHandler.data(new ByteDataReference(136L));
        } else {
            this.streamHandler.data(new ByteDataReference(0L));
        }
        this.streamHandler.data(this.getBootMediaType(bootMediaType));
        this.streamHandler.data(new LSBFShortDataReference(loadSegment));
        this.streamHandler.data(new ByteDataReference(systemType));
        this.streamHandler.data(new ByteDataReference(0L));
        this.streamHandler.data(new LSBFShortDataReference(sectorCount));
        Fixup loadRBA = this.streamHandler.fixup(new LSBFWordDataReference(0L));
        this.streamHandler.data(new EmptyByteArrayDataReference(19));
        return loadRBA;
    }

    public void doSectionHeader(boolean moreHeaders, int platformID, int sectionEntriesCount, String idString) throws HandlerException {
        if (moreHeaders) {
            this.streamHandler.data(new ByteDataReference(144L));
        } else {
            this.streamHandler.data(new ByteDataReference(145L));
        }
        this.streamHandler.data(new ByteDataReference(platformID));
        this.streamHandler.data(new LSBFShortDataReference(sectionEntriesCount));
        byte[] idStringData = this.pad(idString, 28);
        this.streamHandler.data(new ByteArrayDataReference(idStringData));
    }

    public Fixup doSectionEntry(boolean bootable, int bootMediaType, int loadSegment, int systemType, int sectorCount, boolean entryExtFollows, boolean containsATAPIDriver, boolean containsSCSIDriver, int selectionCriteriaType) throws HandlerException {
        if (bootable) {
            this.streamHandler.data(new ByteDataReference(136L));
        } else {
            this.streamHandler.data(new ByteDataReference(0L));
        }
        this.streamHandler.data(this.getExtendedBootMediaType(bootMediaType, entryExtFollows, containsATAPIDriver, containsSCSIDriver));
        this.streamHandler.data(new LSBFShortDataReference(loadSegment));
        this.streamHandler.data(new ByteDataReference(systemType));
        this.streamHandler.data(new ByteDataReference(0L));
        this.streamHandler.data(new LSBFShortDataReference(sectorCount));
        Fixup loadRBA = this.streamHandler.fixup(new LSBFWordDataReference(0L));
        this.streamHandler.data(new ByteDataReference(selectionCriteriaType));
        return loadRBA;
    }

    public void doSectionEntryExtension(boolean moreExtRecords) throws HandlerException {
        this.streamHandler.data(new ByteDataReference(68L));
        if (moreExtRecords) {
            this.streamHandler.data(new ByteDataReference(16L));
        } else {
            this.streamHandler.data(new ByteDataReference(0L));
        }
    }

    private byte[] pad(String string, int pad) {
        if (string.length() == pad) {
            return string.getBytes();
        }
        if (string.length() > pad) {
            return string.substring(0, pad).getBytes();
        }
        byte[] bytes = new byte[pad];
        byte[] original = string.getBytes();
        int i = 0;
        while (i < original.length) {
            bytes[i] = original[i];
            ++i;
        }
        i = original.length;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    private int stringWordSum(byte[] stringData) throws HandlerException {
        if (stringData.length % 2 != 0) {
            throw new HandlerException("stringWordSum expects even string length.");
        }
        int sum = 0;
        int i = 0;
        while (i < stringData.length) {
            sum += stringData[i];
            sum += stringData[i + 1] << 8;
            i += 2;
        }
        return sum;
    }

    private DataReference getBootMediaType(int bootMediaType) throws HandlerException {
        if (bootMediaType >= 0 && bootMediaType <= 4) {
            return new ByteDataReference(bootMediaType);
        }
        throw new HandlerException("Invalid Boot Media Type: " + bootMediaType);
    }

    private DataReference getExtendedBootMediaType(int bootMediaType, boolean entryExtFollows, boolean containsATAPIDriver, boolean containsSCSIDriver) throws HandlerException {
        int bits = 0;
        if (bootMediaType < 0 || bootMediaType > 4) {
            throw new HandlerException("Invalid Boot Media Type: " + bootMediaType);
        }
        bits = bootMediaType;
        if (entryExtFollows) {
            bits &= 0x10;
        }
        if (containsATAPIDriver) {
            bits &= 0x20;
        }
        if (containsSCSIDriver) {
            bits &= 0x40;
        }
        return new ByteDataReference(bits);
    }
}

