/*
 * Decompiled with CFR 0.152.
 */
package create;

import bsh2java.log;
import java.io.File;
import java.util.ArrayList;
import utils.files;

public class CreateFilesystem {
    Boolean isValid = false;
    File sourceFolder;
    File TargetFolder;
    public ArrayList<File> folderList;
    public ArrayList<File> fileList;
    ArrayList<String> ignoreList = new ArrayList();

    public void Scan(File sourceFolder) {
        if (!sourceFolder.exists()) {
            log.write(-1, "Folder %1 does not exist", sourceFolder.getAbsolutePath());
            return;
        }
        this.isValid = true;
        this.sourceFolder = sourceFolder;
        log.write(2, "Looking for files and folders at %1", sourceFolder.getAbsolutePath());
        this.folderList = files.findFolders(sourceFolder, 25);
        this.fileList = files.findFiles(sourceFolder, 25);
        this.fileList = this.removeIgnoredFiles();
        int count = this.folderList.size() + this.fileList.size();
        log.write(30, "Found %1 files and folders on %2", "" + count, sourceFolder.getAbsolutePath());
    }

    public void Apply(String folderTitle, File targetFolder) {
        String nameClean;
        String nameTarget;
        String nameOriginal;
        if (!targetFolder.exists()) {
            log.write(-1, "Folder %1 does not exist", targetFolder.getAbsolutePath());
            return;
        }
        File cloneFolder = new File(targetFolder, folderTitle);
        files.mkdirs(cloneFolder);
        int counter = 0;
        for (File folder : this.folderList) {
            nameOriginal = folder.getAbsolutePath();
            nameTarget = this.sourceFolder.getAbsolutePath();
            nameClean = nameOriginal.replace(nameTarget, "");
            File newFolder = new File(cloneFolder, nameClean);
            ++counter;
            files.mkdirs(newFolder);
        }
        log.write(2, "Copying files from %1 to %2, please wait..", targetFolder.getAbsolutePath(), cloneFolder.getAbsolutePath());
        for (File file : this.fileList) {
            nameOriginal = file.getAbsolutePath();
            nameTarget = this.sourceFolder.getAbsolutePath();
            nameClean = nameOriginal.replace(nameTarget, "");
            File newFile = new File(cloneFolder, nameClean);
            files.copyFile(file, newFile);
            ++counter;
        }
        if (counter > 1) {
            log.write(20, "Created %1 files and folders in %2", "" + counter, cloneFolder.getAbsolutePath());
        }
    }

    ArrayList<File> removeIgnoredFiles() {
        if (this.ignoreList.isEmpty()) {
            return this.fileList;
        }
        ArrayList<File> tempList = new ArrayList<File>();
        for (String ignored : this.ignoreList) {
            for (File file : this.fileList) {
                if (file.getName().equalsIgnoreCase(ignored)) continue;
                tempList.add(file);
            }
        }
        return tempList;
    }

    public void ignore(String filename) {
        this.ignoreList.add(filename);
    }
}

