/*
 * Decompiled with CFR 0.152.
 */
package create;

import bsh2java.log;
import java.io.File;
import rewim.WimBuilder;
import rewim.core.CompressMode;
import utils.files;

public class CreateBootableWIM {
    private boolean hadSuccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateBootableWIM(File source, File dest, String imageName, CompressMode compressMode) {
        log.write(9, "Creating a new WIM archive, using the files from %1 as source, compression \"%2\"", source.getName(), compressMode.toString());
        String customXML = null;
        File customFile = new File(source.getParent(), "custom.xml");
        if (customFile.exists()) {
            customXML = customFile.getAbsolutePath();
        }
        boolean bootable = true;
        this.hadSuccess = false;
        try (WimBuilder builder = new WimBuilder(source, dest, imageName);){
            builder.setCustomXML(customXML).setBootable(bootable).setCompressMode(compressMode);
            log.write(30, builder.showInfo());
            builder.build();
            this.hadSuccess = true;
            log.write(21, "The WIM file is available at %1 and is sized in %2.", dest.getAbsolutePath(), files.humanReadableSize(dest.length()));
            log.endBeep();
        }
    }

    public boolean checkSuccess() {
        return this.hadSuccess;
    }
}

