/*
 * Decompiled with CFR 0.152.
 */
package create;

import bsh2java.log;
import de.tu_darmstadt.informatik.rbg.hatlak.eltorito.impl.ElToritoConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.CreateISO;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Config;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISOImageFileHandler;
import de.tu_darmstadt.informatik.rbg.hatlak.joliet.impl.JolietConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.RockRidgeConfig;
import java.io.File;
import utils.ArtASCII;
import utils.Base64;
import utils.files;

public class CreateBootableISO {
    private String publisher = "http://reboot.pro";
    private String dataPreparer = "Nuno Brito";
    private String volumeId = "reboot";
    private String noemuString = "";
    private File noemu;
    private int bootSize = 4;
    private boolean enableJoliet = true;
    private boolean enableRockRidge = true;
    private boolean enableElTorito = true;
    private boolean restrictdirdepth8 = true;

    public void setVolumeId(String id) {
        this.volumeId = id;
    }

    public void setBootSize(int bootSize) {
        this.bootSize = bootSize;
    }

    public void setNoEmu(String nam) {
        this.noemuString = nam;
    }

    public void handleOption(String option) {
        if (option.equals("disable-joliet")) {
            this.enableJoliet = false;
        } else if (option.equals("no-restrict-dirdepth")) {
            this.restrictdirdepth8 = false;
        } else if (option.equals("disable-rockridge")) {
            this.enableRockRidge = false;
        } else if (option.equals("disable-eltorito")) {
            this.enableElTorito = false;
        }
    }

    public void Start(File sourceFolder, File newISOfile) {
        ISO9660RootDirectory.MOVED_DIRECTORIES_STORE_NAME = "rr_moved";
        ISO9660RootDirectory root = new ISO9660RootDirectory();
        try {
            if (sourceFolder.exists()) {
                if (sourceFolder.isDirectory()) {
                    root.addContentsRecursively(sourceFolder);
                } else {
                    root.addFile(sourceFolder);
                }
            }
            ISO9660Config iso9660Config = new ISO9660Config();
            iso9660Config.allowASCII(false);
            iso9660Config.setInterchangeLevel(1);
            iso9660Config.restrictDirDepthTo8(this.restrictdirdepth8);
            iso9660Config.setPublisher(this.publisher);
            iso9660Config.setVolumeID(this.volumeId);
            iso9660Config.setDataPreparer(this.dataPreparer);
            iso9660Config.forceDotDelimiter(true);
            RockRidgeConfig rrConfig = null;
            if (this.enableRockRidge) {
                rrConfig = new RockRidgeConfig();
                rrConfig.setMkisofsCompatibility(false);
                rrConfig.hideMovedDirectoriesStore(true);
                rrConfig.forcePortableFilenameCharacterSet(true);
            }
            JolietConfig jolietConfig = null;
            if (this.enableJoliet) {
                jolietConfig = new JolietConfig();
                jolietConfig.setPublisher(this.publisher);
                jolietConfig.setVolumeID(this.volumeId);
                jolietConfig.setDataPreparer(this.dataPreparer);
                jolietConfig.forceDotDelimiter(true);
            }
            ElToritoConfig elToritoConfig = null;
            if (this.enableElTorito) {
                if (this.noemuString.equals("")) {
                    this.noemu = new File(sourceFolder.getParentFile(), "Bootable_NoEmulation.img");
                    this.writeFileToDisk(this.noemu);
                } else {
                    this.noemu = new File(this.noemuString);
                }
                elToritoConfig = new ElToritoConfig(this.noemu, ElToritoConfig.BOOT_MEDIA_TYPE_NO_EMU, ElToritoConfig.PLATFORM_ID_X86, this.volumeId, this.bootSize, ElToritoConfig.LOAD_SEGMENT_7C0);
            }
            ArtASCII.text("ISO");
            log.write(9, "Creating the ISO image");
            ISOImageFileHandler streamHandler = new ISOImageFileHandler(newISOfile);
            CreateISO iso = new CreateISO(streamHandler, root);
            iso.process(iso9660Config, rrConfig, jolietConfig, elToritoConfig);
            streamHandler.endDocument();
            log.write(21, "The ISO file is available at %1 and is sized in %2.", newISOfile.getAbsolutePath(), files.humanReadableSize(newISOfile.length()));
            log.endBeep();
        }
        catch (Exception e) {
            log.write(-1, "An exception occurred: %1", e.getLocalizedMessage());
        }
    }

    void writeFileToDisk(File target) {
        String out = "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";
        try {
            Base64.decodeToFile(out, target.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

