/*
 * Decompiled with CFR 0.152.
 */
package create;

import bsh2java.log;
import java.io.File;
import rewim.WimBuilder;
import rewim.WimParser;
import rewim.core.CompressMode;
import rewim.core.Image;
import utils.files;
import utils.time;

public class BootWIM {
    WimBuilder bootWIM;
    File source;
    File dest;
    String imageName;
    Image image;

    public BootWIM(File source, File dest, String imageName, CompressMode compressMode) {
        this.source = source;
        this.dest = dest;
        this.imageName = imageName;
        if (!dest.exists()) {
            this.CreateNewWIM(compressMode);
        }
        try {
            this.image = new WimParser(dest.getAbsolutePath()).parse();
        }
        catch (Exception ex) {
            this.image = null;
        }
    }

    private void CreateNewWIM(CompressMode compressMode) {
        String customXML = new File(this.source.getParent(), "custom.xml").getAbsolutePath();
        boolean bootable = true;
        File temp = new File(this.source.getParent(), "temp");
        files.mkdirs(temp);
        String timestamp = time.getDateTime();
        timestamp = timestamp.replace("/", "-");
        timestamp = timestamp.replace(":", ".");
        files.touch(temp, timestamp);
        try {
            this.bootWIM = new WimBuilder(temp, this.dest, this.imageName);
            this.bootWIM.setCustomXML(customXML).setBootable(bootable).setCompressMode(compressMode);
            log.write(30, this.bootWIM.showInfo());
            this.bootWIM.build();
        }
        catch (Exception e) {
            log.write(-1, "Failed to create the WIM archive at %1 using the files from %2", this.dest.getAbsolutePath(), this.source.getAbsolutePath());
        }
        files.deleteDir(temp);
    }

    public Image getImage() {
        return this.image;
    }

    public File getFile() {
        return this.dest;
    }
}

