/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import build.CodeWords;
import build.CommandStack;
import build.Core;
import commands.Command;
import commands.CommandART;
import commands.CommandAUTO;
import commands.CommandBEEP;
import commands.CommandCLS;
import commands.CommandCONFIG;
import commands.CommandEXIT;
import commands.CommandFILELOG;
import commands.CommandLIST;
import commands.CommandSAY;
import commands.CommandSET;
import commands.CommandTTS;
import commands.CommandVERSION;
import java.util.ArrayList;
import licenses.CommandCERTIFY;
import licenses.CommandCREDITS;
import licenses.RegistrationLib;

public class Commander {
    Core core;
    public Boolean debug = false;
    private String lastCommand = "";
    public ArrayList<Command> plugins = new ArrayList();
    private CommandStack stack = new CommandStack();
    private CodeWords keys;

    public Commander() {
        this.core = Core.sys;
        this.plugins.add(new CommandART());
        this.plugins.add(new CommandAUTO());
        this.plugins.add(new CommandBEEP());
        this.plugins.add(this.core.build);
        this.plugins.add(new CommandCONFIG());
        if (Core.sys.registrationLib.getStatus().ordinal() >= RegistrationLib.KeyStatus.PROFESSIONAL.ordinal()) {
            this.plugins.add(new CommandCERTIFY());
        }
        this.plugins.add(new CommandCREDITS());
        this.plugins.add(new CommandCLS());
        this.plugins.add(this.core.downloads.get);
        this.plugins.add(new CommandEXIT());
        this.plugins.add(new CommandFILELOG());
        this.plugins.add(this.core.downloads.install);
        this.plugins.add(new CommandLIST());
        this.plugins.add(new CommandSAY());
        this.plugins.add(new CommandSET());
        this.plugins.add(this.core.source);
        this.plugins.add(new CommandTTS());
        this.plugins.add(this.core.downloads.upgrade);
        this.plugins.add(this.core.downloads.uninstall);
        this.plugins.add(new CommandVERSION());
        this.plugins.add(this.core.web);
        this.keys = new CodeWords(this.plugins);
    }

    void add(Command plugin) {
        this.plugins.add(plugin);
    }

    public void execute(String what) {
        this.execute(0, what);
    }

    public void execute(Integer typeUI, String what) {
        if (this.core.uiAvailable > 0) {
            log.write(1000, what);
        }
        this.lastCommand = what;
        for (Command plugin : this.plugins) {
            plugin.process(typeUI, what);
        }
    }

    public Boolean isProcessing() {
        Boolean result = false;
        for (Command plugin : this.plugins) {
            if (!plugin.isProcessing()) continue;
            result = true;
            if (!this.debug.booleanValue()) continue;
            System.out.println("Still processing: " + plugin.keyword());
        }
        return result;
    }

    public ArrayList<Command> getPlugins() {
        return this.plugins;
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public String getPrevCmd() {
        return this.stack.getPrevCmd();
    }

    public String getNextCmd() {
        return this.stack.getNextCmd();
    }

    public String autoExpand(String line) {
        return this.keys.expand(line);
    }

    public CommandStack getCommandStack() {
        return this.stack;
    }
}

