/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import commands.Command;
import commands.SubCommand;

public class CommandTTS
extends Command {
    SubCommand cmdON;
    SubCommand cmdSMART;
    SubCommand cmdERRORS;
    SubCommand cmdWARN;
    SubCommand cmdOFF;
    SubCommand cmdSTOP;

    @Override
    public String keyword() {
        return "TTS";
    }

    @Override
    public String description() {
        return "Defines text to speech level of log output";
    }

    @Override
    public void action() {
        log.write(30, "Syntax: " + this.keyword() + " ON | SMART | OFF | STOP");
    }

    @Override
    public void subCommandsProcess() {
        String value;
        String key;
        int posA = this.parameters.indexOf(" ");
        if (posA > 0) {
            key = this.parameters.substring(0, posA);
            value = this.parameters.substring(posA + 1);
        } else {
            key = this.parameters;
            value = "3";
        }
        if (key.equalsIgnoreCase(this.cmdON.keyword)) {
            this.switchTo(this.cmdON);
        } else if (key.equalsIgnoreCase(this.cmdERRORS.keyword)) {
            this.switchTo(this.cmdERRORS);
        } else if (key.equalsIgnoreCase(this.cmdWARN.keyword)) {
            this.switchTo(this.cmdWARN);
        } else if (key.equalsIgnoreCase(this.cmdOFF.keyword)) {
            this.switchTo(this.cmdOFF);
        } else if (key.equalsIgnoreCase(this.cmdSMART.keyword)) {
            this.switchTo(this.cmdSMART);
            log.setBeepInterval(value);
            this.settings.write("BeepInterval", value);
        } else if (key.equalsIgnoreCase(this.cmdSTOP.keyword)) {
            log.setSpeechMode(this.cmdSTOP.keyword);
        } else {
            this.action();
        }
    }

    private void switchTo(SubCommand cmd) {
        this.settings.write(this.keyword(), cmd.keyword);
        log.setSpeechMode(cmd.keyword);
        log.write(30, this.keyword() + " set to " + cmd.keyword);
    }

    @Override
    public final void subCommandsCreate() {
        this.cmdON = new SubCommand();
        this.cmdON.keyword = "ON";
        this.cmdON.descriptionShort = "Switches text to speech of log output on, reporting every line";
        this.cmdON.descriptionLong = "";
        this.cmdON.syntaxExample = this.keyword() + " ON\n";
        this.subCommandAdd(this.cmdON);
        this.cmdERRORS = new SubCommand();
        this.cmdERRORS.keyword = "ERRORS";
        this.cmdERRORS.descriptionShort = "Switches text to speech of log output on, reporting error lines only";
        this.cmdERRORS.descriptionLong = "";
        this.cmdERRORS.syntaxExample = this.keyword() + " ERRORS\n";
        this.cmdERRORS.hide = true;
        this.subCommandAdd(this.cmdERRORS);
        this.cmdOFF = new SubCommand();
        this.cmdOFF.keyword = "OFF";
        this.cmdOFF.descriptionShort = "Switches text to speech of log output off";
        this.cmdOFF.descriptionLong = "";
        this.cmdOFF.syntaxExample = this.keyword() + " OFF\n";
        this.subCommandAdd(this.cmdOFF);
        this.cmdWARN = new SubCommand();
        this.cmdWARN.keyword = "WARNINGS";
        this.cmdWARN.descriptionShort = "Switches text to speech of log output on, reporting warning and error lines only.";
        this.cmdWARN.descriptionLong = "";
        this.cmdWARN.syntaxExample = this.keyword() + " WARNINGS\n";
        this.cmdWARN.hide = true;
        this.subCommandAdd(this.cmdWARN);
        this.cmdSMART = new SubCommand();
        this.cmdSMART.keyword = "SMART";
        this.cmdSMART.descriptionShort = "Switches text to speech of log output on, reporting starting, done, warning and error lines. It gives all 3 seconds an 'alive' beep.";
        this.cmdSMART.descriptionLong = "";
        this.cmdSMART.syntaxExample = this.keyword() + " SMART [seconds beep interval]\n";
        this.subCommandAdd(this.cmdSMART);
        this.cmdSTOP = new SubCommand();
        this.cmdSTOP.keyword = "STOP";
        this.cmdSTOP.descriptionShort = "Stops the current speech output";
        this.cmdSTOP.descriptionLong = "";
        this.cmdSTOP.syntaxExample = this.keyword() + " STOP\n";
        this.subCommandAdd(this.cmdSTOP);
    }

    @Override
    public String syntaxExample() {
        return "";
    }
}

