/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import build.definition;
import commands.Command;
import commands.SubCommand;
import java.lang.reflect.Field;
import java.util.Enumeration;

public class CommandSET
extends Command {
    private SubCommand cmdDELETE;

    @Override
    public String keyword() {
        return "SET";
    }

    @Override
    public String description() {
        return "Change the WinBuilder settings using the key/value format";
    }

    @Override
    public String syntaxExample() {
        return "- Example to view all WinBuilder settings available:\n" + this.keyword() + "\n\n" + "- Example to define key \"test\" with value \"1234\":\n" + this.keyword() + " test 1234\n\n";
    }

    @Override
    public void action() {
        Enumeration e = this.core.settings.getAllKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String result = key + "=" + this.settings.read(key);
            log.print(result);
            System.out.println(result);
        }
    }

    String definedKey(String key) {
        String xkey = key;
        Field[] fld = definition.class.getFields();
        for (int i = 0; i < definition.class.getFields().length; ++i) {
            String tmp = fld[i].getName();
            if (!xkey.equalsIgnoreCase(tmp)) continue;
            xkey = tmp;
            break;
        }
        return xkey;
    }

    void doDelete(String key) {
        String xkey = this.definedKey(key);
        if (!this.settings.hasKey(xkey).booleanValue()) {
            log.write(404, "Key \"%1\" was not found", xkey);
            return;
        }
        this.settings.delete(xkey);
        if (!this.settings.hasKey(xkey).booleanValue()) {
            log.write(20, "Deleted \"%1\" from the settings", xkey);
        } else {
            log.write(-5, "Failed to delete \"%1\" from the settings", xkey);
        }
    }

    @Override
    public void subCommandsProcess() {
        int posA = this.parameters.indexOf(" ");
        String key = this.parameters.substring(0, posA);
        String value = this.parameters.substring(posA + 1);
        if (key.equalsIgnoreCase(this.cmdDELETE.keyword)) {
            this.doDelete(value);
            return;
        }
        key = this.definedKey(key);
        this.settings.write(key, value);
        log.write(30, "Wrote setting \"%1\" with value \"%2\"", key, value);
    }

    @Override
    public void subCommandsCreate() {
        this.cmdDELETE = new SubCommand();
        this.cmdDELETE.keyword = "DELETE";
        this.cmdDELETE.descriptionShort = "Deletes a given key from the WinBuilder settings";
        this.cmdDELETE.descriptionLong = "";
        this.cmdDELETE.syntaxExample = "- Example to delete the FILELOG key:\n" + this.keyword() + " " + this.cmdDELETE.keyword + " filelog";
        this.subCommandAdd(this.cmdDELETE);
    }
}

