/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import commands.Command;
import commands.SubCommand;

public class CommandFILELOG
extends Command {
    SubCommand cmdON;
    SubCommand cmdERRORS;
    SubCommand cmdWARN;
    SubCommand cmdOFF;

    public CommandFILELOG() {
        this.hide = false;
    }

    @Override
    public String keyword() {
        return "FILELOG";
    }

    @Override
    public String description() {
        return "Defines log to file";
    }

    @Override
    public void action() {
        log.write(30, "Syntax: " + this.keyword() + " ON | OFF");
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdON.isChosen(this.parameters)) {
            this.switchTo(this.cmdON);
        } else if (this.cmdERRORS.isChosen(this.parameters)) {
            this.switchTo(this.cmdERRORS);
        } else if (this.cmdWARN.isChosen(this.parameters)) {
            this.switchTo(this.cmdWARN);
        } else if (this.cmdOFF.isChosen(this.parameters)) {
            this.switchTo(this.cmdOFF);
        } else {
            this.action();
        }
    }

    private void switchTo(SubCommand cmd) {
        this.settings.write(this.keyword(), cmd.keyword);
        log.setLogMode(cmd.keyword);
        log.write(30, this.keyword() + " set to " + cmd.keyword);
    }

    @Override
    public final void subCommandsCreate() {
        this.cmdON = new SubCommand();
        this.cmdON.keyword = "ON";
        this.cmdON.descriptionShort = "Switches log output to file on, reporting every line";
        this.cmdON.descriptionLong = "";
        this.cmdON.syntaxExample = "";
        this.subCommandAdd(this.cmdON);
        this.cmdERRORS = new SubCommand();
        this.cmdERRORS.keyword = "ERRORS";
        this.cmdERRORS.descriptionShort = "Switches log output to file on, reporting error lines only";
        this.cmdERRORS.descriptionLong = "";
        this.cmdERRORS.syntaxExample = "";
        this.subCommandAdd(this.cmdERRORS);
        this.cmdOFF = new SubCommand();
        this.cmdOFF.keyword = "OFF";
        this.cmdOFF.descriptionShort = "Switches log output to file off";
        this.cmdOFF.descriptionLong = "";
        this.cmdOFF.syntaxExample = "";
        this.subCommandAdd(this.cmdOFF);
        this.cmdWARN = new SubCommand();
        this.cmdWARN.keyword = "WARNINGS";
        this.cmdWARN.descriptionShort = "Switches log output to file on, reporting warning and error lines only";
        this.cmdWARN.descriptionLong = "";
        this.cmdWARN.syntaxExample = "";
        this.subCommandAdd(this.cmdWARN);
    }

    @Override
    public String syntaxExample() {
        return "Usage example: \n" + this.keyword() + " OFF\n";
    }
}

