/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import build.Core;
import build.SettingsGUI;
import commands.Command;
import commands.SubCommand;
import downloads.Catalog;
import downloads.Entry;
import downloads.Resource;
import downloads.common;
import java.io.File;
import java.util.ArrayList;
import utils.files;
import win7pecore.Win7PE;

public class CommandCONFIG
extends Command {
    private Catalog catalog;
    private SubCommand cmdList = new SubCommand();

    @Override
    public String keyword() {
        return "CONFIG";
    }

    @Override
    public String description() {
        return "Changes the settings of the specified item";
    }

    @Override
    public String syntaxExample() {
        return "- Example to config the NVDA plugin: \n" + this.keyword() + " " + " NVDA";
    }

    @Override
    public void action() {
        log.write(-1, "You need to specify the element to config");
    }

    @Override
    public void subCommandsProcess() {
        Entry entry = null;
        Resource resource = null;
        String entryTitle = null;
        if (this.parameters.toUpperCase().startsWith(this.cmdList.keyword)) {
            ArrayList<String> itemList;
            String param = this.parameters.substring(this.cmdList.keyword.length()).trim().toUpperCase();
            if (param.equals("")) {
                log.write(-1, "You need to specify the element to config");
                return;
            }
            if (this.core.winpecore.projectName.toUpperCase().contains(param)) {
                entryTitle = this.core.winpecore.projectName;
            } else {
                itemList = new ArrayList<String>();
                for (String item : this.core.winpecore.allComponents) {
                    if (!item.toUpperCase().contains(param)) continue;
                    itemList.add(item);
                }
                if (itemList.isEmpty()) {
                    log.write(-1, "We couldn't find %1 installed, sorry!", this.parameters);
                    return;
                }
                if (itemList.size() > 1) {
                    String result = "";
                    for (String ent : itemList) {
                        result = result.concat("-> " + ent + "\n");
                    }
                    log.write(30, "Multiple entries match your search term, please make a unique choice! \n%1", result);
                    return;
                }
                entryTitle = (String)itemList.get(0);
            }
            entry = new Entry();
            entry.title = "core " + entryTitle;
            entry.downloadId = null;
            entry.isLocal = true;
            resource = new Resource(entry);
            itemList = new ArrayList();
            for (String item : this.core.winpecore.allComponents) {
                if (!item.toUpperCase().contains(param)) continue;
                itemList.add(item);
            }
            File coreFolder = common.getFolderCore();
            String cs = new File(coreFolder, entryTitle + ".html").getAbsolutePath();
            if (cs != null) {
                resource.setFileSettings(cs);
            }
        } else {
            File oriSettings;
            if (this.catalog == null) {
                this.catalog = new Catalog();
            }
            ArrayList<Entry> entryList = this.catalog.find(this.parameters);
            File project = null;
            if (entryList.isEmpty()) {
                String projectFolder = this.settings.read("ProjectFolder", "");
                if (!"".equals(projectFolder)) {
                    project = new File(projectFolder);
                    this.catalog = new Catalog(project);
                    entryList = this.catalog.find(this.parameters);
                }
                this.catalog = null;
            }
            if (entryList.isEmpty()) {
                log.write(-1, "We couldn't find %1 installed, sorry!", this.parameters);
                return;
            }
            if (entryList.size() > 1) {
                String result = "";
                for (Entry ent : entryList) {
                    result = result.concat("-> " + ent.title + "\n");
                }
                log.write(30, "Multiple entries match your search term, please make a unique choice! \n%1", result);
                return;
            }
            entry = entryList.get(0);
            resource = new Resource(entry.downloadId, entry.title);
            if (project != null) {
                resource.setFileSettings(project);
            }
            if (!(oriSettings = resource.getFileSettings()).exists()) {
                log.write(-1, "There exist no settings formular available for %1, sorry!", entry.title);
                return;
            }
            File cachedSettings = resource.getFileSettingsCache();
            if (!cachedSettings.exists()) {
                String xmlName = oriSettings.getAbsolutePath().replace(".html", ".xml");
                files.copyFile(new File(xmlName), cachedSettings);
            }
        }
        log.write(30, "Showing the configuration for %1", entry.title);
        if (this.typeUI == 2) {
            this.showConfigGUI(entry, resource);
        }
        if (this.typeUI == 4) {
            this.showConfigWEB(entry, resource);
        }
        Core.sys.winpecore = new Win7PE();
    }

    @Override
    public void subCommandsCreate() {
        this.cmdList.keyword = "CORE";
        this.cmdList.descriptionShort = "Configures the core item";
        this.cmdList.descriptionLong = "";
        this.cmdList.syntaxExample = "- Example to config the core InternetExplorer component: \n" + this.keyword() + " " + this.cmdList.keyword + " InternetExplorer";
        this.subCommandAdd(this.cmdList);
    }

    void showConfigWEB(Entry entry, Resource resource) {
        String webpage;
        this.core.web.webOutput = webpage = files.readAsString(resource.getFileSettings());
    }

    void showConfigGUI(Entry entry, Resource resource) {
        String webpage = files.readAsString(resource.getFileSettings());
        SettingsGUI settingsGUI = new SettingsGUI();
        settingsGUI.showItem(entry, resource, webpage);
    }
}

