/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import commands.Command;
import commands.SubCommand;

public class CommandBEEP
extends Command {
    SubCommand cmdON;
    SubCommand cmdOFF;

    public CommandBEEP() {
        this.hide = true;
    }

    @Override
    public String keyword() {
        return "BEEP";
    }

    @Override
    public String description() {
        return "Switches beeping during build on / off";
    }

    @Override
    public void action() {
        log.write(30, "Syntax: " + this.keyword() + " ON | OFF");
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdON.isChosen(this.parameters)) {
            this.switchTo(this.cmdON);
        } else if (this.cmdOFF.isChosen(this.parameters)) {
            this.switchTo(this.cmdOFF);
        } else {
            this.action();
        }
    }

    private void switchTo(SubCommand cmd) {
        this.settings.write(this.keyword(), cmd.keyword);
        log.setBeepMode(cmd.keyword);
        log.write(30, this.keyword() + " set to " + cmd.keyword);
    }

    @Override
    public final void subCommandsCreate() {
        this.cmdON = new SubCommand();
        this.cmdON.keyword = "ON";
        this.cmdON.descriptionShort = "Switches beeping during build on";
        this.cmdON.descriptionLong = "";
        this.cmdON.syntaxExample = "";
        this.subCommandAdd(this.cmdON);
        this.cmdOFF = new SubCommand();
        this.cmdOFF.keyword = "OFF";
        this.cmdOFF.descriptionShort = "Switches beeping during build off";
        this.cmdOFF.descriptionLong = "";
        this.cmdOFF.syntaxExample = "";
        this.subCommandAdd(this.cmdOFF);
    }

    @Override
    public String syntaxExample() {
        return "Usage example: \n" + this.keyword() + " OFF\n";
    }
}

