/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import build.Core;
import commands.Command;
import downloads.DownloadItem;
import downloads.common;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sevenzipjbinding.ArchiveFormat;
import utils.ExtractSevenZip;
import utils.files;
import utils.time;
import win7pecore.Win7PE;

public class CommandAUTO
extends Command {
    public String baseFolder = "source";
    public String targetSource = "win7_en_x86_sp1";

    @Override
    public String keyword() {
        return "AUTO";
    }

    @Override
    public String description() {
        return "Fully-automated boot disk creation";
    }

    @Override
    public String syntaxExample() {
        return "Usage example: \n" + this.keyword();
    }

    @Override
    public void action() {
        if (Core.temp.containsKey("auto")) {
            log.write(-2, "An AUTO command is already active, cannot start a new one.");
            return;
        }
        Thread test = new Thread(){

            @Override
            public void run() {
                CommandAUTO auto = new CommandAUTO();
                Core.temp.put("auto", auto);
                auto.doAction();
                Core.temp.remove("auto");
            }
        };
        test.start();
    }

    public void doAction() {
        log.write(30, "Starting the AUTO build");
        if (!this.core.source.isValid().booleanValue()) {
            if (!this.hasEnoughDiskFree().booleanValue()) {
                log.write(-1, "Sorry, you need at least 4Gb freeon your disk to create a boot disk");
            }
            Iterator<DownloadItem> items = this.core.downloads.get.items.iterator();
            DownloadItem targetDownload = null;
            while (items.hasNext()) {
                DownloadItem item = items.next();
                if (!item.shortTitle.equals(this.targetSource)) continue;
                targetDownload = item;
                break;
            }
            if (targetDownload == null) {
                log.write(-1, "Didn't found the target source %1", this.targetSource);
                return;
            }
            if (targetDownload.file.length() != targetDownload.fileSize.longValue()) {
                log.write(30, "Downloading a valid Windows ISO to use as source, please wait..");
                targetDownload.getFile(false);
            }
            File sourceFolder = new File(common.getFolderSourceCDs(), this.targetSource);
            files.mkdirs(sourceFolder);
            if (!this.isWin7SourceValid(sourceFolder).booleanValue()) {
                log.write(30, "Extracting files from the ISO, please wait");
                try {
                    ExtractSevenZip test = new ExtractSevenZip(targetDownload.file, sourceFolder, null);
                    test.setArchiveFormat(ArchiveFormat.UDF);
                    test.createTimer(1L, 5);
                    test.extract();
                }
                catch (Exception ex) {
                    log.write(-1, "Failed to extract %1 to folder %2", targetDownload.file.getName(), sourceFolder.getAbsolutePath());
                    return;
                }
            }
            if (!this.isWin7SourceValid(sourceFolder).booleanValue()) {
                log.write(-1, "Failed to extract %1 to folder %2", targetDownload.file.getName(), sourceFolder.getAbsolutePath());
                return;
            }
            this.core.source.setSource(sourceFolder);
            if (!this.core.source.isValid().booleanValue()) {
                this.core.source.setSource(sourceFolder);
            }
        }
        Core.sys.winpecore = new Win7PE();
        long timeStarted = System.currentTimeMillis();
        this.core.command.execute("BUILD CORE");
        this.core.command.execute("BUILD WIM");
        this.core.command.execute("BUILD ISO");
        long timeConcluded = System.currentTimeMillis();
        long timeOverall = timeConcluded - timeStarted;
        log.write(20, "Project build was concluded in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
        log.closeBeep();
    }

    Boolean isWin7SourceValid(File sourceFolder) {
        ArrayList<File> files2 = files.findFiles(sourceFolder);
        Boolean result = files2.size() > 800;
        return result;
    }

    Boolean hasEnoughDiskFree() {
        File currentFolder = new File(".");
        long usableSpace = currentFolder.getUsableSpace() / 1024L / 1024L;
        return usableSpace > 4000L;
    }

    @Override
    public void subCommandsProcess() {
    }

    @Override
    public void subCommandsCreate() {
    }

    public void restartApplication() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            File currentJar = new File(Command.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            System.err.println("Launching new instance of this builder");
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-jar");
            command.add(currentJar.getPath());
            command.add("AUTO");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            System.exit(0);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(CommandAUTO.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CommandAUTO.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

