/*
 * Decompiled with CFR 0.152.
 */
package commands;

import bsh2java.log;
import build.Core;
import commands.SubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import utils.Settings;

public abstract class Command
extends Thread {
    ArrayList<SubCommand> subCommands = new ArrayList();
    ArrayList<String> alias = new ArrayList();
    protected Core core;
    protected String parameters;
    protected Settings settings;
    private boolean enabled = true;
    protected boolean isProcessing = false;
    protected Boolean isThreadProcessing = false;
    public boolean subCommandsNotAddedYet = true;
    protected Integer typeUI;
    protected boolean hide;
    final String[] HELPREQUEST = new String[]{"?", "/?", "-?", "HELP", "/HELP", "-HELP", "/H", "-H"};

    public abstract String keyword();

    public abstract String description();

    public abstract String syntaxExample();

    public abstract void action();

    public abstract void subCommandsProcess();

    public abstract void subCommandsCreate();

    public Command() {
        this.core = Core.sys;
        this.settings = this.core.settings;
    }

    public void process(final Integer typeUI, String what) {
        this.typeUI = typeUI;
        if (this.subCommandsNotAddedYet) {
            this.subCommandsCreate();
            this.subCommandsNotAddedYet = false;
        }
        if (what.contains(";")) {
            Thread test = new Thread(){

                @Override
                public void run() {
                    String[] commands;
                    String what = Core.sys.command.getLastCommand();
                    what = what.replace("; ", ";");
                    for (String command : commands = what.split(";")) {
                        Command.this.process(typeUI, command);
                    }
                }
            };
            test.start();
            return;
        }
        if (what.length() < this.keyword().length()) {
            return;
        }
        String firstParameter = what.substring(0, this.keyword().length());
        if (!firstParameter.equalsIgnoreCase(this.keyword())) {
            return;
        }
        if (what.length() == this.keyword().length()) {
            this.isProcessing = true;
            this.action();
            this.isProcessing = false;
            return;
        }
        firstParameter = what.substring(0, this.keyword().length() + 1);
        if (!firstParameter.equalsIgnoreCase(this.keyword() + " ")) {
            return;
        }
        this.parameters = what.substring(this.keyword().length() + 1);
        if (Arrays.asList(this.HELPREQUEST).contains(this.parameters.toUpperCase())) {
            this.showHelp();
            return;
        }
        this.subCommandsProcess();
    }

    private void showHelp() {
        log.print("\n" + this.keyword() + " - " + this.description());
        if (!this.subCommands.isEmpty()) {
            log.print("\n Available options:");
            for (SubCommand subCommand : this.subCommands) {
                if (subCommand.hide) continue;
                log.print("     " + subCommand.keyword + " - " + subCommand.descriptionShort);
                log.print(this.buildMessage("       ", subCommand.syntaxExample));
            }
        }
        log.print(this.buildMessage("", this.syntaxExample()));
    }

    private String buildMessage(String spaces, String original) {
        String tmp = original.replace("\n\n", "\t");
        return spaces + tmp.replace("\n", "\n" + spaces + "  ").replace("\t", "\n\n");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Core getCore() {
        return this.core;
    }

    public ArrayList<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    public void subCommandAdd(SubCommand command) {
        this.subCommands.add(command);
    }

    public boolean isProcessing() {
        if (this.isThreadProcessing.booleanValue()) {
            this.isProcessing = true;
        }
        return this.isProcessing;
    }
}

