/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;

public class SegmentRelationUtils {
    public static Item getItem(Relation segmentRelation, float time2) {
        Item lastSegment = segmentRelation.getTail();
        float lastSegmentEndTime = SegmentRelationUtils.getSegmentEnd(lastSegment);
        if (time2 < 0.0f || lastSegmentEndTime < time2) {
            return null;
        }
        if (lastSegmentEndTime - time2 > time2) {
            return SegmentRelationUtils.findFromFront(segmentRelation, time2);
        }
        return SegmentRelationUtils.findFromEnd(segmentRelation, time2);
    }

    public static float getSegmentEnd(Item segment) {
        FeatureSet segmentFeatureSet = segment.getFeatures();
        return segmentFeatureSet.getFloat("end");
    }

    public static Item findFromFront(Relation segmentRelation, float time2) {
        Item item;
        for (item = segmentRelation.getHead(); item != null && time2 > SegmentRelationUtils.getSegmentEnd(item); item = item.getNext()) {
        }
        return item;
    }

    public static Item findFromEnd(Relation segmentRelation, float time2) {
        Item item;
        for (item = segmentRelation.getTail(); item != null && SegmentRelationUtils.getSegmentEnd(item) > time2; item = item.getPrevious()) {
        }
        if (item != segmentRelation.getTail()) {
            item = item.getNext();
        }
        return item;
    }
}

