/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SampleInfo {
    public static final String UTT_NAME = "SampleInfo";
    private final int sampleRate;
    private final int numberOfChannels;
    private final int residualFold;
    private final float coeffMin;
    private final float coeffRange;
    private final float postEmphasis;

    public SampleInfo(int sampleRate, int numberOfChannels, int residualFold, float coeffMin, float coeffRange, float postEmphasis) {
        this.sampleRate = sampleRate;
        this.numberOfChannels = numberOfChannels;
        this.residualFold = residualFold;
        this.coeffMin = coeffMin;
        this.coeffRange = coeffRange;
        this.postEmphasis = postEmphasis;
    }

    public SampleInfo(ByteBuffer bb) throws IOException {
        this.numberOfChannels = bb.getInt();
        this.sampleRate = bb.getInt();
        this.coeffMin = bb.getFloat();
        this.coeffRange = bb.getFloat();
        this.postEmphasis = bb.getFloat();
        this.residualFold = bb.getInt();
    }

    public SampleInfo(DataInputStream is2) throws IOException {
        this.numberOfChannels = is2.readInt();
        this.sampleRate = is2.readInt();
        this.coeffMin = is2.readFloat();
        this.coeffRange = is2.readFloat();
        this.postEmphasis = is2.readFloat();
        this.residualFold = is2.readInt();
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public final int getResidualFold() {
        return this.residualFold;
    }

    public final float getCoeffMin() {
        return this.coeffMin;
    }

    public final float getCoeffRange() {
        return this.coeffRange;
    }

    public final float getPostEmphasis() {
        return this.postEmphasis;
    }

    public void dumpBinary(DataOutputStream os) throws IOException {
        os.writeInt(this.numberOfChannels);
        os.writeInt(this.sampleRate);
        os.writeFloat(this.coeffMin);
        os.writeFloat(this.coeffRange);
        os.writeFloat(this.postEmphasis);
        os.writeInt(this.residualFold);
    }
}

