/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.InputMode;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.JavaClipAudioPlayer;
import com.sun.speech.freetts.audio.MultiFileAudioPlayer;
import com.sun.speech.freetts.audio.NullAudioPlayer;
import com.sun.speech.freetts.audio.RawFileAudioPlayer;
import com.sun.speech.freetts.audio.SingleFileAudioPlayer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;

public class FreeTTS {
    private static final Logger LOGGER = Logger.getLogger(FreeTTS.class.getName());
    public static final String VERSION = "FreeTTS 1.2.2";
    private Voice voice;
    private static AudioPlayer audioPlayer = null;
    private boolean silent = false;
    private String audioFile = null;
    private boolean multiAudio = false;
    private boolean streamingAudio = false;
    private InputMode inputMode = InputMode.INTERACTIVE;

    public FreeTTS() {
        VoiceManager voiceManager = VoiceManager.getInstance();
        voiceManager.getVoice("kevin16");
    }

    public FreeTTS(Voice voice) {
        this.voice = voice;
    }

    public void startup() {
        this.voice.allocate();
        if (!this.getSilentMode()) {
            if (this.audioFile != null) {
                AudioFileFormat.Type type = this.getAudioType(this.audioFile);
                if (type != null) {
                    audioPlayer = this.multiAudio ? new MultiFileAudioPlayer(FreeTTS.getBasename(this.audioFile), type) : new SingleFileAudioPlayer(FreeTTS.getBasename(this.audioFile), type);
                } else {
                    try {
                        audioPlayer = new RawFileAudioPlayer(this.audioFile);
                    }
                    catch (IOException ioe) {
                        System.out.println("Can't open " + this.audioFile + " " + ioe);
                    }
                }
            } else if (!this.streamingAudio) {
                audioPlayer = new JavaClipAudioPlayer();
            } else {
                try {
                    audioPlayer = this.voice.getDefaultAudioPlayer();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        if (audioPlayer == null) {
            audioPlayer = new NullAudioPlayer();
        }
        this.voice.setAudioPlayer(audioPlayer);
    }

    private AudioFileFormat.Type getAudioType(String file) {
        AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
        String extension = FreeTTS.getExtension(file);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getExtension().equals(extension)) continue;
            return types[i];
        }
        return null;
    }

    private static String getExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return path.substring(index + 1);
    }

    private static String getBasename(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public void shutdown() {
        audioPlayer.close();
        this.voice.deallocate();
    }

    public boolean textToSpeech(String text2) {
        return this.voice.speak(text2);
    }

    private boolean batchTextToSpeech(String text2) {
        this.voice.startBatch();
        boolean ok = this.textToSpeech(text2);
        this.voice.endBatch();
        return ok;
    }

    private boolean lineToSpeech(String path) {
        boolean ok = true;
        this.voice.startBatch();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(path));
            while ((line = reader.readLine()) != null && ok) {
                ok = this.textToSpeech(line);
            }
            reader.close();
        }
        catch (IOException ioe) {
            LOGGER.severe("can't read " + path);
            throw new Error(ioe);
        }
        this.voice.endBatch();
        return ok;
    }

    protected Voice getVoice() {
        return this.voice;
    }

    public boolean streamToSpeech(InputStream is2) {
        this.voice.startBatch();
        boolean ok = this.voice.speak(is2);
        this.voice.endBatch();
        return ok;
    }

    public boolean urlToSpeech(String urlPath) {
        boolean ok = false;
        try {
            URL url = new URL(urlPath);
            InputStream is2 = url.openStream();
            ok = this.streamToSpeech(is2);
        }
        catch (IOException ioe) {
            System.err.println("Can't read data from " + urlPath);
        }
        return ok;
    }

    public boolean fileToSpeech(String filePath) {
        boolean ok = false;
        try {
            FileInputStream is2 = new FileInputStream(filePath);
            ok = this.streamToSpeech(is2);
        }
        catch (IOException ioe) {
            System.err.println("Can't read data from " + filePath);
        }
        return ok;
    }

    public void setSilentMode(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilentMode() {
        return this.silent;
    }

    public void setInputMode(InputMode inputMode) {
        this.inputMode = inputMode;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public void setAudioFile(String audioFile) {
        this.audioFile = audioFile;
    }

    public void setMultiAudio(boolean multiAudio) {
        this.multiAudio = multiAudio;
    }

    public void setStreamingAudio(boolean streamingAudio) {
        this.streamingAudio = streamingAudio;
    }

    static void usage(String voices) {
        System.out.println(VERSION);
        System.out.println("Usage:");
        System.out.println("    -detailedMetrics: turn on detailed metrics");
        System.out.println("    -dumpAudio file : dump audio to file ");
        System.out.println("    -dumpAudioTypes : dump the possible output types");
        System.out.println("    -dumpMultiAudio file : dump audio to file ");
        System.out.println("    -dumpRelations  : dump the relations ");
        System.out.println("    -dumpUtterance  : dump the final utterance");
        System.out.println("    -dumpASCII file : dump the final wave to file as ASCII");
        System.out.println("    -file file      : speak text from given file");
        System.out.println("    -lines file     : render lines from a file");
        System.out.println("    -help           : shows usage information");
        System.out.println("    -voiceInfo      : print detailed voice info");
        System.out.println("    -metrics        : turn on metrics");
        System.out.println("    -run  name      : sets the name of the run");
        System.out.println("    -silent         : don't say anything");
        System.out.println("    -streaming      : use streaming audio player");
        System.out.println("    -text say me    : speak given text");
        System.out.println("    -url path       : speak text from given URL");
        System.out.println("    -verbose        : verbose output");
        System.out.println("    -version        : shows version number");
        System.out.println("    -voice VOICE    : " + voices);
    }

    private static void interactiveMode(FreeTTS freetts) {
        try {
            while (true) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Enter text: ");
                System.out.flush();
                String text2 = reader.readLine();
                if (text2 == null || text2.length() == 0) {
                    freetts.shutdown();
                    System.exit(0);
                    continue;
                }
                freetts.batchTextToSpeech(text2);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static void dumpAudioTypes() {
        AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
        for (int i = 0; i < types.length; ++i) {
            System.out.println(types[i].getExtension());
        }
    }

    public static void main(String[] args) {
        String text2 = null;
        String inFile = null;
        boolean dumpAudioTypes = false;
        Voice voice = null;
        VoiceManager voiceManager = VoiceManager.getInstance();
        String voices = voiceManager.toString();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-voice")) continue;
            if (++i < args.length) {
                String voiceName = args[i];
                if (voiceManager.contains(voiceName)) {
                    voice = voiceManager.getVoice(voiceName);
                    break;
                }
                System.out.println("Invalid voice: " + voiceName);
                System.out.println("  Valid voices are " + voices);
                System.exit(1);
                break;
            }
            FreeTTS.usage(voices);
            System.exit(1);
            break;
        }
        if (voice == null) {
            voice = voiceManager.getVoice("kevin16");
        }
        if (voice == null) {
            throw new Error("The specified voice is not defined");
        }
        FreeTTS freetts = new FreeTTS(voice);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-metrics")) {
                voice.setMetrics(true);
                continue;
            }
            if (args[i].equals("-detailedMetrics")) {
                voice.setDetailedMetrics(true);
                continue;
            }
            if (args[i].equals("-silent")) {
                freetts.setSilentMode(true);
                continue;
            }
            if (args[i].equals("-streaming")) {
                freetts.setStreamingAudio(true);
                continue;
            }
            if (args[i].equals("-verbose")) {
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                Logger.getLogger("com.sun").addHandler(handler);
                Logger.getLogger("com.sun").setLevel(Level.ALL);
                continue;
            }
            if (args[i].equals("-dumpUtterance")) {
                voice.setDumpUtterance(true);
                continue;
            }
            if (args[i].equals("-dumpAudioTypes")) {
                dumpAudioTypes = true;
                continue;
            }
            if (args[i].equals("-dumpRelations")) {
                voice.setDumpRelations(true);
                continue;
            }
            if (args[i].equals("-dumpASCII")) {
                if (++i < args.length) {
                    voice.setWaveDumpFile(args[i]);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            if (args[i].equals("-dumpAudio")) {
                if (++i < args.length) {
                    freetts.setAudioFile(args[i]);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            if (args[i].equals("-dumpMultiAudio")) {
                if (++i < args.length) {
                    freetts.setAudioFile(args[i]);
                    freetts.setMultiAudio(true);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println(VERSION);
                continue;
            }
            if (args[i].equals("-voice")) {
                ++i;
                continue;
            }
            if (args[i].equals("-help")) {
                FreeTTS.usage(voices);
                System.exit(0);
                continue;
            }
            if (args[i].equals("-voiceInfo")) {
                System.out.println(VoiceManager.getInstance().getVoiceInfo());
                System.exit(0);
                continue;
            }
            if (args[i].equals("-text")) {
                freetts.setInputMode(InputMode.TEXT);
                StringBuffer sb = new StringBuffer();
                for (int j = i + 1; j < args.length; ++j) {
                    sb.append(args[j]);
                    sb.append(" ");
                }
                text2 = sb.toString();
                break;
            }
            if (args[i].equals("-file")) {
                if (++i < args.length) {
                    inFile = args[i];
                    freetts.setInputMode(InputMode.FILE);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            if (args[i].equals("-lines")) {
                if (++i < args.length) {
                    inFile = args[i];
                    freetts.setInputMode(InputMode.LINES);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            if (args[i].equals("-url")) {
                if (++i < args.length) {
                    inFile = args[i];
                    freetts.setInputMode(InputMode.URL);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            if (args[i].equals("-run")) {
                if (++i < args.length) {
                    voice.setRunTitle(args[i]);
                    continue;
                }
                FreeTTS.usage(voices);
                continue;
            }
            System.out.println("Unknown option:" + args[i]);
        }
        if (dumpAudioTypes) {
            FreeTTS.dumpAudioTypes();
        }
        freetts.startup();
        if (freetts.getInputMode() == InputMode.TEXT) {
            freetts.batchTextToSpeech(text2);
        } else if (freetts.getInputMode() == InputMode.FILE) {
            freetts.fileToSpeech(inFile);
        } else if (freetts.getInputMode() == InputMode.URL) {
            freetts.urlToSpeech(inFile);
        } else if (freetts.getInputMode() == InputMode.LINES) {
            freetts.lineToSpeech(inFile);
        } else {
            FreeTTS.interactiveMode(freetts);
        }
        if (!freetts.getVoice().isMetrics() || !freetts.getSilentMode()) {
            // empty if block
        }
        freetts.shutdown();
        System.exit(0);
    }
}

