/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis.text;

import com.sun.speech.engine.synthesis.BaseSynthesizer;
import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import com.sun.speech.engine.synthesis.text.TextSynthesizerQueueItem;
import java.util.Enumeration;
import java.util.Vector;
import javax.speech.EngineStateError;
import javax.speech.synthesis.SynthesizerModeDesc;

public class TextSynthesizer
extends BaseSynthesizer {
    OutputHandler outputHandler = new OutputHandler();

    public TextSynthesizer(SynthesizerModeDesc desc) {
        super(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAllocate() {
        long[] states;
        Object object = this.engineStateLock;
        synchronized (object) {
            long newState = 516L;
            states = this.setEngineState(-1L, newState |= this.outputHandler.isQueueEmpty() ? 65536L : 131072L);
        }
        this.outputHandler.start();
        this.postEngineAllocated(states[0], states[1]);
    }

    protected void handleDeallocate() {
        long[] states = this.setEngineState(-1L, 1L);
        this.cancelAll();
        this.outputHandler.terminate();
        this.postEngineDeallocated(states[0], states[1]);
    }

    protected BaseSynthesizerQueueItem createQueueItem() {
        return new TextSynthesizerQueueItem();
    }

    public Enumeration enumerateQueue() throws EngineStateError {
        this.checkEngineState(9L);
        return this.outputHandler.enumerateQueue();
    }

    protected void appendQueue(BaseSynthesizerQueueItem item) {
        this.outputHandler.appendQueue((TextSynthesizerQueueItem)item);
    }

    public void cancel() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem();
    }

    public void cancel(Object source) throws IllegalArgumentException, EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem(source);
    }

    public void cancelAll() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelAllItems();
    }

    protected void handlePause() {
        this.outputHandler.pauseItem();
    }

    protected void handleResume() {
        this.outputHandler.resumeItem();
    }

    public class OutputHandler
    extends Thread {
        protected boolean done = false;
        protected Vector queue;
        TextSynthesizerQueueItem currentItem = null;
        protected Object currentItemLock = new Object();
        int rate = 100;
        protected int command;
        protected static final int PAUSE = 0;
        protected static final int RESUME = 1;
        protected static final int CANCEL = 2;
        protected static final int CANCEL_ALL = 3;
        protected static final int CANCEL_COMPLETE = 4;
        protected Object commandLock = new Object();

        public OutputHandler() {
            this.queue = new Vector();
        }

        public void terminate() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration enumerateQueue() {
            Vector vector = this.queue;
            synchronized (vector) {
                return this.queue.elements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isQueueEmpty() {
            Vector vector = this.queue;
            synchronized (vector) {
                return this.queue.size() == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendQueue(TextSynthesizerQueueItem item) {
            boolean topOfQueueChanged;
            Vector vector = this.queue;
            synchronized (vector) {
                topOfQueueChanged = this.queue.size() == 0;
                this.queue.addElement(item);
                this.queue.notifyAll();
            }
            if (topOfQueueChanged) {
                long[] states = TextSynthesizer.this.setEngineState(65536L, 131072L);
                TextSynthesizer.this.postQueueUpdated(topOfQueueChanged, states[0], states[1]);
            }
        }

        protected void cancelItem() {
            this.cancelItem(2);
        }

        protected void cancelAllItems() {
            this.cancelItem(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelItem(int cancelType) {
            Object object = this.queue;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    return;
                }
            }
            object = this.commandLock;
            synchronized (object) {
                this.command = cancelType;
                this.commandLock.notifyAll();
                while (this.command != 4) {
                    try {
                        this.commandLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.command = TextSynthesizer.this.testEngineState(256L) ? 0 : 1;
                this.commandLock.notifyAll();
            }
        }

        protected void cancelItem(Object source) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pauseItem() {
            Object object = this.commandLock;
            synchronized (object) {
                if (this.command != 0) {
                    this.command = 0;
                    this.commandLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resumeItem() {
            Object object = this.commandLock;
            synchronized (object) {
                if (this.command != 1) {
                    this.command = 1;
                    this.commandLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.command = TextSynthesizer.this.testEngineState(256L) ? 0 : 1;
            while (!this.done) {
                long[] states;
                boolean queueEmptied;
                Object itemList;
                TextSynthesizerQueueItem item = this.getQueueItem();
                item.postTopOfQueue();
                int currentCommand = this.outputItem(item);
                if (currentCommand == 3) {
                    itemList = new Vector<TextSynthesizerQueueItem>();
                    ((Vector)itemList).add(item);
                    Object object = this.queue;
                    synchronized (object) {
                        this.queue.remove(0);
                        while (this.queue.size() > 0) {
                            ((Vector)itemList).add(this.queue.remove(0));
                        }
                    }
                    object = this.commandLock;
                    synchronized (object) {
                        this.command = 4;
                        this.commandLock.notifyAll();
                    }
                    while (((Vector)itemList).size() > 0) {
                        item = (TextSynthesizerQueueItem)((Vector)itemList).remove(0);
                        item.postSpeakableCancelled();
                    }
                    long[] states2 = TextSynthesizer.this.setEngineState(131072L, 65536L);
                    TextSynthesizer.this.postQueueEmptied(states2[0], states2[1]);
                    continue;
                }
                if (currentCommand == 2) {
                    itemList = this.commandLock;
                    synchronized (itemList) {
                        this.command = 4;
                        this.commandLock.notifyAll();
                    }
                    item.postSpeakableCancelled();
                } else if (currentCommand == 0 || currentCommand == 1) {
                    item.postSpeakableEnded();
                }
                itemList = this.queue;
                synchronized (itemList) {
                    this.queue.remove(0);
                    queueEmptied = this.queue.size() == 0;
                    this.queue.notifyAll();
                }
                if (queueEmptied) {
                    states = TextSynthesizer.this.setEngineState(131072L, 65536L);
                    TextSynthesizer.this.postQueueEmptied(states[0], states[1]);
                    continue;
                }
                states = TextSynthesizer.this.setEngineState(131072L, 131072L);
                TextSynthesizer.this.postQueueUpdated(true, states[0], states[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TextSynthesizerQueueItem getQueueItem() {
            Vector vector = this.queue;
            synchronized (vector) {
                while (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return (TextSynthesizerQueueItem)this.queue.elementAt(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int outputItem(TextSynthesizerQueueItem item) {
            int currentCommand;
            boolean wasPaused = false;
            System.out.println("----- BEGIN: " + item.getTypeString() + "-----");
            String engineText = item.getEngineText();
            int engineTextIndex = 0;
            Object object = this.commandLock;
            synchronized (object) {
                currentCommand = this.command;
            }
            while (engineTextIndex < engineText.length()) {
                if (currentCommand == 0) {
                    if (engineTextIndex > 0) {
                        item.postSpeakablePaused();
                        wasPaused = true;
                    }
                    object = this.commandLock;
                    synchronized (object) {
                        while (this.command == 0) {
                            try {
                                this.commandLock.wait();
                            }
                            catch (InterruptedException e) {}
                        }
                        currentCommand = this.command;
                    }
                }
                if (currentCommand != 1) break;
                if (engineTextIndex == 0) {
                    item.postSpeakableStarted();
                } else if (wasPaused) {
                    item.postSpeakableResumed();
                    wasPaused = false;
                }
                engineTextIndex = this.isCommand(engineText, engineTextIndex) ? this.processCommand(item, engineText, engineTextIndex) : (this.isWhitespace(engineText, engineTextIndex) ? this.processWhitespace(engineText, engineTextIndex) : this.processNormalText(item, engineText, engineTextIndex));
                object = this.commandLock;
                synchronized (object) {
                    currentCommand = this.command;
                }
            }
            System.out.println("\n----- END: " + item.getTypeString() + "-----\n");
            return currentCommand;
        }

        protected boolean isCommand(String engineText, int index) {
            if (!engineText.substring(index, index + 1).equals("/")) {
                return false;
            }
            for (int i = 0; i < TextSynthesizerQueueItem.ELEMENTS.length; ++i) {
                if (!engineText.startsWith("/" + TextSynthesizerQueueItem.ELEMENTS[i], index)) continue;
                return true;
            }
            return false;
        }

        protected int processCommand(TextSynthesizerQueueItem item, String engineText, int index) {
            for (int i = 0; i < TextSynthesizerQueueItem.ELEMENTS.length; ++i) {
                if (!engineText.startsWith("/" + TextSynthesizerQueueItem.ELEMENTS[i], index)) continue;
                int endIndex = engineText.indexOf("/", index + 1) + 1;
                String commandText = engineText.substring(index, endIndex);
                System.out.print(commandText);
                System.out.flush();
                return endIndex;
            }
            return index;
        }

        protected boolean isWhitespace(String engineText, int index) {
            return Character.isWhitespace(engineText.charAt(index));
        }

        protected int processWhitespace(String engineText, int index) {
            int endIndex;
            for (endIndex = index; endIndex < engineText.length() && Character.isWhitespace(engineText.charAt(endIndex)); ++endIndex) {
            }
            System.out.print(engineText.substring(index, endIndex));
            System.out.flush();
            try {
                OutputHandler.sleep(60000 / this.rate);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return endIndex;
        }

        protected int processNormalText(TextSynthesizerQueueItem item, String engineText, int index) {
            int endIndex;
            for (endIndex = index + 1; endIndex < engineText.length() && engineText.charAt(endIndex) != '/' && !Character.isWhitespace(engineText.charAt(endIndex)); ++endIndex) {
            }
            String wordStr = engineText.substring(index, endIndex);
            item.postWordStarted(wordStr, index, endIndex);
            System.out.print(wordStr);
            System.out.flush();
            return endIndex;
        }
    }
}

