/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.speech.synthesis.JSMLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSMLParser {
    private DocumentBuilder validatingDocumentBuilder;
    private DocumentBuilder nonvalidatingDocumentBuilder;
    Document document;

    public JSMLParser(String jsmlText, boolean validate) throws JSMLException {
        if (!jsmlText.substring(0, 2).equals("<?")) {
            jsmlText = "<jsml>\n" + jsmlText + "</jsml>\n";
        }
        try {
            this.document = this.parse(new InputSource(new StringReader(jsmlText)), validate);
        }
        catch (IOException e) {
            throw new JSMLException("JSMLParser: " + e.getMessage());
        }
    }

    public JSMLParser(URL jsmlSource, boolean validate) throws JSMLException, IOException {
        InputStream in = jsmlSource.openStream();
        InputSource source = new InputSource(in);
        this.document = this.parse(source, validate);
    }

    public Document getDocument() {
        return this.document;
    }

    private DocumentBuilder getDocumentBuilder(boolean validate) throws JSMLException {
        if (validate && this.validatingDocumentBuilder != null) {
            return this.validatingDocumentBuilder;
        }
        if (!validate && this.nonvalidatingDocumentBuilder != null) {
            return this.nonvalidatingDocumentBuilder;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validate);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setCoalescing(true);
        dbf.setExpandEntityReferences(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (validate) {
                this.validatingDocumentBuilder = db;
            } else {
                this.nonvalidatingDocumentBuilder = db;
            }
            return db;
        }
        catch (ParserConfigurationException e) {
            throw new JSMLException("JSMLParser: " + e.getMessage());
        }
    }

    protected Document parse(InputSource source, boolean validate) throws JSMLException, IOException {
        Document doc;
        DocumentBuilder db = this.getDocumentBuilder(validate);
        try {
            doc = db.parse(source);
        }
        catch (SAXException e) {
            throw new JSMLException("JSMLParser: " + e.getMessage());
        }
        return doc;
    }
}

