/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.synthesis.BaseSynthesizer;
import com.sun.speech.engine.synthesis.JSMLParser;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.speech.SpeechEvent;
import javax.speech.synthesis.JSMLException;
import javax.speech.synthesis.Speakable;
import javax.speech.synthesis.SpeakableEvent;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.SynthesizerQueueItem;
import org.w3c.dom.Document;

public class BaseSynthesizerQueueItem
extends SynthesizerQueueItem
implements SpeechEventDispatcher {
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private Document document = null;
    protected static int itemNumber = 0;
    protected int thisItemNumber = itemNumber++;
    protected BaseSynthesizer synth;

    public BaseSynthesizerQueueItem() {
        super(null, null, false, null);
    }

    protected void setData(BaseSynthesizer synth, Speakable source, SpeakableListener listener) throws JSMLException {
        this.synth = synth;
        this.source = source;
        this.text = source.getJSMLText();
        this.plainText = false;
        this.listener = listener;
        this.document = new JSMLParser(this.text, false).getDocument();
    }

    protected void setData(BaseSynthesizer synth, String source, boolean plainText, SpeakableListener listener) throws JSMLException {
        this.synth = synth;
        this.source = source;
        this.text = source;
        this.plainText = plainText;
        this.listener = listener;
        if (!plainText) {
            this.document = new JSMLParser(this.text, false).getDocument();
        }
    }

    protected void setData(BaseSynthesizer synth, URL source, SpeakableListener listener) throws JSMLException, IOException {
        this.synth = synth;
        this.source = source;
        this.text = null;
        this.plainText = false;
        this.listener = listener;
        this.document = new JSMLParser(source, false).getDocument();
    }

    protected Document getDocument() {
        return this.document;
    }

    protected synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isCompleted() {
        return this.done;
    }

    public synchronized boolean waitCompleted() {
        while (!this.isCompleted()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                System.err.println("FreeTTSSynthesizerQueueItem.Wait interrupted");
                return false;
            }
        }
        return !this.isCancelled();
    }

    public synchronized void cancelled() {
        this.postSpeakableCancelled();
        this.notifyAll();
    }

    public synchronized void completed() {
        this.postSpeakableEnded();
        this.notifyAll();
    }

    public void started() {
        this.postSpeakableStarted();
    }

    public int getItemNumber() {
        return this.thisItemNumber;
    }

    public void postMarkerReached(String text2, int markerType) {
        SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 608, text2, markerType));
    }

    public void fireMarkerReached(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.markerReached(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.markerReached(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSpeakableCancelled() {
        boolean shouldPost;
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this;
        synchronized (baseSynthesizerQueueItem) {
            shouldPost = !this.done;
            this.done = true;
            this.cancelled = true;
        }
        if (shouldPost) {
            SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 606));
        }
    }

    public void fireSpeakableCancelled(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.speakableCancelled(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.speakableCancelled(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSpeakableEnded() {
        boolean shouldPost;
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this;
        synchronized (baseSynthesizerQueueItem) {
            shouldPost = !this.done;
            this.done = true;
        }
        if (shouldPost) {
            SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 603));
        }
    }

    public void fireSpeakableEnded(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.speakableEnded(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.speakableEnded(event);
            }
        }
    }

    public void postSpeakablePaused() {
        SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 604));
    }

    public void fireSpeakablePaused(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.speakablePaused(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.speakablePaused(event);
            }
        }
    }

    public void postSpeakableResumed() {
        SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 605));
    }

    public void fireSpeakableResumed(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.speakableResumed(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.speakableResumed(event);
            }
        }
    }

    public void postSpeakableStarted() {
        SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 602));
    }

    public void fireSpeakableStarted(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.speakableStarted(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.speakableStarted(event);
            }
        }
    }

    public void postTopOfQueue() {
        SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 601));
    }

    public void fireTopOfQueue(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.topOfQueue(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.topOfQueue(event);
            }
        }
    }

    public void postWordStarted(String text2, int wordStart, int wordEnd) {
        SpeechEventUtilities.postSpeechEvent(this, new SpeakableEvent(this.source, 607, text2, wordStart, wordEnd));
    }

    public void fireWordStarted(SpeakableEvent event) {
        if (this.listener != null) {
            this.listener.wordStarted(event);
        }
        if (this.synth.speakableListeners != null) {
            Iterator iterator = this.synth.speakableListeners.iterator();
            while (iterator.hasNext()) {
                SpeakableListener sl = (SpeakableListener)iterator.next();
                sl.wordStarted(event);
            }
        }
    }

    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 608: {
                this.fireMarkerReached((SpeakableEvent)event);
                break;
            }
            case 606: {
                this.fireSpeakableCancelled((SpeakableEvent)event);
                break;
            }
            case 603: {
                this.fireSpeakableEnded((SpeakableEvent)event);
                break;
            }
            case 604: {
                this.fireSpeakablePaused((SpeakableEvent)event);
                break;
            }
            case 605: {
                this.fireSpeakableResumed((SpeakableEvent)event);
                break;
            }
            case 602: {
                this.fireSpeakableStarted((SpeakableEvent)event);
                break;
            }
            case 601: {
                this.fireTopOfQueue((SpeakableEvent)event);
                break;
            }
            case 607: {
                this.fireWordStarted((SpeakableEvent)event);
            }
        }
    }
}

