/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.BaseAudioManager;
import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.speech.AudioException;
import javax.speech.AudioManager;
import javax.speech.Engine;
import javax.speech.EngineEvent;
import javax.speech.EngineException;
import javax.speech.EngineListener;
import javax.speech.EngineModeDesc;
import javax.speech.EngineProperties;
import javax.speech.EngineStateError;
import javax.speech.SpeechEvent;
import javax.speech.VocabManager;

public abstract class BaseEngine
implements Engine,
SpeechEventDispatcher {
    protected long engineState;
    protected Object engineStateLock;
    protected Collection engineListeners;
    protected AudioManager audioManager = null;
    protected EngineModeDesc engineModeDesc = null;
    protected EngineProperties engineProperties = null;
    protected static final long CLEAR_ALL_STATE = -1L;

    public BaseEngine() {
        this(null);
    }

    public BaseEngine(EngineModeDesc desc) {
        this.engineModeDesc = desc;
        this.engineListeners = new ArrayList();
        this.engineState = 1L;
        this.engineStateLock = new Object();
        this.engineProperties = this.createEngineProperties();
    }

    public long getEngineState() {
        return this.engineState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEngineState(long state) throws InterruptedException, IllegalArgumentException {
        Object object = this.engineStateLock;
        synchronized (object) {
            while (!this.testEngineState(state)) {
                this.engineStateLock.wait();
            }
        }
    }

    public boolean testEngineState(long state) throws IllegalArgumentException {
        return (this.getEngineState() & state) == state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] setEngineState(long clear, long set) {
        long[] states = new long[2];
        Object object = this.engineStateLock;
        synchronized (object) {
            states[0] = this.engineState;
            this.engineState &= clear ^ 0xFFFFFFFFFFFFFFFFL;
            this.engineState |= set;
            states[1] = this.engineState;
            this.engineStateLock.notifyAll();
        }
        return states;
    }

    public void allocate() throws EngineException, EngineStateError {
        if (this.testEngineState(4L)) {
            return;
        }
        long[] states = this.setEngineState(-1L, 2L);
        this.postEngineAllocatingResources(states[0], states[1]);
        this.handleAllocate();
    }

    protected abstract void handleAllocate() throws EngineException;

    public void deallocate() throws EngineException, EngineStateError {
        if (this.testEngineState(1L)) {
            return;
        }
        long[] states = this.setEngineState(-1L, 8L);
        this.postEngineDeallocatingResources(states[0], states[1]);
        this.handleDeallocate();
    }

    protected abstract void handleDeallocate() throws EngineException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws EngineStateError {
        Object object = this.engineStateLock;
        synchronized (object) {
            this.checkEngineState(9L);
            if (this.testEngineState(256L)) {
                return;
            }
            this.handlePause();
            long[] states = this.setEngineState(512L, 256L);
            this.postEnginePaused(states[0], states[1]);
        }
    }

    protected abstract void handlePause();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws AudioException, EngineStateError {
        Object object = this.engineStateLock;
        synchronized (object) {
            this.checkEngineState(9L);
            if (this.testEngineState(512L)) {
                return;
            }
            this.handleResume();
            long[] states = this.setEngineState(256L, 512L);
            this.postEngineResumed(states[0], states[1]);
        }
    }

    protected abstract void handleResume();

    public AudioManager getAudioManager() {
        if (this.audioManager == null) {
            this.audioManager = new BaseAudioManager();
        }
        return this.audioManager;
    }

    public VocabManager getVocabManager() throws EngineStateError {
        return null;
    }

    public EngineProperties getEngineProperties() {
        return this.engineProperties;
    }

    public EngineModeDesc getEngineModeDesc() throws SecurityException {
        return this.engineModeDesc;
    }

    protected void setEngineModeDesc(EngineModeDesc desc) {
        this.engineModeDesc = desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngineListener(EngineListener listener) {
        Collection collection = this.engineListeners;
        synchronized (collection) {
            if (!this.engineListeners.contains(listener)) {
                this.engineListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEngineListener(EngineListener listener) {
        Collection collection = this.engineListeners;
        synchronized (collection) {
            this.engineListeners.remove(listener);
        }
    }

    protected void postEngineAllocated(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new EngineEvent(this, 501, oldState, newState));
    }

    public void fireEngineAllocated(EngineEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        Iterator iterator = this.engineListeners.iterator();
        while (iterator.hasNext()) {
            EngineListener el = (EngineListener)iterator.next();
            el.engineAllocated(event);
        }
    }

    protected void postEngineAllocatingResources(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new EngineEvent(this, 503, oldState, newState));
    }

    public void fireEngineAllocatingResources(EngineEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        Iterator iterator = this.engineListeners.iterator();
        while (iterator.hasNext()) {
            EngineListener el = (EngineListener)iterator.next();
            el.engineAllocatingResources(event);
        }
    }

    protected void postEngineDeallocated(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new EngineEvent(this, 502, oldState, newState));
    }

    public void fireEngineDeallocated(EngineEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        Iterator iterator = this.engineListeners.iterator();
        while (iterator.hasNext()) {
            EngineListener el = (EngineListener)iterator.next();
            el.engineDeallocated(event);
        }
    }

    protected void postEngineDeallocatingResources(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new EngineEvent(this, 504, oldState, newState));
    }

    public void fireEngineDeallocatingResources(EngineEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        Iterator iterator = this.engineListeners.iterator();
        while (iterator.hasNext()) {
            EngineListener el = (EngineListener)iterator.next();
            el.engineDeallocatingResources(event);
        }
    }

    protected void postEnginePaused(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new EngineEvent(this, 505, oldState, newState));
    }

    public void fireEnginePaused(EngineEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        Iterator iterator = this.engineListeners.iterator();
        while (iterator.hasNext()) {
            EngineListener el = (EngineListener)iterator.next();
            el.enginePaused(event);
        }
    }

    protected void postEngineResumed(long oldState, long newState) {
        SpeechEventUtilities.postSpeechEvent(this, new EngineEvent(this, 506, oldState, newState));
    }

    public void fireEngineResumed(EngineEvent event) {
        if (this.engineListeners == null) {
            return;
        }
        Iterator iterator = this.engineListeners.iterator();
        while (iterator.hasNext()) {
            EngineListener el = (EngineListener)iterator.next();
            el.engineResumed(event);
        }
    }

    protected abstract BaseEngineProperties createEngineProperties();

    protected void checkEngineState(long state) throws EngineStateError {
        long currentState = this.getEngineState();
        if ((currentState & state) != 0L) {
            throw new EngineStateError("Invalid EngineState: expected=(" + this.stateToString(state) + ") current state=(" + this.stateToString(currentState) + ")");
        }
    }

    protected String stateToString(long state) {
        StringBuffer buf = new StringBuffer();
        if ((state & 1L) != 0L) {
            buf.append(" DEALLOCATED ");
        }
        if ((state & 2L) != 0L) {
            buf.append(" ALLOCATING_RESOURCES ");
        }
        if ((state & 4L) != 0L) {
            buf.append(" ALLOCATED ");
        }
        if ((state & 8L) != 0L) {
            buf.append(" DEALLOCATING_RESOURCES ");
        }
        if ((state & 0x100L) != 0L) {
            buf.append(" PAUSED ");
        }
        if ((state & 0x200L) != 0L) {
            buf.append(" RESUMED ");
        }
        return buf.toString();
    }

    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 501: {
                this.fireEngineAllocated((EngineEvent)event);
                break;
            }
            case 503: {
                this.fireEngineAllocatingResources((EngineEvent)event);
                break;
            }
            case 502: {
                this.fireEngineDeallocated((EngineEvent)event);
                break;
            }
            case 504: {
                this.fireEngineDeallocatingResources((EngineEvent)event);
                break;
            }
            case 505: {
                this.fireEnginePaused((EngineEvent)event);
                break;
            }
            case 506: {
                this.fireEngineResumed((EngineEvent)event);
            }
        }
    }

    public String toString() {
        return this.getEngineModeDesc().getEngineName() + ":" + this.getEngineModeDesc().getModeName();
    }
}

