/*
 * Decompiled with CFR 0.152.
 */
package build;

import bsh2java.log;
import commands.Command;
import commands.SubCommand;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import logOld.LogEntry;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.simpleframework.util.thread.Scheduler;
import utils.ArtASCII;
import utils.internet;
import utils.say;

public class Web
extends Command
implements Container {
    Scheduler queue;
    Connection connection;
    public String webOutput = "";
    private String pageTitle = "winbuilder";
    SubCommand cmdSTART;
    SubCommand cmdSTOP;
    SubCommand cmdOPEN;
    SubCommand cmdINFO;

    @Override
    public String keyword() {
        return "WEB";
    }

    @Override
    public String description() {
        return "Allow users to control this program from a browser";
    }

    @Override
    public String syntaxExample() {
        return "";
    }

    @Override
    public void action() {
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdSTART.isChosen(this.parameters)) {
            this.startServer();
            return;
        }
        if (this.cmdSTOP.isChosen(this.parameters)) {
            try {
                this.connection.close();
                log.write(8, "Stopped the web server");
            }
            catch (IOException ex) {
                log.write(-1, "Failed to stop the web server");
            }
            return;
        }
        if (this.cmdOPEN.isChosen(this.parameters)) {
            String portNumber = this.settings.read("port", "10101");
            internet.openURL("http://127.0.0.1:" + portNumber);
            return;
        }
        if (this.cmdINFO.isChosen(this.parameters)) {
            log.write(30, "IP addresses available on this machine:\n%1", internet.getLocalIP());
        }
    }

    @Override
    public void subCommandsCreate() {
        this.cmdSTART = new SubCommand();
        this.cmdSTART.keyword = "START";
        this.cmdSTART.descriptionShort = "Starts the web server";
        this.cmdSTART.descriptionLong = "";
        this.cmdSTART.syntaxExample = "";
        this.subCommandAdd(this.cmdSTART);
        this.cmdSTOP = new SubCommand();
        this.cmdSTOP.keyword = "STOP";
        this.cmdSTOP.descriptionShort = "Stops the web server";
        this.cmdSTOP.descriptionLong = "";
        this.cmdSTOP.syntaxExample = "";
        this.subCommandAdd(this.cmdSTOP);
        this.cmdOPEN = new SubCommand();
        this.cmdOPEN.keyword = "OPEN";
        this.cmdOPEN.descriptionShort = "Opens the web browser to see our web page";
        this.cmdOPEN.descriptionLong = "";
        this.cmdOPEN.syntaxExample = "";
        this.subCommandAdd(this.cmdOPEN);
        this.cmdINFO = new SubCommand();
        this.cmdINFO.keyword = "INFO";
        this.cmdINFO.descriptionShort = "Provides info about the local IP address";
        this.cmdINFO.descriptionLong = "";
        this.cmdINFO.syntaxExample = "";
        this.subCommandAdd(this.cmdINFO);
    }

    public void startServer() {
        try {
            String portNumber = this.settings.read("port", "10101");
            int serverPort = Integer.parseInt(portNumber);
            this.queue = new Scheduler(20);
            Web container = this;
            this.connection = new SocketConnection(container);
            InetSocketAddress address = new InetSocketAddress(serverPort);
            this.connection.connect(address);
            log.write(20, "Web server is available on port %1 of this machine", portNumber);
        }
        catch (IOException ex) {
            log.write(-1, "Error occurred: %1", ex.getMessage());
        }
    }

    @Override
    public void handle(Request rqst, Response rspns) {
        Task task = new Task(rqst, rspns);
        this.queue.execute(task);
    }

    class Task
    implements Runnable {
        private final Response response;
        private final Request request;

        public Task(Request request, Response response) {
            this.response = response;
            this.request = request;
        }

        String addAutoRefresh() {
            return "<meta http-equiv=\"refresh\" content=\"5\" >";
        }

        String doTitle(String what) {
            return "<title>" + what + "</title>";
        }

        String doHeaderAndBody() {
            return "<head>" + this.doTitle(Web.this.pageTitle) + "</head><body style=\"color: white; background-color: " + "rgb(51, 51, 51);\" alink=\"red\" link=\"red\" " + "vlink=\"silver\" " + "OnLoad=\"document.command.cmdText.focus();\"" + ">";
        }

        String doHeaderAndBodyAutoRefresh() {
            return "<head>" + this.addAutoRefresh() + "</head><body style=\"color: white; background-color: " + "rgb(51, 51, 51);\" alink=\"red\" link=\"red\" " + "vlink=\"silver\">";
        }

        String doWebPageFooter() {
            return "<br></body>";
        }

        String doCommandLine() {
            return "<form method=\"GET\" action=\"/run\" name=\"command\"><input size=\"70\" name=\"cmdText\"><input value=\"Run\" type=\"SUBMIT\"></form>";
        }

        @Override
        public void run() {
            try {
                PrintStream body = this.response.getPrintStream();
                String address = this.request.getAddress().getPath().toString();
                if (address.equals("/run")) {
                    String action = internet.getHTMLparameter(this.request, "cmdText");
                    Web.this.webOutput = "";
                    ((Web)Web.this).core.command.execute(4, action);
                    if (!Web.this.webOutput.isEmpty()) {
                        body.println(Web.this.webOutput);
                        body.close();
                        this.response.close();
                        return;
                    }
                }
                if (address.equals("/log")) {
                    int count;
                    body.println(this.doHeaderAndBodyAutoRefresh());
                    ArrayList<LogEntry> entries = log.getList();
                    if (entries.isEmpty()) {
                        String temp = "<xmp>" + ArtASCII.creditsWithNoSay() + "</xmp>" + "<tt>" + say.something() + "</tt>";
                        body.println(temp);
                    }
                    body.println("<div style=\"width: 100%;\"><tt>");
                    for (int i = count = entries.size() > 21 ? entries.size() - 20 : 1; i <= entries.size(); ++i) {
                        LogEntry entry = entries.get(i - 1);
                        String output = entry.getMessage() + "<br>";
                        output = output.replace("\n", "\n<br>");
                        if (entry.getResult() != 32) {
                            output = entry.getTimeReadable() + " " + output;
                        }
                        body.println(output);
                    }
                    body.println("</tt></div>");
                    body.println(this.doWebPageFooter());
                    body.close();
                    this.response.close();
                    return;
                }
                if (log.getCounter() > 0L) {
                    Web.this.pageTitle = log.getLatest().getMessageSimple();
                }
                body.println(this.doHeaderAndBody());
                body.println(this.doCommandLine());
                body.println("<iframe name=\"iframeName\" src=\"/log\" width=\"100%\" onload=\"document.title=this.contentWindow.document.title;\" height=\"100%\" frameborder=\"0\" align=\"left\" scrolling=\"no\" onload=\"document.title=parent.frames['iframeName'].document.title;\"></iframe><br><br>");
                body.println(this.doWebPageFooter());
                body.close();
                this.response.set("Connection", "close");
                this.response.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Web.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

