/*
 * Decompiled with CFR 0.152.
 */
package build;

import bsh2java.log;
import build.Core;
import commands.Command;
import commands.SubCommand;
import java.io.File;
import javax.swing.JFileChooser;
import rewim.WimParser;
import rewim.core.Image;

public final class Source
extends Command {
    private SubCommand cmdSOURCENONE;
    private SubCommand cmdINFO;
    public String defaultLanguage;
    public String editionid;
    public String description;
    public String displayname;
    public String hal;
    public String name;
    public String arch = "0";
    public String dsparch;
    public String flags;
    public String major = "6";
    public String minor = "1";
    public String build;
    public String spbuild;
    public String splevel;
    public int lastIndex;
    private Boolean sourceValid = false;
    private File sourceFolder;
    private File fileWimInstall;
    private File fileWimBoot;

    public Source() {
        String lastSource = this.settings.read("WinDVDsource", "");
        if (lastSource.isEmpty()) {
            return;
        }
        File temp = new File(lastSource);
        this.sourceValid = this.checkSource(temp);
    }

    public File getFolderSource() {
        return this.sourceFolder;
    }

    public File getFileWimInstall() {
        return this.fileWimInstall;
    }

    public File getFileWimBoot() {
        return this.fileWimBoot;
    }

    public Boolean isValid() {
        return this.sourceValid;
    }

    @Override
    public String keyword() {
        return "SOURCE";
    }

    @Override
    public String description() {
        return "Chooses a Windows source from where the boot disk is built";
    }

    @Override
    public void action() {
        this.chooseSource();
    }

    public String getDetails() {
        if (!this.isValid().booleanValue()) {
            log.write(-5, "You need to first select a valid source");
            return null;
        }
        String temp = this.dsparch.isEmpty() ? "" : this.dsparch + " ";
        return this.displayname + " " + temp + this.defaultLanguage + " " + this.major + "." + this.minor + "." + this.build + "." + this.spbuild + " with SP" + this.splevel;
    }

    String getVersion() {
        return this.major + "." + this.minor + "." + this.build + "." + this.spbuild;
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdSOURCENONE.isChosen(this.parameters)) {
            this.settings.delete("WinDVDsource");
            log.write(20, "No source folder is currently selected");
            this.sourceValid = false;
            return;
        }
        if (this.cmdINFO.isChosen(this.parameters)) {
            if (!this.isValid().booleanValue()) {
                log.write(-5, "You need to first select a valid source");
                return;
            }
            log.write(30, "%1", this.getDetails());
            return;
        }
        this.setSource(new File(this.parameters));
    }

    public void setSource(File target) {
        if (this.checkSource(target).booleanValue()) {
            this.sourceValid = true;
            this.settings.write("WinDVDsource", target.getAbsolutePath());
            this.settings.write("wimIndexInstall", new Integer(this.lastIndex).toString());
            this.settings.write("wimIndexBoot", "2");
            log.write(22, "Defined source as %1 at location %2", this.getDetails(), target.getAbsolutePath());
        }
    }

    private Boolean checkSource(File source) {
        if (!(!source.exists() || source.isDirectory())) {
            return false;
        }
        File test1 = new File(source, "/sources/boot.wim");
        File test2 = new File(source, "/sources/install.wim");
        if (!test1.exists() || !test2.exists()) {
            return false;
        }
        this.sourceFolder = source;
        this.fileWimInstall = new File(source, "/sources/install.wim");
        this.fileWimBoot = new File(source, "/sources/boot.wim");
        if (!this.processInfo(0).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public void subCommandsCreate() {
        this.cmdSOURCENONE = new SubCommand();
        this.cmdSOURCENONE.keyword = "NONE";
        this.cmdSOURCENONE.descriptionShort = "Removes the information about the selected source folder";
        this.cmdSOURCENONE.descriptionLong = "";
        this.cmdSOURCENONE.syntaxExample = "- Example to deselect folder as source:\n" + this.keyword() + " " + this.cmdSOURCENONE.keyword;
        this.subCommandAdd(this.cmdSOURCENONE);
        this.cmdINFO = new SubCommand();
        this.cmdINFO.keyword = "INFO";
        this.cmdINFO.descriptionShort = "Provides informations about the selected Windows source";
        this.cmdINFO.descriptionLong = "";
        this.cmdINFO.syntaxExample = "- Example to display the selected source folder:\n" + this.keyword() + " " + this.cmdINFO.keyword;
        this.subCommandAdd(this.cmdINFO);
    }

    @Override
    public String syntaxExample() {
        return "- Example to select a folder as project source: \n" + this.keyword() + " c:\\test\\win7\n\n";
    }

    public Boolean processInfo(String index) {
        return this.processInfo(Integer.parseInt(index));
    }

    public Boolean processInfo(int index) {
        try {
            Image wimImage = new WimParser(this.fileWimInstall.getAbsolutePath()).liteParse();
            String originalXML = wimImage.getOrigXml();
            String actImage = "enter while";
            String lastImage = "";
            if (index == 0) {
                int i = 1;
                this.lastIndex = 1;
                while (!actImage.equals("")) {
                    if ((actImage = this.getXMLsection("IMAGE", i++, originalXML)).equals("")) continue;
                    lastImage = actImage;
                    this.lastIndex = i - 1;
                }
            } else {
                lastImage = this.getXMLsection("IMAGE", index, originalXML);
                this.lastIndex = index;
            }
            this.defaultLanguage = this.getXMLdata("DEFAULT", lastImage);
            this.major = this.getXMLdata("MAJOR", lastImage);
            this.minor = this.getXMLdata("MINOR", lastImage);
            this.build = this.getXMLdata("BUILD", lastImage);
            this.spbuild = this.getXMLdata("SPBUILD", lastImage);
            this.splevel = this.getXMLdata("SPLEVEL", lastImage);
            this.editionid = this.getXMLdata("EDITIONID", lastImage);
            this.description = this.getXMLdata("DESCRIPTION", lastImage);
            this.displayname = this.getXMLdata("DISPLAYNAME", lastImage);
            this.name = this.getXMLdata("NAME", lastImage);
            this.arch = this.getXMLdata("ARCH", lastImage);
            this.flags = this.getXMLdata("FLAGS", lastImage);
            this.hal = this.getXMLdata("HAL", lastImage);
        }
        catch (Exception ex) {
            log.write(-1, "Error occurred while reading the install.wim file from our source. The error message is %1", ex.getMessage());
            return false;
        }
        if (this.arch.equals("0")) {
            this.dsparch = "32 bit";
        } else if (this.arch.equals("9")) {
            this.dsparch = "64 bit";
        }
        return true;
    }

    String getXMLdata(String what, String from) {
        int size = what.length();
        String result = from.substring(from.indexOf("<" + what + ">") + size + 2, from.indexOf("</" + what + ">"));
        return result;
    }

    String getXMLsection(String what, int index, String from) {
        String label = " INDEX=\"" + new Integer(index).toString() + "\"";
        int size = what.length() + label.length();
        int fromIndex = from.indexOf("<" + what + label + ">");
        if (fromIndex == -1) {
            return "";
        }
        int toIndex = from.indexOf("</" + what + ">", fromIndex += size + 2);
        String result = from.substring(fromIndex, toIndex);
        return result;
    }

    String getCustomXML() {
        return "<WINDOWS><ARCH>" + this.arch + "</ARCH>" + "<PRODUCTNAME>Microsoft\u00ae Windows\u00ae Operating System" + "</PRODUCTNAME><EDITIONID>WindowsPE</EDITIONID>" + "<INSTALLATIONTYPE>WindowsPE</INSTALLATIONTYPE>" + "<PRODUCTTYPE>WinNT</PRODUCTTYPE>" + "<PRODUCTSUITE>Terminal Server</PRODUCTSUITE>" + "<LANGUAGES><LANGUAGE>" + this.defaultLanguage + "</LANGUAGE>" + "<DEFAULT>" + this.defaultLanguage + "</DEFAULT>" + "</LANGUAGES>" + "<VERSION>" + "<MAJOR>" + this.major + "</MAJOR>" + "<MINOR>" + this.minor + "</MINOR>" + "<BUILD>" + this.build + "</BUILD>" + "<SPBUILD>" + this.spbuild + "</SPBUILD>" + "<SPLEVEL>" + this.splevel + "</SPLEVEL>" + "</VERSION>" + "<SYSTEMROOT>WINDOWS</SYSTEMROOT>" + "</WINDOWS>";
    }

    private void chooseSource() {
        try {
            JFileChooser fc = new JFileChooser();
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(1);
            String lastDir = this.settings.read("LastDir", "");
            File lastFolder = new File(lastDir);
            if (lastFolder.exists()) {
                fc.setCurrentDirectory(new File(lastDir));
            }
            fc.setDialogTitle("Open directory");
            if (fc.showOpenDialog(Core.sys.gui) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            this.settings.write("LastDir", file.getAbsolutePath());
            this.core.command.execute(2, this.core.source.keyword() + " " + file.getAbsolutePath());
            if (!this.core.source.isValid().booleanValue()) {
                log.write(-4, "The selected source at %1 is not a valid Windows source folder.", file.getAbsolutePath());
                return;
            }
            log.write(30, "You can start the build right now if you wish. Just type \"build\" to get started");
            this.core.build.defaultLanguage = this.core.source.defaultLanguage;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

