/*
 * Decompiled with CFR 0.152.
 */
package build;

import bsh2java.log;
import downloads.Entry;
import downloads.Resource;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTMLEditorKit;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import utils.Settings;

public class SettingsGUI
extends JFrame {
    Entry entry;
    Resource resource;
    private final String plugins = "$Plugins";
    private final String components = "$Components";
    private final String files = "$Files";
    private final String submitBtn = "$SubmitButton";
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public SettingsGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL imgURL = this.getClass().getResource("reboot.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(imgURL));
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("settings");
        this.setBackground(new Color(255, 255, 255));
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setBorder(null);
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setMargin(new Insets(10, 10, 10, 10));
        this.jTextPane1.setVerifyInputWhenFocusTarget(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jTextPane1.getAccessibleContext().setAccessibleDescription("");
        this.jTextPane1.getAccessibleContext().setAccessibleParent(this.jTextPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 486, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 294, Short.MAX_VALUE));
        this.jScrollPane1.getAccessibleContext().setAccessibleParent(null);
        this.pack();
    }

    public void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SettingsGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SettingsGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SettingsGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SettingsGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SettingsGUI().setVisible(true);
            }
        });
    }

    void doFormInterception() {
        HTMLEditorKit kit = (HTMLEditorKit)this.jTextPane1.getEditorKit();
        kit.setAutoFormSubmission(false);
        this.jTextPane1.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e instanceof FormSubmitEvent) {
                    SettingsGUI.this.processFormSubmit(((FormSubmitEvent)e).getData());
                }
            }
        });
    }

    public void showItem(Entry entry, Resource resource, String webpage) {
        this.entry = entry;
        this.resource = resource;
        this.doFormInterception();
        File configFile = resource.getFileSettingsCache();
        if (configFile.exists() && configFile.isFile()) {
            Settings config = new Settings(configFile, "");
            Source source = new Source(webpage);
            FormFields formFields = source.getFormFields();
            Enumeration e = config.getAllKeys();
            AccessibleContext fc = this.getAccessibleContext();
            while (e.hasMoreElements()) {
                FormField fld;
                String key = (String)e.nextElement();
                if (key.equals("")) continue;
                String value = config.read(key);
                if (!key.startsWith("$")) {
                    formFields.addValue(key, value);
                    continue;
                }
                if (key.equals("$Plugins")) {
                    fld = formFields.get("$Plugins");
                } else if (key.equals("$Components")) {
                    fld = formFields.get("$Components");
                } else if (key.equals("$Files")) {
                    fld = formFields.get("$Files");
                } else {
                    return;
                }
                if (fld == null) continue;
                fld.clearValues();
                String[] plugs = value.split("\\|");
                for (int i = 0; i < plugs.length; ++i) {
                    fld.addValue(plugs[i]);
                }
            }
            OutputDocument outputDocument = new OutputDocument(source);
            outputDocument.replace(formFields);
            webpage = outputDocument.toString();
        }
        AccessibleContext ac = this.getAccessibleContext();
        AccessibleContext tc = this.jTextPane1.getAccessibleContext();
        this.jTextPane1.setText(webpage);
        this.jTextPane1.setCaretPosition(0);
        if (entry.version != null) {
            this.setTitle(entry.title + " " + entry.version);
        } else {
            this.setTitle(entry.title);
        }
        this.setVisible(true);
    }

    void processFormSubmit(String text2) {
        String pluginList = "";
        String compList = "";
        String filesList = "";
        String[] params = text2.split("&");
        boolean hasPlugins = false;
        boolean hasFiles = false;
        boolean hasComponents = false;
        Settings formSettings = new Settings(this.resource.getFileSettingsCache(), "Settings for " + this.entry.title);
        for (String param : params) {
            String[] pair = param.split("=");
            String value = "";
            String key = "";
            if (pair.length > 1) {
                try {
                    key = URLDecoder.decode(pair[0], "UTF-8");
                    value = URLDecoder.decode(pair[1], "UTF-8");
                }
                catch (Exception e) {
                    log.write(-1, "Failed to save settings for %1", this.entry.title);
                    return;
                }
            }
            if (pair.length == 1) {
                try {
                    key = URLDecoder.decode(pair[0], "UTF-8");
                }
                catch (Exception e) {
                    log.write(-1, "Failed to save settings for %1", this.entry.title);
                    return;
                }
            }
            if (key.startsWith("$")) {
                if (key.equalsIgnoreCase("$Plugins")) {
                    hasPlugins = true;
                    if (!pluginList.equals("")) {
                        pluginList = pluginList.concat("|");
                    }
                    pluginList = pluginList.concat(value);
                    continue;
                }
                if (key.equalsIgnoreCase("$Files")) {
                    hasFiles = true;
                    if (!filesList.equals("")) {
                        filesList = filesList.concat("|");
                    }
                    filesList = filesList.concat(value);
                    continue;
                }
                if (!key.equalsIgnoreCase("$Components")) continue;
                hasComponents = true;
                if (!compList.equals("")) {
                    compList = compList.concat("|");
                }
                compList = compList.concat(value);
                continue;
            }
            if (key.startsWith("!")) continue;
            formSettings.write(key, value.trim());
        }
        if (hasPlugins) {
            formSettings.write("$Plugins", pluginList);
        } else {
            formSettings.delete("$Plugins");
        }
        if (hasFiles) {
            formSettings.write("$Files", filesList);
        } else {
            formSettings.delete("$Files");
        }
        if (hasComponents) {
            formSettings.write("$Components", compList);
        } else {
            formSettings.delete("$Components");
        }
        log.write(20, "Settings for %1 were saved", this.entry.title);
        this.setVisible(false);
        this.dispose();
    }
}

