/*
 * Decompiled with CFR 0.152.
 */
package build;

import bsh2java.log;
import build.Core;
import build.Filter;
import build.TimeThread;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import utils.ArtASCII;
import utils.currentOS;

public final class GUI
extends JFrame {
    long lastMessageCounter = 0L;
    Core core;
    final String actionChooseDir = "Choose your source";
    final String actionBuild = "Build!";
    final String defaultTextField = "Choose the folder where your Windows Install files are located ->";
    final String settingsFile = "winbuilder.xml";
    public int promptPosition = -1;
    public String prompt = " > ";
    public String promptBeingTyped = "";
    public boolean restart = false;
    JScrollPane jScrollPane1;
    JTextArea textArea;

    public GUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL imgURL = this.getClass().getResource("reboot.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(imgURL));
        this.initComponents();
        this.loadSettings();
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GUI.this.textAreaKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                GUI.this.textAreaKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                GUI.this.textAreaKeyTyped(evt);
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GUI.this.doMouseClick(evt);
            }
        });
    }

    public void setRestart() {
        log.print("You MUST restart WinBuilder now! Just hit \"Enter\" to restart");
        this.restart = true;
    }

    void loadSettings() {
        this.core = Core.sys;
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (currentOS.isUnix()) {
            this.textArea.setFont(new Font("DejaVu Sans Mono", 0, 10));
        }
        String initialText = ArtASCII.text("    wb   ", 2) + "\n" + ArtASCII.initialWelcome() + "\n";
        this.textArea.setText(initialText + this.prompt);
        this.moveToBottom();
        this.docFilter(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("winbuilder");
        this.setBackground(new Color(255, 255, 255));
        this.setLocationByPlatform(true);
        this.jScrollPane1.setAlignmentX(0.0f);
        this.jScrollPane1.setAlignmentY(0.0f);
        this.textArea.setBackground(new Color(51, 51, 51));
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Consolas", 0, 11));
        this.textArea.setForeground(new Color(255, 255, 255));
        this.textArea.setLineWrap(true);
        this.textArea.setRows(5);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setAlignmentX(0.0f);
        this.textArea.setAlignmentY(0.0f);
        this.textArea.setBorder(null);
        this.textArea.setCaretColor(new Color(255, 255, 255));
        this.textArea.setCursor(new Cursor(0));
        this.jScrollPane1.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleParent(this.textArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 644, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        this.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GUI().setVisible(true);
            }
        });
    }

    public void launch(Core core) {
        this.core = core;
        TimeThread time2 = new TimeThread(core);
        time2.start();
        core.gui.setVisible(true);
        core.downloads.upgrade.isUpgradeNeeded();
    }

    public void updateLog() {
        String text2 = this.textArea.getText();
        if (text2.isEmpty()) {
            text2 = this.prompt + this.promptBeingTyped;
            this.promptPosition = this.prompt.length();
            this.docFilter(false);
            this.textArea.setText(text2);
            this.docFilter(true);
            this.moveToBottom();
            return;
        }
        if (this.promptPosition == -1) {
            this.promptPosition = text2.length();
            return;
        }
        if (this.promptPosition > text2.length()) {
            this.promptPosition = text2.length();
        }
        if (log.getCounter() == this.lastMessageCounter) {
            return;
        }
        String newMessages = log.getMessagesSince(this.lastMessageCounter);
        this.lastMessageCounter = log.getCounter();
        int textPosEnd = this.promptPosition - this.prompt.length();
        String oldText = text2.substring(0, textPosEnd);
        if (this.promptBeingTyped.contains("\n")) {
            this.promptBeingTyped = "";
        }
        String newText = oldText + newMessages + this.prompt + this.promptBeingTyped;
        this.promptPosition = oldText.length() + newMessages.length() + this.prompt.length();
        this.docFilter(false);
        this.textArea.setText(newText);
        this.docFilter(true);
        this.moveToBottom();
    }

    void docFilter(Boolean activate) {
        if (activate.booleanValue()) {
            ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new Filter());
        } else {
            ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(null);
        }
    }

    void moveToBottom() {
        Document d = this.textArea.getDocument();
        this.textArea.select(d.getLength(), d.getLength());
    }

    private void doMouseClick(MouseEvent evt) {
        int x = this.textArea.getCaretPosition();
        if (x < this.promptPosition) {
            this.textArea.setCaretPosition(this.promptPosition);
        }
    }

    public void textAreaKeyTyped(KeyEvent e) {
    }

    public void textAreaKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int pos;
            int len;
            if (this.restart) {
                try {
                    Core.RestartApplication();
                }
                catch (IOException ex) {
                    Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if ((len = this.textArea.getText().length()) != (pos = this.textArea.getCaretPosition())) {
                this.textArea.setCaretPosition(len);
            }
        } else if (e.getKeyCode() == 27) {
            e.consume();
            this.textArea.replaceRange("", this.promptPosition, this.textArea.getText().length());
        } else if (e.getKeyCode() == 38) {
            e.consume();
            String line = this.core.command.getPrevCmd();
            this.commonLine(line);
        } else if (e.getKeyCode() == 40) {
            e.consume();
            String line = this.core.command.getNextCmd();
            this.commonLine(line);
        } else if (e.getKeyCode() == 36) {
            e.consume();
            this.textArea.setCaretPosition(this.promptPosition);
        }
    }

    private void commonLine(String line) {
        this.textArea.replaceRange("", this.promptPosition, this.textArea.getText().length());
        this.textArea.append(line);
        this.textArea.setCaretPosition(this.promptPosition + line.length());
    }

    public void textAreaKeyReleased(KeyEvent e) {
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

