/*
 * Decompiled with CFR 0.152.
 */
package build;

import bsh2java.log;
import build.Builder;
import build.GUI;
import build.Source;
import build.Web;
import commands.Commander;
import downloads.DownloadsHandler;
import downloads.common;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import licenses.CommandCREDITS;
import licenses.RegistrationLib;
import scripts.Script;
import scripts.Starter;
import utils.Settings;
import utils.UpdateTracker;
import utils.currentOS;
import utils.files;
import win7pecore.Win7PE;

public class Core {
    public static String version = "2016.03.28";
    public static final boolean doRegistrationStuff = true;
    public static final boolean doCertificationStuff = true;
    public final boolean noRebootWBC = true;
    private static final String downloadListURL = "https://github.com/winbuilder/download/raw/master/list.ini";
    GUI gui;
    public Web web;
    public Builder build;
    public Source source;
    public Win7PE winpecore;
    public Commander command;
    public Script script;
    public DownloadsHandler downloads;
    Starter starter;
    public CommandCREDITS credits;
    public RegistrationLib registrationLib;
    public boolean useRegistration;
    public boolean useCertification;
    public Settings settings;
    public File appDir;
    UpdateTracker myTask;
    public Integer uiAvailable = 0;
    public static HashMap temp = new HashMap();
    public static Core sys = new Core();

    public static void main(String[] args) {
        sys.retrieveAppDir();
        File settingsXML = new File(sys.retrieveAppDir(), "winbuilder.xml");
        Core.sys.settings = new Settings(settingsXML, "Settings");
        log.EnableTranslator("EN", "English (US)");
        log.setSpeechMode(Core.sys.settings.read("TTS", "OFF"));
        log.setBeepInterval(Core.sys.settings.read("BeepInterval", "3000"));
        log.setLogMode(Core.sys.settings.read("FILELOG", "OFF"));
        log.setBeepMode(Core.sys.settings.read("BEEP", "OFF"));
        Core.sys.downloads = new DownloadsHandler(downloadListURL);
        Core.sys.script = new Script();
        Core.sys.source = new Source();
        Core.sys.build = new Builder();
        Core.sys.build.defaultLanguage = Core.sys.source.defaultLanguage;
        Core.sys.web = new Web();
        Core.sys.credits = new CommandCREDITS();
        String sep = System.getProperty("file.separator");
        Core.sys.settings.write("FileSeparator", sep);
        String userinput = Core.sys.settings.read("DownloadCatalog", "10");
        Core.sys.settings.write("DownloadCatalog", userinput);
        if (Core.sys.registrationLib == null) {
            Core.sys.registrationLib = new RegistrationLib("");
        }
        Core.sys.useRegistration = true;
        Core.sys.useCertification = true;
        Core.sys.winpecore = new Win7PE();
        Core.sys.registrationLib.setPeLibrary(Core.sys.winpecore.winPeLibrary);
        Core.sys.command = new Commander();
        Core.sys.starter = new Starter();
        String projectName = Core.sys.settings.read("Project");
        if (projectName == null) {
            projectName = "Win7PE";
            Core.sys.settings.write("Project", projectName);
        }
        if (args.length == 0) {
            Core.sys.uiAvailable = 2;
            Core.sys.gui = new GUI();
            if (!common.getFolderDownloads().exists()) {
                files.mkdirs(common.getFolderDownloads());
            }
            Core.sys.gui.launch(sys);
        }
        if (Core.sys.settings.hasKey("Upgrade").booleanValue()) {
            log.write(30, "Upgrade done. Latest version of WinBuilder is running");
            Core.sys.settings.delete("Upgrade");
        }
        if (args.length > 0) {
            String arguments = "";
            boolean doquit = false;
            for (String arg : args) {
                if (arg.toLowerCase().equals("-q") || arg.toLowerCase().equals("/q")) {
                    doquit = true;
                    continue;
                }
                arguments = arguments + arg + " ";
            }
            int t = Thread.activeCount();
            Core.sys.command.execute(0, arguments.trim());
            if (doquit) {
                while (Thread.activeCount() > t) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Core.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                System.exit(0);
            }
        }
    }

    public GUI getGui() {
        return this.gui;
    }

    private File retrieveAppDir() {
        File result = null;
        try {
            result = new File(".").getCanonicalFile();
        }
        catch (IOException ex) {
            Logger.getLogger(Core.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!result.getName().equals("run")) {
            File test;
            String path;
            String decodedPath = path = Core.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            try {
                decodedPath = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            result = new File(decodedPath);
            while (!(test = new File(result, "winbuilder.jar")).exists()) {
                result = result.getParentFile();
            }
        }
        Core.sys.appDir = result;
        String dir2 = result.getAbsolutePath();
        System.setProperty("appDir", dir2);
        return result;
    }

    public static void RestartApplication() throws IOException {
        try {
            File home = new File(System.getProperty("java.home"));
            File bin = new File(home, "bin");
            String key = "";
            if (currentOS.isWindows()) {
                key = "java.exe";
            } else if (currentOS.isUnix()) {
                key = "java";
            } else if (currentOS.isMac()) {
                key = "java";
            }
            String java = new File(bin, key).getAbsolutePath();
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            StringBuffer vmArgsOneLine = new StringBuffer();
            for (String arg : vmArguments) {
                if (!arg.contains("-Xm")) continue;
                vmArgsOneLine.append(arg);
                vmArgsOneLine.append(" ");
            }
            final StringBuffer cmd = new StringBuffer("\"" + java + "\" " + vmArgsOneLine);
            cmd.append("-jar winbuilder.jar");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(cmd.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            temp.remove("restart");
            System.exit(0);
        }
        catch (Exception e) {
            throw new IOException("Error while trying to restart the application", e);
        }
    }
}

