/*
 * Decompiled with CFR 0.152.
 */
package build;

import bsh.Interpreter;
import bsh2java.log;
import build.Core;
import build.Project;
import commands.Command;
import commands.SubCommand;
import create.CreateBootableISO;
import create.CreateBootableWIM;
import downloads.common;
import java.io.File;
import rewim.core.CompressMode;
import utils.Settings;
import utils.time;
import win7pecore.Win7PE;

public final class Builder
extends Command {
    public File folderTarget;
    public File folderPeWIM;
    public File folderInstallWIM;
    public File folderExtra;
    public File folderWinPEsource;
    public File folderBase;
    public File ISOfile;
    public File outFileReference;
    Project project;
    Builder runner;
    String defaultLanguage;
    String ISOfileName;
    String referenceISOFile;
    String referenceBootdiskFolder;
    String referenceWimFile;
    String referencePeFolder;
    String wimPath;
    SubCommand cmdISO;
    SubCommand cmdCore;
    SubCommand cmdCache;
    SubCommand cmdWIM;

    public Builder() {
        String folderRoot = System.getProperty("appDir");
        this.folderTarget = new File(folderRoot, "output");
        this.folderPeWIM = new File(this.folderTarget, "wim-boot");
        this.folderBase = new File(this.folderTarget, "bootdisk");
        this.ISOfileName = "bootdisk.iso";
        this.ISOfile = new File(this.folderTarget, this.ISOfileName);
        this.wimPath = "sources/boot.wim";
        this.outFileReference = new File("output");
        this.referenceISOFile = new File(this.outFileReference, "bootdisk.iso").getPath();
        File tmp = new File(this.outFileReference, "bootdisk");
        this.referenceBootdiskFolder = tmp.getPath();
        tmp = new File(tmp, "sources/boot.wim");
        this.referenceWimFile = tmp.getPath();
        tmp = new File(this.outFileReference, "wim-boot");
        this.referencePeFolder = tmp.getPath();
        this.settings = this.core.settings;
        this.defaultLanguage = this.core.source.defaultLanguage;
    }

    public Project getProject() {
        return this.project;
    }

    public Boolean hasProject() {
        return this.settings.hasKey("Project");
    }

    void chooseProject() {
        if (!this.settings.hasKey("Project").booleanValue()) {
            this.project = null;
            return;
        }
        String temp = this.settings.read("Project");
        File folder = common.getFolder(temp);
        File script = new File(folder, "project.bsh");
        if (!script.exists() || script.isDirectory()) {
            this.project = null;
            return;
        }
        Interpreter scriptResult = this.core.script.run(script);
        Project result = null;
        try {
            scriptResult.set("folderBase", this.folderBase);
            result = (Project)scriptResult.get("project");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result == null) {
            this.project = null;
            return;
        }
        this.project = result;
    }

    @Override
    public void run() {
        this.isThreadProcessing = true;
        this.isProcessing = true;
        long timeStarted = System.currentTimeMillis();
        this.chooseProject();
        if (this.project == null) {
            if (Core.sys.source.defaultLanguage == null) {
                log.write(-5, "You need to first select a valid source");
            } else {
                Core.sys.winpecore = new Win7PE();
                if (!Core.sys.winpecore.sourceFilesFolder.exists()) {
                    this.core.command.execute("BUILD CACHE");
                }
                timeStarted = System.currentTimeMillis();
                this.core.command.execute("BUILD CORE");
                if (Core.sys.winpecore.hasFinished) {
                    this.core.command.execute("BUILD WIM");
                    this.core.command.execute("BUILD ISO");
                }
                long timeConcluded = System.currentTimeMillis();
                long timeOverall = timeConcluded - timeStarted;
                log.write(20, "Project build was concluded in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
                log.closeBeep();
            }
            return;
        }
        if (!this.core.source.isValid().booleanValue()) {
            log.write(-4, "No source is defined for building.");
            return;
        }
        this.core.source.processInfo(Core.sys.settings.read("wimIndexInstall", "1"));
        log.write(30, "Using as source %1", this.core.source.getDetails());
        this.project.create();
        long timeConcluded = System.currentTimeMillis();
        long timeOverall = timeConcluded - timeStarted;
        if (this.project.buildResult()) {
            log.write(20, "Project build was concluded in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
        } else {
            log.write(36, "Due to fatal errors project build was aborted after %1.", "" + time.timeNumberToHumanReadable(timeOverall));
        }
        this.folderPeWIM = null;
        this.folderBase = null;
        this.folderTarget = null;
        this.isThreadProcessing = false;
        this.isProcessing = false;
        this.core.build.isProcessing = false;
    }

    @Override
    public String keyword() {
        return "BUILD";
    }

    @Override
    public String description() {
        return "Creates a new boot disk PE ISO using the actual project";
    }

    @Override
    public void action() {
        if (this.runner == null) {
            this.runner = new Builder();
        }
        if (this.runner.getState() == Thread.State.TERMINATED) {
            this.runner = new Builder();
        }
        if (this.runner.getState() == Thread.State.NEW) {
            this.runner.start();
            return;
        }
        if (this.runner.isThreadProcessing.booleanValue()) {
            log.write(-2, "Please wait for the build to end before starting a new one.");
        }
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdCore.isChosen(this.parameters)) {
            this.cmdWin7PE();
            return;
        }
        if (this.cmdCache.isChosen(this.parameters)) {
            this.cmdWin7PECache();
            return;
        }
        if (this.cmdISO.isChosen(this.parameters)) {
            if (this.folderBase.exists()) {
                long timeStarted = System.currentTimeMillis();
                CreateBootableISO createISO = new CreateBootableISO();
                if (this.settings.hasKey("projectSettings").booleanValue()) {
                    String temp;
                    File settingsFile = new File(this.settings.read("projectSettings"));
                    Settings prjSettings = new Settings(settingsFile, "");
                    if (prjSettings.hasKey("ISO-DirDepth").booleanValue() && (temp = prjSettings.read("ISO-DirDepth")).equalsIgnoreCase("True")) {
                        createISO.handleOption("no-restrict-dirdepth");
                    }
                    if (prjSettings.hasKey("ISO-ElTorito").booleanValue() && !(temp = prjSettings.read("ISO-ElTorito")).equalsIgnoreCase("True")) {
                        createISO.handleOption("disable-eltorito");
                    }
                    if (prjSettings.hasKey("ISO-Joliet").booleanValue() && !(temp = prjSettings.read("ISO-Joliet")).equalsIgnoreCase("True")) {
                        createISO.handleOption("disable-joliet");
                    }
                    if (prjSettings.hasKey("ISO-RockRidge").booleanValue() && !(temp = prjSettings.read("ISO-RockRidge")).equalsIgnoreCase("True")) {
                        createISO.handleOption("disable-rockridge");
                    }
                }
                String temp = this.settings.read("Project");
                createISO.setVolumeId(temp);
                createISO.Start(this.folderBase, this.ISOfile);
                long timeConcluded = System.currentTimeMillis();
                long timeOverall = timeConcluded - timeStarted;
                log.write(21, "ISO built in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
            } else {
                log.write(-1, "Folder %1 does not exist!", this.folderBase.getAbsolutePath());
            }
            return;
        }
        if (this.cmdWIM.isChosen(this.parameters)) {
            if (this.folderPeWIM.exists()) {
                File settingsFile;
                Settings prjSettings;
                long timeStarted = System.currentTimeMillis();
                CompressMode compressMode = CompressMode.NONE;
                if (this.settings.hasKey("projectSettings").booleanValue() && (prjSettings = new Settings(settingsFile = new File(this.settings.read("projectSettings")), "")).hasKey("WIMCompress").booleanValue()) {
                    String temp = prjSettings.read("WIMCompress");
                    compressMode = CompressMode.valueOf(temp);
                }
                File bootableWIM = new File(this.folderBase, "sources/boot.wim");
                String temp = this.settings.read("Project");
                CreateBootableWIM createWIM = new CreateBootableWIM(this.folderPeWIM, bootableWIM, temp, compressMode);
                long timeConcluded = System.currentTimeMillis();
                long timeOverall = timeConcluded - timeStarted;
                log.write(21, "WIM built in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
                createWIM.checkSuccess();
                createWIM = null;
                System.gc();
            } else {
                log.write(-1, "Folder %1 does not exist!", this.folderPeWIM.getAbsolutePath());
            }
            return;
        }
        log.write(-1, "Command \"%1\" was not recognized", this.parameters);
    }

    private boolean cmdWin7PE() {
        if (this.isProcessing) {
            log.write(-2, "A build is already running. Not allowed to start a new build");
            return false;
        }
        long timeStarted = System.currentTimeMillis();
        boolean res = Core.sys.winpecore.buildWin7PE();
        if (res) {
            long timeConcluded = System.currentTimeMillis();
            long timeOverall = timeConcluded - timeStarted;
            log.write(21, "wim-boot directory built in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
        }
        return res;
    }

    private boolean cmdWin7PECache() {
        if (this.isProcessing) {
            log.write(-2, "A build is already running. Not allowed to start a new build");
            return false;
        }
        long timeStarted = System.currentTimeMillis();
        boolean res = Core.sys.winpecore.buildWin7PECache();
        if (res) {
            long timeConcluded = System.currentTimeMillis();
            long timeOverall = timeConcluded - timeStarted;
            log.write(21, "cache built in %1.", "" + time.timeNumberToHumanReadable(timeOverall));
        }
        return res;
    }

    @Override
    public void subCommandsCreate() {
        this.cmdCache = new SubCommand();
        this.cmdCache.keyword = "CACHE";
        this.cmdCache.descriptionShort = "Cache often used Win7PE files (extract from WIM once)";
        this.cmdCache.descriptionLong = "";
        this.cmdCache.syntaxExample = "";
        this.subCommandAdd(this.cmdCache);
        this.cmdCore = new SubCommand();
        this.cmdCore.keyword = "CORE";
        this.cmdCore.descriptionShort = "Creates a Win7PE build assembly from built-in project";
        this.cmdCore.descriptionLong = "";
        this.cmdCore.syntaxExample = "";
        this.subCommandAdd(this.cmdCore);
        this.cmdISO = new SubCommand();
        this.cmdISO.keyword = "ISO";
        this.cmdISO.descriptionShort = "Creates a new ISO file " + this.referenceISOFile + " from " + this.referenceBootdiskFolder + " folder";
        this.cmdISO.descriptionLong = "";
        this.cmdISO.syntaxExample = "- Example to build only the ISO file:\n" + this.keyword() + " ISO";
        this.subCommandAdd(this.cmdISO);
        this.cmdWIM = new SubCommand();
        this.cmdWIM.keyword = "WIM";
        this.cmdWIM.descriptionShort = "Creates a new " + this.referenceWimFile + " archive from " + this.referencePeFolder + " folder";
        this.cmdWIM.descriptionLong = "";
        this.cmdWIM.syntaxExample = "- Example to build only the WIM archive:\n" + this.keyword() + " WIM";
        this.subCommandAdd(this.cmdWIM);
    }

    @Override
    public String syntaxExample() {
        return "- Example to build the actual choosen external project: \n" + this.keyword() + "\n\n";
    }

    @Override
    public boolean isProcessing() {
        if (this.isThreadProcessing.booleanValue()) {
            this.isProcessing = true;
        }
        if (this.runner != null && this.runner.isThreadProcessing.booleanValue()) {
            this.isProcessing = true;
        }
        return this.isProcessing;
    }
}

