/*
 * Decompiled with CFR 0.152.
 */
package bsh2java;

import acessibility.Log2File;
import acessibility.Sound;
import acessibility.Text2Speech;
import java.io.File;
import java.util.ArrayList;
import logOld.Hooks;
import logOld.LogEntry;
import utils.Settings;
import utils.files;
import utils.time;

public class log {
    private static Boolean outputToScreen = true;
    long TimeStart = System.currentTimeMillis();
    static Settings translation;
    static Boolean doTranslation;
    static OutMode ttsMode;
    static OutMode logMode;
    static OutMode beepMode;
    static Text2Speech speechEngine;
    static final String logFileName = "winbuilder.log";
    static Log2File logFile;
    static boolean actBeep;
    static ArrayList<LogEntry> list;
    public static Hooks hooks;
    static LogEntry latest;

    private static String write1(int code, String message, String[] args) {
        if (message == null) {
            return "";
        }
        if (message.isEmpty()) {
            return "";
        }
        LogEntry newEntry = new LogEntry(code, message, args);
        boolean setS = false;
        int res = newEntry.getResult();
        if (ttsMode == OutMode.ON) {
            setS = res != 37;
        } else if (ttsMode == OutMode.SMART) {
            setS = res == -1 | res == 32 | res == 34 | res == 5 | res == 9 | res == 21 | res == 20;
        } else if (ttsMode == OutMode.WARNINGS) {
            setS = res == -1 | res == 34;
        } else if (ttsMode == OutMode.ERRORS) {
            setS = res == -1;
        } else if (ttsMode == OutMode.SMART) {
            setS = true;
        }
        newEntry.setSpeech(setS);
        if (ttsMode == OutMode.SMART) {
            if (res == 9) {
                actBeep = true;
            } else if (res == 20) {
                actBeep = false;
            }
            newEntry.setStartBeep(actBeep);
        }
        newEntry.setBeep(beepMode == OutMode.ON & ttsMode != OutMode.SMART);
        newEntry.setFileLog(logMode == OutMode.ON | logMode == OutMode.ERRORS & res == -1 | logMode == OutMode.WARNINGS & (res == 34 | res == -1) | ttsMode == OutMode.SMART);
        list.add(newEntry);
        if (doTranslation.booleanValue() && code != 1000) {
            log.addTranslation(message);
        }
        if (outputToScreen.booleanValue()) {
            System.out.println(time.getTimeFromLong(newEntry.getTime()) + " " + newEntry.getMessage());
        }
        hooks.process(message);
        latest = newEntry;
        if (newEntry.getBeep()) {
            if (code == -1) {
                Sound.play(Sound.error);
            } else if (code == 5) {
                Sound.play(Sound.start);
            } else if (code == 20) {
                Sound.play(Sound.complete);
            } else if (code == 21) {
                Sound.play(Sound.end);
            }
        }
        if (newEntry.getFileLog()) {
            if (logMode == OutMode.ON) {
                logFile.writeLn(newEntry.getTimeReadable() + " " + newEntry.getMessage());
            } else {
                logFile.writeLn(newEntry.getMessage());
            }
        }
        return newEntry.getMessageSimple();
    }

    public static void print(String message, Boolean writeTranslation, boolean isArt) {
        LogEntry newEntry = new LogEntry(message, isArt);
        boolean setS = false;
        if (ttsMode == OutMode.ON) {
            setS = !isArt;
        } else if (ttsMode == OutMode.SMART) {
            setS = !isArt;
        }
        newEntry.setSpeech(setS);
        list.add(newEntry);
        if (writeTranslation.booleanValue()) {
            log.addTranslation(message);
        }
        latest = newEntry;
    }

    public static void print(String message) {
        log.print(message, false, false);
    }

    public static void printNoTTS(String message) {
        log.print(message, false, true);
    }

    public static long getCounter() {
        return list.size();
    }

    public static ArrayList<LogEntry> getList() {
        return list;
    }

    public static LogEntry getLatest() {
        return latest;
    }

    public static String getMessagesSince(long lastCounter) {
        String output = "";
        int counter = -1;
        for (LogEntry newEntry : list) {
            if ((long)(++counter) < lastCounter) continue;
            output = newEntry.getResult() == 37 | newEntry.getResult() == 32 ? output.concat(newEntry.getMessage() + "\n") : output.concat(time.getTimeFromLongNoDate(newEntry.getTime()) + " " + newEntry.getMessage() + "\n");
            if (newEntry.getSpeech() && newEntry.getResult() != 37) {
                String text2 = newEntry.getMessage();
                if (text2.contains("\\")) {
                    text2 = text2.replaceAll("\\\\", " ");
                }
                if (text2.contains("/")) {
                    text2 = text2.replaceAll("/", " ");
                }
                if (!"".equals(text2)) {
                    speechEngine.add(text2);
                }
            }
            if (newEntry.getStartBeep()) {
                speechEngine.add("***");
                continue;
            }
            speechEngine.add("---");
        }
        return output;
    }

    public void setOutputToScreen(Boolean outputToScreenText) {
        outputToScreen = outputToScreenText;
    }

    public static void setSpeechMode(String mode) {
        if (mode.equalsIgnoreCase("OFF")) {
            ttsMode = OutMode.OFF;
        } else if (mode.equalsIgnoreCase("ON")) {
            ttsMode = OutMode.ON;
        } else if (mode.equalsIgnoreCase("WARNINGS")) {
            ttsMode = OutMode.WARNINGS;
        } else if (mode.equalsIgnoreCase("SMART")) {
            ttsMode = OutMode.SMART;
        } else if (mode.equalsIgnoreCase("ERRORS")) {
            ttsMode = OutMode.ERRORS;
        } else if (mode.equalsIgnoreCase("STOP")) {
            speechEngine.stopSpeak();
        }
    }

    public static void setBeepMode(String mode) {
        if (mode.equalsIgnoreCase("OFF")) {
            beepMode = OutMode.OFF;
        } else if (mode.equalsIgnoreCase("ON")) {
            beepMode = OutMode.ON;
        }
    }

    public static void setLogMode(String mode) {
        if (mode.equalsIgnoreCase("OFF")) {
            logMode = OutMode.OFF;
        } else if (mode.equalsIgnoreCase("ON")) {
            logMode = OutMode.ON;
        } else if (mode.equalsIgnoreCase("WARNINGS")) {
            logMode = OutMode.WARNINGS;
        } else if (mode.equalsIgnoreCase("ERRORS")) {
            logMode = OutMode.ERRORS;
        }
        if (logMode != OutMode.OFF) {
            logFile = new Log2File(logFileName);
        }
    }

    public static void startBeep() {
        speechEngine.startBeep();
    }

    public static void setBeepInterval(String seconds) {
        int milli = Integer.parseInt(seconds);
        if (milli < 1000) {
            milli *= 1000;
        }
        speechEngine.setBeepInterval(milli);
    }

    public static void endBeep() {
        speechEngine.stopBeep();
    }

    public static void closeBeep() {
        speechEngine.closeBeep();
    }

    public static void EnableTranslator(String languageID, String description) {
        String folderBase = System.getProperties().getProperty("appDir");
        File folderTranslation = new File(folderBase, "translation");
        files.mkdirs(folderTranslation);
        File fileTranslation = new File(folderTranslation, "lang-" + languageID + ".xml");
        translation = new Settings(fileTranslation, description);
        doTranslation = true;
    }

    static void addTranslation(String message) {
        if (!translation.hasKey(message).booleanValue()) {
            translation.write(message, message);
        }
    }

    public static String write(int code, String message) {
        String[] text2 = new String[]{};
        return log.write1(code, message, text2);
    }

    public static String write(int code, String message, String arg1) {
        String[] text2 = new String[]{arg1};
        return log.write1(code, message, text2);
    }

    public static String write(int code, String message, String arg1, String arg2) {
        String[] text2 = new String[]{arg1, arg2};
        return log.write1(code, message, text2);
    }

    public static String write(int code, String message, String arg1, String arg2, String arg3) {
        String[] text2 = new String[]{arg1, arg2, arg3};
        return log.write1(code, message, text2);
    }

    public static String write(int code, String message, String arg1, String arg2, String arg3, String arg4) {
        String[] text2 = new String[]{arg1, arg2, arg3, arg4};
        return log.write1(code, message, text2);
    }

    public static String write(int code, String message, String arg1, String arg2, String arg3, String arg4, String arg5) {
        String[] text2 = new String[]{arg1, arg2, arg3, arg4, arg5};
        return log.write1(code, message, text2);
    }

    static {
        doTranslation = false;
        speechEngine = new Text2Speech();
        actBeep = false;
        list = new ArrayList();
        hooks = new Hooks();
        latest = null;
    }

    public static enum OutMode {
        ERRORS,
        OFF,
        WARNINGS,
        ON,
        SMART;

    }
}

