/*
 * Decompiled with CFR 0.152.
 */
package bsh2java;

import bsh.EvalError;
import bsh.Interpreter;
import bsh2java.Plugin;
import bsh2java.log;
import build.Core;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import utils.files;

public class Process {
    static HashMap<String, Object> settings = new HashMap();

    public static void start(File scriptFolder) {
        ArrayList<File> files2 = files.findFilesFiltered(scriptFolder, ".java", 3);
        for (File file : files2) {
            Process.runJava(file, null, "Plugin");
        }
    }

    public Process(Properties settings) {
    }

    public Process() {
    }

    public void run(File scriptFile, String what, String className) {
        if (scriptFile.getName().contains(".java")) {
            Process.runJava(scriptFile, what, className);
            return;
        }
        if (!scriptFile.exists()) {
            log.write(404, "Couldn't find the mentioned script at %1", scriptFile.getAbsolutePath());
            return;
        }
        try {
            Interpreter runScript = new Interpreter();
            Process.addDefinitions(runScript, scriptFile);
            runScript.source(scriptFile.getAbsolutePath());
            settings = (HashMap)runScript.get("settings");
            if (what != null) {
                runScript.eval(what + "();");
            }
        }
        catch (EvalError e) {
            log.write(-1, "Error while interpreting %1, the error message is: %2", scriptFile.getAbsolutePath(), e.getLocalizedMessage());
        }
        catch (IOException e) {
            log.write(-1, "Error while interpreting %1, the error message is: %2", scriptFile.getAbsolutePath(), e.getLocalizedMessage());
        }
    }

    public HashMap<String, Object> getSettings() {
        return settings;
    }

    static void addDefinitions(Interpreter runScript, File scriptFile) throws EvalError {
        runScript.set("temp", Core.temp);
        runScript.set("settings", settings);
        runScript.set("thisFile", scriptFile);
        runScript.set("thisDir", scriptFile.getParentFile());
        runScript.set("winpe", Core.sys.winpecore);
    }

    static String convertJava2bsh(String rawText) {
        String result = "";
        String className = "Plugin";
        String[] lines = rawText.split("\n");
        boolean noPackage = true;
        boolean noClass = true;
        for (String line : lines) {
            if (line.contains("@Override")) {
                result = result.concat("\n");
                continue;
            }
            if (noPackage && line.startsWith("package ")) {
                noPackage = false;
                result = result.concat("\n");
                continue;
            }
            if (noClass && line.startsWith("public class ")) {
                line = className + " plugin = new " + className + "(){" + "File thisFile = global.thisFile;" + "File thisFolder = global.thisFolder;";
                noClass = false;
            }
            result = result.concat(line + "\n");
        }
        result = result + ";";
        return result;
    }

    public static void runJava(File scriptFile, String methodName, String className) {
        if (!scriptFile.exists()) {
            log.write(404, "P23 - Couldn't find script file %1", scriptFile.getAbsolutePath());
            return;
        }
        String rawText = files.readAsString(scriptFile);
        String codeText = Process.convertJava2bsh(rawText);
        try {
            Interpreter runScript = new Interpreter();
            Process.addDefinitions(runScript, scriptFile);
            runScript.set("global.thisFile", scriptFile);
            runScript.set("global.thisFolder", scriptFile.getParentFile());
            runScript.set("temp", Core.temp);
            runScript.set("settings", settings);
            Process.doInterpretation(codeText, className, scriptFile, methodName, runScript);
        }
        catch (Exception e) {
            log.write(-1, "Error while interpreting %1, the error message is: %2", scriptFile.getAbsolutePath(), e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    static void doInterpretation(String sourceCode, String className, File scriptFile, String methodName, Interpreter runScript) throws Exception {
        runScript.eval(sourceCode);
        if (className.equals("Plugin")) {
            Plugin plugin = (Plugin)runScript.get("plugin");
            if (methodName == null) {
                plugin.startup();
                return;
            }
            if (methodName.contains("=")) {
                runScript.eval(methodName);
                return;
            }
            runScript.eval("plugin." + methodName + "();");
            return;
        }
    }
}

