/*
 * Decompiled with CFR 0.152.
 */
package acessibility;

import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class Text2Speech {
    private Voice voice = null;
    private final ArrayList<String> speeches = new ArrayList();
    private Thread asyncSpeak = null;
    private Thread progressBeeper = null;
    private boolean runSpeak = true;
    private boolean runBeep = true;
    private boolean beepStatus;
    private int interval = 3000;
    SynthesizerModeDesc desc;
    Synthesizer synthesizer;

    public Text2Speech() {
        this.doInit("kevin16");
    }

    public Text2Speech(String voiceName) {
        this.doInit(voiceName);
    }

    private void doInit(String voiceName) {
        if (this.desc == null) {
            try {
                Voice[] voices;
                System.setProperty("freetts.voices", "com.sun.speech.freetts.en.us.cmu_us_kal.KevinVoiceDirectory");
                this.desc = new SynthesizerModeDesc(Locale.US);
                Central.registerEngineCentral("com.sun.speech.freetts.jsapi.FreeTTSEngineCentral");
                this.synthesizer = Central.createSynthesizer(this.desc);
                this.synthesizer.allocate();
                this.synthesizer.resume();
                SynthesizerModeDesc smd = (SynthesizerModeDesc)this.synthesizer.getEngineModeDesc();
                for (Voice voice1 : voices = smd.getVoices()) {
                    if (!voice1.getName().equals(voiceName)) continue;
                    this.voice = voice1;
                    break;
                }
                this.synthesizer.getSynthesizerProperties().setVoice(this.voice);
            }
            catch (EngineException ex) {
                Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (AudioException ex) {
                Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (EngineStateError ex) {
                Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (PropertyVetoException ex) {
                Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void startBeep() {
        if (this.progressBeeper == null) {
            this.progressBeeper = new Thread(new ProgressBeep());
            this.runBeep = true;
            this.progressBeeper.start();
        } else {
            this.runBeep = true;
        }
    }

    public void setBeepInterval(int milli) {
        this.interval = milli;
    }

    public void stopBeep() {
        this.beepStatus = this.runBeep;
        this.runBeep = false;
    }

    public void resumeBeep() {
        this.runBeep = this.beepStatus;
    }

    public void closeBeep() {
        this.runBeep = true;
        if (this.progressBeeper != null) {
            this.progressBeeper.interrupt();
            this.progressBeeper = null;
        }
    }

    public void speak(String speakText) {
        try {
            this.synthesizer.speakPlainText(speakText, null);
            this.synthesizer.waitEngineState(65536L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void add(String line) {
        if (this.asyncSpeak == null) {
            this.asyncSpeak = new Thread(new AsyncSpeak());
            this.runSpeak = true;
            this.asyncSpeak.start();
        }
        this.speeches.add(line);
    }

    public void stopSpeak() {
        if (this.asyncSpeak != null) {
            this.speeches.clear();
            this.asyncSpeak.interrupt();
            this.runSpeak = false;
            this.asyncSpeak = null;
        }
    }

    public static void main(String[] args) {
        Text2Speech speaker = new Text2Speech();
        speaker.startBeep();
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Text2Speech.class.getName()).log(Level.SEVERE, null, ex);
        }
        speaker.stopBeep();
        speaker.stopSpeak();
    }

    private class ProgressBeep
    implements Runnable {
        private ProgressBeep() {
        }

        @Override
        public void run() {
            while (true) {
                if (Text2Speech.this.runBeep) {
                    try {
                        Toolkit.getDefaultToolkit().beep();
                        Thread.sleep(Text2Speech.this.interval);
                    }
                    catch (InterruptedException ex) {
                        Text2Speech.this.runBeep = false;
                        return;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Text2Speech.this.runBeep = false;
                    return;
                }
            }
        }
    }

    private class AsyncSpeak
    implements Runnable {
        private int actSpeech = 0;

        private AsyncSpeak() {
        }

        @Override
        public void run() {
            while (Text2Speech.this.runSpeak) {
                while (this.actSpeech >= Text2Speech.this.speeches.size()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Text2Speech.this.speeches.clear();
                        this.actSpeech = 0;
                        return;
                    }
                }
                String speech = (String)Text2Speech.this.speeches.get(this.actSpeech++);
                if ("*".equals(speech)) {
                    Toolkit.getDefaultToolkit().beep();
                } else if ("***".equals(speech)) {
                    Text2Speech.this.startBeep();
                } else if ("---".equals(speech)) {
                    Text2Speech.this.stopBeep();
                } else {
                    Text2Speech.this.stopBeep();
                    Text2Speech.this.speak(speech);
                    Text2Speech.this.resumeBeep();
                }
                if (!Thread.interrupted()) continue;
                Text2Speech.this.speeches.clear();
                this.actSpeech = 0;
                return;
            }
        }
    }
}

