/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGPath;
import com.sun.javafx.sg.PGRectangle;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.sg.PGTextHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.RenderTheme;
import com.sun.webpane.platform.graphics.ScrollBarTheme;
import com.sun.webpane.platform.graphics.WCFont;
import com.sun.webpane.platform.graphics.WCGradient;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCIcon;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCPath;
import com.sun.webpane.platform.graphics.WCPoint;
import com.sun.webpane.platform.graphics.WCRectangle;
import com.sun.webpane.platform.graphics.WCTransform;
import com.sun.webpane.sg.prism.PrismImage;
import com.sun.webpane.sg.prism.WCLinearGradient;
import com.sun.webpane.sg.prism.WCPathImpl;
import com.sun.webpane.sg.prism.WCRadialGradient;
import com.sun.webpane.sg.prism.WCStrokeImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCGraphicsPrismContext
extends WCGraphicsContext {
    private static final Logger log = Logger.getLogger(WCGraphicsPrismContext.class.getName());
    private Graphics baseGraphics;
    private Stack<ContextState> states = new Stack();
    private ContextState state = new ContextState();
    private boolean isInitialized;
    private Graphics cachedGraphics = null;
    private int fontSmoothingType;
    private static final BasicStroke focusRingStroke = new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{1.0f}, 0.0f);

    public WCGraphicsPrismContext(Graphics graphics) {
        this.init(graphics, true);
    }

    protected WCGraphicsPrismContext() {
    }

    protected final void init(Graphics graphics, boolean bl) {
        if (this.isInitialized) {
            return;
        }
        if (graphics != null && bl) {
            this.state.setClip(graphics.getClipRect());
            this.state.setTransform(new Affine3D(graphics.getTransformNoClone()));
            this.state.setAlpha(graphics.getExtraAlpha());
        }
        this.baseGraphics = graphics != null ? graphics.getRenderTarget().createGraphics() : null;
        this.isInitialized = true;
    }

    protected boolean isInitialized() {
        return this.isInitialized;
    }

    private void resetCachedGraphics() {
        this.cachedGraphics = null;
    }

    @Override
    public Object getPlatformGraphics() {
        return this.getGraphics(false);
    }

    public Graphics getGraphics(boolean bl) {
        Object object;
        if (this.cachedGraphics == null) {
            object = this.state.getLayerNoClone();
            this.cachedGraphics = object != null ? ((Layer)object).getGraphics() : this.baseGraphics;
            this.state.apply(this.cachedGraphics);
            if (log.isLoggable(Level.FINE)) {
                log.fine("getPlatformGraphics for " + this + " : " + this.cachedGraphics);
            }
        }
        object = this.cachedGraphics.getClipRectNoClone();
        return bl && object != null && ((Rectangle)object).isEmpty() ? null : this.cachedGraphics;
    }

    @Override
    public void saveState() {
        this.state.markAsRestorePoint();
        this.saveStateInternal();
    }

    private void saveStateInternal() {
        this.states.push(this.state);
        this.state = this.state.clone();
    }

    private void startNewLayer(Layer layer) {
        this.saveStateInternal();
        Rectangle rectangle = this.state.getClipNoClone();
        Affine3D affine3D = new Affine3D(BaseTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
        affine3D.concatenate(this.state.getTransformNoClone());
        rectangle.x = 0;
        rectangle.y = 0;
        Graphics graphics = this.getGraphics(true);
        if (graphics != null && graphics != this.baseGraphics) {
            layer.init(graphics);
        }
        this.state.setTransform(affine3D);
        this.state.setLayer(layer);
        this.resetCachedGraphics();
    }

    private void renderLayer(Layer layer) {
        WCTransform wCTransform = this.getTransform();
        this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, layer.getX(), layer.getY()));
        Graphics graphics = this.getGraphics(true);
        if (graphics != null) {
            layer.render(graphics);
        }
        layer.dispose();
        this.setTransform(wCTransform);
    }

    private void restoreStateInternal() {
        if (this.states.isEmpty()) {
            assert (false) : "Unbalanced restoreState";
            return;
        }
        Layer layer = this.state.getLayerNoClone();
        this.state = this.states.pop();
        if (layer != this.state.getLayerNoClone()) {
            this.renderLayer(layer);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Popped layer " + layer);
            }
        } else {
            this.resetCachedGraphics();
        }
    }

    @Override
    public void restoreState() {
        log.fine("restoring state");
        do {
            this.restoreStateInternal();
        } while (!this.state.isRestorePoint());
    }

    @Override
    public void setClip(WCPath wCPath, boolean bl) {
        Object object;
        Affine3D affine3D = new Affine3D(this.state.getTransformNoClone());
        wCPath.transform(affine3D.getMxx(), affine3D.getMyx(), affine3D.getMxy(), affine3D.getMyy(), affine3D.getMxt(), affine3D.getMyt());
        if (!bl) {
            object = wCPath.getBounds();
            this.state.clip(new Rectangle(((WCRectangle)object).getIntX(), ((WCRectangle)object).getIntY(), ((WCRectangle)object).getIntWidth(), ((WCRectangle)object).getIntHeight()));
        }
        object = this.state.getClipNoClone();
        if (bl) {
            wCPath.addRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        wCPath.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        ClipLayer clipLayer = new ClipLayer(this.getGraphics(false), (Rectangle)object, wCPath);
        this.startNewLayer(clipLayer);
        if (log.isLoggable(Level.FINE)) {
            log.fine("setClip(WCPath " + wCPath.getID() + ")");
            log.fine("Pushed layer " + clipLayer);
        }
    }

    public Rectangle transformClip(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height};
        this.state.getTransformNoClone().transform(fArray, 0, fArray, 0, 4);
        float f = Math.min(fArray[0], Math.min(fArray[2], Math.min(fArray[4], fArray[6])));
        float f2 = Math.max(fArray[0], Math.max(fArray[2], Math.max(fArray[4], fArray[6])));
        float f3 = Math.min(fArray[1], Math.min(fArray[3], Math.min(fArray[5], fArray[7])));
        float f4 = Math.max(fArray[1], Math.max(fArray[3], Math.max(fArray[5], fArray[7])));
        return new Rectangle(new RectBounds(f, f3, f2, f4));
    }

    public void setClip(Rectangle rectangle) {
        Affine3D affine3D = this.state.getTransformNoClone();
        if (affine3D.getMxy() == 0.0 && affine3D.getMxz() == 0.0 && affine3D.getMyx() == 0.0 && affine3D.getMyz() == 0.0 && affine3D.getMzx() == 0.0 && affine3D.getMzy() == 0.0) {
            this.state.clip(this.transformClip(rectangle));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "setClip({0})", rectangle);
                Rectangle rectangle2 = this.state.getClipNoClone();
                if (rectangle2 != null && rectangle2.width >= 2 && rectangle2.height >= 2) {
                    WCTransform wCTransform = this.getTransform();
                    this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                    Graphics graphics = this.getGraphics(true);
                    if (graphics != null) {
                        float f = (float)Math.random();
                        graphics.setPaint(new Color(f, 1.0f - f, 0.5f, 0.1f));
                        graphics.setStroke(new BasicStroke());
                        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics.setPaint(new Color(1.0f - f, f, 0.5f, 1.0f));
                        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    this.setTransform(wCTransform);
                    this.state.clip(new Rectangle(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2));
                }
            }
            if (this.cachedGraphics != null) {
                this.cachedGraphics.setClipRect(this.state.getClipNoClone());
            }
        } else {
            WCPathImpl wCPathImpl = new WCPathImpl();
            ((WCPath)wCPathImpl).addRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.setClip(wCPathImpl, false);
        }
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(WCRectangle wCRectangle) {
        this.setClip(new Rectangle((int)wCRectangle.getX(), (int)wCRectangle.getY(), (int)wCRectangle.getWidth(), (int)wCRectangle.getHeight()));
    }

    @Override
    public WCRectangle getClip() {
        Rectangle rectangle = this.state.getClipNoClone();
        return rectangle == null ? null : new WCRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void translate(float f, float f2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "translate({0},{1})", new Object[]{Float.valueOf(f), Float.valueOf(f2)});
        }
        this.state.translate(f, f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.translate(f, f2);
        }
    }

    @Override
    public void scale(float f, float f2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("scale(" + f + " " + f2 + ")");
        }
        this.state.scale(f, f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.scale(f, f2);
        }
    }

    @Override
    public void rotate(float f) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("rotate(" + f + ")");
        }
        this.state.rotate(f);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.setTransform(this.state.getTransformNoClone());
        }
    }

    @Override
    public void fillRect(final float f, final float f2, final float f3, final float f4, final Integer n) {
        if (log.isLoggable(Level.FINE)) {
            String string = n != null ? "fillRect(%f, %f, %f, %f, 0x%x)" : "fillRect(%f, %f, %f, %f, null)";
            log.fine(String.format(string, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), n));
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Paint paint = n != null ? WCGraphicsPrismContext.createColor(n) : WCGraphicsPrismContext.this.state.getPaintNoClone();
                DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (dropShadow != null) {
                    PGRectangle pGRectangle = Toolkit.getToolkit().createPGRectangle();
                    pGRectangle.updateRectangle(f, f2, f3, f4, 0.0f, 0.0f);
                    WCGraphicsPrismContext.this.render(graphics, dropShadow, paint, null, pGRectangle);
                } else {
                    graphics.setPaint(paint);
                    graphics.fillRect(f, f2, f3, f4);
                }
            }
        }.paint();
    }

    @Override
    public void fillRoundedRect(final float f, final float f2, final float f3, final float f4, final float f5, final float f6, final float f7, final float f8, final float f9, final float f10, final float f11, final float f12, final int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("fillRoundedRect(%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, 0x%x)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9), Float.valueOf(f10), Float.valueOf(f11), Float.valueOf(f12), n));
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                float f13 = (f5 + f7 + f9 + f11) / 2.0f;
                float f22 = (f6 + f8 + f10 + f12) / 2.0f;
                Color color = WCGraphicsPrismContext.createColor(n);
                DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (dropShadow != null) {
                    PGRectangle pGRectangle = Toolkit.getToolkit().createPGRectangle();
                    pGRectangle.updateRectangle(f, f2, f3, f4, f13, f22);
                    WCGraphicsPrismContext.this.render(graphics, dropShadow, color, null, pGRectangle);
                } else {
                    graphics.setPaint(color);
                    graphics.fillRoundRect(f, f2, f3, f4, f13, f22);
                }
            }
        }.paint();
    }

    @Override
    public void clearRect(final float f, final float f2, final float f3, final float f4) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("clearRect(%f, %f, %f, %f)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4)));
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.clearQuad(f, f2, f + f3, f2 + f4);
            }
        }.paint();
    }

    @Override
    public void setFillColor(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("setFillColor(0x%x)", n));
        }
        this.state.setPaint(WCGraphicsPrismContext.createColor(n));
    }

    @Override
    public void setFillGradient(WCGradient wCGradient) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setFillGradient(" + wCGradient + ")");
        }
        this.state.setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setTextMode(boolean bl, boolean bl2, boolean bl3) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setTextMode(fill:" + bl + ",stroke:" + bl2 + ",clip:" + bl3 + ")");
        }
        this.state.setTextMode(bl, bl2, bl3);
    }

    @Override
    public void setFontSmoothingType(int n) {
        this.fontSmoothingType = n;
    }

    @Override
    public void setStrokeStyle(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setStrokeStyle({0})", n);
        }
        this.state.getStrokeNoClone().setStyle(n);
    }

    @Override
    public void setStrokeColor(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("setStrokeColor(0x%x)", n));
        }
        this.state.getStrokeNoClone().setPaint(WCGraphicsPrismContext.createColor(n));
    }

    @Override
    public void setStrokeWidth(float f) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setStrokeWidth({0})", new Object[]{Float.valueOf(f)});
        }
        this.state.getStrokeNoClone().setThickness(f);
    }

    @Override
    public void setStrokeGradient(WCGradient wCGradient) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setStrokeGradient(" + wCGradient + ")");
        }
        this.state.getStrokeNoClone().setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setLineDash(float f, float ... fArray) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setLineDash(" + f + ":" + fArray + ")");
        }
        this.state.getStrokeNoClone().setDashOffset(f);
        if (fArray != null) {
            boolean bl = true;
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == 0.0f) continue;
                bl = false;
                break;
            }
            if (bl) {
                fArray = null;
            }
        }
        this.state.getStrokeNoClone().setDashSizes(fArray);
    }

    @Override
    public void setLineCap(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setLineCap(" + n + ")");
        }
        this.state.getStrokeNoClone().setLineCap(n);
    }

    @Override
    public void setLineJoin(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setLineJoin(" + n + ")");
        }
        this.state.getStrokeNoClone().setLineJoin(n);
    }

    @Override
    public void setMiterLimit(float f) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setMiterLimit(" + f + ")");
        }
        this.state.getStrokeNoClone().setMiterLimit(f);
    }

    @Override
    public void setShadow(float f, float f2, float f3, int n) {
        if (log.isLoggable(Level.FINE)) {
            String string = "setShadow(%f, %f, %f, 0x%x)";
            log.fine(String.format(string, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), n));
        }
        this.state.setShadow(this.createShadow(f, f2, f3, n));
    }

    @Override
    public void drawPolygon(final float[] fArray, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            String string = "[";
            for (int i = 0; i < fArray.length; ++i) {
                string = string + fArray[i] + ",";
            }
            string = string + "]";
            log.log(Level.FINE, "drawPolygon({0},{1})", new Object[]{string, bl});
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Path2D path2D = new Path2D();
                if (fArray != null && fArray.length != 0 && fArray.length % 2 == 0) {
                    path2D.moveTo(fArray[0], fArray[1]);
                    for (int i = 1; i < fArray.length / 2; ++i) {
                        float f = fArray[i * 2 + 0];
                        float f2 = fArray[i * 2 + 1];
                        path2D.lineTo(f, f2);
                    }
                    path2D.closePath();
                }
                graphics.setPaint(WCGraphicsPrismContext.this.state.getPaintNoClone());
                graphics.fill(path2D);
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.draw(path2D);
                }
            }
        }.paint();
    }

    @Override
    public void drawLine(final int n, final int n2, final int n3, final int n4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawLine({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.drawLine(n, n2, n3, n4);
                }
            }
        }.paint();
    }

    @Override
    public void drawPattern(final WCImage wCImage, final WCRectangle wCRectangle, final WCTransform wCTransform, final WCPoint wCPoint, final WCRectangle wCRectangle2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawPattern({0}, {1}, {2}, {3})", new Object[]{wCRectangle2.getIntX(), wCRectangle2.getIntY(), wCRectangle2.getIntWidth(), wCRectangle2.getIntHeight()});
        }
        if (wCImage != null) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    float f = wCPoint.getX() + wCRectangle.getX() * (float)wCTransform.getMatrix()[0];
                    float f2 = wCPoint.getY() + wCRectangle.getY() * (float)wCTransform.getMatrix()[3];
                    float f3 = wCRectangle.getWidth() * (float)wCTransform.getMatrix()[0];
                    float f4 = wCRectangle.getHeight() * (float)wCTransform.getMatrix()[3];
                    Image image = ((PrismImage)wCImage).getImage();
                    if (!wCRectangle.contains(new WCRectangle(0.0f, 0.0f, wCImage.getWidth(), wCImage.getHeight()))) {
                        image = image.createSubImage(wCRectangle.getIntX(), wCRectangle.getIntY(), (int)Math.ceil(wCRectangle.getWidth()), (int)Math.ceil(wCRectangle.getHeight()));
                    }
                    graphics.setPaint(new ImagePattern(image, f, f2, f3, f4, false));
                    graphics.fillRect(wCRectangle2.getX(), wCRectangle2.getY(), wCRectangle2.getWidth(), wCRectangle2.getHeight());
                }
            }.paint();
        }
    }

    @Override
    public void drawImage(final WCImage wCImage, final float f, final float f2, final float f3, final float f4, final float f5, final float f6, final float f7, final float f8) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawImage(img, dst({0},{1},{2},{3}), src({4},{5},{6},{7}))", new Object[]{Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8)});
        }
        if (wCImage instanceof PrismImage) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    PrismImage prismImage = (PrismImage)wCImage;
                    DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (dropShadow != null) {
                        PGImageView pGImageView = Toolkit.getToolkit().createPGImageView();
                        pGImageView.setImage(prismImage.getImage());
                        pGImageView.setX(f);
                        pGImageView.setY(f2);
                        pGImageView.setViewport(f3, f4, f5, f6, f7, f8, false);
                        pGImageView.setContentBounds(new RectBounds(f, f2, f + f3, f2 + f4));
                        WCGraphicsPrismContext.this.render(graphics, dropShadow, null, null, pGImageView);
                    } else {
                        prismImage.draw(graphics, (int)f, (int)f2, (int)(f + f3), (int)(f2 + f4), (int)f5, (int)f6, (int)(f5 + f7), (int)(f6 + f8));
                    }
                }
            }.paint();
        }
    }

    @Override
    public void drawBitmapImage(final ByteBuffer byteBuffer, final int n, final int n2, final int n3, final int n4) {
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                byteBuffer.order(ByteOrder.nativeOrder());
                Image image = Image.fromByteBgraPreData(byteBuffer, n3, n4);
                Texture texture = graphics.getResourceFactory().createTexture(image);
                graphics.drawTexture(texture, n, n2, n + n3, n2 + n4, 0.0f, 0.0f, n3, n4);
                texture.dispose();
            }
        }.paint();
    }

    @Override
    public void drawIcon(WCIcon wCIcon, int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "UNIMPLEMENTED drawIcon ({0}, {1})", new Object[]{n, n2});
        }
    }

    @Override
    public void drawRect(final int n, final int n2, final int n3, final int n4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawRect({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                Paint paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                if (paint != null && paint.isOpaque()) {
                    graphics.setPaint(paint);
                    graphics.fillRect(n, n2, n3, n4);
                }
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.drawRect(n, n2, n3, n4);
                }
            }
        }.paint();
    }

    @Override
    public void drawString(final WCFont wCFont, final int[] nArray, float[] fArray, final float f, final float f2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawStringAsGlyph({0} {1}, {2})", new Object[]{nArray, Float.valueOf(f), Float.valueOf(f2)});
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                String string = new String(nArray, 0, nArray.length);
                PGFont pGFont = (PGFont)wCFont.getPlatformFont();
                Paint paint = WCGraphicsPrismContext.this.state.isTextFill() ? WCGraphicsPrismContext.this.state.getPaintNoClone() : null;
                BasicStroke basicStroke = WCGraphicsPrismContext.this.state.isTextStroke() ? WCGraphicsPrismContext.this.state.getStrokeNoClone().getPlatformStroke() : null;
                DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                if (dropShadow != null) {
                    PGText pGText = Toolkit.getToolkit().createPGText();
                    PGTextHelper pGTextHelper = pGText.getTextHelper();
                    pGTextHelper.setText(string);
                    pGTextHelper.setFont(pGFont);
                    pGTextHelper.setLocation(f, f2);
                    pGTextHelper.setFontSmoothingType(WCGraphicsPrismContext.this.fontSmoothingType);
                    pGText.updateText();
                    WCGraphicsPrismContext.this.render(graphics, dropShadow, paint, basicStroke, pGText);
                } else {
                    FontStrike fontStrike = pGFont.getStrike(graphics.getTransformNoClone(), WCGraphicsPrismContext.this.fontSmoothingType);
                    if (paint != null) {
                        graphics.setPaint(paint);
                        graphics.drawString(string, fontStrike, f, f2);
                    }
                    if (basicStroke != null && (paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint()) != null) {
                        graphics.setPaint(paint);
                        graphics.setStroke(basicStroke);
                        graphics.draw(fontStrike.getOutline(string, BaseTransform.getTranslateInstance(f, f2)));
                    }
                }
            }
        }.paint();
    }

    @Override
    public void drawString(WCFont wCFont, String string, boolean bl, int n, int n2, float f, float f2, float f3, float f4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawString({0}, {1}, {2})", new Object[]{string, Float.valueOf(f3), Float.valueOf(f4)});
        }
        int[] nArray = new int[n2 - n];
        for (int i = 0; i < n2 - n; ++i) {
            nArray[i] = string.codePointAt(bl ? n2 - i - 1 : n + i);
        }
        this.drawString(wCFont, nArray, null, f3, f4);
    }

    @Override
    public void setComposite(int n) {
        log.log(Level.FINE, "setComposite({0})", n);
        this.state.setCompositeOperation(n);
    }

    @Override
    public void drawEllipse(final int n, final int n2, final int n3, final int n4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawEllipse({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.setPaint(WCGraphicsPrismContext.this.state.getPaintNoClone());
                graphics.fillEllipse(n, n2, n3, n4);
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.drawEllipse(n, n2, n3, n4);
                }
            }
        }.paint();
    }

    @Override
    public void drawFocusRing(final int n, final int n2, final int n3, final int n4, final int n5) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("drawFocusRing: %d, %d, %d, %d, 0x%x", n, n2, n3, n4, n5));
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.setPaint(WCGraphicsPrismContext.createColor(n5));
                BasicStroke basicStroke = graphics.getStroke();
                graphics.setStroke(focusRingStroke);
                graphics.drawRoundRect(n, n2, n3, n4, 4.0f, 4.0f);
                graphics.setStroke(basicStroke);
            }
        }.paint();
    }

    @Override
    public void setAlpha(float f) {
        log.log(Level.FINE, "setAlpha({0})", Float.valueOf(f));
        this.state.setAlpha(f);
        if (null != this.cachedGraphics) {
            this.cachedGraphics.setExtraAlpha(this.state.getAlpha());
        }
    }

    @Override
    public float getAlpha() {
        return this.state.getAlpha();
    }

    @Override
    public void beginTransparencyLayer(float f) {
        TransparencyLayer transparencyLayer = new TransparencyLayer(this.getGraphics(false), this.state.getClipNoClone(), f);
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("beginTransparencyLayer(%s)", transparencyLayer));
        }
        this.state.markAsRestorePoint();
        this.startNewLayer(transparencyLayer);
    }

    @Override
    public void endTransparencyLayer() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("endTransparencyLayer(%s)", this.state.getLayerNoClone()));
        }
        this.restoreState();
    }

    @Override
    public void drawWidget(RenderTheme renderTheme, Ref ref, int n, int n2) {
        renderTheme.drawWidget(this, ref, n, n2);
    }

    @Override
    public void drawScrollbar(ScrollBarTheme scrollBarTheme, Ref ref, int n, int n2, int n3, int n4) {
        scrollBarTheme.paint(this, ref, n, n2, n3, n4);
    }

    private static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            return rectangle2;
        }
        RectBounds rectBounds = rectangle.toRectBounds();
        rectBounds.intersectWith(rectangle2);
        rectangle.setBounds(rectBounds);
        return rectangle;
    }

    static Color createColor(int n) {
        float f = (float)(0xFF & n >> 24) / 255.0f;
        float f2 = (float)(0xFF & n >> 16) / 255.0f;
        float f3 = (float)(0xFF & n >> 8) / 255.0f;
        float f4 = (float)(0xFF & n) / 255.0f;
        return new Color(f2, f3, f4, f);
    }

    private static Color4f createColor4f(int n) {
        float f = (float)(0xFF & n >> 24) / 255.0f;
        float f2 = (float)(0xFF & n >> 16) / 255.0f;
        float f3 = (float)(0xFF & n >> 8) / 255.0f;
        float f4 = (float)(0xFF & n) / 255.0f;
        return new Color4f(f2, f3, f4, f);
    }

    private DropShadow createShadow(float f, float f2, float f3, int n) {
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            return null;
        }
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX((int)f);
        dropShadow.setOffsetY((int)f2);
        dropShadow.setRadius(f3 < 0.0f ? 0.0f : (f3 > 127.0f ? 127.0f : f3));
        dropShadow.setColor(WCGraphicsPrismContext.createColor4f(n));
        return dropShadow;
    }

    private void render(Graphics graphics, Effect effect, Paint paint, BasicStroke basicStroke, PGNode pGNode) {
        if (pGNode instanceof NGShape) {
            NGShape nGShape = (NGShape)pGNode;
            Shape shape = nGShape.getShape();
            Paint paint2 = (Paint)this.state.getStrokeNoClone().getPaint();
            if (basicStroke != null && paint2 != null) {
                shape = basicStroke.createStrokedShape(shape);
                nGShape.setDrawStroke(basicStroke);
                nGShape.setDrawPaint(paint2);
                nGShape.setMode(paint == null ? PGShape.Mode.STROKE : PGShape.Mode.STROKE_FILL);
            } else {
                nGShape.setMode(paint == null ? PGShape.Mode.EMPTY : PGShape.Mode.FILL);
            }
            nGShape.setFillPaint(paint);
            nGShape.setContentBounds(shape.getBounds());
        }
        boolean bl = graphics.hasPreCullingBits();
        graphics.setHasPreCullingBits(false);
        pGNode.setEffect(effect);
        ((NGNode)pGNode).render(graphics);
        graphics.setHasPreCullingBits(bl);
    }

    @Override
    public void strokeArc(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("strokeArc(%d, %d, %d, %d, %d, %d)", n, n2, n3, n4, n5, n6));
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                if (WCGraphicsPrismContext.this.state.getStrokeNoClone().apply(graphics)) {
                    graphics.draw(new Arc2D(n, n2, n3, n4, n5, n6, 0));
                }
            }
        }.paint();
    }

    @Override
    public WCImage getImage() {
        return null;
    }

    @Override
    public void strokeRect(final float f, final float f2, final float f3, final float f4, final float f5) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("strokeRect_FFFFF(%f, %f, %f, %f, %f)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5)));
        }
        new Composite(){

            @Override
            void doPaint(Graphics graphics) {
                graphics.setStroke(new BasicStroke(f5, 0, 0, Math.max(1.0f, f5)));
                Paint paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint();
                if (paint == null) {
                    paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                }
                graphics.setPaint(paint);
                graphics.drawRect(f, f2, f3, f4);
            }
        }.paint();
    }

    @Override
    public void strokePath(final WCPath wCPath) {
        log.fine("strokePath");
        if (wCPath != null) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    Path2D path2D = (Path2D)wCPath.getPlatformPath();
                    BasicStroke basicStroke = WCGraphicsPrismContext.this.state.getStrokeNoClone().getPlatformStroke();
                    DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (dropShadow != null) {
                        PGPath pGPath = Toolkit.getToolkit().createPGPath();
                        pGPath.updateWithPath2d(path2D);
                        WCGraphicsPrismContext.this.render(graphics, dropShadow, null, basicStroke, pGPath);
                    } else if (basicStroke != null) {
                        Paint paint = (Paint)WCGraphicsPrismContext.this.state.getStrokeNoClone().getPaint();
                        if (paint == null) {
                            paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                        }
                        graphics.setPaint(paint);
                        graphics.setStroke(basicStroke);
                        graphics.draw(path2D);
                    }
                }
            }.paint();
        }
    }

    @Override
    public void fillPath(final WCPath wCPath) {
        log.fine("fillPath");
        if (wCPath != null) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    Path2D path2D = (Path2D)wCPath.getPlatformPath();
                    Paint paint = WCGraphicsPrismContext.this.state.getPaintNoClone();
                    DropShadow dropShadow = WCGraphicsPrismContext.this.state.getShadowNoClone();
                    if (dropShadow != null) {
                        PGPath pGPath = Toolkit.getToolkit().createPGPath();
                        pGPath.updateWithPath2d(path2D);
                        WCGraphicsPrismContext.this.render(graphics, dropShadow, paint, null, pGPath);
                    } else {
                        graphics.setPaint(paint);
                        graphics.fill(path2D);
                    }
                }
            }.paint();
        }
    }

    @Override
    public void setTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine3D affine3D = new Affine3D(new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
        this.state.setTransform(affine3D);
        this.resetCachedGraphics();
    }

    @Override
    public WCTransform getTransform() {
        Affine3D affine3D = this.state.getTransformNoClone();
        return new WCTransform(affine3D.getMxx(), affine3D.getMyx(), affine3D.getMxy(), affine3D.getMyy(), affine3D.getMxt(), affine3D.getMyt());
    }

    @Override
    public void concatTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine3D affine3D = new Affine3D(new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
        this.state.concatTransform(affine3D);
        this.resetCachedGraphics();
    }

    @Override
    public void dispose() {
        if (!this.states.isEmpty()) {
            new IllegalStateException("Unbalanced saveState/restoreState").printStackTrace();
        }
        while (!this.states.isEmpty()) {
            this.restoreStateInternal();
        }
        Layer layer = this.state.getLayerNoClone();
        if (layer != null) {
            this.renderLayer(layer);
        }
    }

    @Override
    public WCGradient createLinearGradient(WCPoint wCPoint, WCPoint wCPoint2) {
        return new WCLinearGradient(wCPoint, wCPoint2);
    }

    @Override
    public WCGradient createRadialGradient(WCPoint wCPoint, float f, WCPoint wCPoint2, float f2) {
        return new WCRadialGradient(wCPoint, f, wCPoint2, f2);
    }

    private static class ClipLayer
    extends Layer {
        private WCPath normalizedToClipPath;
        boolean srcover;

        public ClipLayer(Graphics graphics, Rectangle rectangle, WCPath wCPath) {
            super(graphics, rectangle);
            this.normalizedToClipPath = wCPath;
            this.srcover = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(Graphics graphics) {
            RTTexture rTTexture = null;
            ReadbackGraphics readbackGraphics = null;
            try {
                readbackGraphics = (ReadbackGraphics)graphics;
                rTTexture = readbackGraphics.readBack(this.bounds);
                this.getGraphics().drawTexture(rTTexture, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
            finally {
                if (readbackGraphics != null && rTTexture != null) {
                    readbackGraphics.releaseReadBackBuffer(rTTexture);
                }
            }
            this.srcover = false;
        }

        @Override
        public void render(Graphics graphics) {
            Path2D path2D = ((WCPathImpl)this.normalizedToClipPath).getPlatformPath();
            PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(this.fctx, this.bounds.width, this.bounds.height);
            Graphics graphics2 = prDrawable.createGraphics();
            graphics2.setPaint(Color.BLACK);
            graphics2.fill(path2D);
            if (graphics instanceof MaskTextureGraphics) {
                MaskTextureGraphics maskTextureGraphics = (MaskTextureGraphics)graphics;
                BaseTransform baseTransform = graphics.getTransformNoClone();
                int n = (int)Math.round(baseTransform.getMxt());
                int n2 = (int)Math.round(baseTransform.getMyt());
                if (this.srcover) {
                    maskTextureGraphics.drawPixelsMasked((RTTexture)this.buffer.getTextureObject(), (RTTexture)prDrawable.getTextureObject(), n, n2, this.bounds.width, this.bounds.height, 0, 0, 0, 0);
                } else {
                    maskTextureGraphics.maskInterpolatePixels((RTTexture)this.buffer.getTextureObject(), (RTTexture)prDrawable.getTextureObject(), n, n2, this.bounds.width, this.bounds.height, 0, 0, 0, 0);
                }
            } else {
                Blend blend = new Blend(Blend.Mode.SRC_IN, new PassThrough(prDrawable, this.bounds.width, this.bounds.height), new PassThrough(this.buffer, this.bounds.width, this.bounds.height));
                PrEffectHelper.render(blend, graphics, 0.0f, 0.0f, null);
            }
            Effect.releaseCompatibleImage(this.fctx, prDrawable);
        }

        public String toString() {
            return String.format("ClipLayer[%d,%d + %dx%d, path %s]", this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.normalizedToClipPath);
        }
    }

    private abstract class Composite {
        private Composite() {
        }

        abstract void doPaint(Graphics var1);

        public void paint() {
            this.paint(WCGraphicsPrismContext.this.getGraphics(true));
        }

        public void paint(Graphics graphics) {
            if (graphics != null) {
                CompositeMode compositeMode = graphics.getCompositeMode();
                switch (WCGraphicsPrismContext.this.state.getCompositeOperation()) {
                    case 1: {
                        graphics.setCompositeMode(CompositeMode.SRC);
                        this.doPaint(graphics);
                        graphics.setCompositeMode(compositeMode);
                        break;
                    }
                    case 2: {
                        graphics.setCompositeMode(CompositeMode.SRC_OVER);
                        this.doPaint(graphics);
                        graphics.setCompositeMode(compositeMode);
                        break;
                    }
                    default: {
                        this.blend(graphics);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blend(Graphics graphics) {
            RTTexture rTTexture;
            ReadbackGraphics readbackGraphics;
            PrDrawable prDrawable;
            PrFilterContext prFilterContext;
            block11: {
                prFilterContext = PrFilterContext.getInstance(graphics.getAssociatedScreen());
                prDrawable = null;
                PrDrawable prDrawable2 = null;
                readbackGraphics = null;
                rTTexture = null;
                Rectangle rectangle = WCGraphicsPrismContext.this.state.getClipNoClone();
                WCImage wCImage = WCGraphicsPrismContext.this.getImage();
                try {
                    Graphics graphics2;
                    if (wCImage != null && wCImage instanceof PrismImage) {
                        prDrawable = (PrDrawable)Effect.createCompatibleImage(prFilterContext, rectangle.width, rectangle.height);
                        graphics2 = prDrawable.createGraphics();
                        ((PrismImage)wCImage).draw(graphics2, 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    } else {
                        readbackGraphics = (ReadbackGraphics)graphics;
                        rTTexture = readbackGraphics.readBack(rectangle);
                        prDrawable = PrDrawable.create(prFilterContext, rTTexture);
                    }
                    prDrawable2 = (PrDrawable)Effect.createCompatibleImage(prFilterContext, rectangle.width, rectangle.height);
                    graphics2 = prDrawable2.createGraphics();
                    WCGraphicsPrismContext.this.state.apply(graphics2);
                    this.doPaint(graphics2);
                    graphics.clear();
                    PrEffectHelper.render(this.createEffect(prDrawable, prDrawable2, rectangle.width, rectangle.height), graphics, 0.0f, 0.0f, null);
                    if (prDrawable2 == null) break block11;
                }
                catch (Throwable throwable) {
                    if (prDrawable2 != null) {
                        Effect.releaseCompatibleImage(prFilterContext, prDrawable2);
                    }
                    if (prDrawable != null) {
                        if (readbackGraphics != null && rTTexture != null) {
                            readbackGraphics.releaseReadBackBuffer(rTTexture);
                        } else {
                            Effect.releaseCompatibleImage(prFilterContext, prDrawable);
                        }
                    }
                    throw throwable;
                }
                Effect.releaseCompatibleImage(prFilterContext, prDrawable2);
            }
            if (prDrawable != null) {
                if (readbackGraphics != null && rTTexture != null) {
                    readbackGraphics.releaseReadBackBuffer(rTTexture);
                } else {
                    Effect.releaseCompatibleImage(prFilterContext, prDrawable);
                }
            }
        }

        private Effect createBlend(Blend.Mode mode, PrDrawable prDrawable, PrDrawable prDrawable2, int n, int n2) {
            return new Blend(mode, new PassThrough(prDrawable, n, n2), new PassThrough(prDrawable2, n, n2));
        }

        private Effect createEffect(PrDrawable prDrawable, PrDrawable prDrawable2, int n, int n2) {
            switch (WCGraphicsPrismContext.this.state.getCompositeOperation()) {
                case 0: 
                case 10: {
                    return new Blend(Blend.Mode.SRC_OVER, this.createBlend(Blend.Mode.SRC_OUT, prDrawable, prDrawable2, n, n2), this.createBlend(Blend.Mode.SRC_OUT, prDrawable2, prDrawable, n, n2));
                }
                case 3: {
                    return this.createBlend(Blend.Mode.SRC_IN, prDrawable, prDrawable2, n, n2);
                }
                case 4: {
                    return this.createBlend(Blend.Mode.SRC_OUT, prDrawable, prDrawable2, n, n2);
                }
                case 5: {
                    return this.createBlend(Blend.Mode.SRC_ATOP, prDrawable, prDrawable2, n, n2);
                }
                case 6: {
                    return this.createBlend(Blend.Mode.SRC_OVER, prDrawable2, prDrawable, n, n2);
                }
                case 7: {
                    return this.createBlend(Blend.Mode.SRC_IN, prDrawable2, prDrawable, n, n2);
                }
                case 8: {
                    return this.createBlend(Blend.Mode.SRC_OUT, prDrawable2, prDrawable, n, n2);
                }
                case 9: {
                    return this.createBlend(Blend.Mode.SRC_ATOP, prDrawable2, prDrawable, n, n2);
                }
                case 12: {
                    return this.createBlend(Blend.Mode.ADD, prDrawable, prDrawable2, n, n2);
                }
            }
            return this.createBlend(Blend.Mode.SRC_OVER, prDrawable, prDrawable2, n, n2);
        }
    }

    private static class ContextState {
        private final WCStrokeImpl stroke = new WCStrokeImpl();
        private Rectangle clip;
        private Paint paint;
        private float alpha;
        private boolean textFill = true;
        private boolean textStroke = false;
        private boolean textClip = false;
        private boolean restorePoint = false;
        private DropShadow shadow;
        private Affine3D xform;
        private Layer layer;
        private int compositeOperation;

        public ContextState() {
            this.clip = null;
            this.paint = Color.BLACK;
            this.stroke.setPaint(Color.BLACK);
            this.alpha = 1.0f;
            this.xform = new Affine3D();
            this.compositeOperation = 2;
        }

        private ContextState(ContextState contextState) {
            this.stroke.copyFrom(contextState.getStrokeNoClone());
            this.setPaint(contextState.getPaintNoClone());
            this.clip = contextState.getClipNoClone();
            if (this.clip != null) {
                this.clip = new Rectangle(this.clip);
            }
            this.xform = new Affine3D(contextState.getTransformNoClone());
            this.setShadow(contextState.getShadowNoClone());
            this.setLayer(contextState.getLayerNoClone());
            this.setAlpha(contextState.getAlpha());
            this.setTextMode(contextState.isTextFill(), contextState.isTextStroke(), contextState.isTextClip());
            this.setCompositeOperation(contextState.getCompositeOperation());
        }

        protected ContextState clone() {
            return new ContextState(this);
        }

        public void apply(Graphics graphics) {
            graphics.setTransform(this.getTransformNoClone());
            graphics.setClipRect(this.getClipNoClone());
            graphics.setExtraAlpha(this.getAlpha());
        }

        public int getCompositeOperation() {
            return this.compositeOperation;
        }

        public void setCompositeOperation(int n) {
            this.compositeOperation = n;
        }

        public WCStrokeImpl getStrokeNoClone() {
            return this.stroke;
        }

        public Paint getPaintNoClone() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Rectangle getClipNoClone() {
            return this.clip;
        }

        public Layer getLayerNoClone() {
            return this.layer;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        public void setClip(Rectangle rectangle) {
            this.clip = rectangle;
        }

        public void clip(Rectangle rectangle) {
            if (null == this.clip) {
                this.clip = rectangle;
            } else {
                this.clip.intersectWith(rectangle);
            }
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setTextMode(boolean bl, boolean bl2, boolean bl3) {
            this.textFill = bl;
            this.textStroke = bl2;
            this.textClip = bl3;
        }

        public boolean isTextFill() {
            return this.textFill;
        }

        public boolean isTextStroke() {
            return this.textStroke;
        }

        public boolean isTextClip() {
            return this.textClip;
        }

        public void markAsRestorePoint() {
            this.restorePoint = true;
        }

        public boolean isRestorePoint() {
            return this.restorePoint;
        }

        public void setShadow(DropShadow dropShadow) {
            this.shadow = dropShadow;
        }

        public DropShadow getShadowNoClone() {
            return this.shadow;
        }

        public Affine3D getTransformNoClone() {
            return this.xform;
        }

        public void setTransform(Affine3D affine3D) {
            this.xform.setTransform(affine3D);
        }

        public void concatTransform(Affine3D affine3D) {
            this.xform.concatenate(affine3D);
        }

        public void translate(double d, double d2) {
            this.xform.translate(d, d2);
        }

        public void scale(double d, double d2) {
            this.xform.scale(d, d2);
        }

        public void rotate(double d) {
            this.xform.rotate(d);
        }
    }

    private static abstract class Layer {
        FilterContext fctx;
        PrDrawable buffer;
        Graphics graphics;
        final Rectangle bounds;

        Layer(Graphics graphics, Rectangle rectangle) {
            this.bounds = new Rectangle(rectangle);
            int n = Math.max(rectangle.width, 1);
            int n2 = Math.max(rectangle.height, 1);
            this.fctx = PrFilterContext.getInstance(graphics.getAssociatedScreen());
            this.buffer = (PrDrawable)Effect.getCompatibleImage(this.fctx, n, n2);
        }

        public Graphics getGraphics() {
            if (this.graphics == null) {
                this.graphics = this.buffer.createGraphics();
            }
            return this.graphics;
        }

        public abstract void init(Graphics var1);

        public abstract void render(Graphics var1);

        public void dispose() {
            Effect.releaseCompatibleImage(this.fctx, this.buffer);
        }

        public double getX() {
            return this.bounds.x;
        }

        public double getY() {
            return this.bounds.y;
        }
    }

    public static class PassThrough
    extends Effect {
        private final PrDrawable img;
        private final int width;
        private final int height;

        public PassThrough(PrDrawable prDrawable, int n, int n2) {
            this.img = prDrawable;
            this.width = n;
            this.height = n2;
        }

        @Override
        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            return new ImageData(filterContext, this.img, new Rectangle((int)baseTransform.getMxt(), (int)baseTransform.getMyt(), this.width, this.height));
        }

        @Override
        public RectBounds getBounds(BaseTransform baseTransform, Effect effect) {
            return null;
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext filterContext) {
            return Effect.AccelType.INTRINSIC;
        }
    }

    private class TransparencyLayer
    extends Layer {
        private float opacity;

        public TransparencyLayer(Graphics graphics, Rectangle rectangle, float f) {
            super(graphics, rectangle);
            this.opacity = f;
        }

        @Override
        public void init(Graphics graphics) {
            WCGraphicsPrismContext.this.state.setCompositeOperation(2);
        }

        @Override
        public void render(Graphics graphics) {
            new Composite(){

                @Override
                void doPaint(Graphics graphics) {
                    float f = graphics.getExtraAlpha();
                    graphics.setExtraAlpha(TransparencyLayer.this.opacity);
                    graphics.drawTexture((Texture)TransparencyLayer.this.buffer.getTextureObject(), 0.0f, 0.0f, TransparencyLayer.this.bounds.width, TransparencyLayer.this.bounds.height);
                    graphics.setExtraAlpha(f);
                }
            }.paint(graphics);
        }

        public String toString() {
            return String.format("TransparencyLayer[%d,%d + %dx%d, opacity %.2f]", this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, Float.valueOf(this.opacity));
        }
    }
}

