//
// restonground.cs
//
// Defines the RestOnGround tool plug-in that places the bottom of the selection bounding box
// at world z=0.
//
// Revision History:
// August 2, 2006			David Wyand		Created script file
//

package RestOnGround
{
   //************************************************************************************
   //*** Standard Tool Functions
   //************************************************************************************
   
   //************************************************************************************
   // Activate()
   //
   // Called when the tool is activated.  %version holds the current version of this
   // tool type in Constructor to allow the tool to step down features if required.
   // %inst is actually a ScriptObject behind the scenes that allows for the tool's
   // instance to be attached to it -- which is typically a ScriptObject itself.
   // %static is a ScriptObject that allows anything to be attached to it that will
   // presist across tool instances.
   // Return a Tool Return Function to indicate success of the tool's activation.
   function Plugin::Activate(%this, %version, %inst, %static)
   {
      //error("RestOnGround: Activate(" @ %version @ "," @ %inst @ "," @ %static @ ")");

      //*** Check for a valid version
      if(%version != 1)
      {
         return tool.FUNC_BADVERSION();
      }
      
      //*** This tool doesn't need to make use of the instance
      %inst.instance = 0;
      %inst.flagsInterface = tool.IFLAG_NONE(); // No special interface flags as there will be no interface
      %inst.flagsApply = tool.AFLAG_NONE();     // No special actions when tool is applied
      
      //*** Return that everything is OK
      return tool.FUNC_OK();
   }

   //************************************************************************************
   // Done()
   //
   // Called when the user is finished with the tool.  Typically any allocated
   // memory is freed here.  %inst and %static are the same as those in the
   // activation function.  This function does not return a value.
   function Plugin::Done(%this, %inst, %static)
   {
      //error("RestOnGround: Done(" @ %inst @ "," @ %static @ ")");

      %plugin = %inst.instance;
      
      if(%plugin)
      {         
         //*** Delete our instance
         %plugin.delete();
         %inst.instance = 0;
      }
   }

   //************************************************************************************
   // Execute()
   //
   // This function is called to perform the actual work of the tool, and does not
   // return a value.
   function Plugin::Execute(%this, %inst)
   {
      //error("RestOnGround: Execute(" @ %inst @ ")");

      %plugin = %inst.instance;
      
      %selbounds = select.getSelectionBounds();
      %axis = %plugin.static.axis;
      %move = "0 0" SPC -(getWord(%selbounds,2));
      
      select.moveItemsRel(%move);
      select.updateBounds();
   }
};

tool.register("RestOnGround", tool.typeGeneric(), tool.RFLAG_NONE(), "Rest On Ground" );
