//
// csgsubtract.cs
//
// Defines the CSGSubtract tool plug-in to subtract brsuhes from other brushes.
//
// Revision History:
// May 17, 2006				David Wyand		Created script file
//

package CSGSubtract
{
   //************************************************************************************
   //*** Standard Tool Functions
   //************************************************************************************
   
   //************************************************************************************
   // Activate()
   //
   // Called when the tool is activated.  %version holds the current version of this
   // tool type in Constructor to allow the tool to step down features if required.
   // %inst is actually a ScriptObject behind the scenes that allows for the tool's
   // instance to be attached to it -- which is typically a ScriptObject itself.
   // %static is a ScriptObject that allows anything to be attached to it that will
   // presist across tool instances.
   // Return a Tool Return Function to indicate success of the tool's activation.
   function Plugin::Activate(%this, %version, %inst, %static)
   {
      //error("CSGSubtract: Activate(" @ %version @ "," @ %inst @ "," @ %static @ ")");

      //*** Check for a valid version
      if(%version != 1)
      {
         return tool.FUNC_BADVERSION();
      }
      
      //*** Only brush selection is supported
      if(select.getSelectionType() !$= "SelectPrimitives")
      {
         tool.activateErrorMsg = "This tool only works in the 'Brushes' selection mode.";
         return tool.FUNC_BADSELECTMODE();
      }
      
      %scene = scene.getCurrent();
      %map = scene.getCurrentMap();

      //*** Make sure that at least one brush is selected...
      if(%map.getNumSelectedBrushes() == 0)
      {
         tool.activateErrorMsg = "Please select one or more brushes to act as the subtractor.";
         return tool.FUNC_BADGENERAL();
      }
      
      //*** This tool doesn't need to make use of the instance
      %inst.instance = 0;
      %inst.flagsInterface = tool.IFLAG_NONE(); // No special interface flags as there will be no interface
      %inst.flagsApply = tool.AFLAG_NONE();     // No special actions when tool is applied
      
      //*** Return that everything is OK
      return tool.FUNC_OK();
   }

   //************************************************************************************
   // Done()
   //
   // Called when the user is finished with the tool.  Typically any allocated
   // memory is freed here.  %inst and %static are the same as those in the
   // activation function.  This function does not return a value.
   function Plugin::Done(%this, %inst, %static)
   {
      //error("CSGSubtract: Done(" @ %inst @ "," @ %static @ ")");

      %plugin = %inst.instance;
      
      if(%plugin)
      {         
         //*** Delete our instance
         %plugin.delete();
         %inst.instance = 0;
      }
   }

   //************************************************************************************
   // Execute()
   //
   // This function is called to perform the actual work of the tool, and does not
   // return a value.
   function Plugin::Execute(%this, %inst)
   {
      //error("CSGSubtract: Execute(" @ %inst @ ")");

      %plugin = %inst.instance;
      
      //*** Perform the CSG Subtraction
      scene.getCurrentMap().performCSGSubtraction(scene.getCurrentMap().getSelectedBrushes());
      scene.notifyBrushRefresh();
   }
};

tool.register("CSGSubtract", tool.typeGeneric(), tool.RFLAG_NONE(), "CSG Subtract" );
