//*** Functions to help with clone tools

//*** This function will add brushes to a list.  It requires the
//*** original brush clone list, the number of brushes in this list,
//*** and the number of brushes to add.  It returns the new list.
function CloneHelperAddBrushes(%list, %oldNumClones, %diff)
{
   %map = scene.getCurrentMap();

   %brushes = %map.getSelectedBrushes();
   %count = getWordCount(%brushes);
   if(%count == 0 && !pref.getBool("ToolOperateSelectionOnly"))
   {
      //*** Use all brushes instead
      %brushes = %map.getUnselectedBrushes();
      %count = getWordCount(%brushes);
   }

   %duplistcount = getWordCount(%list);
   %newlist = %list;

   for(%i=0; %i<%diff; %i++)
   {
      %cloneNum = %oldNumClones + %i;
               
      //*** Duplicate each selected brush, add it to our list
      for(%j=0; %j<%count; %j++)
      {
         %dupID = %map.duplicateBrush(getWord(%brushes, %j));
         if(%dupID != -1)
         {
            if(%duplistcount != 0)
            {
               %newlist = %newlist SPC %dupID SPC %cloneNum;
               %duplistcount++;
                        
            } else
            {
               %newlist = %dupID SPC %cloneNum;
               %duplistcount++;
            }

            //*** Check the parent entity of the duplicated brush.  If it has a
            //*** one-to-one relationship then we'll need to duplicate it too.
            %parentID = %map.getBrushOwner(%dupID);
            if(%map.getEntityChildRelationship(%parentID) == 0)
            {
               %newentityID = %map.duplicateEntity(%parentID);
               %map.setBrushOwner(%dupID, %newentityID);
            }
         }
      }
   }

   return %newlist;
}

//*** This function will remove brushes from a list.  It requires the
//*** original brush clone list and the new number of clones the list should
//*** be reduced to.  It returns the new list.
function CloneHelperRemoveBrushes(%list, %numClones)
{
   %map = scene.getCurrentMap();

   %count = getWordCount(%list);
   %newlist = "";
   %added = false;
   for(%i=0; %i<%count; %i=%i+2)
   {
      %dupID = getWord(%list, %i);
      %cloneNum = getWord(%list, %i+1);
               
      if(%cloneNum < %numClones)
      {
         //*** Keep the clone
         if(%added)
         {
            %newlist = %newlist SPC %dupID SPC %cloneNum;
                        
         } else
         {
            %added = true;
            %newlist = %dupID SPC %cloneNum;
         }
                  
      } else
      {
         //*** Remove the clone
         %map.removeBrush(%dupID);
      }
   }
            
   return %newlist;
}

//*** This function will add shapes to a list.  It requires the
//*** original shape clone list, the number of shapes in this list,
//*** and the number of shapes to add.  It returns the new list.
function CloneHelperAddShapes(%list, %oldNumClones, %diff)
{
   %scene = scene.getCurrent();

   %shapes = %scene.getSelectedShapes();
   %count = getWordCount(%shapes);
   if(%count == 0 && !pref.getBool("ToolOperateSelectionOnly"))
   {
      //*** Use all shapes instead
      %shapes = %scene.getUnselectedShapes();
      %count = getWordCount(%shapes);
   }
            
   %duplistcount = getWordCount(%list);
   %newlist = %list;

   for(%i=0; %i<%diff; %i++)
   {
      %cloneNum = %oldNumClones + %i;
               
      //*** Duplicate each selected shape, add it to our list
      for(%j=0; %j<%count; %j++)
      {
         %dupID = %scene.duplicateShape(getWord(%shapes, %j));
         if(%dupID != -1)
         {
            if(%duplistcount != 0)
            {
               %newlist = %newlist SPC %dupID SPC %cloneNum;
               %duplistcount++;
                        
            } else
            {
               %newlist = %dupID SPC %cloneNum;
               %duplistcount++;
            }
         }
      }
   }

   return %newlist;
}

//*** This function will remove shapes from a list.  It requires the
//*** original shape clone list and the new number of shapes the list should
//*** be reduced to.  It returns the new list.
function CloneHelperRemoveShapes(%list, %numClones)
{
   %scene = scene.getCurrent();

   %count = getWordCount(%list);
   %newlist = "";
   %added = false;
   for(%i=0; %i<%count; %i=%i+2)
   {
      %dupID = getWord(%list, %i);
      %cloneNum = getWord(%list, %i+1);
               
      if(%cloneNum < %numClones)
      {
         //*** Keep the clone
         if(%added)
         {
            %newlist = %newlist SPC %dupID SPC %cloneNum;
                        
         } else
         {
            %added = true;
            %newlist = %dupID SPC %cloneNum;
         }
                  
      } else
      {
         //*** Remove the clone
         %scene.removeShape(%dupID);
      }
   }
            
   return %newlist;
}
