//
// align2d.cs
//
// A collection of tool plug-ins to align the selected objects to a particular edge
//
// Revision History:
// August 25, 2006			David Wyand		Created script file
//

package AlignLeft2D
{
   //************************************************************************************
   //*** Standard Tool Functions
   //************************************************************************************
   
   //************************************************************************************
   // Activate()
   //
   // Called when the tool is activated.  %version holds the current version of this
   // tool type in Constructor to allow the tool to step down features if required.
   // %inst is actually a ScriptObject behind the scenes that allows for the tool's
   // instance to be attached to it -- which is typically a ScriptObject itself.
   // %static is a ScriptObject that allows anything to be attached to it that will
   // presist across tool instances.
   // Return a Tool Return Function to indicate success of the tool's activation.
   function Plugin::Activate(%this, %version, %inst, %static)
   {
      //error("AlignLeft2D: Activate(" @ %version @ "," @ %inst @ "," @ %static @ ")");

      //*** Check for a valid version
      if(%version != 1)
      {
         return tool.FUNC_BADVERSION();
      }
      
      %scene = scene.getCurrent();
      %map = scene.getCurrentMap();

      //*** Make sure that at least two objects or shapes are selected...
      if(select.count() < 2)
      {
         tool.activateErrorMsg = "Please select two or more objects and/or shapes for this tool to operate on.";
         return tool.FUNC_BADGENERAL();
      }

      tool.setUndoEntryLabel("Align 2D: Left");
      
      %inst.instance = tool.userParam1;         // Store the passed parameter as the 'instance'
      %inst.flagsInterface = tool.IFLAG_NONE(); // No special interface flags as there will be no interface
      %inst.flagsApply = tool.AFLAG_NONE();     // No special actions when tool is applied
      
      //*** Return that everything is OK
      return tool.FUNC_OK();
   }

   //************************************************************************************
   // Done()
   //
   // Called when the user is finished with the tool.  Typically any allocated
   // memory is freed here.  %inst and %static are the same as those in the
   // activation function.  This function does not return a value.
   function Plugin::Done(%this, %inst, %static)
   {
      //error("AlignLeft2D: Done(" @ %inst @ "," @ %static @ ")");

      %display = %inst.instance;
   }

   //************************************************************************************
   // Execute()
   //
   // This function is called to perform the actual work of the tool, and does not
   // return a value.
   function Plugin::Execute(%this, %inst)
   {
      //error("AlignLeft2D: Execute(" @ %inst @ ")");

      %display = %inst.instance;

      //*** The coordinate we test against depends on the view
      switch(%display)
      {
         case 1:
            //*** Top View
            %bcoord = 0;
            %replace = 0;

         case 2:
            //*** Bottom View
            %bcoord = 0;
            %replace = 0;

         case 3:
            //*** Front View
            %bcoord = 3;
            %replace = 0;

         case 4:
            //*** Back View
            %bcoord = 0;
            %replace = 0;

         case 5:
            //*** Left View
            %bcoord = 4;
            %replace = 1;

         case 6:
            //*** Right View
            %bcoord = 1;
            %replace = 1;

         default:
            //*** Top View
            %bcoord = 0;
            %replace = 0;
      }

      Align2D_PerformObjectAlign(%bcoord, %replace);
   }
};

tool.register("AlignLeft2D", tool.typeGeneric(), tool.RFLAG_STORETRANSFORMS(), "Align selected objects to the left" );

//---------------------------------------------------------------------------------------

package AlignRight2D
{
   //************************************************************************************
   //*** Standard Tool Functions
   //************************************************************************************
   
   //************************************************************************************
   // Activate()
   //
   // Called when the tool is activated.  %version holds the current version of this
   // tool type in Constructor to allow the tool to step down features if required.
   // %inst is actually a ScriptObject behind the scenes that allows for the tool's
   // instance to be attached to it -- which is typically a ScriptObject itself.
   // %static is a ScriptObject that allows anything to be attached to it that will
   // presist across tool instances.
   // Return a Tool Return Function to indicate success of the tool's activation.
   function Plugin::Activate(%this, %version, %inst, %static)
   {
      //error("AlignRight2D: Activate(" @ %version @ "," @ %inst @ "," @ %static @ ")");

      //*** Check for a valid version
      if(%version != 1)
      {
         return tool.FUNC_BADVERSION();
      }
      
      %scene = scene.getCurrent();
      %map = scene.getCurrentMap();

      //*** Make sure that at least two objects or shapes are selected...
      if(select.count() < 2)
      {
         tool.activateErrorMsg = "Please select two or more objects and/or shapes for this tool to operate on.";
         return tool.FUNC_BADGENERAL();
      }

      tool.setUndoEntryLabel("Align 2D: Right");
      
      %inst.instance = tool.userParam1;         // Store the passed parameter as the 'instance'
      %inst.flagsInterface = tool.IFLAG_NONE(); // No special interface flags as there will be no interface
      %inst.flagsApply = tool.AFLAG_NONE();     // No special actions when tool is applied
      
      //*** Return that everything is OK
      return tool.FUNC_OK();
   }

   //************************************************************************************
   // Done()
   //
   // Called when the user is finished with the tool.  Typically any allocated
   // memory is freed here.  %inst and %static are the same as those in the
   // activation function.  This function does not return a value.
   function Plugin::Done(%this, %inst, %static)
   {
      //error("AlignRight2D: Done(" @ %inst @ "," @ %static @ ")");

      %display = %inst.instance;
   }

   //************************************************************************************
   // Execute()
   //
   // This function is called to perform the actual work of the tool, and does not
   // return a value.
   function Plugin::Execute(%this, %inst)
   {
      //error("AlignRight2D: Execute(" @ %inst @ ")");

      %display = %inst.instance;

      //*** The coordinate we test against depends on the view
      switch(%display)
      {
         case 1:
            //*** Top View
            %bcoord = 3;
            %replace = 0;

         case 2:
            //*** Bottom View
            %bcoord = 3;
            %replace = 0;

         case 3:
            //*** Front View
            %bcoord = 0;
            %replace = 0;

         case 4:
            //*** Back View
            %bcoord = 3;
            %replace = 0;

         case 5:
            //*** Left View
            %bcoord = 1;
            %replace = 1;

         case 6:
            //*** Right View
            %bcoord = 4;
            %replace = 1;

         default:
            //*** Top View
            %bcoord = 3;
            %replace = 0;
      }

      Align2D_PerformObjectAlign(%bcoord, %replace);
   }
};

tool.register("AlignRight2D", tool.typeGeneric(), tool.RFLAG_STORETRANSFORMS(), "Align selected objects to the right" );

//---------------------------------------------------------------------------------------

package AlignTop2D
{
   //************************************************************************************
   //*** Standard Tool Functions
   //************************************************************************************
   
   //************************************************************************************
   // Activate()
   //
   // Called when the tool is activated.  %version holds the current version of this
   // tool type in Constructor to allow the tool to step down features if required.
   // %inst is actually a ScriptObject behind the scenes that allows for the tool's
   // instance to be attached to it -- which is typically a ScriptObject itself.
   // %static is a ScriptObject that allows anything to be attached to it that will
   // presist across tool instances.
   // Return a Tool Return Function to indicate success of the tool's activation.
   function Plugin::Activate(%this, %version, %inst, %static)
   {
      //error("AlignTop2D: Activate(" @ %version @ "," @ %inst @ "," @ %static @ ")");

      //*** Check for a valid version
      if(%version != 1)
      {
         return tool.FUNC_BADVERSION();
      }
      
      %scene = scene.getCurrent();
      %map = scene.getCurrentMap();

      //*** Make sure that at least two objects or shapes are selected...
      if(select.count() < 2)
      {
         tool.activateErrorMsg = "Please select two or more objects and/or shapes for this tool to operate on.";
         return tool.FUNC_BADGENERAL();
      }

      tool.setUndoEntryLabel("Align 2D: Top");
      
      %inst.instance = tool.userParam1;         // Store the passed parameter as the 'instance'
      %inst.flagsInterface = tool.IFLAG_NONE(); // No special interface flags as there will be no interface
      %inst.flagsApply = tool.AFLAG_NONE();     // No special actions when tool is applied
      
      //*** Return that everything is OK
      return tool.FUNC_OK();
   }

   //************************************************************************************
   // Done()
   //
   // Called when the user is finished with the tool.  Typically any allocated
   // memory is freed here.  %inst and %static are the same as those in the
   // activation function.  This function does not return a value.
   function Plugin::Done(%this, %inst, %static)
   {
      //error("AlignTop2D: Done(" @ %inst @ "," @ %static @ ")");

      %display = %inst.instance;
   }

   //************************************************************************************
   // Execute()
   //
   // This function is called to perform the actual work of the tool, and does not
   // return a value.
   function Plugin::Execute(%this, %inst)
   {
      //error("AlignTop2D: Execute(" @ %inst @ ")");

      %display = %inst.instance;

      //*** The coordinate we test against depends on the view
      switch(%display)
      {
         case 1:
            //*** Top View
            %bcoord = 4;
            %replace = 1;

         case 2:
            //*** Bottom View
            %bcoord = 1;
            %replace = 1;

         case 3:
            //*** Front View
            %bcoord = 5;
            %replace = 2;

         case 4:
            //*** Back View
            %bcoord = 5;
            %replace = 2;

         case 5:
            //*** Left View
            %bcoord = 5;
            %replace = 2;

         case 6:
            //*** Right View
            %bcoord = 5;
            %replace = 2;

         default:
            //*** Top View
            %bcoord = 4;
            %replace = 1;
      }

      Align2D_PerformObjectAlign(%bcoord, %replace);
   }
};

tool.register("AlignTop2D", tool.typeGeneric(), tool.RFLAG_STORETRANSFORMS(), "Align selected objects to the top" );

//---------------------------------------------------------------------------------------

package AlignBottom2D
{
   //************************************************************************************
   //*** Standard Tool Functions
   //************************************************************************************
   
   //************************************************************************************
   // Activate()
   //
   // Called when the tool is activated.  %version holds the current version of this
   // tool type in Constructor to allow the tool to step down features if required.
   // %inst is actually a ScriptObject behind the scenes that allows for the tool's
   // instance to be attached to it -- which is typically a ScriptObject itself.
   // %static is a ScriptObject that allows anything to be attached to it that will
   // presist across tool instances.
   // Return a Tool Return Function to indicate success of the tool's activation.
   function Plugin::Activate(%this, %version, %inst, %static)
   {
      //error("AlignBottom2D: Activate(" @ %version @ "," @ %inst @ "," @ %static @ ")");

      //*** Check for a valid version
      if(%version != 1)
      {
         return tool.FUNC_BADVERSION();
      }
      
      %scene = scene.getCurrent();
      %map = scene.getCurrentMap();

      //*** Make sure that at least two objects or shapes are selected...
      if(select.count() < 2)
      {
         tool.activateErrorMsg = "Please select two or more objects and/or shapes for this tool to operate on.";
         return tool.FUNC_BADGENERAL();
      }

      tool.setUndoEntryLabel("Align 2D: Bottom");
      
      %inst.instance = tool.userParam1;         // Store the passed parameter as the 'instance'
      %inst.flagsInterface = tool.IFLAG_NONE(); // No special interface flags as there will be no interface
      %inst.flagsApply = tool.AFLAG_NONE();     // No special actions when tool is applied
      
      //*** Return that everything is OK
      return tool.FUNC_OK();
   }

   //************************************************************************************
   // Done()
   //
   // Called when the user is finished with the tool.  Typically any allocated
   // memory is freed here.  %inst and %static are the same as those in the
   // activation function.  This function does not return a value.
   function Plugin::Done(%this, %inst, %static)
   {
      //error("AlignBottom2D: Done(" @ %inst @ "," @ %static @ ")");

      %display = %inst.instance;
   }

   //************************************************************************************
   // Execute()
   //
   // This function is called to perform the actual work of the tool, and does not
   // return a value.
   function Plugin::Execute(%this, %inst)
   {
      //error("AlignBottom2D: Execute(" @ %inst @ ")");

      %display = %inst.instance;

      //*** The coordinate we test against depends on the view
      switch(%display)
      {
         case 1:
            //*** Top View
            %bcoord = 1;
            %replace = 1;

         case 2:
            //*** Bottom View
            %bcoord = 4;
            %replace = 1;

         case 3:
            //*** Front View
            %bcoord = 2;
            %replace = 2;

         case 4:
            //*** Back View
            %bcoord = 2;
            %replace = 2;

         case 5:
            //*** Left View
            %bcoord = 2;
            %replace = 2;

         case 6:
            //*** Right View
            %bcoord = 2;
            %replace = 2;

         default:
            //*** Top View
            %bcoord = 1;
            %replace = 1;
      }

      Align2D_PerformObjectAlign(%bcoord, %replace);
   }
};

tool.register("AlignBottom2D", tool.typeGeneric(), tool.RFLAG_STORETRANSFORMS(), "Align selected objects to the bottom" );

//---------------------------------------------------------------------------------------

//*** Perform the actual alignment
function Align2D_PerformObjectAlign(%bcoord, %replace)
{
   %selbounds = select.getSelectionBounds();
   %scene = scene.getCurrent();
   %map = scene.getCurrentMap();

   //*** Brushes
   if(select.getSelectionType() $= "SelectPrimitives")
   {
      %sel = %map.getSelectedBrushes();
      %count = getWordCount(%sel);
      for(%i=0; %i<%count; %i++)
      {
         %brushID = getWord(%sel, %i);
         %bcenter = %map.getBrushPosition(%brushID);
         %bbounds = %map.getBrushBounds(%brushID);

         %diff = getWord(%selbounds, %bcoord) - getWord(%bbounds, %bcoord);
         %move = "0 0 0";
         %move = setWord(%move, %replace, %diff);
         %map.moveBrush(%brushID, %move);
      }
   } else if(select.getSelectionType() $= "SelectFaces")
   {
      %sel = %map.getSelectedFaces(); // (brushID, faceID) pairs
      %count = getWordCount(%sel);
      for(%i=0; %i<%count; %i=%i+2)
      {
         %brushID = getWord(%sel, %i);
         %faceID = getWord(%sel, %i+1);
         %fbounds = %map.getFaceBounds(%brushID, %faceID);

         %diff = getWord(%selbounds, %bcoord) - getWord(%fbounds, %bcoord);
         %move = "0 0 0";
         %move = setWord(%move, %replace, %diff);
         %map.moveFace(%brushID, %faceID, %move);
      }
   } else if(select.getSelectionType() $= "SelectVertices")
   {
      //*** Convert the box axis into a point axis
      %vbcoord = %bcoord;
      if(%vbcoord >= 3)
         %vbcoord = %vbcoord - 3;

      %sel = %map.getSelectedVertices(); // (brushID, vertID) pairs
      %count = getWordCount(%sel);
      %prevBrushID = -1;
      %bpos = "0 0 0";
      for(%i=0; %i<%count; %i=%i+2)
      {
         %brushID = getWord(%sel, %i);
         %vertID = getWord(%sel, %i+1);

         if(%brushID != %prevBrushID)
         {
            //%bpos = %map.getBrushTransformedPosition(%brushID);
            %bpos = %map.getBrushPosition(%brushID);
            %prevBrushID = %brushID;
         }
         %pos = %map.getVertexPosition(%brushID, %vertID);
         %pos = VectorAdd(%bpos, %pos);

         %diff = getWord(%selbounds, %bcoord) - getWord(%pos, %vbcoord);
         %move = "0 0 0";
         %move = setWord(%move, %replace, %diff);
         %map.moveVertex(%brushID, %vertID, %move);
      }
   }

   //*** Shapes
   %sel = %scene.getSelectedShapes();
   %count = getWordCount(%sel);
   for(%i=0; %i<%count; %i++)
   {
      %shapeID = getWord(%sel, %i);
      %scenter = %scene.getShapePosition(%shapeID);
      %sbounds = %scene.getShapeBounds(%shapeID);

      %diff = getWord(%selbounds, %bcoord) - getWord(%sbounds, %bcoord);
      %move = "0 0 0";
      %move = setWord(%move, %replace, %diff);
      %scene.moveShape(%shapeID, %move);
   }
}
