//***
//*** Constructor Initialization
//***

//-----------------------------------------------------------------------------
exec("./scripts/units.cs");

// JMK - test func...
function lm()
{
   scene.getcurrentmap().calculatelighting();
}

function exp()
{
   scene.exportToDif("D:\\temp\\dif_test\\test.dif", scene.getCurrent());
}

function initServer()
{
   echo("\n--------- Initializing MOD: Constructor: Server ---------");

   // Server::Status is returned in the Game Info Query and represents the
   // current status of the server. This string sould be very short.
   $Server::Status = "Unknown";

   // Turn on testing/debug script functions
   $Server::TestCheats = false;

   // Specify where the mission files are.
   $Server::MissionFileSpec = "*/missions/*.mis";

   // The common module provides the basic server functionality
   initBaseServer();

   // Load up game server support scripts
//   exec("./scripts/commands.cs");
//   exec("./scripts/centerPrint.cs");
//   exec("./scripts/game.cs");
}

//-----------------------------------------------------------------------------

function initClient()
{
   echo("\n--------- Initializing Lighting System: Loading Extensions ---------");
   LightingSystemExtensions_loadExtensions();

   echo("\n--------- Initializing MOD: Constructor: Client ---------");

   // Make sure this variable reflects the correct state.
   $Server::Dedicated = false;

   // Game information used to query the master server
   $Client::GameTypeQuery = "Constructor";
   $Client::MissionTypeQuery = "Any";

   //
   exec("./ui/customProfiles.cs"); // override the base profiles if necessary

   //*** Create the instant group that all script objects automatically belong to
   new SimGroup( ClientCleanupGroup );
   $instantGroup = ClientCleanupGroup;

   // The common module provides basic client functionality
   initBaseClient();

   // InitCanvas starts up the graphics system.
   // The canvas needs to be constructed before the gui scripts are
   // run because many of the controls assume the canvas exists at
   // load time.
   
   // THB: The window title and version numbering is now updated in version.cs.
   // Please change versions there instead of hacking the window title here.
   initCanvas($ApplicationWindowTitle, false);

   //*** The Digital Rights Management GUIs
   exec("common/ui/RegisterDlg.gui");
   exec("common/ui/TrialDlg.gui");

   /// Load client-side Audio Profiles/Descriptions
   exec("./scripts/audioProfiles.cs");

   //*** Load up the new file browser
   exec("./filebrowser/LoadFileDlg.gui");
   exec("./filebrowser/SaveFileDlg.gui");
   exec("./filebrowser/BrowseDirDlg.gui");
   
   exec("./fbFileBrowser/fallbackBrowser.cs");

   // Load up the Game GUIs
   exec("./ui/defaultGameProfiles.cs");
   exec("./ui/PlayGui.gui");
   exec("./ui/ChatHud.gui");
   exec("./ui/playerList.gui");

   // Load up the shell GUIs
   exec("./ui/GuiDisplayBitmapDialog.gui");
   exec("./ui/MainGui.gui");
   exec("./ui/SelectLayoutDialog.gui");
   exec("./ui/SaveLayoutAsDialog.gui");
   exec("./ui/RenameLayoutAsDialog.gui");
   exec("./ui/ManageLayoutsDialog.gui");
   exec("./ui/NewAlbumNameDialog.gui");
   exec("./ui/RenameAlbumDialog.gui");
   exec("./ui/CopyTextureToAlbumDialog.gui");
   exec("./ui/AddSelectedEntityDialog.gui");
   exec("./ui/AddSelectedPropertyDialog.gui");
   exec("./ui/LoadSelectionDialog.gui");
   exec("./ui/SaveSelectionDialog.gui");
   exec("./ui/SaveWorkplaneDialog.gui");
   exec("./ui/AddNewEntityClassDialog.gui");
   exec("./ui/AddNewEntityClassPropertyDialog.gui");
   exec("./ui/OtherBrushEntityDialog.gui");
   exec("./ui/ToolStandardDialog.gui");
   exec("./ui/NoInputDialog.gui");
   exec("./ui/UnresolvedTexturesDialog.gui");
   exec("./ui/ToolProgressDialog.gui");
   exec("./ui/AboutGui.gui");
//   exec("./ui/QuitGui.gui");
//   exec("./ui/aboutDlg.gui");
//   exec("./ui/startMissionGui.gui");
//   exec("./ui/joinServerGui.gui");
//   exec("./ui/loadingGui.gui");
//   exec("./ui/endGameGui.gui");
//   exec("./ui/optionsDlg.gui");
//   exec("./ui/remapDlg.gui");
//   exec("./ui/StartupGui.gui");

   // Client scripts
   exec("./scripts/client.cs");
   exec("./scripts/game.cs");
   exec("./scripts/missionDownload.cs");
   exec("./scripts/serverConnection.cs");
   exec("./scripts/playerList.cs");
   exec("./scripts/loadingGui.cs");
   exec("./scripts/optionsDlg.cs");
   exec("./scripts/chatHud.cs");
   exec("./scripts/messageHud.cs");
   exec("./scripts/playGui.cs");
   exec("./scripts/centerPrint.cs");

   //*** Constructor Scripts
   exec("./scripts/colorpopup.cs");
   exec("./scripts/constants.cs");
   exec("./scripts/messagerouter.cs");
   exec("./scripts/preferencesmanager.cs");
   exec("./scripts/userselectableaction.cs");
   exec("./scripts/userselectableactionmenuitem.cs");
   exec("./scripts/userselectiontype.cs");
   exec("./scripts/userselectiontypemenuitem.cs");
   exec("./scripts/actioncentermenuitem.cs");
   exec("./scripts/interiormapmanager.cs");
   exec("./scripts/materialsmanager.cs");
   exec("./scripts/thememanager.cs");
   exec("./scripts/workplane.cs");
   exec("./scripts/axisgizmo.cs");
   exec("./scripts/useractionmanager.cs");
   exec("./scripts/scene.cs");
   exec("./scripts/scenemanager.cs");
   exec("./scripts/scenepersistance.cs");
   exec("./scripts/toolmanager.cs");
   exec("./scripts/toolmanagergui.cs");
   exec("./scripts/toolpluginedit.cs");
   exec("./scripts/selectionmanager.cs");
   exec("./scripts/clipboard.cs");
   exec("./scripts/undomanager.cs");
   exec("./scripts/filemanagement.cs");
   exec("./scripts/layoutfunctions.cs");
   exec("./scripts/themefunctions.cs");
   exec("./scripts/formmenu.cs");
   exec("./scripts/database.cs");
   exec("./scripts/databaseconfig.cs");
   exec("./scripts/databasetexture.cs");
   exec("./scripts/databaseentityclasses.cs");
   exec("./scripts/databaseentities.cs");
   exec("./scripts/databaseplatform.cs");
   exec("./scripts/databaseprefabs.cs");
   exec("./scripts/tgemenubar.cs");
   exec("./scripts/windowmenu.cs");
   exec("./scripts/viewtexturedialog.cs");
   exec("./ui/SelectLayoutDialog.cs");
   exec("./scripts/exportlodlistdialog.cs");
   exec("./scripts/manageentitiesdialog.cs");
   exec("./scripts/managegametypesdialog.cs");
   exec("./scripts/manageprefabsdialog.cs");
   exec("./scripts/manageworkplanesdialog.cs");
   exec("./scripts/otherbrushentitydialog.cs");
   exec("./scripts/texturebrowserdialog.cs");
   exec("./scripts/addselectedentitydialog.cs");
   exec("./scripts/addselectedpropertydialog.cs");
   exec("./scripts/windowbackdropbitmap.cs");
   exec("./scripts/loadselectiondialog.cs");
   exec("./scripts/saveselectiondialog.cs");
   exec("./scripts/saveworkplanedialog.cs");
   exec("./scripts/systemmanageentitiesdialog.cs");
   exec("./scripts/systemmanageentitypropertiesdialog.cs");
   exec("./scripts/addnewentityclassdialog.cs");
   exec("./scripts/addnewentityclasspropertydialog.cs");
   exec("./scripts/toolstandarddialog.cs");
   exec("./scripts/camera.cs");
   exec("./scripts/prefsGui.cs");
   
   exec("./scripts/treeViewTest.cs");

   //*** Dynamic control scripts
   exec("./dynamicctrls/dynamicctrls.cs");

   //*** Constructor GUIs that need to launch after the scripts and dynamic controls
   exec("./ui/ManageEntitiesDialog.gui");
   exec("./ui/ManageGameTypesDialog.gui");
   exec("./ui/ManagePrefabsDialog.gui");
   exec("./ui/ManageWorkplanesDialog.gui");
   exec("./ui/SystemManageEntitiesDialog.gui");
   exec("./ui/SystemManageEntityPropertiesDialog.gui");
   exec("./ui/TextureBrowserDialog.gui");
   exec("./ui/LightingProfileGui.gui");
   exec("./ui/LightingSystemGui.gui");
   exec("./ui/LightingProgressGui.gui");
   exec("./ui/FormTabbedModifyDialog.gui");
   exec("./ui/PrefsGui.gui");
   exec("./ui/ExportLODListDialog.gui");

   //*** Constructor Form Content Scripts
   exec("./scripts/entityproperties.cs");
   exec("./scripts/formtools.cs");
   exec("./scripts/formtoolsproperties.cs");
   exec("./scripts/formselectionmodes.cs");
   exec("./scripts/formvalues.cs");
   exec("./scripts/form3dview.cs");
   exec("./scripts/formmaterials.cs");
   exec("./scripts/formlayers.cs");
   exec("./scripts/formvizgroups.cs");
   exec("./scripts/formtoolsmini.cs");
   exec("./scripts/formselectmap.cs");
   exec("./scripts/formpreferences.cs");
   exec("./scripts/formconsole.cs");
   exec("./scripts/formundo.cs");
   exec("./scripts/formobjectproperties.cs");
   exec("./scripts/formproperties.cs");
   exec("./scripts/formsunlight.cs");
   exec("./scripts/formtabbed.cs");
   exec("./scripts/formselectionsets.cs");
   exec("./scripts/formselectionops.cs");

   exec("./scripts/documentation.cs");
   exec("./scripts/system.cs");

   //*** Command line tools
   exec("./ui/EditCmdScriptDlg.gui");
   exec("./ui/EditCmdCfgDlg.gui");
   exec("./ui/ExecCmdScriptDlg.gui");

   exec("./scripts/cmdLineTool.cs");
   exec("./scripts/editCmdScriptDlg.cs");
   exec("./scripts/editCmdCfgDlg.cs");
   exec("./scripts/execCmdScriptDlg.cs");
   exec("./scripts/cmdInserts.cs");

   // Default player key bindings
   exec("./scripts/default.bind.cs");
   exec("./config.cs");

   // Really shouldn't be starting the networking unless we are
   // going to connect to a remote server, or host a multi-player
   // game.
   setNetPort(0);

   // Copy saved script prefs into C++ code.
   setShadowDetailLevel( $pref::shadows );
   setDefaultFov( $pref::Player::defaultFov );
   setZoomSpeed( $pref::Player::zoomSpeed );

   // Start up the main menu... this is separated out into a
   // method for easier mod override.
   setupClient();
}


//-----------------------------------------------------------------------------

function setupClient()
{

   //*** Open the configuration database
   DB::OpenConfigDatabase();

   //*** Open the texture album database
   DB::OpenTextureAlbumDatabase();

   //*** Open the map entity database
   DB::OpenEntityDatabase();

   //*** Initialize the Preferences Manager and build the standard preferences
   initPreferencesManager();
   pref.__buildStandardPrefs();

   //*** Initialize the Scene Manager
   initSceneManager();

   //*** Initialize the Materials Manager
   initMaterialsManager();

   //*** Initialize the Tool Manager
   initToolManager();

   //*** Initialize the Selection Manager
   initSelectionManager();

   //*** Initialize the Constructor Clipboard
   initConstructorClipboard();

   //*** Initialize the Undo Manager
   initUndoManager();

   //*** Initialize the Interior Map Manager
   initInteriorMapManager();

   //*** Initialize the User Action Manager
   initUserActionManager();

   //*** Initialize the Theme Manager
   initThemeManager();

   //*** Initialize the Workplane
   initWorkplane();

   //*** Initialize the Axis Gizmo
   initAxisGizmo();

   //*** Initialize the 3D View Camera
   init3DViewCamera();

   //*** Add the sun to the scene
   //addSunToScene();
   new Sun(Sunlight) {
      azimuth = "180";
      elevation = "35";
      color = "1 1 1 1";
      ambient = "0 0 0 1";
   };
   
   //*** Build some GUI storage sets
   new SimSet(ToolPropertiesFormSet);
   new SimSet(ObjectPropertiesSet);

   //*** Load the command line export configs
   loadExportCfg();
   
   $showProgress = true;
   
   echo("- Loading default scene ...");
   scene.loadDefaultScene();
   
   //*** Set the type of menu bar to make
   if( $platform $= "x86UNIX" )
      $pref::Constructor::useTGEMenuBar = true;
      
   //$pref::Constructor::useTGEMenuBar = true; //*** FOR TESTING!!!

   //*** Set up the TGE menu bar if required
   %menuheight = 0;
   if($pref::Constructor::useTGEMenuBar)
   {
      %menuheight = 22;
      
      %menubar = new GuiMenuBar(MainGuiMenuBar) {
         profile = "GuiMenuBarProfile";
         horizSizing = "width";
         vertSizing = "bottom";
         position = "0 0";
         extent = "800" SPC %menuheight;
         minExtent = "8" SPC %menuheight;
         visible = "1";
         helpTag = "0";
      };
      %menubar.setKeyboardAcceleratorState(false);
      MainGuiBackdrop.add(%menubar);
      
   } else
   {
      //*** Use a standard platform menu
      PlatformCreateMenuBar();
   }

   //*** Set up the main container for the Constructor layouts
   %maingui = new GuiLayoutCanvas(MainGui) {
      profile = "GuiDefaultProfile";
      horizSizing = "width";
      vertSizing = "height";
      position = "0" SPC %menuheight;
      extent = "800" SPC (600-%menuheight);
      minExtent = "8 8";
      visible = "1";
   };
   MainGuiBackdrop.add(%maingui);
   
   // Startup the client with the Main menu...
   Canvas.setContent( MainGuiBackdrop );

   //*** Build out the Window menu bar and a default menu for DRM
   if($platform !$= "macos")
   {
      PlatformAddMenuItem(1, "File");
      PlatformAddMenuChildItem(3,1,"Quit","",0,userAction.MFLAG_NONE());
   }

   // Make sure the audio initialized.
   if($Audio::initFailed) {
      MessageBoxOK("Audio Initialization Failed",
         "The OpenAL audio system failed to initialize.  " @
         "You can get the most recent OpenAL drivers <a:www.garagegames.com/docs/torque/gstarted/openal.html>here</a>.");
   }

   Canvas.setCursor("DefaultCursor");

   if(!$DRMExpired)
      setupClientPostDRM();
}

function setupClientPostDRM()
{
   //*** Build out the platform menus based on the database
   if($platform !$= "macos")
   {
      PlatformDeleteTopLevelMenu(1);
   }
   DB::BuildWindowMenus();

   //*** Build the keyboard shortcuts
   DB::BuildKeyboardShortcuts();

   //*** Make sure the main window's backdrop is listening to the message queues
   MR::AddToQueue($MRQThemeChangeQueue, MainGuiBackdrop.getId() ); //*** Join the Theme queue

   //*** Load in the tools
   tool.loadToolPlugins();
   
   //*** Set the canvas content
   Canvas.setContent( MainGuiBackdrop );
   Canvas.prep();

   //*** Set that it is safe to save the current layout on exit
   $SafeToSaveCurrentLayoutOnExit = true;

   //*** Set the default theme
   setDefaultTheme();

   //*** Start with the last layout the user selected as stored in preferences
   %layoutID = DB::GetLayoutDatabaseId(pref.get("LastLayout"));
error("*** Last Layout: " @ pref.get("LastLayout"));
   if(%layoutID >= 0)
   {
      AddGuiLayout(%layoutID);

   } else
   {
      //*** Couldn't use the layout in preferences, so attempt to load the default one
      %layoutID = DB::GetLayoutDatabaseId("Constructor Default");
      if(%layoutID >= 0)
      {
         AddGuiLayout(%layoutID);

      } else
      {
         BuildFormControl(MainGui);
      }
   }

   //*** Build the Recent Scenes and Shapes platform menus
   scene.__rebuildRecentScenesList();
   scene.__rebuildRecentShapesList();
   scene.__rebuildRecentStaticMeshList();

   buildExportMenu();

   //*** And with an empty scene
   scene.newScene();

   if(DRMInTrialPeriod())
   {
      Canvas.pushDialog(RegisterDialog);
   }
}

//-----------------------------------------------------------------------------

//*** This function will display a file dialog for the user to select
//*** a script file and then execute the script.
function executeCommandScript()
{
   //*** Ask the user for a filename
   platformGetOpenFilename("", $pref::Constructor::lastScriptPath, "__executeCommandScriptCallbackOK", 0,
      "Torque Script Files (*.cs)", "*.cs",
      "All Files (*.*)", "*.*");
}
function __executeCommandScriptCallbackOK(%filename, %cbData)
{
   if(%filename $= "")
      return;
      
   //*** Recompile the script file every time
   %test = compile(%filename);
   if(!%test)
   {
      warn("Could not compile script (" @ %filename @ ")");
      return;
   }

   //*** Execute the script file
   warn("User executing scipt: " @ %filename);
   %test = exec(%filename);
   if(!%test)
   {
      warn("Could not execute script (" @ %filename @ ")");
   }
   else
      $pref::Constructor::lastScriptPath = filepath(%filename) @ "/";
}
