/*
	frameAnimation3 - by Vince McKelvie (vincemckelvie.com)
	Dual licensed under MIT and GPL.
*/

(function($) {
    $.frameAnimation = function(options) {
		var frameAnimation = this,
			animations = [],
			t,
			interval,
			browserPrefix = '',
            ticking = false,
            requestAnimFrame =	window.requestAnimationFrame ||
								window.webkitRequestAnimationFrame ||
								window.mozRequestAnimationFrame    ||
								window.oRequestAnimationFrame      ||
								window.msRequestAnimationFrame     ||
								function( callback ){
									window.setTimeout(callback, 1000 / 60);
								},
			defaults = {};
		
		frameAnimation.settings = $.extend({}, defaults, options);
		
		// PRIVATE FUNCTIONS
		function init() {
			//var i;
			// set browser prefix
			if ($.browser.mozilla) { browserPrefix = '-moz-'; }
			if ($.browser.webkit) { browserPrefix = '-webkit-'; }
			if ($.browser.opera) { browserPrefix = '-o-'; }
			if ($.browser.msie) { browserPrefix = '-ms-'; }
			
            ticking = false;
            interval = setInterval(doTick,60);
		}

		function doTick() {
            requestTick();
        }
        
        function requestTick() {
            if(!ticking) {
                requestAnimFrame(function(){
                    onframeAnimation();
                    update();
                });
            }
            ticking = true;
        }
        
        function update() {
            ticking = false;
        }
		
		var hide = false;
		var rand = 0;
		
		function onframeAnimation() {
			var i, j, anim, endAnimPos, loadIndex, frame, counter, finished;
			
			for (i=0; i<animations.length; i++) {
				anim = animations[i];
				anim.counter++;
				startAnimPos = anim.delay;
				endAnimPos = anim.endPos;
				/*
				if (anim.counter < startAnimPos) {
					if(!anim.show)anim.element.css('display','none');
					else anim.element.css('display','block');
				}
				else if (anim.counter > endAnimPos) {
					if(!anim.show)anim.element.css('display','none');
					else {
						anim.element.css('display','block');
					}
				}
				*/
				if(anim.totalFrames!=0){
					
					if(Math.floor(anim.counter*anim.rate)<anim.totalFrames){
						frame = Math.floor(anim.counter*anim.rate)*anim.step;
						anim.element.css('backgroundPosition', 0 + "px " + frame + "px");
					}else{
						if(!anim.show)anim.element.css('display','none');
						else {
							anim.element.css('display','block');
						}
					}
					
				}else{
					frame = Math.floor(anim.counter*anim.rate)*anim.step;
					anim.element.css('backgroundPosition', 0 + "px " + frame + "px");
				}
			}
		}
		
		// PUBLIC FUNCTIONS
		frameAnimation.animate = function(target) {
			var targetIndex,
				anim,
				offset,
				myT,
				i;
			if (typeof target === 'string') { target = $(target); }
			for (i=1; i<arguments.length; i++) {
				
				anim = arguments[i];
	
				if (anim.delay === undefined) { anim.delay = 0; }
				
				animations.push({
					element: target,
					delay: anim.delay,
					step: anim.step,
					counter: anim.counter !== undefined ? anim.counter : 0,
					show: anim.show !== undefined ? anim.show : false,
					rate: anim.rate !== undefined ? anim.rate: 1.0,
					totalFrames: anim.totalFrames !== undefined ? anim.totalFrames: 0,
					loops: anim.loops !== undefined ? anim.loops: 100000000000000
					
				});
			}
					
			onframeAnimation();
		};
		
		frameAnimation.destroy = function () {
			for (i=0; i<animations.length; i++) {
				delete animations[i];
			}
			clearInterval(interval);
			delete frameAnimation;
		};
		
		init();
		
		return frameAnimation;
    };
     
})(jQuery);