/*
 * Copyright (c) 2022 shchmue
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _FS_CRYPTO_H_
#define _FS_CRYPTO_H_

#include "crypto.h"

#include <utils/types.h>

static const u8 bis_kek_source[0x10] __attribute__((aligned(4))) = {
    0x34, 0xC1, 0xA0, 0xC4, 0x82, 0x58, 0xF8, 0xB4, 0xFA, 0x9E, 0x5E, 0x6A, 0xDA, 0xFC, 0x7E, 0x4F};
static const u8 bis_key_sources[3][0x20] __attribute__((aligned(4))) = {
    {0xF8, 0x3F, 0x38, 0x6E, 0x2C, 0xD2, 0xCA, 0x32, 0xA8, 0x9A, 0xB9, 0xAA, 0x29, 0xBF, 0xC7, 0x48,
     0x7D, 0x92, 0xB0, 0x3A, 0xA8, 0xBF, 0xDE, 0xE1, 0xA7, 0x4C, 0x3B, 0x6E, 0x35, 0xCB, 0x71, 0x06},
    {0x41, 0x00, 0x30, 0x49, 0xDD, 0xCC, 0xC0, 0x65, 0x64, 0x7A, 0x7E, 0xB4, 0x1E, 0xED, 0x9C, 0x5F,
     0x44, 0x42, 0x4E, 0xDA, 0xB4, 0x9D, 0xFC, 0xD9, 0x87, 0x77, 0x24, 0x9A, 0xDC, 0x9F, 0x7C, 0xA4},
    {0x52, 0xC2, 0xE9, 0xEB, 0x09, 0xE3, 0xEE, 0x29, 0x32, 0xA1, 0x0C, 0x1F, 0xB6, 0xA0, 0x92, 0x6C,
     0x4D, 0x12, 0xE1, 0x4B, 0x2A, 0x47, 0x4C, 0x1C, 0x09, 0xCB, 0x03, 0x59, 0xF0, 0x15, 0xF4, 0xE4}
};

static const u8 header_kek_source[0x10] __attribute__((aligned(4))) = {
    0x1F, 0x12, 0x91, 0x3A, 0x4A, 0xCB, 0xF0, 0x0D, 0x4C, 0xDE, 0x3A, 0xF6, 0xD5, 0x23, 0x88, 0x2A};
static const u8 header_key_source[0x20] __attribute__((aligned(4))) = {
    0x5A, 0x3E, 0xD8, 0x4F, 0xDE, 0xC0, 0xD8, 0x26, 0x31, 0xF7, 0xE2, 0x5D, 0x19, 0x7B, 0xF5, 0xD0,
    0x1C, 0x9B, 0x7B, 0xFA, 0xF6, 0x28, 0x18, 0x3D, 0x71, 0xF6, 0x4D, 0x73, 0xF1, 0x50, 0xB9, 0xD2};

static const u8 key_area_key_sources[3][0x10] __attribute__((aligned(4))) = {
    {0x7F, 0x59, 0x97, 0x1E, 0x62, 0x9F, 0x36, 0xA1, 0x30, 0x98, 0x06, 0x6F, 0x21, 0x44, 0xC3, 0x0D}, // application
    {0x32, 0x7D, 0x36, 0x08, 0x5A, 0xD1, 0x75, 0x8D, 0xAB, 0x4E, 0x6F, 0xBA, 0xA5, 0x55, 0xD8, 0x82}, // ocean
    {0x87, 0x45, 0xF1, 0xBB, 0xA6, 0xBE, 0x79, 0x64, 0x7D, 0x04, 0x8B, 0xA6, 0x7B, 0x5F, 0xDA, 0x4A}, // system
};

static const u8 save_mac_kek_source[0x10] __attribute__((aligned(4))) = {
    0xD8, 0x9C, 0x23, 0x6E, 0xC9, 0x12, 0x4E, 0x43, 0xC8, 0x2B, 0x03, 0x87, 0x43, 0xF9, 0xCF, 0x1B};
static const u8 save_mac_key_source[0x10] __attribute__((aligned(4))) = {
    0xE4, 0xCD, 0x3D, 0x4A, 0xD5, 0x0F, 0x74, 0x28, 0x45, 0xA4, 0x87, 0xE5, 0xA0, 0x63, 0xEA, 0x1F};

static const u8 save_mac_sd_card_kek_source[0x10] __attribute__((aligned(4))) = {
    0x04, 0x89, 0xEF, 0x5D, 0x32, 0x6E, 0x1A, 0x59, 0xC4, 0xB7, 0xAB, 0x8C, 0x36, 0x7A, 0xAB, 0x17};
static const u8 save_mac_sd_card_key_source[0x10] __attribute__((aligned(4))) = {
    0x6F, 0x64, 0x59, 0x47, 0xC5, 0x61, 0x46, 0xF9, 0xFF, 0xA0, 0x45, 0xD5, 0x95, 0x33, 0x29, 0x18};

static const u8 sd_card_custom_storage_key_source[0x20] __attribute__((aligned(4))) = {
    0x37, 0x0C, 0x34, 0x5E, 0x12, 0xE4, 0xCE, 0xFE, 0x21, 0xB5, 0x8E, 0x64, 0xDB, 0x52, 0xAF, 0x35,
    0x4F, 0x2C, 0xA5, 0xA3, 0xFC, 0x99, 0x9A, 0x47, 0xC0, 0x3E, 0xE0, 0x04, 0x48, 0x5B, 0x2F, 0xD0};
static const u8 sd_card_kek_source[0x10] __attribute__((aligned(4))) = {
    0x88, 0x35, 0x8D, 0x9C, 0x62, 0x9B, 0xA1, 0xA0, 0x01, 0x47, 0xDB, 0xE0, 0x62, 0x1B, 0x54, 0x32};
static const u8 sd_card_nca_key_source[0x20] __attribute__((aligned(4))) = {
    0x58, 0x41, 0xA2, 0x84, 0x93, 0x5B, 0x56, 0x27, 0x8B, 0x8E, 0x1F, 0xC5, 0x18, 0xE9, 0x9F, 0x2B,
    0x67, 0xC7, 0x93, 0xF0, 0xF2, 0x4F, 0xDE, 0xD0, 0x75, 0x49, 0x5D, 0xCA, 0x00, 0x6D, 0x99, 0xC2};
static const u8 sd_card_save_key_source[0x20] __attribute__((aligned(4))) = {
    0x24, 0x49, 0xB7, 0x22, 0x72, 0x67, 0x03, 0xA8, 0x19, 0x65, 0xE6, 0xE3, 0xEA, 0x58, 0x2F, 0xDD,
    0x9A, 0x95, 0x15, 0x17, 0xB1, 0x6E, 0x8F, 0x7F, 0x1F, 0x68, 0x26, 0x31, 0x52, 0xEA, 0x29, 0x6A};

void fs_derive_bis_keys(key_storage_t *keys, u8 out_bis_keys[4][32], u32 generation);
void fs_derive_header_key(key_storage_t *keys, void *out_key);
void fs_derive_key_area_key(key_storage_t *keys, void *out_key, u32 source_type, u32 generation);
void fs_derive_save_mac_key(key_storage_t *keys, void *out_key);

#endif
