/*
 * Copyright (c) 2013, NVIDIA CORPORATION.  All rights reserved.
 * Copyright 2014 Google Inc.
 * Copyright (c) 2018 naehrwert
 * Copyright (c) 2018-2020 CTCaer
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 */

#include <soc/t210.h>
#include <soc/pmc_lp0_t210.h>
#include <mem/sdram_lp0_param_t210.h>
#include <mem/sdram_lp0_param_t210b01.h>

#define pack(src, src_bits, dst, dst_bits) { \
	u32 mask = 0xffffffff >> (31 - ((1 ? src_bits) - (0 ? src_bits))); \
	dst &= ~(mask << (0 ? dst_bits)); \
	dst |= ((src >> (0 ? src_bits)) & mask) << (0 ? dst_bits); \
}

#define s(param, src_bits, pmcreg, dst_bits) \
	pack(sdram->param, src_bits, pmc->pmcreg, dst_bits)

#define c(value, pmcreg, dst_bits) \
	pack(value, (1 ? dst_bits) - (0 ? dst_bits) : 0, pmc->pmcreg, dst_bits)

/* 32 bits version of s macro */
#define s32(param, pmcreg) pmc->pmcreg = sdram->param

/* 32 bits version c macro */
#define c32(value, pmcreg) pmc->pmcreg = value

/*
 * This function reads SDRAM parameters from the common BCT format and
 * writes them into PMC scratch registers (where the BootROM expects them
 * on LP0 resume).
 */
static void _sdram_lp0_save_params_t210(const void *params)
{
	struct sdram_params_t210 *sdram = (struct sdram_params_t210 *)params;
	struct tegra_pmc_regs *pmc = (struct tegra_pmc_regs *)PMC_BASE;

	//TODO: pkg1.1 (1.X - 3.X) reads them from MC.
	// Patch carveout parameters.
	/*sdram->McGeneralizedCarveout1Bom = 0;
	sdram->McGeneralizedCarveout1BomHi = 0;
	sdram->McGeneralizedCarveout1Size128kb = 0;
	sdram->McGeneralizedCarveout1Access0 = 0;
	sdram->McGeneralizedCarveout1Access1 = 0;
	sdram->McGeneralizedCarveout1Access2 = 0;
	sdram->McGeneralizedCarveout1Access3 = 0;
	sdram->McGeneralizedCarveout1Access4 = 0;
	sdram->McGeneralizedCarveout1ForceInternalAccess0 = 0;
	sdram->McGeneralizedCarveout1ForceInternalAccess1 = 0;
	sdram->McGeneralizedCarveout1ForceInternalAccess2 = 0;
	sdram->McGeneralizedCarveout1ForceInternalAccess3 = 0;
	sdram->McGeneralizedCarveout1ForceInternalAccess4 = 0;
	sdram->McGeneralizedCarveout1Cfg0 = 0;
	sdram->McGeneralizedCarveout2Bom = 0x80020000;
	sdram->McGeneralizedCarveout2BomHi = 0;
	sdram->McGeneralizedCarveout2Size128kb = 2;
	sdram->McGeneralizedCarveout2Access0 = 0;
	sdram->McGeneralizedCarveout2Access1 = 0;
	sdram->McGeneralizedCarveout2Access2 = 0x3000000;
	sdram->McGeneralizedCarveout2Access3 = 0;
	sdram->McGeneralizedCarveout2Access4 = 0x300;
	sdram->McGeneralizedCarveout2ForceInternalAccess0 = 0;
	sdram->McGeneralizedCarveout2ForceInternalAccess1 = 0;
	sdram->McGeneralizedCarveout2ForceInternalAccess2 = 0;
	sdram->McGeneralizedCarveout2ForceInternalAccess3 = 0;
	sdram->McGeneralizedCarveout2ForceInternalAccess4 = 0;
	sdram->McGeneralizedCarveout2Cfg0 = 0x440167E;
	sdram->McGeneralizedCarveout3Bom = 0;
	sdram->McGeneralizedCarveout3BomHi = 0;
	sdram->McGeneralizedCarveout3Size128kb = 0;
	sdram->McGeneralizedCarveout3Access0 = 0;
	sdram->McGeneralizedCarveout3Access1 = 0;
	sdram->McGeneralizedCarveout3Access2 = 0x3000000;
	sdram->McGeneralizedCarveout3Access3 = 0;
	sdram->McGeneralizedCarveout3Access4 = 0x300;
	sdram->McGeneralizedCarveout3ForceInternalAccess0 = 0;
	sdram->McGeneralizedCarveout3ForceInternalAccess1 = 0;
	sdram->McGeneralizedCarveout3ForceInternalAccess2 = 0;
	sdram->McGeneralizedCarveout3ForceInternalAccess3 = 0;
	sdram->McGeneralizedCarveout3ForceInternalAccess4 = 0;
	sdram->McGeneralizedCarveout3Cfg0 = 0x4401E7E;
	sdram->McGeneralizedCarveout4Bom = 0;
	sdram->McGeneralizedCarveout4BomHi = 0;
	sdram->McGeneralizedCarveout4Size128kb = 0;
	sdram->McGeneralizedCarveout4Access0 = 0;
	sdram->McGeneralizedCarveout4Access1 = 0;
	sdram->McGeneralizedCarveout4Access2 = 0;
	sdram->McGeneralizedCarveout4Access3 = 0;
	sdram->McGeneralizedCarveout4Access4 = 0;
	sdram->McGeneralizedCarveout4ForceInternalAccess0 = 0;
	sdram->McGeneralizedCarveout4ForceInternalAccess1 = 0;
	sdram->McGeneralizedCarveout4ForceInternalAccess2 = 0;
	sdram->McGeneralizedCarveout4ForceInternalAccess3 = 0;
	sdram->McGeneralizedCarveout4ForceInternalAccess4 = 0;
	sdram->McGeneralizedCarveout4Cfg0 = 0x8F;
	sdram->McGeneralizedCarveout5Bom = 0;
	sdram->McGeneralizedCarveout5BomHi = 0;
	sdram->McGeneralizedCarveout5Size128kb = 0;
	sdram->McGeneralizedCarveout5Access0 = 0;
	sdram->McGeneralizedCarveout5Access1 = 0;
	sdram->McGeneralizedCarveout5Access2 = 0;
	sdram->McGeneralizedCarveout5Access3 = 0;
	sdram->McGeneralizedCarveout5Access4 = 0;
	sdram->McGeneralizedCarveout5ForceInternalAccess0 = 0;
	sdram->McGeneralizedCarveout5ForceInternalAccess1 = 0;
	sdram->McGeneralizedCarveout5ForceInternalAccess2 = 0;
	sdram->McGeneralizedCarveout5ForceInternalAccess3 = 0;
	sdram->McGeneralizedCarveout5ForceInternalAccess4 = 0;
	sdram->McGeneralizedCarveout5Cfg0 = 0x8F;*/

	//TODO: this is 4.X+ behaviour which seems to work fine for < 4.X.
	// Patch carveout parameters.
	sdram->McGeneralizedCarveout1Cfg0 = 0;
	sdram->McGeneralizedCarveout2Cfg0 = 0;
	sdram->McGeneralizedCarveout3Cfg0 = 0;
	sdram->McGeneralizedCarveout4Cfg0 = 0;
	sdram->McGeneralizedCarveout5Cfg0 = 0;

	// Patch SDRAM parameters.
	u32 t0 = sdram->EmcSwizzleRank0Byte0 << 5 >> 29 > sdram->EmcSwizzleRank0Byte0 << 1 >> 29;
	u32 t1 = (t0 & 0xFFFFFFEF) | ((sdram->EmcSwizzleRank1Byte0 << 5 >> 29 > sdram->EmcSwizzleRank1Byte0 << 1 >> 29) << 4);
	u32 t2 = (t1 & 0xFFFFFFFD) | ((sdram->EmcSwizzleRank0Byte1 << 5 >> 29 > sdram->EmcSwizzleRank0Byte1 << 1 >> 29) << 1);
	u32 t3 = (t2 & 0xFFFFFFDF) | ((sdram->EmcSwizzleRank1Byte1 << 5 >> 29 > sdram->EmcSwizzleRank1Byte1 << 1 >> 29) << 5);
	u32 t4 = (t3 & 0xFFFFFFFB) | ((sdram->EmcSwizzleRank0Byte2 << 5 >> 29 > sdram->EmcSwizzleRank0Byte2 << 1 >> 29) << 2);
	u32 t5 = (t4 & 0xFFFFFFBF) | ((sdram->EmcSwizzleRank1Byte2 << 5 >> 29 > sdram->EmcSwizzleRank1Byte2 << 1 >> 29) << 6);
	u32 t6 = (t5 & 0xFFFFFFF7) | ((sdram->EmcSwizzleRank0Byte3 << 5 >> 29 > sdram->EmcSwizzleRank0Byte3 << 1 >> 29) << 3);
	u32 t7 = (t6 & 0xFFFFFF7F) | ((sdram->EmcSwizzleRank1Byte3 << 5 >> 29 > sdram->EmcSwizzleRank1Byte3 << 1 >> 29) << 7);
	sdram->SwizzleRankByteEncode = t7;
	sdram->EmcBctSpare2 = 0x40000DD8;
	sdram->EmcBctSpare3 = t7;

	s(EmcClockSource, 7:0, scratch6, 15:8);
	s(EmcClockSourceDll, 7:0, scratch6, 23:16);
	s(EmcClockSource, 31:29, scratch6, 26:24);
	s(EmcClockSourceDll, 31:29, scratch6, 29:27);
	s(EmcClockSourceDll, 11:10, scratch6, 31:30);
	s(ClkRstControllerPllmMisc2Override, 9:8, scratch7, 1:0);
	s(ClkRstControllerPllmMisc2Override, 2:1, scratch7, 3:2);
	s(EmcZqCalLpDdr4WarmBoot, 31:30, scratch7, 5:4);
	s(EmcClockSource, 15:15, scratch7, 6:6);
	s(EmcClockSource, 26:26, scratch7, 7:7);
	s(EmcClockSource, 20:20, scratch7, 8:8);
	s(EmcClockSource, 19:19, scratch7, 9:9);
	s(ClkRstControllerPllmMisc2Override, 13:13, scratch7, 10:10);
	s(ClkRstControllerPllmMisc2Override, 12:12, scratch7, 11:11);
	s(ClkRstControllerPllmMisc2Override, 11:11, scratch7, 12:12);
	s(ClkRstControllerPllmMisc2Override, 10:10, scratch7, 13:13);
	s(ClkRstControllerPllmMisc2Override, 5:5, scratch7, 14:14);
	s(ClkRstControllerPllmMisc2Override, 4:4, scratch7, 15:15);
	s(ClkRstControllerPllmMisc2Override, 3:3, scratch7, 16:16);
	s(ClkRstControllerPllmMisc2Override, 0:0, scratch7, 17:17);
	s(EmcZqCalLpDdr4WarmBoot, 1:0, scratch7, 19:18);
	s(EmcZqCalLpDdr4WarmBoot, 4:4, scratch7, 20:20);
	s(EmcOdtWrite, 5:0, scratch7, 26:21);
	s(EmcOdtWrite, 11:8, scratch7, 30:27);
	s(EmcOdtWrite, 31:31, scratch7, 31:31);
	s(EmcFdpdCtrlCmdNoRamp, 0:0, scratch13, 30:30);
	s(EmcCfgPipeClk, 0:0, scratch13, 31:31);
	s(McEmemArbMisc2, 0:0, scratch14, 30:30);
	s(McDaCfg0, 0:0, scratch14, 31:31);
	s(EmcQRst, 6:0, scratch15, 26:20);
	s(EmcQRst, 20:16, scratch15, 31:27);
	s(EmcPmacroCmdTxDrv, 5:0, scratch16, 25:20);
	s(EmcPmacroCmdTxDrv, 13:8, scratch16, 31:26);
	s(EmcPmacroAutocalCfg0, 2:0, scratch17, 22:20);
	s(EmcPmacroAutocalCfg0, 10:8, scratch17, 25:23);
	s(EmcPmacroAutocalCfg0, 18:16, scratch17, 28:26);
	s(EmcPmacroAutocalCfg0, 26:24, scratch17, 31:29);
	s(EmcPmacroAutocalCfg1, 2:0, scratch18, 22:20);
	s(EmcPmacroAutocalCfg1, 10:8, scratch18, 25:23);
	s(EmcPmacroAutocalCfg1, 18:16, scratch18, 28:26);
	s(EmcPmacroAutocalCfg1, 26:24, scratch18, 31:29);
	s(EmcPmacroAutocalCfg2, 2:0, scratch19, 22:20);
	s(EmcPmacroAutocalCfg2, 10:8, scratch19, 25:23);
	s(EmcPmacroAutocalCfg2, 18:16, scratch19, 28:26);
	s(EmcPmacroAutocalCfg2, 26:24, scratch19, 31:29);
	s32(EmcCfgRsv,scratch22);
	s32(EmcAutoCalConfig, scratch23);
	s32(EmcAutoCalVrefSel0, scratch24);
	s32(EmcPmacroBrickCtrlRfu1, scratch25);
	s32(EmcPmacroBrickCtrlRfu2, scratch26);
	s32(EmcPmcScratch1, scratch27);
	s32(EmcPmcScratch2, scratch28);
	s32(EmcPmcScratch3, scratch29);
	s32(McEmemArbDaTurns, scratch30);
	s(EmcFbioSpare, 31:24, scratch58, 7:0);
	s(EmcFbioSpare, 23:16, scratch58, 15:8);
	s(EmcFbioSpare, 15:8, scratch58, 23:16);
	s(EmcFbioSpare, 7:2, scratch58, 29:24);
	s(EmcFbioSpare, 0:0, scratch58, 30:30);
	s(EmcDllCfg0, 29:0, scratch59, 29:0);
	s(EmcPmacroDdllBypass, 11:0, scratch60, 11:0);
	s(EmcPmacroDdllBypass, 27:13, scratch60, 26:12);
	s(EmcPmacroDdllBypass, 31:29, scratch60, 29:27);
	s(McEmemArbMisc0, 14:0, scratch61, 14:0);
	s(McEmemArbMisc0, 30:16, scratch61, 29:15);
	s(EmcFdpdCtrlCmd, 16:0, scratch62, 16:0);
	s(EmcFdpdCtrlCmd, 31:20, scratch62, 28:17);
	s(EmcAutoCalConfig2, 27:0, scratch63, 27:0);
	s(EmcBurstRefreshNum, 3:0, scratch63, 31:28);
	s(EmcPmacroZctrl, 27:0, scratch64, 27:0);
	s(EmcTppd, 3:0, scratch64, 31:28);
	s(EmcCfgDigDll, 10:0, scratch65, 10:0);
	s(EmcCfgDigDll, 25:12, scratch65, 24:11);
	s(EmcCfgDigDll, 27:27, scratch65, 25:25);
	s(EmcCfgDigDll, 31:30, scratch65, 27:26);
	s(EmcR2r, 3:0, scratch65, 31:28);
	s(EmcFdpdCtrlDq, 16:0, scratch66, 16:0);
	s(EmcFdpdCtrlDq, 28:20, scratch66, 25:17);
	s(EmcFdpdCtrlDq, 31:30, scratch66, 27:26);
	s(EmcW2w, 3:0, scratch66, 31:28);
	s(EmcPmacroTxPwrd4, 13:0, scratch67, 13:0);
	s(EmcPmacroTxPwrd4, 29:16, scratch67, 27:14);
	s(EmcPmacroCommonPadTxCtrl, 3:0, scratch67, 31:28);
	s(EmcPmacroTxPwrd5, 13:0, scratch68, 13:0);
	s(EmcPmacroTxPwrd5, 29:16, scratch68, 27:14);
	s(EmcPmacroDdllPwrd0, 4:0, scratch69, 4:0);
	s(EmcPmacroDdllPwrd0, 12:6, scratch69, 11:5);
	s(EmcPmacroDdllPwrd0, 20:14, scratch69, 18:12);
	s(EmcPmacroDdllPwrd0, 28:22, scratch69, 25:19);
	s(EmcPmacroDdllPwrd0, 31:30, scratch69, 27:26);
	s(EmcCfg, 4:4, scratch69, 31:31);
	s(EmcPmacroDdllPwrd1, 4:0, scratch70, 4:0);
	s(EmcPmacroDdllPwrd1, 12:6, scratch70, 11:5);
	s(EmcPmacroDdllPwrd1, 20:14, scratch70, 18:12);
	s(EmcPmacroDdllPwrd1, 28:22, scratch70, 25:19);
	s(EmcPmacroDdllPwrd1, 31:30, scratch70, 27:26);
	s(EmcCfg, 5:5, scratch70, 31:31);
	s(EmcPmacroDdllPwrd2, 4:0, scratch71, 4:0);
	s(EmcPmacroDdllPwrd2, 12:6, scratch71, 11:5);
	s(EmcPmacroDdllPwrd2, 20:14, scratch71, 18:12);
	s(EmcPmacroDdllPwrd2, 28:22, scratch71, 25:19);
	s(EmcPmacroDdllPwrd2, 31:30, scratch71, 27:26);
	s(EmcFbioCfg5, 23:20, scratch71, 31:28);
	s(EmcPmacroIbVrefDq_0, 6:0, scratch72, 6:0);
	s(EmcPmacroIbVrefDq_0, 14:8, scratch72, 13:7);
	s(EmcPmacroIbVrefDq_0, 22:16, scratch72, 20:14);
	s(EmcPmacroIbVrefDq_0, 30:24, scratch72, 27:21);
	s(EmcFbioCfg5, 15:13, scratch72, 30:28);
	s(EmcCfg, 6:6, scratch72, 31:31);
	s(EmcPmacroIbVrefDq_1, 6:0, scratch73, 6:0);
	s(EmcPmacroIbVrefDq_1, 14:8, scratch73, 13:7);
	s(EmcPmacroIbVrefDq_1, 22:16, scratch73, 20:14);
	s(EmcPmacroIbVrefDq_1, 30:24, scratch73, 27:21);
	s(EmcCfg2, 5:3, scratch73, 30:28);
	s(EmcCfg, 7:7, scratch73, 31:31);
	s(EmcPmacroIbVrefDqs_0, 6:0, scratch74, 6:0);
	s(EmcPmacroIbVrefDqs_0, 14:8, scratch74, 13:7);
	s(EmcPmacroIbVrefDqs_0, 22:16, scratch74, 20:14);
	s(EmcPmacroIbVrefDqs_0, 30:24, scratch74, 27:21);
	s(EmcCfg, 17:16, scratch74, 29:28);
	s(EmcFbioCfg5, 1:0, scratch74, 31:30);
	s(EmcPmacroIbVrefDqs_1, 6:0, scratch75, 6:0);
	s(EmcPmacroIbVrefDqs_1, 14:8, scratch75, 13:7);
	s(EmcPmacroIbVrefDqs_1, 22:16, scratch75, 20:14);
	s(EmcPmacroIbVrefDqs_1, 30:24, scratch75, 27:21);
	s(EmcFbioCfg5, 3:2, scratch75, 29:28);
	s(EmcCfg2, 27:26, scratch75, 31:30);
	s(EmcPmacroDdllShortCmd_0, 6:0, scratch76, 6:0);
	s(EmcPmacroDdllShortCmd_0, 14:8, scratch76, 13:7);
	s(EmcPmacroDdllShortCmd_0, 22:16, scratch76, 20:14);
	s(EmcPmacroDdllShortCmd_0, 30:24, scratch76, 27:21);
	s(EmcPmacroCmdPadTxCtrl, 3:2, scratch76, 29:28);
	s(EmcPmacroCmdPadTxCtrl, 7:6, scratch76, 31:30);
	s(EmcPmacroDdllShortCmd_1, 6:0, scratch77, 6:0);
	s(EmcPmacroDdllShortCmd_1, 14:8, scratch77, 13:7);
	s(EmcPmacroDdllShortCmd_1, 22:16, scratch77, 20:14);
	s(EmcPmacroDdllShortCmd_1, 30:24, scratch77, 27:21);
	s(EmcPmacroCmdPadTxCtrl, 11:10, scratch77, 29:28);
	s(EmcPmacroCmdPadTxCtrl, 15:14, scratch77, 31:30);
	s(EmcAutoCalChannel, 5:0, scratch78, 5:0);
	s(EmcAutoCalChannel, 11:8, scratch78, 9:6);
	s(EmcAutoCalChannel, 27:16, scratch78, 21:10);
	s(EmcAutoCalChannel, 31:29, scratch78, 24:22);
	s(EmcConfigSampleDelay, 6:0, scratch78, 31:25);
	s(EmcPmacroRxTerm, 5:0, scratch79, 5:0);
	s(EmcPmacroRxTerm, 13:8, scratch79, 11:6);
	s(EmcPmacroRxTerm, 21:16, scratch79, 17:12);
	s(EmcPmacroRxTerm, 29:24, scratch79, 23:18);
	s(EmcRc, 7:0, scratch79, 31:24);
	s(EmcPmacroDqTxDrv, 5:0, scratch80, 5:0);
	s(EmcPmacroDqTxDrv, 13:8, scratch80, 11:6);
	s(EmcPmacroDqTxDrv, 21:16, scratch80, 17:12);
	s(EmcPmacroDqTxDrv, 29:24, scratch80, 23:18);
	s(EmcSelDpdCtrl, 5:2, scratch80, 27:24);
	s(EmcSelDpdCtrl, 8:8, scratch80, 28:28);
	s(EmcSelDpdCtrl, 18:16, scratch80, 31:29);
	s(EmcPmacroCaTxDrv, 5:0, scratch81, 5:0);
	s(EmcPmacroCaTxDrv, 13:8, scratch81, 11:6);
	s(EmcPmacroCaTxDrv, 21:16, scratch81, 17:12);
	s(EmcPmacroCaTxDrv, 29:24, scratch81, 23:18);
	s(EmcObdly, 5:0, scratch81, 29:24);
	s(EmcObdly, 29:28, scratch81, 31:30);
	s(EmcZcalInterval, 23:10, scratch82, 13:0);
	s(EmcZcalInterval, 9:0, scratch82, 23:14);
	s(EmcPmacroCmdRxTermMode, 1:0, scratch82, 25:24);
	s(EmcPmacroCmdRxTermMode, 5:4, scratch82, 27:26);
	s(EmcPmacroCmdRxTermMode, 9:8, scratch82, 29:28);
	s(EmcPmacroCmdRxTermMode, 13:12, scratch82, 31:30);
	s(EmcDataBrlshft0, 23:0, scratch83, 23:0);
	s(EmcPmacroDataRxTermMode, 1:0, scratch83, 25:24);
	s(EmcPmacroDataRxTermMode, 5:4, scratch83, 27:26);
	s(EmcPmacroDataRxTermMode, 9:8, scratch83, 29:28);
	s(EmcPmacroDataRxTermMode, 13:12, scratch83, 31:30);
	s(EmcDataBrlshft1, 23:0, scratch84, 23:0);
	s(McEmemArbTimingRc, 7:0, scratch84, 31:24);
	s(EmcDqsBrlshft0, 23:0, scratch85, 23:0);
	s(McEmemArbRsv, 7:0, scratch85, 31:24);
	s(EmcDqsBrlshft1, 23:0, scratch86, 23:0);
	s(EmcCfgPipe2, 11:0, scratch87, 11:0);
	s(EmcCfgPipe2, 27:16, scratch87, 23:12);
	s(EmcCfgPipe1, 11:0, scratch88, 11:0);
	s(EmcCfgPipe1, 27:16, scratch88, 23:12);
	s(EmcPmacroCmdCtrl0, 5:0, scratch89, 5:0);
	s(EmcPmacroCmdCtrl0, 13:8, scratch89, 11:6);
	s(EmcPmacroCmdCtrl0, 21:16, scratch89, 17:12);
	s(EmcPmacroCmdCtrl0, 29:24, scratch89, 23:18);
	s(EmcPmacroCmdCtrl1, 5:0, scratch90, 5:0);
	s(EmcPmacroCmdCtrl1, 13:8, scratch90, 11:6);
	s(EmcPmacroCmdCtrl1, 21:16, scratch90, 17:12);
	s(EmcPmacroCmdCtrl1, 29:24, scratch90, 23:18);
	s(EmcRas, 6:0, scratch90, 30:24);
	s(EmcCfg, 8:8, scratch90, 31:31);
	s(EmcPmacroVttgenCtrl2, 23:0, scratch91, 23:0);
	s(EmcW2p, 6:0, scratch91, 30:24);
	s(EmcCfg, 9:9, scratch91, 31:31);
	s(EmcPmacroCmdPadRxCtrl, 2:0, scratch92, 2:0);
	s(EmcPmacroCmdPadRxCtrl, 5:4, scratch92, 4:3);
	s(EmcPmacroCmdPadRxCtrl, 10:8, scratch92, 7:5);
	s(EmcPmacroCmdPadRxCtrl, 22:12, scratch92, 18:8);
	s(EmcPmacroCmdPadRxCtrl, 28:24, scratch92, 23:19);
	s(EmcQSafe, 6:0, scratch92, 30:24);
	s(EmcCfg, 18:18, scratch92, 31:31);
	s(EmcPmacroDataPadRxCtrl, 2:0, scratch93, 2:0);
	s(EmcPmacroDataPadRxCtrl, 5:4, scratch93, 4:3);
	s(EmcPmacroDataPadRxCtrl, 10:8, scratch93, 7:5);
	s(EmcPmacroDataPadRxCtrl, 22:12, scratch93, 18:8);
	s(EmcPmacroDataPadRxCtrl, 28:24, scratch93, 23:19);
	s(EmcRdv, 6:0, scratch93, 30:24);
	s(EmcCfg, 21:21, scratch93, 31:31);
	s(McEmemArbDaCovers, 23:0, scratch94, 23:0);
	s(EmcRw2Pden, 6:0, scratch94, 30:24);
	s(EmcCfg, 22:22, scratch94, 31:31);
	s(EmcPmacroCmdCtrl2, 5:0, scratch95, 5:0);
	s(EmcPmacroCmdCtrl2, 13:9, scratch95, 10:6);
	s(EmcPmacroCmdCtrl2, 21:16, scratch95, 16:11);
	s(EmcPmacroCmdCtrl2, 29:24, scratch95, 22:17);
	s(EmcRfcPb, 8:0, scratch95, 31:23);
	s(EmcPmacroQuseDdllRank0_0, 10:0, scratch96, 10:0);
	s(EmcPmacroQuseDdllRank0_0, 26:16, scratch96, 21:11);
	s(EmcCfgUpdate, 2:0, scratch96, 24:22);
	s(EmcCfgUpdate, 10:8, scratch96, 27:25);
	s(EmcCfgUpdate, 31:28, scratch96, 31:28);
	s(EmcPmacroQuseDdllRank0_1, 10:0, scratch97, 10:0);
	s(EmcPmacroQuseDdllRank0_1, 26:16, scratch97, 21:11);
	s(EmcRfc, 9:0, scratch97, 31:22);
	s(EmcPmacroQuseDdllRank0_2, 10:0, scratch98, 10:0);
	s(EmcPmacroQuseDdllRank0_2, 26:16, scratch98, 21:11);
	s(EmcTxsr, 9:0, scratch98, 31:22);
	s(EmcPmacroQuseDdllRank0_3, 10:0, scratch99, 10:0);
	s(EmcPmacroQuseDdllRank0_3, 26:16, scratch99, 21:11);
	s(EmcMc2EmcQ, 2:0, scratch99, 24:22);
	s(EmcMc2EmcQ, 10:8, scratch99, 27:25);
	s(EmcMc2EmcQ, 27:24, scratch99, 31:28);
	s(EmcPmacroQuseDdllRank0_4, 10:0, scratch100, 10:0);
	s(EmcPmacroQuseDdllRank0_4, 26:16, scratch100, 21:11);
	s(McEmemArbRing1Throttle, 4:0, scratch100, 26:22);
	s(McEmemArbRing1Throttle, 20:16, scratch100, 31:27);
	s(EmcPmacroQuseDdllRank0_5, 10:0, scratch101, 10:0);
	s(EmcPmacroQuseDdllRank0_5, 26:16, scratch101, 21:11);
	s(EmcPmacroQuseDdllRank1_0, 10:0, scratch102, 10:0);
	s(EmcPmacroQuseDdllRank1_0, 26:16, scratch102, 21:11);
	s(EmcAr2Pden, 8:0, scratch102, 30:22);
	s(EmcCfg, 23:23, scratch102, 31:31);
	s(EmcPmacroQuseDdllRank1_1, 10:0, scratch103, 10:0);
	s(EmcPmacroQuseDdllRank1_1, 26:16, scratch103, 21:11);
	s(EmcRfcSlr, 8:0, scratch103, 30:22);
	s(EmcCfg, 24:24, scratch103, 31:31);
	s(EmcPmacroQuseDdllRank1_2, 10:0, scratch104, 10:0);
	s(EmcPmacroQuseDdllRank1_2, 26:16, scratch104, 21:11);
	s(EmcIbdly, 6:0, scratch104, 28:22);
	s(EmcIbdly, 29:28, scratch104, 30:29);
	s(EmcCfg, 25:25, scratch104, 31:31);
	s(EmcPmacroQuseDdllRank1_3, 10:0, scratch105, 10:0);
	s(EmcPmacroQuseDdllRank1_3, 26:16, scratch105, 21:11);
	s(McEmemArbTimingRFCPB, 8:0, scratch105, 30:22);
	s(EmcCfg, 26:26, scratch105, 31:31);
	s(EmcPmacroQuseDdllRank1_4, 10:0, scratch106, 10:0);
	s(EmcPmacroQuseDdllRank1_4, 26:16, scratch106, 21:11);
	s(EmcTfaw, 6:0, scratch106, 28:22);
	s(EmcPmacroDataPadTxCtrl, 3:2, scratch106, 30:29);
	s(EmcCfg, 28:28, scratch106, 31:31);
	s(EmcPmacroQuseDdllRank1_5, 10:0, scratch107, 10:0);
	s(EmcPmacroQuseDdllRank1_5, 26:16, scratch107, 21:11);
	s(EmcTClkStable, 6:0, scratch107, 28:22);
	s(EmcPmacroDataPadTxCtrl, 7:6, scratch107, 30:29);
	s(EmcCfg, 29:29, scratch107, 31:31);
	s(EmcPmacroObDdllLongDqRank0_0, 10:0, scratch108, 10:0);
	s(EmcPmacroObDdllLongDqRank0_0, 26:16, scratch108, 21:11);
	s(EmcPdex2Mrr, 6:0, scratch108, 28:22);
	s(EmcPmacroDataPadTxCtrl, 11:10, scratch108, 30:29);
	s(EmcCfg, 30:30, scratch108, 31:31);
	s(EmcPmacroObDdllLongDqRank0_1, 10:0, scratch109, 10:0);
	s(EmcPmacroObDdllLongDqRank0_1, 26:16, scratch109, 21:11);
	s(EmcRdvMask, 6:0, scratch109, 28:22);
	s(EmcPmacroDataPadTxCtrl, 15:14, scratch109, 30:29);
	s(EmcCfg, 31:31, scratch109, 31:31);
	s(EmcPmacroObDdllLongDqRank0_2, 10:0, scratch110, 10:0);
	s(EmcPmacroObDdllLongDqRank0_2, 26:16, scratch110, 21:11);
	s(EmcRdvEarlyMask, 6:0, scratch110, 28:22);
	s(EmcFbioCfg5, 4:4, scratch110, 29:29);
	s(EmcFbioCfg5, 8:8, scratch110, 30:30);
	s(EmcFbioCfg5, 10:10, scratch110, 31:31);
	s(EmcPmacroObDdllLongDqRank0_3, 10:0, scratch111, 10:0);
	s(EmcPmacroObDdllLongDqRank0_3, 26:16, scratch111, 21:11);
	s(EmcRdvEarly, 6:0, scratch111, 28:22);
	s(EmcFbioCfg5, 12:12, scratch111, 29:29);
	s(EmcFbioCfg5, 25:24, scratch111, 31:30);
	s(EmcPmacroObDdllLongDqRank0_4, 10:0, scratch112, 10:0);
	s(EmcPmacroObDdllLongDqRank0_4, 26:16, scratch112, 21:11);
	s(EmcPmacroDdllShortCmd_2, 6:0, scratch112, 28:22);
	s(EmcFbioCfg5, 28:26, scratch112, 31:29);
	s(EmcPmacroObDdllLongDqRank0_5, 10:0, scratch113, 10:0);
	s(EmcPmacroObDdllLongDqRank0_5, 26:16, scratch113, 21:11);
	s(McEmemArbTimingRp, 6:0, scratch113, 28:22);
	s(EmcFbioCfg5, 31:30, scratch113, 30:29);
	s(EmcCfg2, 0:0, scratch113, 31:31);
	s(EmcPmacroObDdllLongDqRank1_0, 10:0, scratch114, 10:0);
	s(EmcPmacroObDdllLongDqRank1_0, 26:16, scratch114, 21:11);
	s(McEmemArbTimingRas, 6:0, scratch114, 28:22);
	s(EmcCfg2, 2:1, scratch114, 30:29);
	s(EmcCfg2, 7:7, scratch114, 31:31);
	s(EmcPmacroObDdllLongDqRank1_1, 10:0, scratch115, 10:0);
	s(EmcPmacroObDdllLongDqRank1_1, 26:16, scratch115, 21:11);
	s(McEmemArbTimingFaw, 6:0, scratch115, 28:22);
	s(EmcCfg2, 11:10, scratch115, 30:29);
	s(EmcCfg2, 14:14, scratch115, 31:31);
	s(EmcPmacroObDdllLongDqRank1_2, 10:0, scratch123, 10:0);
	s(EmcPmacroObDdllLongDqRank1_2, 26:16, scratch123, 21:11);
	s(McEmemArbTimingRap2Pre, 6:0, scratch123, 28:22);
	s(EmcCfg2, 16:15, scratch123, 30:29);
	s(EmcCfg2, 20:20, scratch123, 31:31);
	s(EmcPmacroObDdllLongDqRank1_3, 10:0, scratch124, 10:0);
	s(EmcPmacroObDdllLongDqRank1_3, 26:16, scratch124, 21:11);
	s(McEmemArbTimingWap2Pre, 6:0, scratch124, 28:22);
	s(EmcCfg2, 24:22, scratch124, 31:29);
	s(EmcPmacroObDdllLongDqRank1_4, 10:0, scratch125, 10:0);
	s(EmcPmacroObDdllLongDqRank1_4, 26:16, scratch125, 21:11);
	s(McEmemArbTimingR2W, 6:0, scratch125, 28:22);
	s(EmcCfg2, 25:25, scratch125, 29:29);
	s(EmcCfg2, 29:28, scratch125, 31:30);
	s(EmcPmacroObDdllLongDqRank1_5, 10:0, scratch126, 10:0);
	s(EmcPmacroObDdllLongDqRank1_5, 26:16, scratch126, 21:11);
	s(McEmemArbTimingW2R, 6:0, scratch126, 28:22);
	s(EmcCfg2, 31:30, scratch126, 30:29);
	s(EmcCfgPipe, 0:0, scratch126, 31:31);
	s(EmcPmacroObDdllLongDqsRank0_0, 10:0, scratch127, 10:0);
	s(EmcPmacroObDdllLongDqsRank0_0, 26:16, scratch127, 21:11);
	s(EmcRp, 5:0, scratch127, 27:22);
	s(EmcCfgPipe, 4:1, scratch127, 31:28);
	s(EmcPmacroObDdllLongDqsRank0_1, 10:0, scratch128, 10:0);
	s(EmcPmacroObDdllLongDqsRank0_1, 26:16, scratch128, 21:11);
	s(EmcR2w, 5:0, scratch128, 27:22);
	s(EmcCfgPipe, 8:5, scratch128, 31:28);
	s(EmcPmacroObDdllLongDqsRank0_2, 10:0, scratch129, 10:0);
	s(EmcPmacroObDdllLongDqsRank0_2, 26:16, scratch129, 21:11);
	s(EmcW2r, 5:0, scratch129, 27:22);
	s(EmcCfgPipe, 11:9, scratch129, 30:28);
	s(EmcCfgPipe, 16:16, scratch129, 31:31);
	s(EmcPmacroObDdllLongDqsRank0_3, 10:0, scratch130, 10:0);
	s(EmcPmacroObDdllLongDqsRank0_3, 26:16, scratch130, 21:11);
	s(EmcR2p, 5:0, scratch130, 27:22);
	s(EmcCfgPipe, 20:17, scratch130, 31:28);
	s(EmcPmacroObDdllLongDqsRank0_4, 10:0, scratch131, 10:0);
	s(EmcPmacroObDdllLongDqsRank0_4, 26:16, scratch131, 21:11);
	s(EmcCcdmw, 5:0, scratch131, 27:22);
	s(EmcCfgPipe, 24:21, scratch131, 31:28);
	s(EmcPmacroObDdllLongDqsRank0_5, 10:0, scratch132, 10:0);
	s(EmcPmacroObDdllLongDqsRank0_5, 26:16, scratch132, 21:11);
	s(EmcRdRcd, 5:0, scratch132, 27:22);
	s(EmcCfgPipe, 27:25, scratch132, 30:28);
	s(EmcPmacroTxPwrd0, 0:0, scratch132, 31:31);
	s(EmcPmacroObDdllLongDqsRank1_0, 10:0, scratch133, 10:0);
	s(EmcPmacroObDdllLongDqsRank1_0, 26:16, scratch133, 21:11);
	s(EmcWrRcd, 5:0, scratch133, 27:22);
	s(EmcPmacroTxPwrd0, 4:1, scratch133, 31:28);
	s(EmcPmacroObDdllLongDqsRank1_1, 10:0, scratch134, 10:0);
	s(EmcPmacroObDdllLongDqsRank1_1, 26:16, scratch134, 21:11);
	s(EmcWdv, 5:0, scratch134, 27:22);
	s(EmcPmacroTxPwrd0, 8:5, scratch134, 31:28);
	s(EmcPmacroObDdllLongDqsRank1_2, 10:0, scratch135, 10:0);
	s(EmcPmacroObDdllLongDqsRank1_2, 26:16, scratch135, 21:11);
	s(EmcQUse, 5:0, scratch135, 27:22);
	s(EmcPmacroTxPwrd0, 12:9, scratch135, 31:28);
	s(EmcPmacroObDdllLongDqsRank1_3, 10:0, scratch136, 10:0);
	s(EmcPmacroObDdllLongDqsRank1_3, 26:16, scratch136, 21:11);
	s(EmcPdEx2Wr, 5:0, scratch136, 27:22);
	s(EmcPmacroTxPwrd0, 13:13, scratch136, 28:28);
	s(EmcPmacroTxPwrd0, 18:16, scratch136, 31:29);
	s(EmcPmacroObDdllLongDqsRank1_4, 10:0, scratch137, 10:0);
	s(EmcPmacroObDdllLongDqsRank1_4, 26:16, scratch137, 21:11);
	s(EmcPdEx2Rd, 5:0, scratch137, 27:22);
	s(EmcPmacroTxPwrd0, 22:19, scratch137, 31:28);
	s(EmcPmacroObDdllLongDqsRank1_5, 10:0, scratch138, 10:0);
	s(EmcPmacroObDdllLongDqsRank1_5, 26:16, scratch138, 21:11);
	s(EmcPdex2Cke, 5:0, scratch138, 27:22);
	s(EmcPmacroTxPwrd0, 26:23, scratch138, 31:28);
	s(EmcPmacroIbDdllLongDqsRank0_0, 10:0, scratch139, 10:0);
	s(EmcPmacroIbDdllLongDqsRank0_0, 26:16, scratch139, 21:11);
	s(EmcPChg2Pden, 5:0, scratch139, 27:22);
	s(EmcPmacroTxPwrd0, 29:27, scratch139, 30:28);
	s(EmcPmacroTxPwrd1, 0:0, scratch139, 31:31);
	s(EmcPmacroIbDdllLongDqsRank0_1, 10:0, scratch140, 10:0);
	s(EmcPmacroIbDdllLongDqsRank0_1, 26:16, scratch140, 21:11);
	s(EmcAct2Pden, 5:0, scratch140, 27:22);
	s(EmcPmacroTxPwrd1, 4:1, scratch140, 31:28);
	s(EmcPmacroIbDdllLongDqsRank0_2, 10:0, scratch141, 10:0);
	s(EmcPmacroIbDdllLongDqsRank0_2, 26:16, scratch141, 21:11);
	s(EmcCke2Pden, 5:0, scratch141, 27:22);
	s(EmcPmacroTxPwrd1, 8:5, scratch141, 31:28);
	s(EmcPmacroIbDdllLongDqsRank0_3, 10:0, scratch142, 10:0);
	s(EmcPmacroIbDdllLongDqsRank0_3, 26:16, scratch142, 21:11);
	s(EmcTcke, 5:0, scratch142, 27:22);
	s(EmcPmacroTxPwrd1, 12:9, scratch142, 31:28);
	s(EmcPmacroIbDdllLongDqsRank1_0, 10:0, scratch143, 10:0);
	s(EmcPmacroIbDdllLongDqsRank1_0, 26:16, scratch143, 21:11);
	s(EmcTrpab, 5:0, scratch143, 27:22);
	s(EmcPmacroTxPwrd1, 13:13, scratch143, 28:28);
	s(EmcPmacroTxPwrd1, 18:16, scratch143, 31:29);
	s(EmcPmacroIbDdllLongDqsRank1_1, 10:0, scratch144, 10:0);
	s(EmcPmacroIbDdllLongDqsRank1_1, 26:16, scratch144, 21:11);
	s(EmcClkenOverride, 3:1, scratch144, 24:22);
	s(EmcClkenOverride, 8:6, scratch144, 27:25);
	s(EmcPmacroTxPwrd1, 22:19, scratch144, 31:28);
	s(EmcPmacroIbDdllLongDqsRank1_2, 10:0, scratch145, 10:0);
	s(EmcPmacroIbDdllLongDqsRank1_2, 26:16, scratch145, 21:11);
	s(EmcEInput, 5:0, scratch145, 27:22);
	s(EmcPmacroTxPwrd1, 26:23, scratch145, 31:28);
	s(EmcPmacroIbDdllLongDqsRank1_3, 10:0, scratch146, 10:0);
	s(EmcPmacroIbDdllLongDqsRank1_3, 26:16, scratch146, 21:11);
	s(EmcEInputDuration, 5:0, scratch146, 27:22);
	s(EmcPmacroTxPwrd1, 29:27, scratch146, 30:28);
	s(EmcPmacroTxPwrd2, 0:0, scratch146, 31:31);
	s(EmcPmacroDdllLongCmd_0, 10:0, scratch147, 10:0);
	s(EmcPmacroDdllLongCmd_0, 26:16, scratch147, 21:11);
	s(EmcPutermExtra, 5:0, scratch147, 27:22);
	s(EmcPmacroTxPwrd2, 4:1, scratch147, 31:28);
	s(EmcPmacroDdllLongCmd_1, 10:0, scratch148, 10:0);
	s(EmcPmacroDdllLongCmd_1, 26:16, scratch148, 21:11);
	s(EmcTckesr, 5:0, scratch148, 27:22);
	s(EmcPmacroTxPwrd2, 8:5, scratch148, 31:28);
	s(EmcPmacroDdllLongCmd_2, 10:0, scratch149, 10:0);
	s(EmcPmacroDdllLongCmd_2, 26:16, scratch149, 21:11);
	s(EmcTpd, 5:0, scratch149, 27:22);
	s(EmcPmacroTxPwrd2, 12:9, scratch149, 31:28);
	s(EmcPmacroDdllLongCmd_3, 10:0, scratch150, 10:0);
	s(EmcPmacroDdllLongCmd_3, 26:16, scratch150, 21:11);
	s(EmcWdvMask, 5:0, scratch150, 27:22);
	s(EmcPmacroTxPwrd2, 13:13, scratch150, 28:28);
	s(EmcPmacroTxPwrd2, 18:16, scratch150, 31:29);
	s(McEmemArbCfg, 8:0, scratch151, 8:0);
	s(McEmemArbCfg, 20:16, scratch151, 13:9);
	s(McEmemArbCfg, 31:24, scratch151, 21:14);
	s(EmcWdvChk, 5:0, scratch151, 27:22);
	s(EmcPmacroTxPwrd2, 22:19, scratch151, 31:28);
	s(McEmemArbMisc1, 12:0, scratch152, 12:0);
	s(McEmemArbMisc1, 25:21, scratch152, 17:13);
	s(McEmemArbMisc1, 31:28, scratch152, 21:18);
	s(EmcCmdBrlshft0, 5:0, scratch152, 27:22);
	s(EmcPmacroTxPwrd2, 26:23, scratch152, 31:28);
	s(EmcMrsWaitCnt2, 9:0, scratch153, 9:0);
	s(EmcMrsWaitCnt2, 26:16, scratch153, 20:10);
	s(EmcPmacroIbRxrt, 10:0, scratch153, 31:21);
	s(EmcMrsWaitCnt, 9:0, scratch154, 9:0);
	s(EmcMrsWaitCnt, 26:16, scratch154, 20:10);
	s(EmcPmacroDdllLongCmd_4, 10:0, scratch154, 31:21);
	s(EmcAutoCalInterval, 20:0, scratch155, 20:0);
	s(McEmemArbOutstandingReq, 8:0, scratch155, 29:21);
	s(McEmemArbOutstandingReq, 31:30, scratch155, 31:30);
	s(McEmemArbRefpbHpCtrl, 6:0, scratch156, 6:0);
	s(McEmemArbRefpbHpCtrl, 14:8, scratch156, 13:7);
	s(McEmemArbRefpbHpCtrl, 22:16, scratch156, 20:14);
	s(EmcCmdBrlshft1, 5:0, scratch156, 26:21);
	s(EmcRrd, 4:0, scratch156, 31:27);
	s(EmcQuseBrlshft0, 19:0, scratch157, 19:0);
	s(EmcFbioCfg8, 27:16, scratch157, 31:20);
	s(EmcQuseBrlshft1, 19:0, scratch158, 19:0);
	s(EmcTxsrDll, 11:0, scratch158, 31:20);
	s(EmcQuseBrlshft2, 19:0, scratch159, 19:0);
	s(EmcTxdsrvttgen, 11:0, scratch159, 31:20);
	s(EmcQuseBrlshft3, 19:0, scratch160, 19:0);
	s(EmcPmacroVttgenCtrl0, 3:0, scratch160, 23:20);
	s(EmcPmacroVttgenCtrl0, 11:8, scratch160, 27:24);
	s(EmcPmacroVttgenCtrl0, 19:16, scratch160, 31:28);
	s(EmcPmacroVttgenCtrl1, 19:0, scratch161, 19:0);
	s(EmcCmdBrlshft2, 5:0, scratch161, 25:20);
	s(EmcCmdBrlshft3, 5:0, scratch161, 31:26);
	s(EmcAutoCalConfig3, 5:0, scratch162, 5:0);
	s(EmcAutoCalConfig3, 13:8, scratch162, 11:6);
	s(EmcAutoCalConfig3, 18:16, scratch162, 14:12);
	s(EmcAutoCalConfig3, 22:20, scratch162, 17:15);
	s(EmcTRefBw, 13:0, scratch162, 31:18);
	s(EmcAutoCalConfig4, 5:0, scratch163, 5:0);
	s(EmcAutoCalConfig4, 13:8, scratch163, 11:6);
	s(EmcAutoCalConfig4, 18:16, scratch163, 14:12);
	s(EmcAutoCalConfig4, 22:20, scratch163, 17:15);
	s(EmcQpop, 6:0, scratch163, 24:18);
	s(EmcQpop, 22:16, scratch163, 31:25);
	s(EmcAutoCalConfig5, 5:0, scratch164, 5:0);
	s(EmcAutoCalConfig5, 13:8, scratch164, 11:6);
	s(EmcAutoCalConfig5, 18:16, scratch164, 14:12);
	s(EmcAutoCalConfig5, 22:20, scratch164, 17:15);
	s(EmcPmacroAutocalCfgCommon, 5:0, scratch164, 23:18);
	s(EmcPmacroAutocalCfgCommon, 13:8, scratch164, 29:24);
	s(EmcPmacroAutocalCfgCommon, 16:16, scratch164, 30:30);
	s(EmcPmacroTxPwrd2, 27:27, scratch164, 31:31);
	s(EmcAutoCalConfig6, 5:0, scratch165, 5:0);
	s(EmcAutoCalConfig6, 13:8, scratch165, 11:6);
	s(EmcAutoCalConfig6, 18:16, scratch165, 14:12);
	s(EmcAutoCalConfig6, 22:20, scratch165, 17:15);
	s(EmcWev, 5:0, scratch165, 23:18);
	s(EmcWsv, 5:0, scratch165, 29:24);
	s(EmcPmacroTxPwrd2, 29:28, scratch165, 31:30);
	s(EmcAutoCalConfig7, 5:0, scratch166, 5:0);
	s(EmcAutoCalConfig7, 13:8, scratch166, 11:6);
	s(EmcAutoCalConfig7, 18:16, scratch166, 14:12);
	s(EmcAutoCalConfig7, 22:20, scratch166, 17:15);
	s(EmcCfg3, 2:0, scratch166, 20:18);
	s(EmcCfg3, 6:4, scratch166, 23:21);
	s(EmcQuseWidth, 3:0, scratch166, 27:24);
	s(EmcQuseWidth, 29:28, scratch166, 29:28);
	s(EmcPmacroTxPwrd3, 1:0, scratch166, 31:30);
	s(EmcAutoCalConfig8, 5:0, scratch167, 5:0);
	s(EmcAutoCalConfig8, 13:8, scratch167, 11:6);
	s(EmcAutoCalConfig8, 18:16, scratch167, 14:12);
	s(EmcAutoCalConfig8, 22:20, scratch167, 17:15);
	s(EmcPmacroBgBiasCtrl0, 2:0, scratch167, 20:18);
	s(EmcPmacroBgBiasCtrl0, 6:4, scratch167, 23:21);
	s(McEmemArbTimingRcd, 5:0, scratch167, 29:24);
	s(EmcPmacroTxPwrd3, 3:2, scratch167, 31:30);
	s(EmcXm2CompPadCtrl2, 17:0, scratch168, 17:0);
	s(McEmemArbTimingCcdmw, 5:0, scratch168, 23:18);
	s(McEmemArbOverride, 27:27, scratch168, 24:24);
	s(McEmemArbOverride, 26:26, scratch168, 25:25);
	s(McEmemArbOverride, 16:16, scratch168, 26:26);
	s(McEmemArbOverride, 10:10, scratch168, 27:27);
	s(McEmemArbOverride, 4:4, scratch168, 28:28);
	s(McEmemArbOverride, 3:3, scratch168, 29:29);
	s(EmcPmacroTxPwrd3, 5:4, scratch168, 31:30);
	s(EmcXm2CompPadCtrl3, 17:0, scratch169, 17:0);
	s(EmcRext, 4:0, scratch169, 22:18);
	s(EmcTClkStop, 4:0, scratch169, 27:23);
	s(EmcPmacroTxPwrd3, 9:6, scratch169, 31:28);
	s(EmcZcalWaitCnt, 10:0, scratch170, 10:0);
	s(EmcZcalWaitCnt, 21:16, scratch170, 16:11);
	s(EmcZcalWaitCnt, 31:31, scratch170, 17:17);
	s(EmcWext, 4:0, scratch170, 22:18);
	s(EmcRefctrl2, 0:0, scratch170, 23:23);
	s(EmcRefctrl2, 26:24, scratch170, 26:24);
	s(EmcRefctrl2, 31:31, scratch170, 27:27);
	s(EmcPmacroTxPwrd3, 13:10, scratch170, 31:28);
	s(EmcZcalMrwCmd, 7:0, scratch171, 7:0);
	s(EmcZcalMrwCmd, 23:16, scratch171, 15:8);
	s(EmcZcalMrwCmd, 31:30, scratch171, 17:16);
	s(EmcWeDuration, 4:0, scratch171, 22:18);
	s(EmcWsDuration, 4:0, scratch171, 27:23);
	s(EmcPmacroTxPwrd3, 19:16, scratch171, 31:28);
	s(EmcSwizzleRank0Byte0, 2:0, scratch172, 2:0);
	s(EmcSwizzleRank0Byte0, 6:4, scratch172, 5:3);
	s(EmcSwizzleRank0Byte0, 10:8, scratch172, 8:6);
	s(EmcSwizzleRank0Byte0, 14:12, scratch172, 11:9);
	s(EmcSwizzleRank0Byte0, 18:16, scratch172, 14:12);
	s(EmcSwizzleRank0Byte0, 22:20, scratch172, 17:15);
	s(EmcPutermWidth, 31:31, scratch172, 18:18);
	s(EmcPutermWidth, 3:0, scratch172, 22:19);
	s(McEmemArbTimingRrd, 4:0, scratch172, 27:23);
	s(EmcPmacroTxPwrd3, 23:20, scratch172, 31:28);
	s(EmcSwizzleRank0Byte1, 2:0, scratch173, 2:0);
	s(EmcSwizzleRank0Byte1, 6:4, scratch173, 5:3);
	s(EmcSwizzleRank0Byte1, 10:8, scratch173, 8:6);
	s(EmcSwizzleRank0Byte1, 14:12, scratch173, 11:9);
	s(EmcSwizzleRank0Byte1, 18:16, scratch173, 14:12);
	s(EmcSwizzleRank0Byte1, 22:20, scratch173, 17:15);
	s(McEmemArbTimingR2R, 4:0, scratch173, 22:18);
	s(McEmemArbTimingW2W, 4:0, scratch173, 27:23);
	s(EmcPmacroTxPwrd3, 27:24, scratch173, 31:28);
	s(EmcSwizzleRank0Byte2, 2:0, scratch174, 2:0);
	s(EmcSwizzleRank0Byte2, 6:4, scratch174, 5:3);
	s(EmcSwizzleRank0Byte2, 10:8, scratch174, 8:6);
	s(EmcSwizzleRank0Byte2, 14:12, scratch174, 11:9);
	s(EmcSwizzleRank0Byte2, 18:16, scratch174, 14:12);
	s(EmcSwizzleRank0Byte2, 22:20, scratch174, 17:15);
	s(EmcPmacroTxPwrd3, 29:28, scratch174, 19:18);
	s(EmcPmacroTxSelClkSrc0, 11:0, scratch174, 31:20);
	s(EmcSwizzleRank0Byte3, 2:0, scratch175, 2:0);
	s(EmcSwizzleRank0Byte3, 6:4, scratch175, 5:3);
	s(EmcSwizzleRank0Byte3, 10:8, scratch175, 8:6);
	s(EmcSwizzleRank0Byte3, 14:12, scratch175, 11:9);
	s(EmcSwizzleRank0Byte3, 18:16, scratch175, 14:12);
	s(EmcSwizzleRank0Byte3, 22:20, scratch175, 17:15);
	s(EmcPmacroTxSelClkSrc0, 27:16, scratch175, 29:18);
	s(EmcPmacroTxSelClkSrc1, 1:0, scratch175, 31:30);
	s(EmcSwizzleRank1Byte0, 2:0, scratch176, 2:0);
	s(EmcSwizzleRank1Byte0, 6:4, scratch176, 5:3);
	s(EmcSwizzleRank1Byte0, 10:8, scratch176, 8:6);
	s(EmcSwizzleRank1Byte0, 14:12, scratch176, 11:9);
	s(EmcSwizzleRank1Byte0, 18:16, scratch176, 14:12);
	s(EmcSwizzleRank1Byte0, 22:20, scratch176, 17:15);
	s(EmcPmacroTxSelClkSrc1, 11:2, scratch176, 27:18);
	s(EmcPmacroTxSelClkSrc1, 19:16, scratch176, 31:28);
	s(EmcSwizzleRank1Byte1, 2:0, scratch177, 2:0);
	s(EmcSwizzleRank1Byte1, 6:4, scratch177, 5:3);
	s(EmcSwizzleRank1Byte1, 10:8, scratch177, 8:6);
	s(EmcSwizzleRank1Byte1, 14:12, scratch177, 11:9);
	s(EmcSwizzleRank1Byte1, 18:16, scratch177, 14:12);
	s(EmcSwizzleRank1Byte1, 22:20, scratch177, 17:15);
	s(EmcPmacroTxSelClkSrc1, 27:20, scratch177, 25:18);
	s(EmcPmacroTxSelClkSrc3, 5:0, scratch177, 31:26);
	s(EmcSwizzleRank1Byte2, 2:0, scratch178, 2:0);
	s(EmcSwizzleRank1Byte2, 6:4, scratch178, 5:3);
	s(EmcSwizzleRank1Byte2, 10:8, scratch178, 8:6);
	s(EmcSwizzleRank1Byte2, 14:12, scratch178, 11:9);
	s(EmcSwizzleRank1Byte2, 18:16, scratch178, 14:12);
	s(EmcSwizzleRank1Byte2, 22:20, scratch178, 17:15);
	s(EmcPmacroTxSelClkSrc3, 11:6, scratch178, 23:18);
	s(EmcPmacroTxSelClkSrc3, 23:16, scratch178, 31:24);
	s(EmcSwizzleRank1Byte3, 2:0, scratch179, 2:0);
	s(EmcSwizzleRank1Byte3, 6:4, scratch179, 5:3);
	s(EmcSwizzleRank1Byte3, 10:8, scratch179, 8:6);
	s(EmcSwizzleRank1Byte3, 14:12, scratch179, 11:9);
	s(EmcSwizzleRank1Byte3, 18:16, scratch179, 14:12);
	s(EmcSwizzleRank1Byte3, 22:20, scratch179, 17:15);
	s(EmcPmacroTxSelClkSrc3, 27:24, scratch179, 21:18);
	s(EmcPmacroTxSelClkSrc2, 9:0, scratch179, 31:22);
	s(EmcPmacroCmdBrickCtrlFdpd, 17:0, scratch180, 17:0);
	s(EmcPmacroTxSelClkSrc2, 11:10, scratch180, 19:18);
	s(EmcPmacroTxSelClkSrc2, 27:16, scratch180, 31:20);
	s(EmcPmacroDataBrickCtrlFdpd, 17:0, scratch181, 17:0);
	s(EmcPmacroTxSelClkSrc4, 11:0, scratch181, 29:18);
	s(EmcPmacroTxSelClkSrc4, 17:16, scratch181, 31:30);
	s(EmcFbioCfg7, 16:0, scratch182, 16:0);
	s(McEmemArbRefpbBankCtrl, 6:0, scratch182, 23:17);
	s(McEmemArbRefpbBankCtrl, 14:8, scratch182, 30:24);
	s(McEmemArbRefpbBankCtrl, 31:31, scratch182, 31:31);
	s(EmcDynSelfRefControl, 15:0, scratch183, 15:0);
	s(EmcDynSelfRefControl, 31:31, scratch183, 16:16);
	s(EmcPmacroTxSelClkSrc4, 27:18, scratch183, 26:17);
	s(EmcPmacroTxSelClkSrc5, 4:0, scratch183, 31:27);
	s(EmcDllCfg1, 16:0, scratch184, 16:0);
	s(EmcPmacroTxSelClkSrc5, 11:5, scratch184, 23:17);
	s(EmcPmacroTxSelClkSrc5, 23:16, scratch184, 31:24);
	s(EmcPmacroPadCfgCtrl, 1:0, scratch185, 1:0);
	s(EmcPmacroPadCfgCtrl, 6:5, scratch185, 3:2);
	s(EmcPmacroPadCfgCtrl, 11:9, scratch185, 6:4);
	s(EmcPmacroPadCfgCtrl, 13:13, scratch185, 7:7);
	s(EmcPmacroPadCfgCtrl, 17:16, scratch185, 9:8);
	s(EmcPmacroPadCfgCtrl, 21:20, scratch185, 11:10);
	s(EmcPmacroPadCfgCtrl, 25:24, scratch185, 13:12);
	s(EmcPmacroPadCfgCtrl, 30:28, scratch185, 16:14);
	s(EmcPmacroTxSelClkSrc5, 27:24, scratch185, 20:17);
	s(EmcPmacroCmdPadTxCtrl, 1:0, scratch185, 22:21);
	s(EmcPmacroCmdPadTxCtrl, 5:4, scratch185, 24:23);
	s(EmcPmacroCmdPadTxCtrl, 9:8, scratch185, 26:25);
	s(EmcPmacroCmdPadTxCtrl, 13:12, scratch185, 28:27);
	s(EmcPmacroCmdPadTxCtrl, 16:16, scratch185, 29:29);
	s(EmcPmacroCmdPadTxCtrl, 21:20, scratch185, 31:30);
	s(EmcRefresh, 15:0, scratch186, 15:0);
	s(EmcCmdQ, 4:0, scratch186, 20:16);
	s(EmcCmdQ, 10:8, scratch186, 23:21);
	s(EmcCmdQ, 14:12, scratch186, 26:24);
	s(EmcCmdQ, 28:24, scratch186, 31:27);
	s(EmcAcpdControl, 15:0, scratch187, 15:0);
	s(EmcAutoCalVrefSel1, 15:0, scratch187, 31:16);
	s(EmcXm2CompPadCtrl, 1:0, scratch188, 1:0);
	s(EmcXm2CompPadCtrl, 6:3, scratch188, 5:2);
	s(EmcXm2CompPadCtrl, 9:9, scratch188, 6:6);
	s(EmcXm2CompPadCtrl, 19:11, scratch188, 15:7);
	s(EmcCfgDigDllPeriod, 15:0, scratch188, 31:16);
	s(EmcCfgDigDll_1, 15:0, scratch189, 15:0);
	s(EmcPreRefreshReqCnt, 15:0, scratch189, 31:16);
	s(EmcPmacroCmdPadTxCtrl, 27:24, scratch190, 19:16);
	s(EmcPmacroDataPadTxCtrl, 1:0, scratch190, 21:20);
	s(EmcPmacroDataPadTxCtrl, 5:4, scratch190, 23:22);
	s(EmcPmacroDataPadTxCtrl, 9:8, scratch190, 25:24);
	s(EmcPmacroDataPadTxCtrl, 13:12, scratch190, 27:26);
	s(EmcPmacroDataPadTxCtrl, 16:16, scratch190, 28:28);
	s(EmcPmacroDataPadTxCtrl, 21:20, scratch190, 30:29);
	s(EmcPmacroDataPadTxCtrl, 24:24, scratch190, 31:31);
	s(EmcPmacroDataPadTxCtrl, 27:25, scratch191, 2:0);

	s(EmcPinGpio, 1:0, scratch8, 31:30);
	s(EmcPinGpioEn, 1:0, scratch9, 31:30);
	s(EmcDevSelect, 1:0, scratch10, 31:30);
	s(EmcZcalWarmColdBootEnables, 1:0, scratch11, 31:30);
	s(EmcCfgDigDllPeriodWarmBoot, 1:0, scratch12, 31:30);
	s32(EmcBctSpare13, scratch31);
	s32(EmcBctSpare12, scratch32);
	s32(EmcBctSpare7, scratch33);
	s32(EmcBctSpare6, scratch40);
	s32(EmcBctSpare5, scratch42);
	s32(EmcBctSpare4, scratch44);
	s32(EmcBctSpare3, scratch45);
	s32(EmcBctSpare2, scratch46);
	s32(EmcBctSpare1, scratch47);
	s32(EmcBctSpare0, scratch48);
	s32(EmcBctSpare9, scratch50);
	s32(EmcBctSpare8, scratch51);
	s32(BootRomPatchData, scratch56);
	s32(BootRomPatchControl, scratch57);
	s(McClkenOverrideAllWarmBoot, 0:0, scratch58, 31:31);
	s(EmcClkenOverrideAllWarmBoot, 0:0, scratch59, 30:30);
	s(EmcMrsWarmBootEnable, 0:0, scratch59, 31:31);
	s(ClearClk2Mc1, 0:0, scratch60, 30:30);
	s(EmcWarmBootExtraModeRegWriteEnable, 0:0, scratch60, 31:31);
	s(ClkRstControllerPllmMisc2OverrideEnable, 0:0, scratch61, 30:30);
	s(EmcDbgWriteMux, 0:0, scratch61, 31:31);
	s(EmcExtraRefreshNum, 2:0, scratch62, 31:29);
	s(PmcIoDpd3ReqWait, 2:0, scratch68, 30:28);
	s(AhbArbitrationXbarCtrlMemInitDone, 0:0, scratch68, 31:31);
	s(MemoryType, 2:0, scratch69, 30:28);
	s(PmcIoDpd4ReqWait, 2:0, scratch70, 30:28);
	s(EmcTimingControlWait, 7:0, scratch86, 31:24);
	s(EmcZcalWarmBootWait, 7:0, scratch87, 31:24);
	s(WarmBootWait, 7:0, scratch88, 31:24);
	s(EmcPinProgramWait, 7:0, scratch89, 31:24);
	s(EmcAutoCalWait, 9:0, scratch101, 31:22);
	s(SwizzleRankByteEncode, 15:0, scratch190, 15:0);

	switch (sdram->MemoryType)
	{
	case NvBootMemoryType_LpDdr2:
	case NvBootMemoryType_LpDdr4:
		s(EmcMrwLpddr2ZcalWarmBoot, 23:16, scratch5, 7:0);
		s(EmcMrwLpddr2ZcalWarmBoot, 7:0, scratch5, 15:8);
		s(EmcWarmBootMrwExtra, 23:16, scratch5, 23:16);
		s(EmcWarmBootMrwExtra, 7:0, scratch5, 31:24);
		s(EmcMrwLpddr2ZcalWarmBoot, 31:30, scratch6, 1:0);
		s(EmcWarmBootMrwExtra, 31:30, scratch6, 3:2);
		s(EmcMrwLpddr2ZcalWarmBoot, 27:26, scratch6, 5:4);
		s(EmcWarmBootMrwExtra, 27:26, scratch6, 7:6);
		s(EmcMrw6, 27:0, scratch8, 27:0);
		s(EmcMrw6, 31:30, scratch8, 29:28);
		s(EmcMrw8, 27:0, scratch9, 27:0);
		s(EmcMrw8, 31:30, scratch9, 29:28);
		s(EmcMrw9, 27:0, scratch10, 27:0);
		s(EmcMrw9, 31:30, scratch10, 29:28);
		s(EmcMrw10, 27:0, scratch11, 27:0);
		s(EmcMrw10, 31:30, scratch11, 29:28);
		s(EmcMrw12, 27:0, scratch12, 27:0);
		s(EmcMrw12, 31:30, scratch12, 29:28);
		s(EmcMrw13, 27:0, scratch13, 27:0);
		s(EmcMrw13, 31:30, scratch13, 29:28);
		s(EmcMrw14, 27:0, scratch14, 27:0);
		s(EmcMrw14, 31:30, scratch14, 29:28);
		s(EmcMrw1, 7:0, scratch15, 7:0);
		s(EmcMrw1, 23:16, scratch15, 15:8);
		s(EmcMrw1, 27:26, scratch15, 17:16);
		s(EmcMrw1, 31:30, scratch15, 19:18);
		s(EmcWarmBootMrwExtra, 7:0, scratch16, 7:0);
		s(EmcWarmBootMrwExtra, 23:16, scratch16, 15:8);
		s(EmcWarmBootMrwExtra, 27:26, scratch16, 17:16);
		s(EmcWarmBootMrwExtra, 31:30, scratch16, 19:18);
		s(EmcMrw2, 7:0, scratch17, 7:0);
		s(EmcMrw2, 23:16, scratch17, 15:8);
		s(EmcMrw2, 27:26, scratch17, 17:16);
		s(EmcMrw2, 31:30, scratch17, 19:18);
		s(EmcMrw3, 7:0, scratch18, 7:0);
		s(EmcMrw3, 23:16, scratch18, 15:8);
		s(EmcMrw3, 27:26, scratch18, 17:16);
		s(EmcMrw3, 31:30, scratch18, 19:18);
		s(EmcMrw4, 7:0, scratch19, 7:0);
		s(EmcMrw4, 23:16, scratch19, 15:8);
		s(EmcMrw4, 27:26, scratch19, 17:16);
		s(EmcMrw4, 31:30, scratch19, 19:18);
		break;
	case NvBootMemoryType_Ddr3:
		s(EmcMrs, 13:0, scratch5, 13:0);
		s(EmcEmrs, 13:0, scratch5, 27:14);
		s(EmcMrs, 21:20, scratch5, 29:28);
		s(EmcMrs, 31:30, scratch5, 31:30);
		s(EmcEmrs2, 13:0, scratch8, 13:0);
		s(EmcEmrs3, 13:0, scratch8, 27:14);
		s(EmcEmrs, 21:20, scratch8, 29:28);
		s(EmcWarmBootMrsExtra, 13:0, scratch9, 13:0);
		s(EmcEmrs, 31:30, scratch9, 15:14);
		s(EmcEmrs2, 21:20, scratch9, 17:16);
		s(EmcEmrs2, 31:30, scratch9, 19:18);
		s(EmcEmrs3, 21:20, scratch9, 21:20);
		s(EmcEmrs3, 31:30, scratch9, 23:22);
		s(EmcWarmBootMrsExtra, 31:30, scratch9, 25:24);
		s(EmcWarmBootMrsExtra, 21:20, scratch9, 27:26);
		s(EmcZqCalDdr3WarmBoot, 31:30, scratch9, 29:28);
		s(EmcMrs, 27:26, scratch10, 1:0);
		s(EmcEmrs, 27:26, scratch10, 3:2);
		s(EmcEmrs2, 27:26, scratch10, 5:4);
		s(EmcEmrs3, 27:26, scratch10, 7:6);
		s(EmcWarmBootMrsExtra, 27:27, scratch10, 8:8);
		s(EmcWarmBootMrsExtra, 26:26, scratch10, 9:9);
		s(EmcZqCalDdr3WarmBoot, 0:0, scratch10, 10:10);
		s(EmcZqCalDdr3WarmBoot, 4:4, scratch10, 11:11);
		break;
	}

	s32(EmcCmdMappingByte, secure_scratch8);
	s32(EmcPmacroBrickMapping0, secure_scratch9);
	s32(EmcPmacroBrickMapping1, secure_scratch10);
	s32(EmcPmacroBrickMapping2, secure_scratch11);
	s32(McVideoProtectGpuOverride0, secure_scratch12);
	s(EmcCmdMappingCmd0_0, 6:0, secure_scratch13, 6:0);
	s(EmcCmdMappingCmd0_0, 14:8, secure_scratch13, 13:7);
	s(EmcCmdMappingCmd0_0, 22:16, secure_scratch13, 20:14);
	s(EmcCmdMappingCmd0_0, 30:24, secure_scratch13, 27:21);
	s(McVideoProtectBomAdrHi, 1:0, secure_scratch13, 29:28);
	s(McVideoProtectWriteAccess, 1:0, secure_scratch13, 31:30);
	s(EmcCmdMappingCmd0_1, 6:0, secure_scratch14, 6:0);
	s(EmcCmdMappingCmd0_1, 14:8, secure_scratch14, 13:7);
	s(EmcCmdMappingCmd0_1, 22:16, secure_scratch14, 20:14);
	s(EmcCmdMappingCmd0_1, 30:24, secure_scratch14, 27:21);
	s(McSecCarveoutAdrHi, 1:0, secure_scratch14, 29:28);
	s(McMtsCarveoutAdrHi, 1:0, secure_scratch14, 31:30);
	s(EmcCmdMappingCmd1_0, 6:0, secure_scratch15, 6:0);
	s(EmcCmdMappingCmd1_0, 14:8, secure_scratch15, 13:7);
	s(EmcCmdMappingCmd1_0, 22:16, secure_scratch15, 20:14);
	s(EmcCmdMappingCmd1_0, 30:24, secure_scratch15, 27:21);
	s(McGeneralizedCarveout5BomHi, 1:0, secure_scratch15, 29:28);
	s(McGeneralizedCarveout3BomHi, 1:0, secure_scratch15, 31:30);
	s(EmcCmdMappingCmd1_1, 6:0, secure_scratch16, 6:0);
	s(EmcCmdMappingCmd1_1, 14:8, secure_scratch16, 13:7);
	s(EmcCmdMappingCmd1_1, 22:16, secure_scratch16, 20:14);
	s(EmcCmdMappingCmd1_1, 30:24, secure_scratch16, 27:21);
	s(McGeneralizedCarveout2BomHi, 1:0, secure_scratch16, 29:28);
	s(McGeneralizedCarveout4BomHi, 1:0, secure_scratch16, 31:30);
	s(EmcCmdMappingCmd2_0, 6:0, secure_scratch17, 6:0);
	s(EmcCmdMappingCmd2_0, 14:8, secure_scratch17, 13:7);
	s(EmcCmdMappingCmd2_0, 22:16, secure_scratch17, 20:14);
	s(EmcCmdMappingCmd2_0, 30:24, secure_scratch17, 27:21);
	s(McGeneralizedCarveout1BomHi, 1:0, secure_scratch17, 29:28);
	s(EmcAdrCfg, 0:0, secure_scratch17, 30:30);
	s(EmcFbioSpare, 1:1, secure_scratch17, 31:31);
	s(EmcCmdMappingCmd2_1, 6:0, secure_scratch18, 6:0);
	s(EmcCmdMappingCmd2_1, 14:8, secure_scratch18, 13:7);
	s(EmcCmdMappingCmd2_1, 22:16, secure_scratch18, 20:14);
	s(EmcCmdMappingCmd2_1, 30:24, secure_scratch18, 27:21);
	s(EmcFbioCfg8, 15:15, secure_scratch18, 28:28);
	s(McEmemAdrCfg, 0:0, secure_scratch18, 29:29);
	s(McSecCarveoutProtectWriteAccess, 0:0, secure_scratch18, 30:30);
	s(McMtsCarveoutRegCtrl, 0:0, secure_scratch18, 31:31);
	s(EmcCmdMappingCmd3_0, 6:0, secure_scratch19, 6:0);
	s(EmcCmdMappingCmd3_0, 14:8, secure_scratch19, 13:7);
	s(EmcCmdMappingCmd3_0, 22:16, secure_scratch19, 20:14);
	s(EmcCmdMappingCmd3_0, 30:24, secure_scratch19, 27:21);
	s(McGeneralizedCarveout2Cfg0, 6:3, secure_scratch19, 31:28);
	s(EmcCmdMappingCmd3_1, 6:0, secure_scratch20, 6:0);
	s(EmcCmdMappingCmd3_1, 14:8, secure_scratch20, 13:7);
	s(EmcCmdMappingCmd3_1, 22:16, secure_scratch20, 20:14);
	s(EmcCmdMappingCmd3_1, 30:24, secure_scratch20, 27:21);
	s(McGeneralizedCarveout2Cfg0, 10:7, secure_scratch20, 31:28);
	s(McGeneralizedCarveout4Cfg0, 26:0, secure_scratch39, 26:0);
	s(McGeneralizedCarveout2Cfg0, 17:14, secure_scratch39, 30:27);
	s(McVideoProtectVprOverride, 0:0, secure_scratch39, 31:31);
	s(McGeneralizedCarveout5Cfg0, 26:0, secure_scratch40, 26:0);
	s(McGeneralizedCarveout2Cfg0, 21:18, secure_scratch40, 30:27);
	s(McVideoProtectVprOverride, 1:1, secure_scratch40, 31:31);
	s(EmcCmdMappingCmd0_2, 6:0, secure_scratch41, 6:0);
	s(EmcCmdMappingCmd0_2, 14:8, secure_scratch41, 13:7);
	s(EmcCmdMappingCmd0_2, 22:16, secure_scratch41, 20:14);
	s(EmcCmdMappingCmd0_2, 27:24, secure_scratch41, 24:21);
	s(McGeneralizedCarveout1Cfg0, 6:3, secure_scratch41, 28:25);
	s(McGeneralizedCarveout2Cfg0, 13:11, secure_scratch41, 31:29);
	s(EmcCmdMappingCmd1_2, 6:0, secure_scratch42, 6:0);
	s(EmcCmdMappingCmd1_2, 14:8, secure_scratch42, 13:7);
	s(EmcCmdMappingCmd1_2, 22:16, secure_scratch42, 20:14);
	s(EmcCmdMappingCmd1_2, 27:24, secure_scratch42, 24:21);
	s(McGeneralizedCarveout1Cfg0, 13:7, secure_scratch42, 31:25);
	s(EmcCmdMappingCmd2_2, 6:0, secure_scratch43, 6:0);
	s(EmcCmdMappingCmd2_2, 14:8, secure_scratch43, 13:7);
	s(EmcCmdMappingCmd2_2, 22:16, secure_scratch43, 20:14);
	s(EmcCmdMappingCmd2_2, 27:24, secure_scratch43, 24:21);
	s(McGeneralizedCarveout1Cfg0, 17:14, secure_scratch43, 28:25);
	s(McGeneralizedCarveout3Cfg0, 13:11, secure_scratch43, 31:29);
	s(EmcCmdMappingCmd3_2, 6:0, secure_scratch44, 6:0);
	s(EmcCmdMappingCmd3_2, 14:8, secure_scratch44, 13:7);
	s(EmcCmdMappingCmd3_2, 22:16, secure_scratch44, 20:14);
	s(EmcCmdMappingCmd3_2, 27:24, secure_scratch44, 24:21);
	s(McGeneralizedCarveout1Cfg0, 21:18, secure_scratch44, 28:25);
	s(McVideoProtectVprOverride, 3:2, secure_scratch44, 30:29);
	s(McVideoProtectVprOverride, 6:6, secure_scratch44, 31:31);
	s(McEmemAdrCfgChannelMask, 31:9, secure_scratch45, 22:0);
	s(McEmemAdrCfgDev0, 2:0, secure_scratch45, 25:23);
	s(McEmemAdrCfgDev0, 9:8, secure_scratch45, 27:26);
	s(McEmemAdrCfgDev0, 19:16, secure_scratch45, 31:28);
	s(McEmemAdrCfgBankMask0, 31:10, secure_scratch46, 21:0);
	s(McEmemAdrCfgDev1, 2:0, secure_scratch46, 24:22);
	s(McEmemAdrCfgDev1, 9:8, secure_scratch46, 26:25);
	s(McEmemAdrCfgDev1, 19:16, secure_scratch46, 30:27);
	s(McVideoProtectVprOverride, 7:7, secure_scratch46, 31:31);
	s(McEmemAdrCfgBankMask1, 31:10, secure_scratch47, 21:0);
	s(McGeneralizedCarveout3Cfg0, 10:3, secure_scratch47, 29:22);
	s(McVideoProtectVprOverride, 9:8, secure_scratch47, 31:30);
	s(McEmemAdrCfgBankMask2, 31:10, secure_scratch48, 21:0);
	s(McGeneralizedCarveout3Cfg0, 21:14, secure_scratch48, 29:22);
	s(McVideoProtectVprOverride, 11:11, secure_scratch48, 30:30);
	s(McVideoProtectVprOverride, 14:14, secure_scratch48, 31:31);
	s(McVideoProtectGpuOverride1, 15:0, secure_scratch49, 15:0);
	s(McEmemCfg, 13:0, secure_scratch49, 29:16);
	s(McEmemCfg, 31:31, secure_scratch49, 30:30);
	s(McVideoProtectVprOverride, 15:15, secure_scratch49, 31:31);
	s(McGeneralizedCarveout3Bom, 31:17, secure_scratch50, 14:0);
	s(McGeneralizedCarveout1Bom, 31:17, secure_scratch50, 29:15);
	s(McVideoProtectVprOverride, 18:17, secure_scratch50, 31:30);
	s(McGeneralizedCarveout4Bom, 31:17, secure_scratch51, 14:0);
	s(McGeneralizedCarveout2Bom, 31:17, secure_scratch51, 29:15);
	s(McVideoProtectVprOverride, 20:19, secure_scratch51, 31:30);
	s(McGeneralizedCarveout5Bom, 31:17, secure_scratch52, 14:0);
	s(McVideoProtectBom, 31:20, secure_scratch52, 26:15);
	s(McVideoProtectVprOverride, 23:21, secure_scratch52, 29:27);
	s(McVideoProtectVprOverride, 26:26, secure_scratch52, 30:30);
	s(McVideoProtectVprOverride, 29:29, secure_scratch52, 31:31);
	s(McVideoProtectSizeMb, 11:0, secure_scratch53, 11:0);
	s(McSecCarveoutBom, 31:20, secure_scratch53, 23:12);
	s(McVideoProtectVprOverride, 31:30, secure_scratch53, 25:24);
	s(McVideoProtectVprOverride1, 1:0, secure_scratch53, 27:26);
	s(McVideoProtectVprOverride1, 7:4, secure_scratch53, 31:28);
	s(McSecCarveoutSizeMb, 11:0, secure_scratch54, 11:0);
	s(McMtsCarveoutBom, 31:20, secure_scratch54, 23:12);
	s(McVideoProtectVprOverride1, 15:8, secure_scratch54, 31:24);
	s(McMtsCarveoutSizeMb, 11:0, secure_scratch55, 11:0);
	s(McGeneralizedCarveout4Size128kb, 11:0, secure_scratch55, 23:12);
	s(McVideoProtectVprOverride1, 16:16, secure_scratch55, 24:24);
	s(McGeneralizedCarveout2Cfg0, 2:0, secure_scratch55, 27:25);
	s(McGeneralizedCarveout2Cfg0, 25:22, secure_scratch55, 31:28);
	s(McGeneralizedCarveout3Size128kb, 11:0, secure_scratch56, 11:0);
	s(McGeneralizedCarveout2Size128kb, 11:0, secure_scratch56, 23:12);
	s(McGeneralizedCarveout2Cfg0, 26:26, secure_scratch56, 24:24);
	s(McGeneralizedCarveout1Cfg0, 2:0, secure_scratch56, 27:25);
	s(McGeneralizedCarveout1Cfg0, 25:22, secure_scratch56, 31:28);
	s(McGeneralizedCarveout1Size128kb, 11:0, secure_scratch57, 11:0);
	s(McGeneralizedCarveout5Size128kb, 11:0, secure_scratch57, 23:12);
	s(McGeneralizedCarveout1Cfg0, 26:26, secure_scratch57, 24:24);
	s(McGeneralizedCarveout3Cfg0, 2:0, secure_scratch57, 27:25);
	s(McGeneralizedCarveout3Cfg0, 25:22, secure_scratch57, 31:28);
	s(McGeneralizedCarveout3Cfg0, 26:26, secure_scratch58, 0:0);

	s32(McGeneralizedCarveout1Access0, secure_scratch59);
	s32(McGeneralizedCarveout1Access1, secure_scratch60);
	s32(McGeneralizedCarveout1Access2, secure_scratch61);
	s32(McGeneralizedCarveout1Access3, secure_scratch62);
	s32(McGeneralizedCarveout1Access4, secure_scratch63);
	s32(McGeneralizedCarveout2Access0, secure_scratch64);
	s32(McGeneralizedCarveout2Access1, secure_scratch65);
	s32(McGeneralizedCarveout2Access2, secure_scratch66);
	s32(McGeneralizedCarveout2Access3, secure_scratch67);
	s32(McGeneralizedCarveout2Access4, secure_scratch68);
	s32(McGeneralizedCarveout3Access0, secure_scratch69);
	s32(McGeneralizedCarveout3Access1, secure_scratch70);
	s32(McGeneralizedCarveout3Access2, secure_scratch71);
	s32(McGeneralizedCarveout3Access3, secure_scratch72);
	s32(McGeneralizedCarveout3Access4, secure_scratch73);
	s32(McGeneralizedCarveout4Access0, secure_scratch74);
	s32(McGeneralizedCarveout4Access1, secure_scratch75);
	s32(McGeneralizedCarveout4Access2, secure_scratch76);
	s32(McGeneralizedCarveout4Access3, secure_scratch77);
	s32(McGeneralizedCarveout4Access4, secure_scratch78);
	s32(McGeneralizedCarveout5Access0, secure_scratch79);
	s32(McGeneralizedCarveout5Access1, secure_scratch80);
	s32(McGeneralizedCarveout5Access2, secure_scratch81);
	s32(McGeneralizedCarveout5Access3, secure_scratch82);
	s32(McGeneralizedCarveout1ForceInternalAccess0, secure_scratch84);
	s32(McGeneralizedCarveout1ForceInternalAccess1, secure_scratch85);
	s32(McGeneralizedCarveout1ForceInternalAccess2, secure_scratch86);
	s32(McGeneralizedCarveout1ForceInternalAccess3, secure_scratch87);
	s32(McGeneralizedCarveout1ForceInternalAccess4, secure_scratch88);
	s32(McGeneralizedCarveout2ForceInternalAccess0, secure_scratch89);
	s32(McGeneralizedCarveout2ForceInternalAccess1, secure_scratch90);
	s32(McGeneralizedCarveout2ForceInternalAccess2, secure_scratch91);
	s32(McGeneralizedCarveout2ForceInternalAccess3, secure_scratch92);
	s32(McGeneralizedCarveout2ForceInternalAccess4, secure_scratch93);
	s32(McGeneralizedCarveout3ForceInternalAccess0, secure_scratch94);
	s32(McGeneralizedCarveout3ForceInternalAccess1, secure_scratch95);
	s32(McGeneralizedCarveout3ForceInternalAccess2, secure_scratch96);
	s32(McGeneralizedCarveout3ForceInternalAccess3, secure_scratch97);
	s32(McGeneralizedCarveout3ForceInternalAccess4, secure_scratch98);
	s32(McGeneralizedCarveout4ForceInternalAccess0, secure_scratch99);
	s32(McGeneralizedCarveout4ForceInternalAccess1, secure_scratch100);
	s32(McGeneralizedCarveout4ForceInternalAccess2, secure_scratch101);
	s32(McGeneralizedCarveout4ForceInternalAccess3, secure_scratch102);
	s32(McGeneralizedCarveout4ForceInternalAccess4, secure_scratch103);
	s32(McGeneralizedCarveout5ForceInternalAccess0, secure_scratch104);
	s32(McGeneralizedCarveout5ForceInternalAccess1, secure_scratch105);
	s32(McGeneralizedCarveout5ForceInternalAccess2, secure_scratch106);
	s32(McGeneralizedCarveout5ForceInternalAccess3, secure_scratch107);

	c32(0, scratch2);
	s(PllMInputDivider, 7:0, scratch2, 7:0);
	s(PllMFeedbackDivider, 7:0, scratch2, 15:8);
	s(PllMPostDivider, 4:0, scratch2, 20:16);
	s(PllMKVCO, 0:0, scratch2, 21:21);
	s(PllMKCP, 1:0, scratch2, 23:22);

	c32(0, scratch35);
	s(PllMSetupControl, 15:0, scratch35, 15:0);

	c32(0, scratch3);
	s(PllMInputDivider, 7:0, scratch3, 7:0);
	c(0x3e, scratch3, 15:8);
	c(0, scratch3, 20:16);
	s(PllMKVCO, 0:0, scratch3, 21:21);
	s(PllMKCP, 1:0, scratch3, 23:22);

	c32(0, scratch36);
	s(PllMSetupControl, 23:0, scratch36, 23:0);

	c32(0, scratch4);
	s(PllMStableTime, 9:0, scratch4, 9:0);
}

// #pragma GCC diagnostic ignored "-Wparentheses"

// static void _sdram_lp0_save_params_t210b01(const void *params)
// {
// 	struct sdram_params_t210b01 *sdram = (struct sdram_params_t210b01 *)params;
// 	struct tegra_pmc_regs *pmc = (struct tegra_pmc_regs *)PMC_BASE;

// 	u32 tmp = 0;

// 	sdram->mc_generalized_carveout1_cfg0 = 0;
// 	sdram->mc_generalized_carveout2_cfg0 = 0;
// 	sdram->mc_generalized_carveout3_cfg0 = 0;
// 	sdram->mc_generalized_carveout4_cfg0 = 0;
// 	sdram->mc_generalized_carveout5_cfg0 = 0;

// 	// Patch SDRAM parameters.
// 	u32 t0 = sdram->emc_swizzle_rank0_byte0 << 5 >> 29 > sdram->emc_swizzle_rank0_byte0 << 1 >> 29;
// 	u32 t1 = (t0 & 0xFFFFFFEF) | ((sdram->emc_swizzle_rank1_byte0 << 5 >> 29 > sdram->emc_swizzle_rank1_byte0 << 1 >> 29) << 4);
// 	u32 t2 = (t1 & 0xFFFFFFFD) | ((sdram->emc_swizzle_rank0_byte1 << 5 >> 29 > sdram->emc_swizzle_rank0_byte1 << 1 >> 29) << 1);
// 	u32 t3 = (t2 & 0xFFFFFFDF) | ((sdram->emc_swizzle_rank1_byte1 << 5 >> 29 > sdram->emc_swizzle_rank1_byte1 << 1 >> 29) << 5);
// 	u32 t4 = (t3 & 0xFFFFFFFB) | ((sdram->emc_swizzle_rank0_byte2 << 5 >> 29 > sdram->emc_swizzle_rank0_byte2 << 1 >> 29) << 2);
// 	u32 t5 = (t4 & 0xFFFFFFBF) | ((sdram->emc_swizzle_rank1_byte2 << 5 >> 29 > sdram->emc_swizzle_rank1_byte2 << 1 >> 29) << 6);
// 	u32 t6 = (t5 & 0xFFFFFFF7) | ((sdram->emc_swizzle_rank0_byte3 << 5 >> 29 > sdram->emc_swizzle_rank0_byte3 << 1 >> 29) << 3);
// 	u32 t7 = (t6 & 0xFFFFFF7F) | ((sdram->emc_swizzle_rank1_byte3 << 5 >> 29 > sdram->emc_swizzle_rank1_byte3 << 1 >> 29) << 7);
// 	sdram->swizzle_rank_byte_encode = t7;
// 	sdram->emc_bct_spare2 = 0x40000DD8;
// 	sdram->emc_bct_spare3 = t7;

// 	s(emc_clock_source, 7:0, scratch6, 15:8);
// 	s(emc_clock_source_dll, 7:0, scratch6, 23:16);
// 	s(emc_clock_source, 31:29, scratch6, 26:24);
// 	s(emc_clock_source_dll, 31:29, scratch6, 29:27);
// 	s(emc_clock_source_dll, 11:10, scratch6, 31:30);
// 	pmc->scratch7 = (sdram->emc_rc << 24) | ((sdram->emc_zqcal_lpddr4_warm_boot << 27 >> 31 << 23) | ((sdram->emc_zqcal_lpddr4_warm_boot << 30 >> 31 << 22) | ((sdram->emc_zqcal_lpddr4_warm_boot << 21) & 0x3FFFFF | ((sdram->clk_rst_pllm_misc20_override << 20) & 0x1FFFFF | ((sdram->clk_rst_pllm_misc20_override << 28 >> 31 << 19) | ((sdram->clk_rst_pllm_misc20_override << 27 >> 31 << 18) | ((sdram->clk_rst_pllm_misc20_override << 26 >> 31 << 17) | ((sdram->clk_rst_pllm_misc20_override << 21 >> 31 << 16) | ((sdram->clk_rst_pllm_misc20_override << 20 >> 31 << 15) | ((sdram->clk_rst_pllm_misc20_override << 19 >> 31 << 14) | ((sdram->clk_rst_pllm_misc20_override << 18 >> 31 << 13) | ((sdram->emc_clock_source << 15 >> 31 << 12) | ((sdram->emc_clock_source << 11 >> 31 << 11) | ((sdram->emc_clock_source << 12 >> 31 << 10) | ((sdram->emc_clock_source << 6 >> 31 << 9) | ((sdram->emc_clock_source << 16 >> 31 << 8) | ((32 * sdram->emc_clock_source >> 31 << 7) | ((16 * sdram->emc_clock_source >> 31 << 6) | (16 * (sdram->emc_zqcal_lpddr4_warm_boot >> 30) | (4 * (sdram->clk_rst_pllm_misc20_override << 29 >> 30) | ((sdram->clk_rst_pllm_misc20_override << 22 >> 30) | 4 * (pmc->scratch7 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFFFFFF;
// 	pmc->scratch8 = (sdram->emc_pmacro_bg_bias_ctrl0 << 18 >> 30 << 30) | ((4 * pmc->scratch8) >> 2);
// 	pmc->scratch14 = ((u8)(sdram->emc_cfg_pipe_clk) << 31) | (2 * (((u8)(sdram->emc_fdpd_ctrl_cmd_no_ramp) << 30) | pmc->scratch14 & 0xBFFFFFFF) >> 1);
// 	s(emc_qrst, 6:0, scratch15, 26:20);
// 	s(emc_qrst, 20:16, scratch15, 31:27);
// 	s(emc_pmacro_cmd_tx_drive, 5:0, scratch16, 25:20);
// 	s(emc_pmacro_cmd_tx_drive, 13:8, scratch16, 31:26);
// 	pmc->scratch17 = (16 * sdram->emc_fbio_cfg8 >> 31 << 31) | (2 * ((32 * sdram->emc_fbio_cfg8 >> 31 << 30) | ((sdram->emc_fbio_cfg8 << 6 >> 31 << 29) | ((sdram->emc_fbio_cfg8 << 7 >> 31 << 28) | ((sdram->emc_fbio_cfg8 << 8 >> 31 << 27) | ((sdram->emc_fbio_cfg8 << 9 >> 31 << 26) | ((sdram->emc_fbio_cfg8 << 10 >> 31 << 25) | ((sdram->emc_fbio_cfg8 << 11 >> 31 << 24) | ((sdram->emc_fbio_cfg8 << 12 >> 31 << 23) | ((sdram->emc_fbio_cfg8 << 13 >> 31 << 22) | ((sdram->emc_fbio_cfg8 << 14 >> 31 << 21) | ((sdram->emc_fbio_cfg8 << 15 >> 31 << 20) | pmc->scratch17 & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch18 = ((u16)(sdram->emc_txsr_dll) << 20) | pmc->scratch18 & 0xFFFFF;
// 	pmc->scratch19 = (sdram->emc_txdsrvttgen << 20) | pmc->scratch19 & 0xFFFFF;
// 	s32(emc_cfg_rsv, scratch22);
// 	s32(emc_auto_cal_config, scratch23);
// 	s32(emc_auto_cal_vref_sel0, scratch24);
// 	s32(emc_pmacro_brick_ctrl_rfu1, scratch25);
// 	s32(emc_pmacro_brick_ctrl_rfu2, scratch26);
// 	s32(emc_pmc_scratch1, scratch27);
// 	s32(emc_pmc_scratch2, scratch28);
// 	s32(emc_pmc_scratch3, scratch29);
// 	pmc->scratch30 = (sdram->emc_pmacro_perbit_rfu_ctrl0 >> 30 << 30) | (4 * ((4 * sdram->emc_pmacro_perbit_rfu_ctrl0 >> 30 << 28) | ((16 * sdram->emc_pmacro_perbit_rfu_ctrl0 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 6 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 8 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 10 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 12 >> 30 << 18) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 14 >> 30 << 16) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 16 >> 30 << 14) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 18 >> 30 << 12) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 20 >> 30 << 10) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 22 >> 30 << 8) | ((sdram->emc_pmacro_perbit_rfu_ctrl0 << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_perbit_rfu_ctrl0 << 26 >> 30) | (4 * (sdram->emc_pmacro_perbit_rfu_ctrl0 << 28 >> 30) | (sdram->emc_pmacro_perbit_rfu_ctrl0 & 3 | 4 * (pmc->scratch30 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch31 = (sdram->emc_pmacro_perbit_rfu_ctrl1 >> 30 << 30) | (4 * ((4 * sdram->emc_pmacro_perbit_rfu_ctrl1 >> 30 << 28) | ((16 * sdram->emc_pmacro_perbit_rfu_ctrl1 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 6 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 8 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 10 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 12 >> 30 << 18) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 14 >> 30 << 16) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 16 >> 30 << 14) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 18 >> 30 << 12) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 20 >> 30 << 10) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 22 >> 30 << 8) | ((sdram->emc_pmacro_perbit_rfu_ctrl1 << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_perbit_rfu_ctrl1 << 26 >> 30) | (4 * (sdram->emc_pmacro_perbit_rfu_ctrl1 << 28 >> 30) | (sdram->emc_pmacro_perbit_rfu_ctrl1 & 3 | 4 * (pmc->scratch31 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch32 = (sdram->emc_pmacro_perbit_rfu_ctrl2 >> 30 << 30) | (4 * ((4 * sdram->emc_pmacro_perbit_rfu_ctrl2 >> 30 << 28) | ((16 * sdram->emc_pmacro_perbit_rfu_ctrl2 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 6 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 8 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 10 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 12 >> 30 << 18) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 14 >> 30 << 16) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 16 >> 30 << 14) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 18 >> 30 << 12) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 20 >> 30 << 10) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 22 >> 30 << 8) | ((sdram->emc_pmacro_perbit_rfu_ctrl2 << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_perbit_rfu_ctrl2 << 26 >> 30) | (4 * (sdram->emc_pmacro_perbit_rfu_ctrl2 << 28 >> 30) | (sdram->emc_pmacro_perbit_rfu_ctrl2 & 3 | 4 * (pmc->scratch32 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch33 = (sdram->emc_pmacro_perbit_rfu_ctrl3 >> 30 << 30) | (4 * ((4 * sdram->emc_pmacro_perbit_rfu_ctrl3 >> 30 << 28) | ((16 * sdram->emc_pmacro_perbit_rfu_ctrl3 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 6 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 8 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 10 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 12 >> 30 << 18) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 14 >> 30 << 16) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 16 >> 30 << 14) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 18 >> 30 << 12) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 20 >> 30 << 10) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 22 >> 30 << 8) | ((sdram->emc_pmacro_perbit_rfu_ctrl3 << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_perbit_rfu_ctrl3 << 26 >> 30) | (4 * (sdram->emc_pmacro_perbit_rfu_ctrl3 << 28 >> 30) | (sdram->emc_pmacro_perbit_rfu_ctrl3 & 3 | 4 * (pmc->scratch33 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch40 = (sdram->emc_pmacro_perbit_rfu_ctrl4 >> 30 << 30) | (4 * ((4 * sdram->emc_pmacro_perbit_rfu_ctrl4 >> 30 << 28) | ((16 * sdram->emc_pmacro_perbit_rfu_ctrl4 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 6 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 8 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 10 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 12 >> 30 << 18) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 14 >> 30 << 16) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 16 >> 30 << 14) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 18 >> 30 << 12) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 20 >> 30 << 10) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 22 >> 30 << 8) | ((sdram->emc_pmacro_perbit_rfu_ctrl4 << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_perbit_rfu_ctrl4 << 26 >> 30) | (4 * (sdram->emc_pmacro_perbit_rfu_ctrl4 << 28 >> 30) | (sdram->emc_pmacro_perbit_rfu_ctrl4 & 3 | 4 * (pmc->scratch40 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch42 = (sdram->emc_pmacro_perbit_rfu_ctrl5 >> 30 << 30) | (4 * ((4 * sdram->emc_pmacro_perbit_rfu_ctrl5 >> 30 << 28) | ((16 * sdram->emc_pmacro_perbit_rfu_ctrl5 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 6 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 8 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 10 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 12 >> 30 << 18) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 14 >> 30 << 16) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 16 >> 30 << 14) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 18 >> 30 << 12) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 20 >> 30 << 10) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 22 >> 30 << 8) | ((sdram->emc_pmacro_perbit_rfu_ctrl5 << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_perbit_rfu_ctrl5 << 26 >> 30) | (4 * (sdram->emc_pmacro_perbit_rfu_ctrl5 << 28 >> 30) | (sdram->emc_pmacro_perbit_rfu_ctrl5 & 3 | 4 * (pmc->scratch42 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch44 = (sdram->mc_emem_arb_da_turns >> 24 << 24) | ((sdram->mc_emem_arb_da_turns >> 16 << 16) | ((sdram->mc_emem_arb_da_turns << 16 >> 24 << 8) | (sdram->mc_emem_arb_da_turns & 0xFF | (pmc->scratch44 >> 8 << 8)) & 0xFFFF00FF) & 0xFF00FFFF) & 0xFFFFFF;
// 	pmc->scratch64 = ((u16)(sdram->mc_emem_arb_misc2) << 31) | (2 * ((sdram->emc_fbio_spare << 30) | ((sdram->emc_fbio_spare << 24 >> 26 << 24) | ((sdram->emc_fbio_spare << 16 >> 24 << 16) | ((sdram->emc_fbio_spare << 8 >> 24 << 8) | ((sdram->emc_fbio_spare >> 24) | (pmc->scratch64 >> 8 << 8)) & 0xFFFF00FF) & 0xFF00FFFF) & 0xC0FFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch65 = ((u16)(sdram->mc_da_cfg0) << 31 >> 1) | ((2 * sdram->mc_emem_arb_misc0 >> 29 << 27) | ((16 * sdram->mc_emem_arb_misc0 >> 31 << 26) | ((32 * sdram->mc_emem_arb_misc0 >> 26 << 20) | ((sdram->mc_emem_arb_misc0 << 11 >> 27 << 15) | ((sdram->mc_emem_arb_misc0 << 17 >> 25 << 8) | ((u8)sdram->mc_emem_arb_misc0 | (pmc->scratch65 >> 8 << 8)) & 0xFFFF80FF) & 0xFFF07FFF) & 0xFC0FFFFF) & 0xFBFFFFFF) & 0xC7FFFFFF) & 0xBFFFFFFF;
// 	pmc->scratch66 = (sdram->emc_fdpd_ctrl_cmd >> 30 << 27) | ((4 * sdram->emc_fdpd_ctrl_cmd >> 31 << 26) | ((8 * sdram->emc_fdpd_ctrl_cmd >> 27 << 21) | ((sdram->emc_fdpd_ctrl_cmd << 8 >> 28 << 17) | ((sdram->emc_fdpd_ctrl_cmd << 15 >> 27 << 12) | ((sdram->emc_fdpd_ctrl_cmd << 20 >> 28 << 8) | ((u8)sdram->emc_fdpd_ctrl_cmd | (pmc->scratch66 >> 8 << 8)) & 0xFFFFF0FF) & 0xFFFE0FFF) & 0xFFE1FFFF) & 0xFC1FFFFF) & 0xFBFFFFFF) & 0xE7FFFFFF;
// 	pmc->scratch67 = ((u8)(sdram->emc_burst_refresh_num) << 28) | ((16 * sdram->emc_auto_cal_config2 >> 30 << 26) | ((sdram->emc_auto_cal_config2 << 6 >> 30 << 24) | ((sdram->emc_auto_cal_config2 << 8 >> 30 << 22) | ((sdram->emc_auto_cal_config2 << 10 >> 30 << 20) | ((sdram->emc_auto_cal_config2 << 12 >> 30 << 18) | ((sdram->emc_auto_cal_config2 << 14 >> 30 << 16) | ((sdram->emc_auto_cal_config2 << 16 >> 30 << 14) | ((sdram->emc_auto_cal_config2 << 18 >> 30 << 12) | ((sdram->emc_auto_cal_config2 << 20 >> 30 << 10) | ((sdram->emc_auto_cal_config2 << 22 >> 30 << 8) | ((sdram->emc_auto_cal_config2 << 24 >> 30 << 6) | (16 * (sdram->emc_auto_cal_config2 << 26 >> 30) | (4 * (sdram->emc_auto_cal_config2 << 28 >> 30) | (sdram->emc_auto_cal_config2 & 3 | 4 * (pmc->scratch67 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xFFFFFFF;
// 	pmc->scratch68 = ((u8)(sdram->emc_tppd) << 28) | ((sdram->emc_cfg_dig_dll >> 31 << 27) | ((2 * sdram->emc_cfg_dig_dll >> 31 << 26) | ((16 * sdram->emc_cfg_dig_dll >> 31 << 25) | ((sdram->emc_cfg_dig_dll << 6 >> 22 << 15) | ((sdram->emc_cfg_dig_dll << 16 >> 31 << 14) | ((sdram->emc_cfg_dig_dll << 17 >> 31 << 13) | ((sdram->emc_cfg_dig_dll << 18 >> 30 << 11) | ((sdram->emc_cfg_dig_dll << 21 >> 29 << 8) | ((sdram->emc_cfg_dig_dll << 24 >> 30 << 6) | (32 * (sdram->emc_cfg_dig_dll << 26 >> 31) | (16 * (sdram->emc_cfg_dig_dll << 27 >> 31) | (8 * (sdram->emc_cfg_dig_dll << 28 >> 31) | (4 * (sdram->emc_cfg_dig_dll << 29 >> 31) | (2 * (sdram->emc_cfg_dig_dll << 30 >> 31) | (sdram->emc_cfg_dig_dll & 1 | 2 * (pmc->scratch68 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFF3F) & 0xFFFFF8FF) & 0xFFFFE7FF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFE007FFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xFFFFFFF;
// 	pmc->scratch69 = (sdram->emc_r2r << 28) | ((sdram->emc_fdpd_ctrl_dq >> 30 << 26) | ((8 * sdram->emc_fdpd_ctrl_dq >> 27 << 21) | ((sdram->emc_fdpd_ctrl_dq << 8 >> 28 << 17) | ((sdram->emc_fdpd_ctrl_dq << 15 >> 27 << 12) | ((sdram->emc_fdpd_ctrl_dq << 20 >> 28 << 8) | ((u8)sdram->emc_fdpd_ctrl_dq | (pmc->scratch69 >> 8 << 8)) & 0xFFFFF0FF) & 0xFFFE0FFF) & 0xFFE1FFFF) & 0xFC1FFFFF) & 0xF3FFFFFF) & 0xFFFFFFF;
// 	pmc->scratch70 = (sdram->emc_w2w << 28) | ((2 * sdram->emc_pmacro_ib_vref_dq_0 >> 25 << 21) | ((sdram->emc_pmacro_ib_vref_dq_0 << 9 >> 25 << 14) | ((sdram->emc_pmacro_ib_vref_dq_0 << 17 >> 25 << 7) | (sdram->emc_pmacro_ib_vref_dq_0 & 0x7F | (pmc->scratch70 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xFFFFFFF;
// 	pmc->scratch71 = (sdram->emc_pmacro_vttgen_ctrl0 << 12 >> 28 << 28) | ((2 * sdram->emc_pmacro_ib_vref_dq_1 >> 25 << 21) | ((sdram->emc_pmacro_ib_vref_dq_1 << 9 >> 25 << 14) | ((sdram->emc_pmacro_ib_vref_dq_1 << 17 >> 25 << 7) | ((pmc->scratch71 >> 7 << 7) | sdram->emc_pmacro_ib_vref_dq_1 & 0x7F) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xFFFFFFF;
// 	pmc->scratch72 = (((sdram->emc_pmacro_ib_vref_dqs_0 << 17 >> 25 << 7) | ((pmc->scratch72 >> 7 << 7) | sdram->emc_pmacro_ib_vref_dqs_0 & 0x7F) & 0xFFFFC07F) & 0xFFE03FFF | (sdram->emc_pmacro_ib_vref_dqs_0 << 9 >> 25 << 14)) & 0xF01FFFFF | (2 * sdram->emc_pmacro_ib_vref_dqs_0 >> 25 << 21);
// 	pmc->scratch73 = (2 * sdram->emc_pmacro_ib_vref_dqs_1 >> 25 << 21) | ((sdram->emc_pmacro_ib_vref_dqs_1 << 9 >> 25 << 14) | ((sdram->emc_pmacro_ib_vref_dqs_1 << 17 >> 25 << 7) | ((pmc->scratch73 >> 7 << 7) | sdram->emc_pmacro_ib_vref_dqs_1 & 0x7F) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF;
// 	pmc->scratch74 = (2 * sdram->emc_pmacro_ddll_short_cmd_0 >> 25 << 21) | ((sdram->emc_pmacro_ddll_short_cmd_0 << 9 >> 25 << 14) | ((sdram->emc_pmacro_ddll_short_cmd_0 << 17 >> 25 << 7) | (sdram->emc_pmacro_ddll_short_cmd_0 & 0x7F | (pmc->scratch74 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF;
// 	pmc->scratch75 = (2 * sdram->emc_pmacro_ddll_short_cmd_1 >> 25 << 21) | ((sdram->emc_pmacro_ddll_short_cmd_1 << 9 >> 25 << 14) | ((sdram->emc_pmacro_ddll_short_cmd_1 << 17 >> 25 << 7) | (sdram->emc_pmacro_ddll_short_cmd_1 & 0x7F | (pmc->scratch75 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF;
// 	pmc->scratch76 = (sdram->emc_rp << 26) | ((4 * sdram->emc_dll_cfg0 >> 31 << 25) | ((8 * sdram->emc_dll_cfg0 >> 31 << 24) | ((16 * sdram->emc_dll_cfg0 >> 28 << 20) | ((sdram->emc_dll_cfg0 << 8 >> 28 << 16) | ((sdram->emc_dll_cfg0 << 12 >> 28 << 12) | ((sdram->emc_dll_cfg0 << 16 >> 28 << 8) | ((sdram->emc_dll_cfg0 << 20 >> 24) | (pmc->scratch76 >> 8 << 8)) & 0xFFFFF0FF) & 0xFFFF0FFF) & 0xFFF0FFFF) & 0xFF0FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0x3FFFFFF;
// 	tmp = (sdram->emc_pmacro_tx_pwrd0 << 12 >> 31 << 16) | ((sdram->emc_pmacro_tx_pwrd0 << 13 >> 31 << 15) | ((sdram->emc_pmacro_tx_pwrd0 << 14 >> 31 << 14) | ((sdram->emc_pmacro_tx_pwrd0 << 15 >> 31 << 13) | ((sdram->emc_pmacro_tx_pwrd0 << 18 >> 31 << 12) | ((sdram->emc_pmacro_tx_pwrd0 << 19 >> 31 << 11) | ((sdram->emc_pmacro_tx_pwrd0 << 21 >> 31 << 10) | ((sdram->emc_pmacro_tx_pwrd0 << 22 >> 31 << 9) | ((sdram->emc_pmacro_tx_pwrd0 << 23 >> 31 << 8) | ((sdram->emc_pmacro_tx_pwrd0 << 24 >> 31 << 7) | ((sdram->emc_pmacro_tx_pwrd0 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_tx_pwrd0 << 26 >> 31) | (16 * (sdram->emc_pmacro_tx_pwrd0 << 27 >> 31) | (8 * (sdram->emc_pmacro_tx_pwrd0 << 28 >> 31) | (4 * (sdram->emc_pmacro_tx_pwrd0 << 29 >> 31) | (2 * (sdram->emc_pmacro_tx_pwrd0 << 30 >> 31) | (sdram->emc_pmacro_tx_pwrd0 & 1 | 2 * (pmc->scratch77 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF;
// 	pmc->scratch77 = (sdram->emc_r2w << 26) | ((4 * sdram->emc_pmacro_tx_pwrd0 >> 31 << 25) | ((8 * sdram->emc_pmacro_tx_pwrd0 >> 31 << 24) | ((32 * sdram->emc_pmacro_tx_pwrd0 >> 31 << 23) | ((sdram->emc_pmacro_tx_pwrd0 << 6 >> 31 << 22) | ((sdram->emc_pmacro_tx_pwrd0 << 7 >> 31 << 21) | ((sdram->emc_pmacro_tx_pwrd0 << 8 >> 31 << 20) | ((sdram->emc_pmacro_tx_pwrd0 << 9 >> 31 << 19) | ((sdram->emc_pmacro_tx_pwrd0 << 10 >> 31 << 18) | ((sdram->emc_pmacro_tx_pwrd0 << 11 >> 31 << 17) | tmp & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0x3FFFFFF;
// 	tmp = ((8 * sdram->emc_pmacro_tx_pwrd1 >> 31 << 24) | ((32 * sdram->emc_pmacro_tx_pwrd1 >> 31 << 23) | ((sdram->emc_pmacro_tx_pwrd1 << 6 >> 31 << 22) | ((sdram->emc_pmacro_tx_pwrd1 << 7 >> 31 << 21) | ((sdram->emc_pmacro_tx_pwrd1 << 8 >> 31 << 20) | ((sdram->emc_pmacro_tx_pwrd1 << 9 >> 31 << 19) | ((sdram->emc_pmacro_tx_pwrd1 << 10 >> 31 << 18) | ((sdram->emc_pmacro_tx_pwrd1 << 11 >> 31 << 17) | ((sdram->emc_pmacro_tx_pwrd1 << 12 >> 31 << 16) | ((sdram->emc_pmacro_tx_pwrd1 << 13 >> 31 << 15) | ((sdram->emc_pmacro_tx_pwrd1 << 14 >> 31 << 14) | ((sdram->emc_pmacro_tx_pwrd1 << 15 >> 31 << 13) | ((sdram->emc_pmacro_tx_pwrd1 << 18 >> 31 << 12) | ((sdram->emc_pmacro_tx_pwrd1 << 19 >> 31 << 11) | ((sdram->emc_pmacro_tx_pwrd1 << 21 >> 31 << 10) | ((sdram->emc_pmacro_tx_pwrd1 << 22 >> 31 << 9) | ((sdram->emc_pmacro_tx_pwrd1 << 23 >> 31 << 8) | ((sdram->emc_pmacro_tx_pwrd1 << 24 >> 31 << 7) | ((sdram->emc_pmacro_tx_pwrd1 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_tx_pwrd1 << 26 >> 31) | (16 * (sdram->emc_pmacro_tx_pwrd1 << 27 >> 31) | (8 * (sdram->emc_pmacro_tx_pwrd1 << 28 >> 31) | (4 * (sdram->emc_pmacro_tx_pwrd1 << 29 >> 31) | (2 * (sdram->emc_pmacro_tx_pwrd1 << 30 >> 31) | (sdram->emc_pmacro_tx_pwrd1 & 1 | 2 * (pmc->scratch78 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF;
// 	pmc->scratch78 = (sdram->emc_w2r << 26) | ((4 * sdram->emc_pmacro_tx_pwrd1 >> 31 << 25) | tmp) & 0x3FFFFFF;
// 	tmp = ((8 * sdram->emc_pmacro_tx_pwrd2 >> 31 << 24) | ((32 * sdram->emc_pmacro_tx_pwrd2 >> 31 << 23) | ((sdram->emc_pmacro_tx_pwrd2 << 6 >> 31 << 22) | ((sdram->emc_pmacro_tx_pwrd2 << 7 >> 31 << 21) | ((sdram->emc_pmacro_tx_pwrd2 << 8 >> 31 << 20) | ((sdram->emc_pmacro_tx_pwrd2 << 9 >> 31 << 19) | ((sdram->emc_pmacro_tx_pwrd2 << 10 >> 31 << 18) | ((sdram->emc_pmacro_tx_pwrd2 << 11 >> 31 << 17) | ((sdram->emc_pmacro_tx_pwrd2 << 12 >> 31 << 16) | ((sdram->emc_pmacro_tx_pwrd2 << 13 >> 31 << 15) | ((sdram->emc_pmacro_tx_pwrd2 << 14 >> 31 << 14) | ((sdram->emc_pmacro_tx_pwrd2 << 15 >> 31 << 13) | ((sdram->emc_pmacro_tx_pwrd2 << 18 >> 31 << 12) | ((sdram->emc_pmacro_tx_pwrd2 << 19 >> 31 << 11) | ((sdram->emc_pmacro_tx_pwrd2 << 21 >> 31 << 10) | ((sdram->emc_pmacro_tx_pwrd2 << 22 >> 31 << 9) | ((sdram->emc_pmacro_tx_pwrd2 << 23 >> 31 << 8) | ((sdram->emc_pmacro_tx_pwrd2 << 24 >> 31 << 7) | ((sdram->emc_pmacro_tx_pwrd2 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_tx_pwrd2 << 26 >> 31) | (16 * (sdram->emc_pmacro_tx_pwrd2 << 27 >> 31) | (8 * (sdram->emc_pmacro_tx_pwrd2 << 28 >> 31) | (4 * (sdram->emc_pmacro_tx_pwrd2 << 29 >> 31) | (2 * (sdram->emc_pmacro_tx_pwrd2 << 30 >> 31) | (sdram->emc_pmacro_tx_pwrd2 & 1 | 2 * (pmc->scratch79 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF;
// 	pmc->scratch79 = (sdram->emc_r2p << 26) | ((4 * sdram->emc_pmacro_tx_pwrd2 >> 31 << 25) | tmp) & 0x3FFFFFF;
// 	tmp = (sdram->emc_pmacro_tx_pwrd3 << 23 >> 31 << 8) | ((sdram->emc_pmacro_tx_pwrd3 << 24 >> 31 << 7) | ((sdram->emc_pmacro_tx_pwrd3 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_tx_pwrd3 << 26 >> 31) | (16 * (sdram->emc_pmacro_tx_pwrd3 << 27 >> 31) | (8 * (sdram->emc_pmacro_tx_pwrd3 << 28 >> 31) | (4 * (sdram->emc_pmacro_tx_pwrd3 << 29 >> 31) | (2 * (sdram->emc_pmacro_tx_pwrd3 << 30 >> 31) | (sdram->emc_pmacro_tx_pwrd3 & 1 | 2 * (pmc->scratch80 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF;
// 	pmc->scratch80 = ((u8)(sdram->emc_ccdmw) << 26) | ((4 * sdram->emc_pmacro_tx_pwrd3 >> 31 << 25) | ((8 * sdram->emc_pmacro_tx_pwrd3 >> 31 << 24) | ((32 * sdram->emc_pmacro_tx_pwrd3 >> 31 << 23) | ((sdram->emc_pmacro_tx_pwrd3 << 6 >> 31 << 22) | ((sdram->emc_pmacro_tx_pwrd3 << 7 >> 31 << 21) | ((sdram->emc_pmacro_tx_pwrd3 << 8 >> 31 << 20) | ((sdram->emc_pmacro_tx_pwrd3 << 9 >> 31 << 19) | ((sdram->emc_pmacro_tx_pwrd3 << 10 >> 31 << 18) | ((sdram->emc_pmacro_tx_pwrd3 << 11 >> 31 << 17) | ((sdram->emc_pmacro_tx_pwrd3 << 12 >> 31 << 16) | ((sdram->emc_pmacro_tx_pwrd3 << 13 >> 31 << 15) | ((sdram->emc_pmacro_tx_pwrd3 << 14 >> 31 << 14) | ((sdram->emc_pmacro_tx_pwrd3 << 15 >> 31 << 13) | ((sdram->emc_pmacro_tx_pwrd3 << 18 >> 31 << 12) | ((sdram->emc_pmacro_tx_pwrd3 << 19 >> 31 << 11) | ((sdram->emc_pmacro_tx_pwrd3 << 21 >> 31 << 10) | ((sdram->emc_pmacro_tx_pwrd3 << 22 >> 31 << 9) | tmp & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0x3FFFFFF;
// 	tmp = ((8 * sdram->emc_pmacro_tx_pwrd4 >> 31 << 24) | ((32 * sdram->emc_pmacro_tx_pwrd4 >> 31 << 23) | ((sdram->emc_pmacro_tx_pwrd4 << 6 >> 31 << 22) | ((sdram->emc_pmacro_tx_pwrd4 << 7 >> 31 << 21) | ((sdram->emc_pmacro_tx_pwrd4 << 8 >> 31 << 20) | ((sdram->emc_pmacro_tx_pwrd4 << 9 >> 31 << 19) | ((sdram->emc_pmacro_tx_pwrd4 << 10 >> 31 << 18) | ((sdram->emc_pmacro_tx_pwrd4 << 11 >> 31 << 17) | ((sdram->emc_pmacro_tx_pwrd4 << 12 >> 31 << 16) | ((sdram->emc_pmacro_tx_pwrd4 << 13 >> 31 << 15) | ((sdram->emc_pmacro_tx_pwrd4 << 14 >> 31 << 14) | ((sdram->emc_pmacro_tx_pwrd4 << 15 >> 31 << 13) | ((sdram->emc_pmacro_tx_pwrd4 << 18 >> 31 << 12) | ((sdram->emc_pmacro_tx_pwrd4 << 19 >> 31 << 11) | ((sdram->emc_pmacro_tx_pwrd4 << 21 >> 31 << 10) | ((sdram->emc_pmacro_tx_pwrd4 << 22 >> 31 << 9) | ((sdram->emc_pmacro_tx_pwrd4 << 23 >> 31 << 8) | ((sdram->emc_pmacro_tx_pwrd4 << 24 >> 31 << 7) | ((sdram->emc_pmacro_tx_pwrd4 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_tx_pwrd4 << 26 >> 31) | (16 * (sdram->emc_pmacro_tx_pwrd4 << 27 >> 31) | (8 * (sdram->emc_pmacro_tx_pwrd4 << 28 >> 31) | (4 * (sdram->emc_pmacro_tx_pwrd4 << 29 >> 31) | (2 * (sdram->emc_pmacro_tx_pwrd4 << 30 >> 31) | (sdram->emc_pmacro_tx_pwrd4 & 1 | 2 * (pmc->scratch81 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF;
// 	pmc->scratch81 = ((u8)(sdram->emc_rd_rcd) << 26) | ((4 * sdram->emc_pmacro_tx_pwrd4 >> 31 << 25) | tmp) & 0x3FFFFFF;
// 	tmp = ((8 * sdram->emc_pmacro_tx_pwrd5 >> 31 << 24) | ((32 * sdram->emc_pmacro_tx_pwrd5 >> 31 << 23) | ((sdram->emc_pmacro_tx_pwrd5 << 6 >> 31 << 22) | ((sdram->emc_pmacro_tx_pwrd5 << 7 >> 31 << 21) | ((sdram->emc_pmacro_tx_pwrd5 << 8 >> 31 << 20) | ((sdram->emc_pmacro_tx_pwrd5 << 9 >> 31 << 19) | ((sdram->emc_pmacro_tx_pwrd5 << 10 >> 31 << 18) | ((sdram->emc_pmacro_tx_pwrd5 << 11 >> 31 << 17) | ((sdram->emc_pmacro_tx_pwrd5 << 12 >> 31 << 16) | ((sdram->emc_pmacro_tx_pwrd5 << 13 >> 31 << 15) | ((sdram->emc_pmacro_tx_pwrd5 << 14 >> 31 << 14) | ((sdram->emc_pmacro_tx_pwrd5 << 15 >> 31 << 13) | ((sdram->emc_pmacro_tx_pwrd5 << 18 >> 31 << 12) | ((sdram->emc_pmacro_tx_pwrd5 << 19 >> 31 << 11) | ((sdram->emc_pmacro_tx_pwrd5 << 21 >> 31 << 10) | ((sdram->emc_pmacro_tx_pwrd5 << 22 >> 31 << 9) | ((sdram->emc_pmacro_tx_pwrd5 << 23 >> 31 << 8) | ((sdram->emc_pmacro_tx_pwrd5 << 24 >> 31 << 7) | ((sdram->emc_pmacro_tx_pwrd5 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_tx_pwrd5 << 26 >> 31) | (16 * (sdram->emc_pmacro_tx_pwrd5 << 27 >> 31) | (8 * (sdram->emc_pmacro_tx_pwrd5 << 28 >> 31) | (4 * (sdram->emc_pmacro_tx_pwrd5 << 29 >> 31) | (2 * (sdram->emc_pmacro_tx_pwrd5 << 30 >> 31) | (sdram->emc_pmacro_tx_pwrd5 & 1 | 2 * (pmc->scratch82 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF;
// 	pmc->scratch82 = ((u16)(sdram->emc_wr_rcd) << 26) | ((4 * sdram->emc_pmacro_tx_pwrd5 >> 31 << 25) | tmp) & 0x3FFFFFF;
// 	pmc->scratch83 = ((u8)(sdram->emc_config_sample_delay) << 25) | ((sdram->emc_auto_cal_channel >> 31 << 24) | ((2 * sdram->emc_auto_cal_channel >> 31 << 23) | ((4 * sdram->emc_auto_cal_channel >> 31 << 22) | ((16 * sdram->emc_auto_cal_channel >> 25 << 15) | ((sdram->emc_auto_cal_channel << 11 >> 27 << 10) | ((sdram->emc_auto_cal_channel << 20 >> 28 << 6) | (sdram->emc_auto_cal_channel & 0x3F | (pmc->scratch83 >> 6 << 6)) & 0xFFFFFC3F) & 0xFFFF83FF) & 0xFFC07FFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0x1FFFFFF;
// 	pmc->scratch84 = (sdram->emc_sel_dpd_ctrl << 13 >> 29 << 29) | ((sdram->emc_sel_dpd_ctrl << 23 >> 31 << 28) | ((sdram->emc_sel_dpd_ctrl << 26 >> 31 << 27) | ((sdram->emc_sel_dpd_ctrl << 27 >> 31 << 26) | ((sdram->emc_sel_dpd_ctrl << 28 >> 31 << 25) | ((sdram->emc_sel_dpd_ctrl << 29 >> 31 << 24) | ((4 * sdram->emc_pmacro_rx_term >> 26 << 18) | ((sdram->emc_pmacro_rx_term << 10 >> 26 << 12) | ((sdram->emc_pmacro_rx_term << 18 >> 26 << 6) | (sdram->emc_pmacro_rx_term & 0x3F | (pmc->scratch84 >> 6 << 6)) & 0xFFFFF03F) & 0xFFFC0FFF) & 0xFF03FFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0x1FFFFFFF;
// 	pmc->scratch85 = (4 * sdram->emc_obdly >> 30 << 30) | (4 * ((sdram->emc_obdly << 24) | ((4 * sdram->emc_pmacro_dq_tx_drive >> 26 << 18) | ((sdram->emc_pmacro_dq_tx_drive << 10 >> 26 << 12) | ((sdram->emc_pmacro_dq_tx_drive << 18 >> 26 << 6) | (sdram->emc_pmacro_dq_tx_drive & 0x3F | (pmc->scratch85 >> 6 << 6)) & 0xFFFFF03F) & 0xFFFC0FFF) & 0xFF03FFFF) & 0xC0FFFFFF) >> 2);
// 	pmc->scratch86 = (sdram->emc_pmacro_vttgen_ctrl1 << 10 >> 30 << 30) | (4 * ((sdram->emc_pmacro_vttgen_ctrl1 << 16 >> 26 << 24) | ((4 * sdram->emc_pmacro_ca_tx_drive >> 26 << 18) | ((sdram->emc_pmacro_ca_tx_drive << 10 >> 26 << 12) | ((sdram->emc_pmacro_ca_tx_drive << 18 >> 26 << 6) | (sdram->emc_pmacro_ca_tx_drive & 0x3F | (pmc->scratch86 >> 6 << 6)) & 0xFFFFF03F) & 0xFFFC0FFF) & 0xFF03FFFF) & 0xC0FFFFFF) >> 2);
// 	pmc->scratch87 = (sdram->emc_pmacro_vttgen_ctrl2 >> 16 << 24) | ((16 * sdram->emc_pmacro_zcrtl >> 30 << 22) | ((sdram->emc_pmacro_zcrtl << 6 >> 30 << 20) | ((sdram->emc_pmacro_zcrtl << 8 >> 30 << 18) | ((sdram->emc_pmacro_zcrtl << 10 >> 30 << 16) | ((sdram->emc_pmacro_zcrtl << 12 >> 30 << 14) | ((sdram->emc_pmacro_zcrtl << 14 >> 30 << 12) | ((sdram->emc_pmacro_zcrtl << 16 >> 30 << 10) | ((sdram->emc_pmacro_zcrtl << 18 >> 30 << 8) | ((sdram->emc_pmacro_zcrtl << 20 >> 30 << 6) | (16 * (sdram->emc_pmacro_zcrtl << 22 >> 30) | (4 * (sdram->emc_pmacro_zcrtl << 24 >> 30) | ((sdram->emc_pmacro_zcrtl << 26 >> 30) | 4 * (pmc->scratch87 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFFFFFF;
// 	pmc->scratch88 = (sdram->mc_emem_arb_timing_rc << 24) | ((sdram->emc_zcal_interval << 14) | ((sdram->emc_zcal_interval << 8 >> 18) | (pmc->scratch88 >> 14 << 14)) & 0xFF003FFF) & 0xFFFFFF;
// 	pmc->scratch89 = ((u16)(sdram->mc_emem_arb_rsv) << 24) | ((sdram->emc_data_brlshft0 << 8 >> 29 << 21) | ((sdram->emc_data_brlshft0 << 11 >> 29 << 18) | ((sdram->emc_data_brlshft0 << 14 >> 29 << 15) | ((sdram->emc_data_brlshft0 << 17 >> 29 << 12) | ((sdram->emc_data_brlshft0 << 20 >> 29 << 9) | ((sdram->emc_data_brlshft0 << 23 >> 29 << 6) | (8 * (sdram->emc_data_brlshft0 << 26 >> 29) | (sdram->emc_data_brlshft0 & 7 | 8 * (pmc->scratch89 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF) & 0xFFFFFF;
// 	pmc->scratch90 = (sdram->emc_data_brlshft1 << 8 >> 29 << 21) | ((sdram->emc_data_brlshft1 << 11 >> 29 << 18) | ((sdram->emc_data_brlshft1 << 14 >> 29 << 15) | ((sdram->emc_data_brlshft1 << 17 >> 29 << 12) | ((sdram->emc_data_brlshft1 << 20 >> 29 << 9) | ((sdram->emc_data_brlshft1 << 23 >> 29 << 6) | (8 * (sdram->emc_data_brlshft1 << 26 >> 29) | (sdram->emc_data_brlshft1 & 7 | 8 * (pmc->scratch90 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF;
// 	pmc->scratch91 = (sdram->emc_dqs_brlshft0 << 8 >> 29 << 21) | ((sdram->emc_dqs_brlshft0 << 11 >> 29 << 18) | ((sdram->emc_dqs_brlshft0 << 14 >> 29 << 15) | ((sdram->emc_dqs_brlshft0 << 17 >> 29 << 12) | ((sdram->emc_dqs_brlshft0 << 20 >> 29 << 9) | ((sdram->emc_dqs_brlshft0 << 23 >> 29 << 6) | (8 * (sdram->emc_dqs_brlshft0 << 26 >> 29) | (sdram->emc_dqs_brlshft0 & 7 | 8 * (pmc->scratch91 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF;
// 	pmc->scratch92 = (sdram->emc_dqs_brlshft1 << 8 >> 29 << 21) | ((sdram->emc_dqs_brlshft1 << 11 >> 29 << 18) | ((sdram->emc_dqs_brlshft1 << 14 >> 29 << 15) | ((sdram->emc_dqs_brlshft1 << 17 >> 29 << 12) | ((sdram->emc_dqs_brlshft1 << 20 >> 29 << 9) | ((sdram->emc_dqs_brlshft1 << 23 >> 29 << 6) | (8 * (sdram->emc_dqs_brlshft1 << 26 >> 29) | (sdram->emc_dqs_brlshft1 & 7 | 8 * (pmc->scratch92 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF;
// 	pmc->scratch93 = (2 * sdram->emc_swizzle_rank0_byte0 >> 29 << 21) | ((32 * sdram->emc_swizzle_rank0_byte0 >> 29 << 18) | ((sdram->emc_swizzle_rank0_byte0 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank0_byte0 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank0_byte0 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank0_byte0 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank0_byte0 << 25 >> 29) | (sdram->emc_swizzle_rank0_byte0 & 7 | 8 * (pmc->scratch93 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF;
// 	pmc->scratch94 = ((u8)(sdram->emc_cfg) << 27 >> 31 << 31) | (2 * ((sdram->emc_ras << 24) | ((2 * sdram->emc_swizzle_rank0_byte1 >> 29 << 21) | ((32 * sdram->emc_swizzle_rank0_byte1 >> 29 << 18) | ((sdram->emc_swizzle_rank0_byte1 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank0_byte1 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank0_byte1 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank0_byte1 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank0_byte1 << 25 >> 29) | (sdram->emc_swizzle_rank0_byte1 & 7 | 8 * (pmc->scratch94 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch95 = ((u8)(sdram->emc_cfg) << 26 >> 31 << 31) | (2 * ((sdram->emc_w2p << 24) | ((2 * sdram->emc_swizzle_rank0_byte2 >> 29 << 21) | ((32 * sdram->emc_swizzle_rank0_byte2 >> 29 << 18) | ((sdram->emc_swizzle_rank0_byte2 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank0_byte2 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank0_byte2 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank0_byte2 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank0_byte2 << 25 >> 29) | (sdram->emc_swizzle_rank0_byte2 & 7 | 8 * (pmc->scratch95 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch96 = ((u8)(sdram->emc_cfg) << 25 >> 31 << 31) | (2 * ((sdram->emc_qsafe << 24) | ((2 * sdram->emc_swizzle_rank0_byte3 >> 29 << 21) | (((sdram->emc_swizzle_rank0_byte3 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank0_byte3 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank0_byte3 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank0_byte3 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank0_byte3 << 25 >> 29) | (sdram->emc_swizzle_rank0_byte3 & 7 | 8 * (pmc->scratch96 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF | (32 * sdram->emc_swizzle_rank0_byte3 >> 29 << 18)) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch97 = ((u8)(sdram->emc_cfg) << 24 >> 31 << 31) | (2 * ((sdram->emc_rdv << 24) | ((2 * sdram->emc_swizzle_rank1_byte0 >> 29 << 21) | (((sdram->emc_swizzle_rank1_byte0 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank1_byte0 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank1_byte0 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank1_byte0 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank1_byte0 << 25 >> 29) | (sdram->emc_swizzle_rank1_byte0 & 7 | 8 * (pmc->scratch97 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF | (32 * sdram->emc_swizzle_rank1_byte0 >> 29 << 18)) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch98 = ((u16)(sdram->emc_cfg) << 23 >> 31 << 31) | (2 * (((u16)(sdram->emc_rw2pden) << 24) | ((2 * sdram->emc_swizzle_rank1_byte1 >> 29 << 21) | ((32 * sdram->emc_swizzle_rank1_byte1 >> 29 << 18) | ((sdram->emc_swizzle_rank1_byte1 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank1_byte1 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank1_byte1 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank1_byte1 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank1_byte1 << 25 >> 29) | (sdram->emc_swizzle_rank1_byte1 & 7 | 8 * (pmc->scratch98 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch99 = ((u16)(sdram->emc_cfg) << 22 >> 31 << 31) | (2 * ((sdram->emc_tfaw << 24) | ((2 * sdram->emc_swizzle_rank1_byte2 >> 29 << 21) | ((32 * sdram->emc_swizzle_rank1_byte2 >> 29 << 18) | ((sdram->emc_swizzle_rank1_byte2 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank1_byte2 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank1_byte2 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank1_byte2 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank1_byte2 << 25 >> 29) | (sdram->emc_swizzle_rank1_byte2 & 7 | 8 * (pmc->scratch99 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch100 = (sdram->emc_cfg << 13 >> 31 << 31) | (2 * ((sdram->emc_tclkstable << 24) | ((2 * sdram->emc_swizzle_rank1_byte3 >> 29 << 21) | ((32 * sdram->emc_swizzle_rank1_byte3 >> 29 << 18) | ((sdram->emc_swizzle_rank1_byte3 << 9 >> 29 << 15) | ((sdram->emc_swizzle_rank1_byte3 << 13 >> 29 << 12) | ((sdram->emc_swizzle_rank1_byte3 << 17 >> 29 << 9) | ((sdram->emc_swizzle_rank1_byte3 << 21 >> 29 << 6) | (8 * (sdram->emc_swizzle_rank1_byte3 << 25 >> 29) | (sdram->emc_swizzle_rank1_byte3 & 7 | 8 * (pmc->scratch100 >> 3)) & 0xFFFFFFC7) & 0xFFFFFE3F) & 0xFFFFF1FF) & 0xFFFF8FFF) & 0xFFFC7FFF) & 0xFFE3FFFF) & 0xFF1FFFFF) & 0x80FFFFFF) >> 1);
// 	tmp = 2 * (((u8)(sdram->emc_trtm) << 24) | ((16 * sdram->emc_cfg_pipe2 >> 31 << 23) | ((32 * sdram->emc_cfg_pipe2 >> 31 << 22) | ((sdram->emc_cfg_pipe2 << 6 >> 31 << 21) | ((sdram->emc_cfg_pipe2 << 7 >> 31 << 20) | ((sdram->emc_cfg_pipe2 << 8 >> 31 << 19) | ((sdram->emc_cfg_pipe2 << 9 >> 31 << 18) | ((sdram->emc_cfg_pipe2 << 10 >> 31 << 17) | ((sdram->emc_cfg_pipe2 << 11 >> 31 << 16) | ((sdram->emc_cfg_pipe2 << 12 >> 31 << 15) | ((sdram->emc_cfg_pipe2 << 13 >> 31 << 14) | ((sdram->emc_cfg_pipe2 << 14 >> 31 << 13) | ((sdram->emc_cfg_pipe2 << 15 >> 31 << 12) | ((sdram->emc_cfg_pipe2 << 20 >> 31 << 11) | ((sdram->emc_cfg_pipe2 << 21 >> 31 << 10) | ((sdram->emc_cfg_pipe2 << 22 >> 31 << 9) | ((sdram->emc_cfg_pipe2 << 23 >> 31 << 8) | ((sdram->emc_cfg_pipe2 << 24 >> 31 << 7) | ((sdram->emc_cfg_pipe2 << 25 >> 31 << 6) | (32 * (sdram->emc_cfg_pipe2 << 26 >> 31) | (16 * (sdram->emc_cfg_pipe2 << 27 >> 31) | (8 * (sdram->emc_cfg_pipe2 << 28 >> 31) | (4 * (sdram->emc_cfg_pipe2 << 29 >> 31) | (2 * (sdram->emc_cfg_pipe2 << 30 >> 31) | (sdram->emc_cfg_pipe2 & 1 | 2 * (pmc->scratch101 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1;
// 	pmc->scratch101 = (sdram->emc_cfg << 10 >> 31 << 31) | tmp;
// 	tmp = (2 * (pmc->scratch102 >> 1) | sdram->emc_cfg_pipe1 & 1) & 0xFFFFFFFD;
// 	pmc->scratch102 = (sdram->emc_cfg << 9 >> 31 << 31) | (2 * (((u8)(sdram->emc_twtm) << 24) | ((16 * sdram->emc_cfg_pipe1 >> 31 << 23) | ((32 * sdram->emc_cfg_pipe1 >> 31 << 22) | ((sdram->emc_cfg_pipe1 << 6 >> 31 << 21) | ((sdram->emc_cfg_pipe1 << 7 >> 31 << 20) | ((sdram->emc_cfg_pipe1 << 8 >> 31 << 19) | ((sdram->emc_cfg_pipe1 << 9 >> 31 << 18) | ((sdram->emc_cfg_pipe1 << 10 >> 31 << 17) | ((sdram->emc_cfg_pipe1 << 11 >> 31 << 16) | ((sdram->emc_cfg_pipe1 << 12 >> 31 << 15) | ((sdram->emc_cfg_pipe1 << 13 >> 31 << 14) | ((sdram->emc_cfg_pipe1 << 14 >> 31 << 13) | ((sdram->emc_cfg_pipe1 << 15 >> 31 << 12) | ((sdram->emc_cfg_pipe1 << 20 >> 31 << 11) | ((sdram->emc_cfg_pipe1 << 21 >> 31 << 10) | ((sdram->emc_cfg_pipe1 << 22 >> 31 << 9) | ((sdram->emc_cfg_pipe1 << 23 >> 31 << 8) | ((sdram->emc_cfg_pipe1 << 24 >> 31 << 7) | ((sdram->emc_cfg_pipe1 << 25 >> 31 << 6) | (32 * (sdram->emc_cfg_pipe1 << 26 >> 31) | (16 * (sdram->emc_cfg_pipe1 << 27 >> 31) | (8 * (sdram->emc_cfg_pipe1 << 28 >> 31) | (4 * (sdram->emc_cfg_pipe1 << 29 >> 31) | (2 * (sdram->emc_cfg_pipe1 << 30 >> 31) | tmp) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1);
// 	tmp = 2 * (((u8)(sdram->emc_tratm) << 24) | ((sdram->emc_pmacro_ddll_pwrd0 >> 31 << 23) | ((2 * sdram->emc_pmacro_ddll_pwrd0 >> 31 << 22) | ((8 * sdram->emc_pmacro_ddll_pwrd0 >> 31 << 21) | ((16 * sdram->emc_pmacro_ddll_pwrd0 >> 31 << 20) | ((32 * sdram->emc_pmacro_ddll_pwrd0 >> 31 << 19) | ((sdram->emc_pmacro_ddll_pwrd0 << 6 >> 31 << 18) | ((sdram->emc_pmacro_ddll_pwrd0 << 8 >> 31 << 17) | ((sdram->emc_pmacro_ddll_pwrd0 << 9 >> 31 << 16) | ((sdram->emc_pmacro_ddll_pwrd0 << 11 >> 31 << 15) | ((sdram->emc_pmacro_ddll_pwrd0 << 12 >> 31 << 14) | ((sdram->emc_pmacro_ddll_pwrd0 << 13 >> 31 << 13) | ((sdram->emc_pmacro_ddll_pwrd0 << 14 >> 31 << 12) | ((sdram->emc_pmacro_ddll_pwrd0 << 16 >> 31 << 11) | ((sdram->emc_pmacro_ddll_pwrd0 << 17 >> 31 << 10) | ((sdram->emc_pmacro_ddll_pwrd0 << 19 >> 31 << 9) | ((sdram->emc_pmacro_ddll_pwrd0 << 20 >> 31 << 8) | ((sdram->emc_pmacro_ddll_pwrd0 << 21 >> 31 << 7) | ((sdram->emc_pmacro_ddll_pwrd0 << 22 >> 31 << 6) | (32 * (sdram->emc_pmacro_ddll_pwrd0 << 24 >> 31) | (16 * (sdram->emc_pmacro_ddll_pwrd0 << 25 >> 31) | (8 * (sdram->emc_pmacro_ddll_pwrd0 << 27 >> 31) | (4 * (sdram->emc_pmacro_ddll_pwrd0 << 28 >> 31) | (2 * (sdram->emc_pmacro_ddll_pwrd0 << 29 >> 31) | ((sdram->emc_pmacro_ddll_pwrd0 << 30 >> 31) | 2 * (pmc->scratch103 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1;
// 	pmc->scratch103 = (sdram->emc_cfg << 8 >> 31 << 31) | tmp;
// 	tmp = 2 * (((u8)(sdram->emc_twatm) << 24) | ((sdram->emc_pmacro_ddll_pwrd1 >> 31 << 23) | ((2 * sdram->emc_pmacro_ddll_pwrd1 >> 31 << 22) | ((8 * sdram->emc_pmacro_ddll_pwrd1 >> 31 << 21) | ((16 * sdram->emc_pmacro_ddll_pwrd1 >> 31 << 20) | ((32 * sdram->emc_pmacro_ddll_pwrd1 >> 31 << 19) | ((sdram->emc_pmacro_ddll_pwrd1 << 6 >> 31 << 18) | ((sdram->emc_pmacro_ddll_pwrd1 << 8 >> 31 << 17) | ((sdram->emc_pmacro_ddll_pwrd1 << 9 >> 31 << 16) | ((sdram->emc_pmacro_ddll_pwrd1 << 11 >> 31 << 15) | ((sdram->emc_pmacro_ddll_pwrd1 << 12 >> 31 << 14) | ((sdram->emc_pmacro_ddll_pwrd1 << 13 >> 31 << 13) | ((sdram->emc_pmacro_ddll_pwrd1 << 14 >> 31 << 12) | ((sdram->emc_pmacro_ddll_pwrd1 << 16 >> 31 << 11) | ((sdram->emc_pmacro_ddll_pwrd1 << 17 >> 31 << 10) | ((sdram->emc_pmacro_ddll_pwrd1 << 19 >> 31 << 9) | ((sdram->emc_pmacro_ddll_pwrd1 << 20 >> 31 << 8) | ((sdram->emc_pmacro_ddll_pwrd1 << 21 >> 31 << 7) | ((sdram->emc_pmacro_ddll_pwrd1 << 22 >> 31 << 6) | (32 * (sdram->emc_pmacro_ddll_pwrd1 << 24 >> 31) | (16 * (sdram->emc_pmacro_ddll_pwrd1 << 25 >> 31) | (8 * (sdram->emc_pmacro_ddll_pwrd1 << 27 >> 31) | (4 * (sdram->emc_pmacro_ddll_pwrd1 << 28 >> 31) | (2 * (sdram->emc_pmacro_ddll_pwrd1 << 29 >> 31) | ((sdram->emc_pmacro_ddll_pwrd1 << 30 >> 31) | 2 * (pmc->scratch104 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1;
// 	pmc->scratch104 = (sdram->emc_cfg << 7 >> 31 << 31) | tmp;
// 	tmp = (sdram->emc_pmacro_ddll_pwrd2 << 22 >> 31 << 6) | (32 * (sdram->emc_pmacro_ddll_pwrd2 << 24 >> 31) | (16 * (sdram->emc_pmacro_ddll_pwrd2 << 25 >> 31) | (8 * (sdram->emc_pmacro_ddll_pwrd2 << 27 >> 31) | (4 * (sdram->emc_pmacro_ddll_pwrd2 << 28 >> 31) | (2 * (sdram->emc_pmacro_ddll_pwrd2 << 29 >> 31) | ((sdram->emc_pmacro_ddll_pwrd2 << 30 >> 31) | 2 * (pmc->scratch105 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF;
// 	pmc->scratch105 = (sdram->emc_cfg << 6 >> 31 << 31) | (2 * (((u8)(sdram->emc_tr2ref) << 24) | ((sdram->emc_pmacro_ddll_pwrd2 >> 31 << 23) | ((2 * sdram->emc_pmacro_ddll_pwrd2 >> 31 << 22) | ((8 * sdram->emc_pmacro_ddll_pwrd2 >> 31 << 21) | ((16 * sdram->emc_pmacro_ddll_pwrd2 >> 31 << 20) | ((32 * sdram->emc_pmacro_ddll_pwrd2 >> 31 << 19) | ((sdram->emc_pmacro_ddll_pwrd2 << 6 >> 31 << 18) | ((sdram->emc_pmacro_ddll_pwrd2 << 8 >> 31 << 17) | ((sdram->emc_pmacro_ddll_pwrd2 << 9 >> 31 << 16) | ((sdram->emc_pmacro_ddll_pwrd2 << 11 >> 31 << 15) | ((sdram->emc_pmacro_ddll_pwrd2 << 12 >> 31 << 14) | ((sdram->emc_pmacro_ddll_pwrd2 << 13 >> 31 << 13) | ((sdram->emc_pmacro_ddll_pwrd2 << 14 >> 31 << 12) | ((sdram->emc_pmacro_ddll_pwrd2 << 16 >> 31 << 11) | ((sdram->emc_pmacro_ddll_pwrd2 << 17 >> 31 << 10) | ((sdram->emc_pmacro_ddll_pwrd2 << 19 >> 31 << 9) | ((sdram->emc_pmacro_ddll_pwrd2 << 20 >> 31 << 8) | ((sdram->emc_pmacro_ddll_pwrd2 << 21 >> 31 << 7) | tmp & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch106 = (32 * sdram->emc_cfg >> 31 << 31) | (2 * (((u16)(sdram->emc_pdex2mrr) << 24) | ((8 * sdram->emc_pmacro_ddll_periodic_offset >> 31 << 23) | ((16 * sdram->emc_pmacro_ddll_periodic_offset >> 31 << 22) | ((32 * sdram->emc_pmacro_ddll_periodic_offset >> 31 << 21) | ((sdram->emc_pmacro_ddll_periodic_offset << 6 >> 31 << 20) | ((sdram->emc_pmacro_ddll_periodic_offset << 7 >> 31 << 19) | ((sdram->emc_pmacro_ddll_periodic_offset << 8 >> 31 << 18) | ((sdram->emc_pmacro_ddll_periodic_offset << 9 >> 31 << 17) | ((sdram->emc_pmacro_ddll_periodic_offset << 10 >> 31 << 16) | ((sdram->emc_pmacro_ddll_periodic_offset << 11 >> 31 << 15) | ((sdram->emc_pmacro_ddll_periodic_offset << 15 >> 31 << 14) | ((sdram->emc_pmacro_ddll_periodic_offset << 16 >> 31 << 13) | ((sdram->emc_pmacro_ddll_periodic_offset << 17 >> 31 << 12) | ((sdram->emc_pmacro_ddll_periodic_offset << 18 >> 31 << 11) | ((sdram->emc_pmacro_ddll_periodic_offset << 19 >> 31 << 10) | ((sdram->emc_pmacro_ddll_periodic_offset << 20 >> 31 << 9) | ((sdram->emc_pmacro_ddll_periodic_offset << 21 >> 31 << 8) | ((sdram->emc_pmacro_ddll_periodic_offset << 22 >> 31 << 7) | ((sdram->emc_pmacro_ddll_periodic_offset << 23 >> 31 << 6) | (sdram->emc_pmacro_ddll_periodic_offset & 0x3F | (pmc->scratch106 >> 6 << 6)) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch107 = (8 * sdram->emc_cfg >> 31 << 31) | (2 * ((sdram->emc_clken_override << 15 >> 31 << 30) | ((sdram->emc_clken_override << 23 >> 31 << 29) | ((sdram->emc_clken_override << 24 >> 31 << 28) | ((sdram->emc_clken_override << 25 >> 31 << 27) | ((sdram->emc_clken_override << 28 >> 31 << 26) | ((sdram->emc_clken_override << 29 >> 31 << 25) | ((sdram->emc_clken_override << 30 >> 31 << 24) | ((sdram->mc_emem_arb_da_covers << 8 >> 24 << 16) | ((sdram->mc_emem_arb_da_covers << 16 >> 24 << 8) | (sdram->mc_emem_arb_da_covers & 0xFF | (pmc->scratch107 >> 8 << 8)) & 0xFFFF00FF) & 0xFF00FFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch108 = (sdram->emc_rfc_pb << 23) | ((sdram->emc_xm2_comp_pad_ctrl >> 24 << 15) | ((sdram->emc_xm2_comp_pad_ctrl << 12 >> 24 << 7) | ((sdram->emc_xm2_comp_pad_ctrl << 20 >> 31 << 6) | (32 * (sdram->emc_xm2_comp_pad_ctrl << 22 >> 31) | (4 * (sdram->emc_xm2_comp_pad_ctrl << 25 >> 29) | (sdram->emc_xm2_comp_pad_ctrl & 3 | 4 * (pmc->scratch108 >> 2)) & 0xFFFFFFE3) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFF807F) & 0xFF807FFF) & 0x7FFFFF;
// 	pmc->scratch109 = (sdram->emc_cfg_update >> 31 << 31) | (2 * ((2 * sdram->emc_cfg_update >> 31 << 30) | ((4 * sdram->emc_cfg_update >> 31 << 29) | ((8 * sdram->emc_cfg_update >> 31 << 28) | ((sdram->emc_cfg_update << 21 >> 30 << 26) | ((sdram->emc_cfg_update << 23 >> 31 << 25) | ((sdram->emc_cfg_update << 29 >> 30 << 23) | ((sdram->emc_cfg_update << 22) & 0x7FFFFF | ((sdram->emc_auto_cal_config3 << 8 >> 28 << 18) | ((sdram->emc_auto_cal_config3 << 12 >> 28 << 14) | ((sdram->emc_auto_cal_config3 << 17 >> 25 << 7) | ((pmc->scratch109 >> 7 << 7) | sdram->emc_auto_cal_config3 & 0x7F) & 0xFFFFC07F) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0xFFBFFFFF) & 0xFE7FFFFF) & 0xFDFFFFFF) & 0xF3FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch110 = (sdram->emc_rfc << 22) | ((sdram->emc_auto_cal_config4 << 8 >> 28 << 18) | ((sdram->emc_auto_cal_config4 << 12 >> 28 << 14) | ((sdram->emc_auto_cal_config4 << 17 >> 25 << 7) | (sdram->emc_auto_cal_config4 & 0x7F | (pmc->scratch110 >> 7 << 7)) & 0xFFFFC07F) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0x3FFFFF;
// 	pmc->scratch111 = ((u16)(sdram->emc_txsr) << 22) | ((sdram->emc_auto_cal_config5 << 8 >> 28 << 18) | ((sdram->emc_auto_cal_config5 << 12 >> 28 << 14) | ((sdram->emc_auto_cal_config5 << 17 >> 25 << 7) | ((pmc->scratch111 >> 7 << 7) | sdram->emc_auto_cal_config5 & 0x7F) & 0xFFFFC07F) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0x3FFFFF;
// 	pmc->scratch112 = (16 * sdram->emc_mc2emc_q >> 28 << 28) | ((sdram->emc_mc2emc_q << 21 >> 29 << 25) | ((sdram->emc_mc2emc_q << 22) & 0x1FFFFFF | ((sdram->emc_auto_cal_config6 << 8 >> 28 << 18) | ((sdram->emc_auto_cal_config6 << 12 >> 28 << 14) | ((sdram->emc_auto_cal_config6 << 17 >> 25 << 7) | (sdram->emc_auto_cal_config6 & 0x7F | (pmc->scratch112 >> 7 << 7)) & 0xFFFFC07F) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0xFE3FFFFF) & 0xF1FFFFFF) & 0xFFFFFFF;
// 	pmc->scratch113 = (sdram->mc_emem_arb_ring1_throttle << 11 >> 27 << 27) | ((sdram->mc_emem_arb_ring1_throttle << 22) | ((sdram->emc_auto_cal_config7 << 8 >> 28 << 18) | ((sdram->emc_auto_cal_config7 << 12 >> 28 << 14) | ((sdram->emc_auto_cal_config7 << 17 >> 25 << 7) | (sdram->emc_auto_cal_config7 & 0x7F | (pmc->scratch113 >> 7 << 7)) & 0xFFFFC07F) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0xF83FFFFF) & 0x7FFFFFF;
// 	pmc->scratch114 = (sdram->emc_auto_cal_config8 << 8 >> 28 << 18) | ((sdram->emc_auto_cal_config8 << 12 >> 28 << 14) | ((sdram->emc_auto_cal_config8 << 17 >> 25 << 7) | (sdram->emc_auto_cal_config8 & 0x7F | (pmc->scratch114 >> 7 << 7)) & 0xFFFFC07F) & 0xFFFC3FFF) & 0xFFC3FFFF;
// 	pmc->scratch115 = (4 * sdram->emc_cfg >> 31 << 31) | (2 * (((u16)(sdram->emc_ar2pden) << 22) | ((sdram->emc_fbio_cfg7 << 10 >> 30 << 20) | ((sdram->emc_fbio_cfg7 << 12 >> 31 << 19) | ((sdram->emc_fbio_cfg7 << 13 >> 31 << 18) | ((sdram->emc_fbio_cfg7 << 14 >> 31 << 17) | ((sdram->emc_fbio_cfg7 << 15 >> 31 << 16) | ((sdram->emc_fbio_cfg7 << 16 >> 31 << 15) | ((sdram->emc_fbio_cfg7 << 17 >> 31 << 14) | ((sdram->emc_fbio_cfg7 << 18 >> 31 << 13) | ((sdram->emc_fbio_cfg7 << 19 >> 31 << 12) | ((sdram->emc_fbio_cfg7 << 20 >> 31 << 11) | ((sdram->emc_fbio_cfg7 << 21 >> 31 << 10) | ((sdram->emc_fbio_cfg7 << 22 >> 31 << 9) | ((sdram->emc_fbio_cfg7 << 23 >> 31 << 8) | ((sdram->emc_fbio_cfg7 << 24 >> 31 << 7) | ((sdram->emc_fbio_cfg7 << 25 >> 31 << 6) | (32 * (sdram->emc_fbio_cfg7 << 26 >> 31) | (16 * (sdram->emc_fbio_cfg7 << 27 >> 31) | (8 * (sdram->emc_fbio_cfg7 << 28 >> 31) | (4 * (sdram->emc_fbio_cfg7 << 29 >> 31) | (2 * (sdram->emc_fbio_cfg7 << 30 >> 31) | (sdram->emc_fbio_cfg7 & 1 | 2 * (pmc->scratch115 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFCFFFFF) & 0x803FFFFF) >> 1);
// 	pmc->scratch123 = (2 * sdram->emc_cfg >> 31 << 31) | (2 * ((sdram->emc_rfc_slr << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank0_0 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank0_0 & 0x7FF | (pmc->scratch123 >> 11 << 11)) & 0xFFC007FF) & 0x803FFFFF) >> 1);
// 	pmc->scratch124 = (sdram->emc_cfg >> 31 << 31) | (2 * ((4 * sdram->emc_ibdly >> 30 << 29) | ((sdram->emc_ibdly << 22) & 0x1FFFFFFF | ((32 * sdram->emc_pmacro_quse_ddll_rank0_1 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank0_1 & 0x7FF | (pmc->scratch124 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x9FFFFFFF) >> 1);
// 	pmc->scratch125 = (sdram->emc_fbio_cfg5 << 27 >> 31 << 31) | (2 * (((u16)(sdram->mc_emem_arb_timing_rfcpb) << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank0_2 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank0_2 & 0x7FF | (pmc->scratch125 >> 11 << 11)) & 0xFFC007FF) & 0x803FFFFF) >> 1);
// 	pmc->scratch126 = (sdram->emc_fbio_cfg5 << 16 >> 29 << 29) | ((sdram->emc_auto_cal_config9 << 25 >> 31 << 28) | ((sdram->emc_auto_cal_config9 << 26 >> 31 << 27) | ((sdram->emc_auto_cal_config9 << 27 >> 31 << 26) | ((sdram->emc_auto_cal_config9 << 28 >> 31 << 25) | ((sdram->emc_auto_cal_config9 << 29 >> 31 << 24) | ((sdram->emc_auto_cal_config9 << 30 >> 31 << 23) | ((sdram->emc_auto_cal_config9 << 22) & 0x7FFFFF | ((32 * sdram->emc_pmacro_quse_ddll_rank0_3 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank0_3 & 0x7FF | (pmc->scratch126 >> 11 << 11)) & 0xFFC007FF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0x1FFFFFFF;
// 	pmc->scratch127 = ((u8)(sdram->emc_cfg2) << 26 >> 29 << 29) | ((sdram->emc_rdv_mask << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank0_4 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank0_4 & 0x7FF | (pmc->scratch127 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x1FFFFFFF;
// 	pmc->scratch128 = (sdram->emc_pmacro_cmd_pad_tx_ctrl << 27 >> 29 << 29) | (((u8)(sdram->emc_rdv_early_mask) << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank0_5 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank0_5 & 0x7FF | (pmc->scratch128 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x1FFFFFFF;
// 	pmc->scratch129 = (sdram->emc_pmacro_cmd_pad_tx_ctrl << 22 >> 29 << 29) | ((sdram->emc_rdv_early << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank1_0 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank1_0 & 0x7FF | (pmc->scratch129 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x1FFFFFFF;
// 	pmc->scratch130 = (sdram->emc_pmacro_cmd_pad_tx_ctrl << 17 >> 29 << 29) | ((4 * sdram->emc_quse_width >> 31 << 28) | ((8 * sdram->emc_quse_width >> 31 << 27) | ((sdram->emc_quse_width << 22) & 0x7FFFFFF | ((32 * sdram->emc_pmacro_quse_ddll_rank1_1 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank1_1 & 0x7FF | (pmc->scratch130 >> 11 << 11)) & 0xFFC007FF) & 0xF83FFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0x1FFFFFFF;
// 	pmc->scratch131 = (sdram->emc_pmacro_cmd_pad_tx_ctrl << 12 >> 29 << 29) | (((u16)(sdram->emc_pmacro_ddll_short_cmd_2) << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank1_2 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank1_2 & 0x7FF | (pmc->scratch131 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x1FFFFFFF;
// 	pmc->scratch132 = (sdram->emc_pmacro_data_pad_tx_ctrl << 27 >> 29 << 29) | ((sdram->emc_pmacro_cmd_rx_term_mode << 18 >> 31 << 28) | ((sdram->emc_pmacro_cmd_rx_term_mode << 22 >> 30 << 26) | ((sdram->emc_pmacro_cmd_rx_term_mode << 26 >> 30 << 24) | ((sdram->emc_pmacro_cmd_rx_term_mode << 22) & 0xFFFFFF | ((32 * sdram->emc_pmacro_quse_ddll_rank1_3 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank1_3 & 0x7FF | (pmc->scratch132 >> 11 << 11)) & 0xFFC007FF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xEFFFFFFF) & 0x1FFFFFFF;
// 	pmc->scratch133 = (sdram->emc_pmacro_data_pad_tx_ctrl << 22 >> 29 << 29) | ((sdram->emc_pmacro_data_rx_term_mode << 18 >> 31 << 28) | ((sdram->emc_pmacro_data_rx_term_mode << 22 >> 30 << 26) | ((sdram->emc_pmacro_data_rx_term_mode << 26 >> 30 << 24) | ((sdram->emc_pmacro_data_rx_term_mode << 22) & 0xFFFFFF | ((32 * sdram->emc_pmacro_quse_ddll_rank1_4 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank1_4 & 0x7FF | (pmc->scratch133 >> 11 << 11)) & 0xFFC007FF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xEFFFFFFF) & 0x1FFFFFFF;
// 	pmc->scratch134 = (sdram->emc_pmacro_data_pad_tx_ctrl << 17 >> 29 << 29) | ((sdram->mc_emem_arb_timing_rp << 22) | ((32 * sdram->emc_pmacro_quse_ddll_rank1_5 >> 21 << 11) | (sdram->emc_pmacro_quse_ddll_rank1_5 & 0x7FF | (pmc->scratch134 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x1FFFFFFF;
// 	pmc->scratch135 = (sdram->emc_pmacro_data_pad_tx_ctrl << 12 >> 29 << 29) | ((sdram->mc_emem_arb_timing_ras << 22) | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank0_0 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank0_0 & 0x7FF | (pmc->scratch135 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x1FFFFFFF;
// 	pmc->scratch136 = (sdram->emc_fbio_cfg5 << 23 >> 31 << 31) | (2 * ((sdram->emc_cfg << 14 >> 30 << 29) | ((sdram->mc_emem_arb_timing_faw << 22) & 0x1FFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank0_1 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank0_1 & 0x7FF | (pmc->scratch136 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x9FFFFFFF) >> 1);
// 	pmc->scratch137 = (sdram->emc_fbio_cfg5 << 21 >> 31 << 31) | (2 * ((sdram->emc_fbio_cfg5 << 29) | ((sdram->mc_emem_arb_timing_rap2pre << 22) & 0x1FFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank0_2 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank0_2 & 0x7FF | (pmc->scratch137 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x9FFFFFFF) >> 1);
// 	pmc->scratch138 = (sdram->emc_fbio_cfg5 << 19 >> 31 << 31) | (2 * ((sdram->emc_fbio_cfg5 << 28 >> 30 << 29) | ((sdram->mc_emem_arb_timing_wap2pre << 22) & 0x1FFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank0_3 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank0_3 & 0x7FF | (pmc->scratch138 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x9FFFFFFF) >> 1);
// 	pmc->scratch139 = (sdram->emc_fbio_cfg5 << 7 >> 31 << 31) | (2 * ((16 * sdram->emc_cfg2 >> 30 << 29) | (((u8)(sdram->mc_emem_arb_timing_r2w) << 22) & 0x1FFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank0_4 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank0_4 & 0x7FF | (pmc->scratch139 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0x9FFFFFFF) >> 1);
// 	pmc->scratch140 = (16 * sdram->emc_fbio_cfg5 >> 31 << 31) | (2 * ((32 * sdram->emc_fbio_cfg5 >> 31 << 30) | ((sdram->emc_fbio_cfg5 << 6 >> 31 << 29) | (((u8)(sdram->mc_emem_arb_timing_w2r) << 22) & 0x1FFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank0_5 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank0_5 & 0x7FF | (pmc->scratch140 >> 11 << 11)) & 0xFFC007FF) & 0xE03FFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch141 = (sdram->emc_fbio_cfg5 << 8 >> 28 << 28) | (((u16)(sdram->emc_wdv) << 22) | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank1_0 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank1_0 & 0x7FF | (pmc->scratch141 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xFFFFFFF;
// 	pmc->scratch142 = ((u8)(sdram->emc_cfg2) << 31) | (2 * ((sdram->emc_fbio_cfg5 >> 31 << 30) | ((2 * sdram->emc_fbio_cfg5 >> 31 << 29) | ((8 * sdram->emc_fbio_cfg5 >> 31 << 28) | ((sdram->emc_quse << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank1_1 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank1_1 & 0x7FF | (pmc->scratch142 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch143 = (((u16)(sdram->emc_cfg2) << 21) >> 31 << 31) | (2 * ((((u16)(sdram->emc_cfg2) << 24) >> 31 << 30) | ((((u16)(sdram->emc_cfg2) << 29) >> 31 << 29) | ((((u16)(sdram->emc_cfg2) << 30) >> 31 << 28) | (((u8)(sdram->emc_pdex2wr) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank1_2 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank1_2 & 0x7FF | (pmc->scratch143 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch144 = (sdram->emc_cfg2 << 15 >> 31 << 31) | (2 * ((sdram->emc_cfg2 << 16 >> 31 << 30) | ((sdram->emc_cfg2 << 17 >> 31 << 29) | ((sdram->emc_cfg2 << 20 >> 31 << 28) | (((u8)(sdram->emc_pdex2rd) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank1_3 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank1_3 & 0x7FF | (pmc->scratch144 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch145 = (sdram->emc_cfg2 << 7 >> 31 << 31) | (2 * ((sdram->emc_cfg2 << 8 >> 31 << 30) | ((sdram->emc_cfg2 << 9 >> 31 << 29) | ((sdram->emc_cfg2 << 11 >> 31 << 28) | (((u16)(sdram->emc_pdex2che) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank1_4 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank1_4 & 0x7FF | (pmc->scratch145 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch146 = (2 * sdram->emc_cfg2 >> 31 << 31) | (2 * ((4 * sdram->emc_cfg2 >> 31 << 30) | (((sdram->emc_cfg2 << 6 >> 31 << 28) | (((u8)(sdram->emc_pchg2pden) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dq_rank1_5 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dq_rank1_5 & 0x7FF | (pmc->scratch146 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF | (8 * sdram->emc_cfg2 >> 31 << 29)) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch147 = (((u8)(sdram->emc_cfg_pipe) << 29) >> 31 << 31) | (2 * ((((u8)(sdram->emc_cfg_pipe) << 30) >> 31 << 30) | ((((u8)(sdram->emc_cfg_pipe) << 31) >> 2) | ((sdram->emc_cfg2 >> 31 << 28) | (((u16)(sdram->emc_act2pden) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank0_0 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank0_0 & 0x7FF | (pmc->scratch147 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch148 = (((u8)(sdram->emc_cfg_pipe) << 25) >> 31 << 31) | (2 * ((((u8)(sdram->emc_cfg_pipe) << 26) >> 31 << 30) | ((((u8)(sdram->emc_cfg_pipe) << 27) >> 31 << 29) | ((((u8)(sdram->emc_cfg_pipe) << 28) >> 31 << 28) | (((u16)(sdram->emc_cke2pden) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank0_1 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank0_1 & 0x7FF | (pmc->scratch148 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch149 = (((u16)(sdram->emc_cfg_pipe) << 21) >> 31 << 31) | (2 * ((((u16)(sdram->emc_cfg_pipe) << 22) >> 31 << 30) | ((((u16)(sdram->emc_cfg_pipe) << 23) >> 31 << 29) | ((((u16)(sdram->emc_cfg_pipe) << 24) >> 31 << 28) | ((sdram->emc_tcke << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank0_2 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank0_2 & 0x7FF | (pmc->scratch149 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch150 = (sdram->emc_cfg_pipe << 13 >> 31 << 31) | (2 * ((sdram->emc_cfg_pipe << 14 >> 31 << 30) | (((sdram->emc_cfg_pipe << 20 >> 31 << 28) | ((sdram->emc_trpab << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank0_3 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank0_3 & 0x7FF | (pmc->scratch150 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF | (sdram->emc_cfg_pipe << 15 >> 31 << 29)) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch151 = (sdram->emc_cfg_pipe << 9 >> 31 << 31) | (2 * ((sdram->emc_cfg_pipe << 10 >> 31 << 30) | ((sdram->emc_cfg_pipe << 11 >> 31 << 29) | ((sdram->emc_cfg_pipe << 12 >> 31 << 28) | ((sdram->emc_einput << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank0_4 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank0_4 & 0x7FF | (pmc->scratch151 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch152 = (32 * sdram->emc_cfg_pipe >> 31 << 31) | (2 * ((sdram->emc_cfg_pipe << 6 >> 31 << 30) | ((sdram->emc_cfg_pipe << 7 >> 31 << 29) | ((sdram->emc_cfg_pipe << 8 >> 31 << 28) | ((sdram->emc_einput_duration << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank0_5 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank0_5 & 0x7FF | (pmc->scratch152 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch153 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 29) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 30) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 31) >> 2) | ((16 * sdram->emc_cfg_pipe >> 31 << 28) | ((sdram->emc_puterm_extra << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank1_0 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank1_0 & 0x7FF | (pmc->scratch153 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch154 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 25) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 26) >> 31 << 30) | (((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 28) >> 31 << 28) | ((sdram->emc_tckesr << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank1_1 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank1_1 & 0x7FF | (pmc->scratch154 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF | (((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 27) >> 31 << 29)) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch155 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 21) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 22) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 23) >> 31 << 29) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src0) << 24) >> 31 << 28) | ((sdram->emc_tpd << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank1_2 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank1_2 & 0x7FF | (pmc->scratch155 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch156 = (sdram->emc_pmacro_tx_sel_clk_src0 << 12 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src0 << 13 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src0 << 14 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src0 << 15 >> 31 << 28) | ((sdram->emc_wdv_mask << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank1_3 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank1_3 & 0x7FF | (pmc->scratch156 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch157 = (sdram->emc_pmacro_tx_sel_clk_src0 << 8 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src0 << 9 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src0 << 10 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src0 << 11 >> 31 << 28) | (((u16)(sdram->emc_wdv_chk) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank1_4 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank1_4 & 0x7FF | (pmc->scratch157 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch158 = ((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 31) | (2 * ((32 * sdram->emc_pmacro_tx_sel_clk_src0 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src0 << 6 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src0 << 7 >> 31 << 28) | (((u8)(sdram->emc_cmd_brlshft0) << 26 >> 29 << 25) | (((u8)(sdram->emc_cmd_brlshft0) << 22) & 0x1FFFFFF | ((32 * sdram->emc_pmacro_ob_ddll_long_dqs_rank1_5 >> 21 << 11) | (sdram->emc_pmacro_ob_ddll_long_dqs_rank1_5 & 0x7FF | (pmc->scratch158 >> 11 << 11)) & 0xFFC007FF) & 0xFE3FFFFF) & 0xF1FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch159 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 27) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 28) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 29) >> 31 << 29) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 30) >> 31 << 28) | (((u8)(sdram->emc_cmd_brlshft1) << 26 >> 29 << 25) | (((u8)(sdram->emc_cmd_brlshft1) << 22) & 0x1FFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank0_0 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank0_0 & 0x7FF | (pmc->scratch159 >> 11 << 11)) & 0xFFC007FF) & 0xFE3FFFFF) & 0xF1FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch160 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 23) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 24) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 25) >> 31 << 29) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src1) << 26) >> 31 << 28) | (((u8)(sdram->emc_cmd_brlshft2) << 26 >> 29 << 25) | (((u8)(sdram->emc_cmd_brlshft2) << 22) & 0x1FFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank0_1 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank0_1 & 0x7FF | (pmc->scratch160 >> 11 << 11)) & 0xFFC007FF) & 0xFE3FFFFF) & 0xF1FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch161 = (sdram->emc_pmacro_tx_sel_clk_src1 << 14 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src1 << 15 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src1 << 21 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src1 << 22 >> 31 << 28) | (((u8)(sdram->emc_cmd_brlshft3) << 26 >> 29 << 25) | (((u8)(sdram->emc_cmd_brlshft3) << 22) & 0x1FFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank0_2 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank0_2 & 0x7FF | (pmc->scratch161 >> 11 << 11)) & 0xFFC007FF) & 0xFE3FFFFF) & 0xF1FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch162 = (sdram->emc_pmacro_tx_sel_clk_src1 << 10 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src1 << 11 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src1 << 12 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src1 << 13 >> 31 << 28) | (((u16)(sdram->emc_wev) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank0_3 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank0_3 & 0x7FF | (pmc->scratch162 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch163 = (sdram->emc_pmacro_tx_sel_clk_src1 << 6 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src1 << 7 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src1 << 8 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src1 << 9 >> 31 << 28) | (((u16)(sdram->emc_wsv) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank1_0 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank1_0 & 0x7FF | (pmc->scratch163 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch164 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 29) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 30) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 31) >> 2) | ((32 * sdram->emc_pmacro_tx_sel_clk_src1 >> 31 << 28) | (((u8)(sdram->emc_cfg3) << 25 >> 29 << 25) | (((u8)(sdram->emc_cfg3) << 22) & 0x1FFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank1_1 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank1_1 & 0x7FF | (pmc->scratch164 >> 11 << 11)) & 0xFFC007FF) & 0xFE3FFFFF) & 0xF1FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch165 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 25) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 26) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 27) >> 31 << 29) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 28) >> 31 << 28) | ((sdram->emc_puterm_width << 23) & 0xFFFFFFF | ((sdram->emc_puterm_width >> 31 << 22) | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank1_2 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank1_2 & 0x7FF | (pmc->scratch165 >> 11 << 11)) & 0xFFC007FF) & 0xFFBFFFFF) & 0xF07FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch166 = (((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 21) >> 31 << 31) | (2 * ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 22) >> 31 << 30) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 23) >> 31 << 29) | ((((u16)(sdram->emc_pmacro_tx_sel_clk_src3) << 24) >> 31 << 28) | ((sdram->mc_emem_arb_timing_rcd << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ib_ddll_long_dqs_rank1_3 >> 21 << 11) | (sdram->emc_pmacro_ib_ddll_long_dqs_rank1_3 & 0x7FF | (pmc->scratch166 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch167 = (sdram->emc_pmacro_tx_sel_clk_src3 << 12 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src3 << 13 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src3 << 14 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src3 << 15 >> 31 << 28) | (((u16)(sdram->mc_emem_arb_timing_ccdmw) << 22) & 0xFFFFFFF | ((32 * sdram->emc_pmacro_ddll_long_cmd_0 >> 21 << 11) | (sdram->emc_pmacro_ddll_long_cmd_0 & 0x7FF | (pmc->scratch167 >> 11 << 11)) & 0xFFC007FF) & 0xF03FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch168 = (sdram->emc_pmacro_tx_sel_clk_src3 << 8 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src3 << 9 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src3 << 10 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src3 << 11 >> 31 << 28) | ((sdram->mc_emem_arb_override << 28 >> 31 << 27) | (((sdram->mc_emem_arb_override << 21 >> 31 << 25) | ((sdram->mc_emem_arb_override << 15 >> 31 << 24) | ((32 * sdram->mc_emem_arb_override >> 31 << 23) | ((16 * sdram->mc_emem_arb_override >> 31 << 22) | ((32 * sdram->emc_pmacro_ddll_long_cmd_1 >> 21 << 11) | (sdram->emc_pmacro_ddll_long_cmd_1 & 0x7FF | (pmc->scratch168 >> 11 << 11)) & 0xFFC007FF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF | (sdram->mc_emem_arb_override << 27 >> 31 << 26)) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch169 = ((u16)(sdram->emc_rext) << 27) | (((u16)(sdram->emc_rrd) << 22) | ((32 * sdram->emc_pmacro_ddll_long_cmd_2 >> 21 << 11) | (sdram->emc_pmacro_ddll_long_cmd_2 & 0x7FF | (pmc->scratch169 >> 11 << 11)) & 0xFFC007FF) & 0xF83FFFFF) & 0x7FFFFFF;
// 	pmc->scratch170 = ((u16)(sdram->emc_wext) << 27) | ((sdram->emc_tclkstop << 22) | ((32 * sdram->emc_pmacro_ddll_long_cmd_3 >> 21 << 11) | (sdram->emc_pmacro_ddll_long_cmd_3 & 0x7FF | (pmc->scratch170 >> 11 << 11)) & 0xFFC007FF) & 0xF83FFFFF) & 0x7FFFFFF;
// 	tmp = (32 * sdram->emc_pmacro_perbit_fgcg_ctrl0 >> 31 << 21) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 6 >> 31 << 20) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 7 >> 31 << 19) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 8 >> 31 << 18) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 9 >> 31 << 17) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 10 >> 31 << 16) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 11 >> 31 << 15) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 12 >> 31 << 14) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 13 >> 31 << 13) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 14 >> 31 << 12) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 15 >> 31 << 11) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 21 >> 31 << 10) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 22 >> 31 << 9) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 23 >> 31 << 8) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 24 >> 31 << 7) | ((sdram->emc_pmacro_perbit_fgcg_ctrl0 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_perbit_fgcg_ctrl0 << 26 >> 31) | (16 * (sdram->emc_pmacro_perbit_fgcg_ctrl0 << 27 >> 31) | (8 * (sdram->emc_pmacro_perbit_fgcg_ctrl0 << 28 >> 31) | (4 * (sdram->emc_pmacro_perbit_fgcg_ctrl0 << 29 >> 31) | (2 * (sdram->emc_pmacro_perbit_fgcg_ctrl0 << 30 >> 31) | (sdram->emc_pmacro_perbit_fgcg_ctrl0 & 1 | 2 * (pmc->scratch171 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF;
// 	pmc->scratch171 = (sdram->emc_we_duration << 27) | ((sdram->emc_ref_ctrl2 >> 31 << 26) | ((32 * sdram->emc_ref_ctrl2 >> 29 << 23) | ((sdram->emc_ref_ctrl2 << 22) & 0x7FFFFF | tmp & 0xFFBFFFFF) & 0xFC7FFFFF) & 0xFBFFFFFF) & 0x7FFFFFF;
// 	tmp = (sdram->emc_pmacro_pad_cfg_ctrl << 22 >> 31 << 28) | ((sdram->emc_pmacro_pad_cfg_ctrl << 27) & 0xFFFFFFF | ((sdram->emc_ws_duration << 22) & 0x7FFFFFF | ((32 * sdram->emc_pmacro_perbit_fgcg_ctrl1 >> 31 << 21) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 6 >> 31 << 20) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 7 >> 31 << 19) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 8 >> 31 << 18) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 9 >> 31 << 17) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 10 >> 31 << 16) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 11 >> 31 << 15) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 12 >> 31 << 14) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 13 >> 31 << 13) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 14 >> 31 << 12) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 15 >> 31 << 11) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 21 >> 31 << 10) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 22 >> 31 << 9) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 23 >> 31 << 8) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 24 >> 31 << 7) | ((sdram->emc_pmacro_perbit_fgcg_ctrl1 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_perbit_fgcg_ctrl1 << 26 >> 31) | (16 * (sdram->emc_pmacro_perbit_fgcg_ctrl1 << 27 >> 31) | (8 * (sdram->emc_pmacro_perbit_fgcg_ctrl1 << 28 >> 31) | (4 * (sdram->emc_pmacro_perbit_fgcg_ctrl1 << 29 >> 31) | (2 * (sdram->emc_pmacro_perbit_fgcg_ctrl1 << 30 >> 31) | (sdram->emc_pmacro_perbit_fgcg_ctrl1 & 1 | 2 * (pmc->scratch172 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xF83FFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF;
// 	pmc->scratch172 = (sdram->emc_pmacro_pad_cfg_ctrl << 14 >> 30 << 30) | (4 * ((sdram->emc_pmacro_pad_cfg_ctrl << 18 >> 31 << 29) | tmp & 0xDFFFFFFF) >> 2);
// 	pmc->scratch173 = ((u8)(sdram->mc_emem_arb_timing_r2r) << 27) | ((sdram->mc_emem_arb_timing_rrd << 22) | ((32 * sdram->emc_pmacro_perbit_fgcg_ctrl2 >> 31 << 21) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 6 >> 31 << 20) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 7 >> 31 << 19) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 8 >> 31 << 18) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 9 >> 31 << 17) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 10 >> 31 << 16) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 11 >> 31 << 15) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 12 >> 31 << 14) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 13 >> 31 << 13) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 14 >> 31 << 12) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 15 >> 31 << 11) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 21 >> 31 << 10) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 22 >> 31 << 9) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 23 >> 31 << 8) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 24 >> 31 << 7) | ((sdram->emc_pmacro_perbit_fgcg_ctrl2 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_perbit_fgcg_ctrl2 << 26 >> 31) | (16 * (sdram->emc_pmacro_perbit_fgcg_ctrl2 << 27 >> 31) | (8 * (sdram->emc_pmacro_perbit_fgcg_ctrl2 << 28 >> 31) | (4 * (sdram->emc_pmacro_perbit_fgcg_ctrl2 << 29 >> 31) | (2 * (sdram->emc_pmacro_perbit_fgcg_ctrl2 << 30 >> 31) | (sdram->emc_pmacro_perbit_fgcg_ctrl2 & 1 | 2 * (pmc->scratch173 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xF83FFFFF) & 0x7FFFFFF;
// 	tmp = 32 * (sdram->emc_pmacro_perbit_fgcg_ctrl3 << 26 >> 31) | (16 * (sdram->emc_pmacro_perbit_fgcg_ctrl3 << 27 >> 31) | (8 * (sdram->emc_pmacro_perbit_fgcg_ctrl3 << 28 >> 31) | (4 * (sdram->emc_pmacro_perbit_fgcg_ctrl3 << 29 >> 31) | (2 * (sdram->emc_pmacro_perbit_fgcg_ctrl3 << 30 >> 31) | (sdram->emc_pmacro_perbit_fgcg_ctrl3 & 1 | 2 * (pmc->scratch174 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF;
// 	pmc->scratch174 = ((u16)(sdram->emc_pmacro_tx_sel_clk_src2) << 30 >> 31 << 31) | (2 * (((u16)(sdram->emc_pmacro_tx_sel_clk_src2) << 30) | ((32 * sdram->emc_pmacro_tx_sel_clk_src3 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src3 << 6 >> 31 << 28) | ((sdram->emc_pmacro_tx_sel_clk_src3 << 7 >> 31 << 27) | (((u8)(sdram->mc_emem_arb_timing_w2w) << 22) & 0x7FFFFFF | ((32 * sdram->emc_pmacro_perbit_fgcg_ctrl3 >> 31 << 21) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 6 >> 31 << 20) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 7 >> 31 << 19) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 8 >> 31 << 18) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 9 >> 31 << 17) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 10 >> 31 << 16) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 11 >> 31 << 15) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 12 >> 31 << 14) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 13 >> 31 << 13) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 14 >> 31 << 12) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 15 >> 31 << 11) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 21 >> 31 << 10) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 22 >> 31 << 9) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 23 >> 31 << 8) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 24 >> 31 << 7) | ((sdram->emc_pmacro_perbit_fgcg_ctrl3 << 25 >> 31 << 6) | tmp & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xF83FFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	tmp = (sdram->emc_pmacro_tx_sel_clk_src2 << 28 >> 31 << 23) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 29 >> 31 << 22) | ((32 * sdram->emc_pmacro_perbit_fgcg_ctrl4 >> 31 << 21) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 6 >> 31 << 20) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 7 >> 31 << 19) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 8 >> 31 << 18) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 9 >> 31 << 17) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 10 >> 31 << 16) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 11 >> 31 << 15) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 12 >> 31 << 14) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 13 >> 31 << 13) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 14 >> 31 << 12) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 15 >> 31 << 11) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 21 >> 31 << 10) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 22 >> 31 << 9) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 23 >> 31 << 8) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 24 >> 31 << 7) | ((sdram->emc_pmacro_perbit_fgcg_ctrl4 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_perbit_fgcg_ctrl4 << 26 >> 31) | (16 * (sdram->emc_pmacro_perbit_fgcg_ctrl4 << 27 >> 31) | (8 * (sdram->emc_pmacro_perbit_fgcg_ctrl4 << 28 >> 31) | (4 * (sdram->emc_pmacro_perbit_fgcg_ctrl4 << 29 >> 31) | (2 * (sdram->emc_pmacro_perbit_fgcg_ctrl4 << 30 >> 31) | (sdram->emc_pmacro_perbit_fgcg_ctrl4 & 1 | 2 * (pmc->scratch175 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF;
// 	pmc->scratch175 = (sdram->emc_pmacro_tx_sel_clk_src2 << 15 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src2 << 21 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 22 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 23 >> 31 << 28) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 24 >> 31 << 27) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 25 >> 31 << 26) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 26 >> 31 << 25) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 27 >> 31 << 24) | tmp & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	tmp = (sdram->emc_pmacro_tx_sel_clk_src2 << 12 >> 31 << 24) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 13 >> 31 << 23) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 14 >> 31 << 22) | ((32 * sdram->emc_pmacro_perbit_fgcg_ctrl5 >> 31 << 21) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 6 >> 31 << 20) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 7 >> 31 << 19) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 8 >> 31 << 18) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 9 >> 31 << 17) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 10 >> 31 << 16) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 11 >> 31 << 15) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 12 >> 31 << 14) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 13 >> 31 << 13) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 14 >> 31 << 12) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 15 >> 31 << 11) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 21 >> 31 << 10) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 22 >> 31 << 9) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 23 >> 31 << 8) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 24 >> 31 << 7) | ((sdram->emc_pmacro_perbit_fgcg_ctrl5 << 25 >> 31 << 6) | (32 * (sdram->emc_pmacro_perbit_fgcg_ctrl5 << 26 >> 31) | (16 * (sdram->emc_pmacro_perbit_fgcg_ctrl5 << 27 >> 31) | (8 * (sdram->emc_pmacro_perbit_fgcg_ctrl5 << 28 >> 31) | (4 * (sdram->emc_pmacro_perbit_fgcg_ctrl5 << 29 >> 31) | (2 * (sdram->emc_pmacro_perbit_fgcg_ctrl5 << 30 >> 31) | (sdram->emc_pmacro_perbit_fgcg_ctrl5 & 1 | 2 * (pmc->scratch176 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF;
// 	pmc->scratch176 = (32 * sdram->emc_pmacro_tx_sel_clk_src2 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src2 << 6 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 7 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 8 >> 31 << 28) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 9 >> 31 << 27) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 10 >> 31 << 26) | ((sdram->emc_pmacro_tx_sel_clk_src2 << 11 >> 31 << 25) | tmp & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch177 = (sdram->emc_pmacro_tx_sel_clk_src4 << 22 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src4 << 23 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 24 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 25 >> 31 << 28) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 26 >> 31 << 27) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 27 >> 31 << 26) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 28 >> 31 << 25) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 29 >> 31 << 24) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 30 >> 31 << 23) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 22) & 0x7FFFFF | ((sdram->mc_emem_arb_cfg >> 28 << 18) | ((16 * sdram->mc_emem_arb_cfg >> 28 << 14) | ((sdram->mc_emem_arb_cfg << 11 >> 27 << 9) | (sdram->mc_emem_arb_cfg & 0x1FF | (pmc->scratch177 >> 9 << 9)) & 0xFFFFC1FF) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch178 = (sdram->emc_pmacro_tx_sel_clk_src4 << 7 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src4 << 8 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 9 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 10 >> 31 << 28) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 11 >> 31 << 27) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 12 >> 31 << 26) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 13 >> 31 << 25) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 14 >> 31 << 24) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 15 >> 31 << 23) | ((sdram->emc_pmacro_tx_sel_clk_src4 << 21 >> 31 << 22) | ((sdram->mc_emem_arb_misc1 >> 28 << 18) | ((sdram->mc_emem_arb_misc1 << 6 >> 30 << 16) | ((sdram->mc_emem_arb_misc1 << 8 >> 29 << 13) | (16 * (sdram->mc_emem_arb_misc1 << 19 >> 23) | (8 * (sdram->mc_emem_arb_misc1 << 28 >> 31) | (4 * (sdram->mc_emem_arb_misc1 << 29 >> 31) | (2 * (sdram->mc_emem_arb_misc1 << 30 >> 31) | (sdram->mc_emem_arb_misc1 & 1 | 2 * (pmc->scratch178 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFE00F) & 0xFFFF1FFF) & 0xFFFCFFFF) & 0xFFC3FFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch179 = (sdram->emc_odt_write >> 31 << 31) | (2 * ((sdram->emc_odt_write << 20 >> 28 << 27) | ((sdram->emc_odt_write << 26 >> 31 << 26) | ((sdram->emc_odt_write << 27 >> 31 << 25) | ((sdram->emc_odt_write << 21) & 0x1FFFFFF | ((32 * sdram->emc_mrs_wait_cnt2 >> 21 << 10) | (sdram->emc_mrs_wait_cnt2 & 0x3FF | (pmc->scratch179 >> 10 << 10)) & 0xFFE003FF) & 0xFE1FFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0x87FFFFFF) >> 1);
// 	pmc->scratch180 = (sdram->emc_pmacro_ib_rxrt << 21) | ((32 * sdram->emc_mrs_wait_cnt >> 21 << 10) | (sdram->emc_mrs_wait_cnt & 0x3FF | (pmc->scratch180 >> 10 << 10)) & 0xFFE003FF) & 0x1FFFFF;
// 	pmc->scratch181 = ((u16)(sdram->emc_pmacro_ddll_long_cmd_4) << 21) | sdram->emc_auto_cal_interval & 0x1FFFFF;
// 	pmc->scratch182 = (sdram->mc_emem_arb_outstanding_req >> 31 << 31) | (2 * ((2 * sdram->mc_emem_arb_outstanding_req >> 31 << 30) | ((sdram->mc_emem_arb_outstanding_req << 23 >> 2) | ((sdram->emc_emem_arb_refpb_hp_ctrl << 9 >> 25 << 14) | ((sdram->emc_emem_arb_refpb_hp_ctrl << 17 >> 25 << 7) | (sdram->emc_emem_arb_refpb_hp_ctrl & 0x7F | (pmc->scratch182 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xC01FFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch183 = (4 * sdram->emc_pmacro_cmd_ctrl0 >> 31 << 31) | (2 * ((8 * sdram->emc_pmacro_cmd_ctrl0 >> 31 << 30) | ((sdram->emc_pmacro_cmd_ctrl0 << 7 >> 31 << 29) | ((sdram->emc_pmacro_cmd_ctrl0 << 10 >> 31 << 28) | ((sdram->emc_pmacro_cmd_ctrl0 << 11 >> 31 << 27) | ((sdram->emc_pmacro_cmd_ctrl0 << 15 >> 31 << 26) | ((sdram->emc_pmacro_cmd_ctrl0 << 18 >> 31 << 25) | ((sdram->emc_pmacro_cmd_ctrl0 << 19 >> 31 << 24) | ((sdram->emc_pmacro_cmd_ctrl0 << 23 >> 31 << 23) | ((sdram->emc_pmacro_cmd_ctrl0 << 26 >> 31 << 22) | ((sdram->emc_pmacro_cmd_ctrl0 << 27 >> 31 << 21) | ((sdram->emc_pmacro_cmd_ctrl0 << 20) & 0x1FFFFF | ((4 * sdram->emc_xm2_comp_pad_ctrl2 >> 26 << 14) | ((sdram->emc_xm2_comp_pad_ctrl2 << 10 >> 30 << 12) | ((sdram->emc_xm2_comp_pad_ctrl2 << 14 >> 31 << 11) | ((sdram->emc_xm2_comp_pad_ctrl2 << 15 >> 31 << 10) | ((sdram->emc_xm2_comp_pad_ctrl2 << 16 >> 30 << 8) | ((sdram->emc_xm2_comp_pad_ctrl2 << 18 >> 30 << 6) | (4 * (sdram->emc_xm2_comp_pad_ctrl2 << 26 >> 28) | (sdram->emc_xm2_comp_pad_ctrl2 & 3 | 4 * (pmc->scratch183 >> 2)) & 0xFFFFFFC3) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFCFFF) & 0xFFF03FFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch184 = (4 * sdram->emc_pmacro_cmd_ctrl1 >> 31 << 31) | (2 * ((8 * sdram->emc_pmacro_cmd_ctrl1 >> 31 << 30) | ((sdram->emc_pmacro_cmd_ctrl1 << 7 >> 31 << 29) | ((sdram->emc_pmacro_cmd_ctrl1 << 10 >> 31 << 28) | ((sdram->emc_pmacro_cmd_ctrl1 << 11 >> 31 << 27) | ((sdram->emc_pmacro_cmd_ctrl1 << 15 >> 31 << 26) | ((sdram->emc_pmacro_cmd_ctrl1 << 18 >> 31 << 25) | ((sdram->emc_pmacro_cmd_ctrl1 << 19 >> 31 << 24) | ((sdram->emc_pmacro_cmd_ctrl1 << 23 >> 31 << 23) | ((sdram->emc_pmacro_cmd_ctrl1 << 26 >> 31 << 22) | ((sdram->emc_pmacro_cmd_ctrl1 << 27 >> 31 << 21) | ((sdram->emc_pmacro_cmd_ctrl1 << 20) & 0x1FFFFF | ((sdram->emc_cfg_dig_dll_1 << 12 >> 28 << 16) | ((sdram->emc_cfg_dig_dll_1 << 16 >> 28 << 12) | ((sdram->emc_cfg_dig_dll_1 << 20 >> 26 << 6) | (2 * (sdram->emc_cfg_dig_dll_1 << 26 >> 27) | (sdram->emc_cfg_dig_dll_1 & 1 | 2 * (pmc->scratch184 >> 1)) & 0xFFFFFFC1) & 0xFFFFF03F) & 0xFFFF0FFF) & 0xFFF0FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch185 = (4 * sdram->emc_pmacro_cmd_ctrl2 >> 31 << 31) | (2 * ((8 * sdram->emc_pmacro_cmd_ctrl2 >> 31 << 30) | ((sdram->emc_pmacro_cmd_ctrl2 << 7 >> 31 << 29) | ((sdram->emc_pmacro_cmd_ctrl2 << 10 >> 31 << 28) | ((sdram->emc_pmacro_cmd_ctrl2 << 11 >> 31 << 27) | ((sdram->emc_pmacro_cmd_ctrl2 << 15 >> 31 << 26) | ((sdram->emc_pmacro_cmd_ctrl2 << 18 >> 31 << 25) | ((sdram->emc_pmacro_cmd_ctrl2 << 19 >> 31 << 24) | ((sdram->emc_pmacro_cmd_ctrl2 << 23 >> 31 << 23) | ((sdram->emc_pmacro_cmd_ctrl2 << 26 >> 31 << 22) | ((sdram->emc_pmacro_cmd_ctrl2 << 27 >> 31 << 21) | ((sdram->emc_pmacro_cmd_ctrl2 << 20) & 0x1FFFFF | ((sdram->emc_quse_brlshft0 << 12 >> 27 << 15) | ((sdram->emc_quse_brlshft0 << 17 >> 27 << 10) | (32 * (sdram->emc_quse_brlshft0 << 22 >> 27) | (sdram->emc_quse_brlshft0 & 0x1F | 32 * (pmc->scratch185 >> 5)) & 0xFFFFFC1F) & 0xFFFF83FF) & 0xFFF07FFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch186 = (sdram->emc_pmacro_dsr_vttgen_ctrl0 >> 8 << 24) | ((sdram->emc_pmacro_dsr_vttgen_ctrl0 << 20) | ((sdram->emc_quse_brlshft1 << 12 >> 27 << 15) | ((sdram->emc_quse_brlshft1 << 17 >> 27 << 10) | (32 * (sdram->emc_quse_brlshft1 << 22 >> 27) | (sdram->emc_quse_brlshft1 & 0x1F | 32 * (pmc->scratch186 >> 5)) & 0xFFFFFC1F) & 0xFFFF83FF) & 0xFFF07FFF) & 0xFF0FFFFF) & 0xFFFFFF;
// 	pmc->scratch187 = (sdram->emc_pmacro_perbit_rfu1_ctrl0 << 10 >> 30 << 30) | (4 * ((sdram->emc_pmacro_perbit_rfu1_ctrl0 << 12 >> 30 << 28) | ((sdram->emc_pmacro_perbit_rfu1_ctrl0 << 14 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu1_ctrl0 << 26 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu1_ctrl0 << 28 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu1_ctrl0 << 20) & 0x3FFFFF | ((sdram->emc_quse_brlshft2 << 12 >> 27 << 15) | ((sdram->emc_quse_brlshft2 << 17 >> 27 << 10) | (32 * (sdram->emc_quse_brlshft2 << 22 >> 27) | (sdram->emc_quse_brlshft2 & 0x1F | 32 * (pmc->scratch187 >> 5)) & 0xFFFFFC1F) & 0xFFFF83FF) & 0xFFF07FFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch188 = (sdram->emc_pmacro_perbit_rfu1_ctrl1 << 10 >> 30 << 30) | (4 * ((sdram->emc_pmacro_perbit_rfu1_ctrl1 << 12 >> 30 << 28) | ((sdram->emc_pmacro_perbit_rfu1_ctrl1 << 14 >> 30 << 26) | ((sdram->emc_pmacro_perbit_rfu1_ctrl1 << 26 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu1_ctrl1 << 28 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu1_ctrl1 << 20) & 0x3FFFFF | ((sdram->emc_quse_brlshft3 << 12 >> 27 << 15) | ((sdram->emc_quse_brlshft3 << 17 >> 27 << 10) | (32 * (sdram->emc_quse_brlshft3 << 22 >> 27) | (sdram->emc_quse_brlshft3 & 0x1F | 32 * (pmc->scratch188 >> 5)) & 0xFFFFFC1F) & 0xFFFF83FF) & 0xFFF07FFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->scratch189 = (sdram->emc_trefbw << 18) | ((sdram->emc_dbg >> 31 << 17) | ((2 * sdram->emc_dbg >> 31 << 16) | ((4 * sdram->emc_dbg >> 31 << 15) | ((8 * sdram->emc_dbg >> 31 << 14) | ((16 * sdram->emc_dbg >> 30 << 12) | ((sdram->emc_dbg << 6 >> 31 << 11) | ((sdram->emc_dbg << 7 >> 31 << 10) | ((sdram->emc_dbg << 18 >> 31 << 9) | ((sdram->emc_dbg << 19 >> 31 << 8) | ((sdram->emc_dbg << 20 >> 31 << 7) | ((sdram->emc_dbg << 21 >> 31 << 6) | (32 * (sdram->emc_dbg << 22 >> 31) | (16 * (sdram->emc_dbg << 27 >> 31) | (8 * (sdram->emc_dbg << 28 >> 31) | (4 * (sdram->emc_dbg << 29 >> 31) | (2 * (sdram->emc_dbg << 30 >> 31) | (sdram->emc_dbg & 1 | 2 * (pmc->scratch189 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFCFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0x3FFFF;
// 	pmc->scratch191 = (sdram->emc_qpop << 9 >> 25 << 25) | ((sdram->emc_qpop << 18) | ((sdram->emc_zcal_wait_cnt >> 31 << 17) | ((sdram->emc_zcal_wait_cnt << 10 >> 26 << 11) | (sdram->emc_zcal_wait_cnt & 0x7FF | (pmc->scratch191 >> 11 << 11)) & 0xFFFE07FF) & 0xFFFDFFFF) & 0xFE03FFFF) & 0x1FFFFFF;
// 	pmc->scratch192 = (sdram->emc_pmacro_tx_sel_clk_src4 << 6 >> 31 << 31) | (2 * ((sdram->emc_pmacro_auto_cal_common << 15 >> 31 << 30) | ((sdram->emc_pmacro_auto_cal_common << 18 >> 26 << 24) | ((sdram->emc_pmacro_auto_cal_common << 18) & 0xFFFFFF | ((sdram->emc_zcal_mrw_cmd >> 30 << 16) | ((sdram->emc_zcal_mrw_cmd << 8 >> 24 << 8) | (sdram->emc_zcal_mrw_cmd & 0xFF | (pmc->scratch192 >> 8 << 8)) & 0xFFFF00FF) & 0xFFFCFFFF) & 0xFF03FFFF) & 0xC0FFFFFF) & 0xBFFFFFFF) >> 1);
// 	tmp = (sdram->emc_dll_cfg1 << 7 >> 31 << 17) | ((sdram->emc_dll_cfg1 << 10 >> 31 << 16) | ((sdram->emc_dll_cfg1 << 11 >> 31 << 15) | ((sdram->emc_dll_cfg1 << 14 >> 30 << 13) | ((sdram->emc_dll_cfg1 << 18 >> 31 << 12) | ((sdram->emc_dll_cfg1 << 19 >> 31 << 11) | ((pmc->scratch193 >> 11 << 11) | sdram->emc_dll_cfg1 & 0x7FF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFF9FFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF;
// 	pmc->scratch193 = (sdram->emc_pmacro_tx_sel_clk_src5 << 31) | (2 * ((32 * sdram->emc_pmacro_tx_sel_clk_src4 >> 31 << 30) | ((sdram->emc_pmacro_perbit_rfu1_ctrl2 << 10 >> 30 << 28) | (((sdram->emc_pmacro_perbit_rfu1_ctrl2 << 14 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu1_ctrl2 << 26 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu1_ctrl2 << 28 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu1_ctrl2 << 18) & 0xFFFFF | tmp & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF | (sdram->emc_pmacro_perbit_rfu1_ctrl2 << 12 >> 30 << 26)) & 0xCFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch194 = (sdram->emc_pmacro_tx_sel_clk_src5 << 29 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src5 << 30 >> 31 << 30) | ((sdram->emc_pmacro_perbit_rfu1_ctrl3 << 10 >> 30 << 28) | (((sdram->emc_pmacro_perbit_rfu1_ctrl3 << 14 >> 30 << 24) | (((sdram->emc_pmacro_perbit_rfu1_ctrl3 << 28 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu1_ctrl3 << 18) & 0xFFFFF | ((sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 14 >> 30 << 16) | ((sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 16 >> 30 << 14) | ((sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 18 >> 30 << 12) | ((sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 20 >> 30 << 10) | ((sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 22 >> 30 << 8) | ((sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 26 >> 30) | (4 * (sdram->emc_pmacro_cmd_brick_ctrl_fdpd << 28 >> 30) | (sdram->emc_pmacro_cmd_brick_ctrl_fdpd & 3 | 4 * (pmc->scratch194 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF | (sdram->emc_pmacro_perbit_rfu1_ctrl3 << 26 >> 30 << 22)) & 0xFCFFFFFF) & 0xF3FFFFFF | (sdram->emc_pmacro_perbit_rfu1_ctrl3 << 12 >> 30 << 26)) & 0xCFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch195 = (sdram->emc_pmacro_tx_sel_clk_src5 << 27 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src5 << 28 >> 31 << 30) | ((sdram->emc_pmacro_perbit_rfu1_ctrl4 << 10 >> 30 << 28) | (((sdram->emc_pmacro_perbit_rfu1_ctrl4 << 14 >> 30 << 24) | ((sdram->emc_pmacro_perbit_rfu1_ctrl4 << 26 >> 30 << 22) | ((sdram->emc_pmacro_perbit_rfu1_ctrl4 << 28 >> 30 << 20) | ((sdram->emc_pmacro_perbit_rfu1_ctrl4 << 18) & 0xFFFFF | ((sdram->emc_pmacro_data_brick_ctrl_fdpd << 14 >> 30 << 16) | ((sdram->emc_pmacro_data_brick_ctrl_fdpd << 16 >> 30 << 14) | ((sdram->emc_pmacro_data_brick_ctrl_fdpd << 18 >> 30 << 12) | ((sdram->emc_pmacro_data_brick_ctrl_fdpd << 20 >> 30 << 10) | ((sdram->emc_pmacro_data_brick_ctrl_fdpd << 22 >> 30 << 8) | ((sdram->emc_pmacro_data_brick_ctrl_fdpd << 24 >> 30 << 6) | (16 * (sdram->emc_pmacro_data_brick_ctrl_fdpd << 26 >> 30) | (4 * (sdram->emc_pmacro_data_brick_ctrl_fdpd << 28 >> 30) | (sdram->emc_pmacro_data_brick_ctrl_fdpd & 3 | 4 * (pmc->scratch195 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFCF) & 0xFFFFFF3F) & 0xFFFFFCFF) & 0xFFFFF3FF) & 0xFFFFCFFF) & 0xFFFF3FFF) & 0xFFFCFFFF) & 0xFFF3FFFF) & 0xFFCFFFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xF3FFFFFF | (sdram->emc_pmacro_perbit_rfu1_ctrl4 << 12 >> 30 << 26)) & 0xCFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch196 = (sdram->emc_emem_arb_refpb_bank_ctrl >> 31 << 31) | (2 * ((sdram->emc_emem_arb_refpb_bank_ctrl << 17 >> 25 << 24) | ((sdram->emc_emem_arb_refpb_bank_ctrl << 17) & 0xFFFFFF | ((sdram->emc_dyn_self_ref_control >> 31 << 16) | (sdram->emc_dyn_self_ref_control & 0xFFFF | (pmc->scratch196 >> 16 << 16)) & 0xFFFEFFFF) & 0xFF01FFFF) & 0x80FFFFFF) >> 1);
// 	pmc->scratch197 = (sdram->emc_pmacro_tx_sel_clk_src5 << 24 >> 31 << 31) | (2 * ((sdram->emc_pmacro_tx_sel_clk_src5 << 25 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 26 >> 31 << 29) | ((sdram->emc_pmacro_perbit_rfu1_ctrl5 << 10 >> 30 << 27) | (((sdram->emc_pmacro_perbit_rfu1_ctrl5 << 14 >> 30 << 23) | ((sdram->emc_pmacro_perbit_rfu1_ctrl5 << 26 >> 30 << 21) | ((sdram->emc_pmacro_perbit_rfu1_ctrl5 << 28 >> 30 << 19) | ((sdram->emc_pmacro_perbit_rfu1_ctrl5 << 17) & 0x7FFFF | ((16 * sdram->emc_pmacro_cmd_pad_rx_ctrl >> 28 << 13) | ((sdram->emc_pmacro_cmd_pad_rx_ctrl << 8 >> 31 << 12) | ((sdram->emc_pmacro_cmd_pad_rx_ctrl << 9 >> 31 << 11) | ((sdram->emc_pmacro_cmd_pad_rx_ctrl << 10 >> 31 << 10) | ((sdram->emc_pmacro_cmd_pad_rx_ctrl << 12 >> 28 << 6) | (32 * (sdram->emc_pmacro_cmd_pad_rx_ctrl << 16 >> 31) | (16 * (sdram->emc_pmacro_cmd_pad_rx_ctrl << 19 >> 31) | (4 * (sdram->emc_pmacro_cmd_pad_rx_ctrl << 26 >> 30) | (sdram->emc_pmacro_cmd_pad_rx_ctrl & 3 | 4 * (pmc->scratch197 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFC3F) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFE1FFF) & 0xFFF9FFFF) & 0xFFE7FFFF) & 0xFF9FFFFF) & 0xFE7FFFFF) & 0xF9FFFFFF | (sdram->emc_pmacro_perbit_rfu1_ctrl5 << 12 >> 30 << 25)) & 0xE7FFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch198 = (sdram->emc_pmacro_cmd_pad_tx_ctrl << 31) | (2 * ((32 * sdram->emc_pmacro_tx_sel_clk_src5 >> 31 << 30) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 6 >> 31 << 29) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 7 >> 31 << 28) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 8 >> 31 << 27) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 9 >> 31 << 26) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 10 >> 31 << 25) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 11 >> 31 << 24) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 12 >> 31 << 23) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 13 >> 31 << 22) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 14 >> 31 << 21) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 15 >> 31 << 20) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 21 >> 31 << 19) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 22 >> 31 << 18) | ((sdram->emc_pmacro_tx_sel_clk_src5 << 23 >> 31 << 17) | ((16 * sdram->emc_pmacro_data_pad_rx_ctrl >> 28 << 13) | ((sdram->emc_pmacro_data_pad_rx_ctrl << 8 >> 31 << 12) | ((sdram->emc_pmacro_data_pad_rx_ctrl << 9 >> 31 << 11) | ((sdram->emc_pmacro_data_pad_rx_ctrl << 10 >> 31 << 10) | ((sdram->emc_pmacro_data_pad_rx_ctrl << 12 >> 28 << 6) | (32 * (sdram->emc_pmacro_data_pad_rx_ctrl << 16 >> 31) | (16 * (sdram->emc_pmacro_data_pad_rx_ctrl << 19 >> 31) | (4 * (sdram->emc_pmacro_data_pad_rx_ctrl << 26 >> 30) | (sdram->emc_pmacro_data_pad_rx_ctrl & 3 | 4 * (pmc->scratch198 >> 2)) & 0xFFFFFFF3) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFC3F) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFE1FFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch199 = (8 * sdram->emc_cmd_q >> 27 << 27) | ((sdram->emc_cmd_q << 17 >> 29 << 24) | ((sdram->emc_cmd_q << 21 >> 29 << 21) | ((sdram->emc_cmd_q << 16) & 0x1FFFFF | (((u16)(sdram->emc_refresh) << 16 >> 22 << 6) | (sdram->emc_refresh & 0x3F | (pmc->scratch199 >> 6 << 6)) & 0xFFFF003F) & 0xFFE0FFFF) & 0xFF1FFFFF) & 0xF8FFFFFF) & 0x7FFFFFF;
// 	pmc->scratch210 = (sdram->emc_auto_cal_vref_sel1 << 16 >> 31 << 31) | (2 * ((sdram->emc_auto_cal_vref_sel1 << 17 >> 25 << 24) | ((sdram->emc_auto_cal_vref_sel1 << 24 >> 31 << 23) | ((sdram->emc_auto_cal_vref_sel1 << 16) & 0x7FFFFF | (sdram->emc_acpd_control & 0xFFFF | (pmc->scratch210 >> 16 << 16)) & 0xFF80FFFF) & 0xFF7FFFFF) & 0x80FFFFFF) >> 1);
// 	tmp = 8 * (sdram->emc_pmacro_auto_cal_cfg0 << 28 >> 31) | (4 * (sdram->emc_pmacro_auto_cal_cfg0 << 29 >> 31) | (2 * (sdram->emc_pmacro_auto_cal_cfg0 << 30 >> 31) | (sdram->emc_pmacro_auto_cal_cfg0 & 1 | 2 * (pmc->scratch211 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7;
// 	tmp = (sdram->emc_pmacro_auto_cal_cfg1 << 7 >> 31 << 28) | ((sdram->emc_pmacro_auto_cal_cfg1 << 12 >> 31 << 27) | ((sdram->emc_pmacro_auto_cal_cfg1 << 13 >> 31 << 26) | ((sdram->emc_pmacro_auto_cal_cfg1 << 14 >> 31 << 25) | ((sdram->emc_pmacro_auto_cal_cfg1 << 15 >> 31 << 24) | ((sdram->emc_pmacro_auto_cal_cfg1 << 20 >> 31 << 23) | ((sdram->emc_pmacro_auto_cal_cfg1 << 21 >> 31 << 22) | ((sdram->emc_pmacro_auto_cal_cfg1 << 22 >> 31 << 21) | ((sdram->emc_pmacro_auto_cal_cfg1 << 23 >> 31 << 20) | ((sdram->emc_pmacro_auto_cal_cfg1 << 28 >> 31 << 19) | ((sdram->emc_pmacro_auto_cal_cfg1 << 29 >> 31 << 18) | ((sdram->emc_pmacro_auto_cal_cfg1 << 30 >> 31 << 17) | ((sdram->emc_pmacro_auto_cal_cfg1 << 16) & 0x1FFFF | ((16 * sdram->emc_pmacro_auto_cal_cfg0 >> 31 << 15) | ((32 * sdram->emc_pmacro_auto_cal_cfg0 >> 31 << 14) | ((sdram->emc_pmacro_auto_cal_cfg0 << 6 >> 31 << 13) | ((sdram->emc_pmacro_auto_cal_cfg0 << 7 >> 31 << 12) | ((sdram->emc_pmacro_auto_cal_cfg0 << 12 >> 31 << 11) | ((sdram->emc_pmacro_auto_cal_cfg0 << 13 >> 31 << 10) | ((sdram->emc_pmacro_auto_cal_cfg0 << 14 >> 31 << 9) | ((sdram->emc_pmacro_auto_cal_cfg0 << 15 >> 31 << 8) | ((sdram->emc_pmacro_auto_cal_cfg0 << 20 >> 31 << 7) | ((sdram->emc_pmacro_auto_cal_cfg0 << 21 >> 31 << 6) | (32 * (sdram->emc_pmacro_auto_cal_cfg0 << 22 >> 31) | (16 * (sdram->emc_pmacro_auto_cal_cfg0 << 23 >> 31) | tmp & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF;
// 	pmc->scratch211 = (16 * sdram->emc_pmacro_auto_cal_cfg1 >> 31 << 31) | (2 * ((32 * sdram->emc_pmacro_auto_cal_cfg1 >> 31 << 30) | ((sdram->emc_pmacro_auto_cal_cfg1 << 6 >> 31 << 29) | tmp & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->scratch212 = (sdram->emc_xm2_comp_pad_ctrl3 << 8 >> 28 << 28) | ((sdram->emc_xm2_comp_pad_ctrl3 << 14 >> 31 << 27) | ((sdram->emc_xm2_comp_pad_ctrl3 << 15 >> 31 << 26) | ((sdram->emc_xm2_comp_pad_ctrl3 << 16 >> 30 << 24) | ((sdram->emc_xm2_comp_pad_ctrl3 << 18 >> 30 << 22) | ((sdram->emc_xm2_comp_pad_ctrl3 << 26 >> 28 << 18) | ((sdram->emc_xm2_comp_pad_ctrl3 << 16) & 0x3FFFF | ((16 * sdram->emc_pmacro_auto_cal_cfg2 >> 31 << 15) | ((32 * sdram->emc_pmacro_auto_cal_cfg2 >> 31 << 14) | ((sdram->emc_pmacro_auto_cal_cfg2 << 6 >> 31 << 13) | ((sdram->emc_pmacro_auto_cal_cfg2 << 7 >> 31 << 12) | ((sdram->emc_pmacro_auto_cal_cfg2 << 12 >> 31 << 11) | ((sdram->emc_pmacro_auto_cal_cfg2 << 13 >> 31 << 10) | ((sdram->emc_pmacro_auto_cal_cfg2 << 14 >> 31 << 9) | ((sdram->emc_pmacro_auto_cal_cfg2 << 15 >> 31 << 8) | ((sdram->emc_pmacro_auto_cal_cfg2 << 20 >> 31 << 7) | ((sdram->emc_pmacro_auto_cal_cfg2 << 21 >> 31 << 6) | (32 * (sdram->emc_pmacro_auto_cal_cfg2 << 22 >> 31) | (16 * (sdram->emc_pmacro_auto_cal_cfg2 << 23 >> 31) | (8 * (sdram->emc_pmacro_auto_cal_cfg2 << 28 >> 31) | (4 * (sdram->emc_pmacro_auto_cal_cfg2 << 29 >> 31) | (2 * (sdram->emc_pmacro_auto_cal_cfg2 << 30 >> 31) | (sdram->emc_pmacro_auto_cal_cfg2 & 1 | 2 * (pmc->scratch212 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFCFFFF) & 0xFFC3FFFF) & 0xFF3FFFFF) & 0xFCFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xFFFFFFF;
// 	pmc->scratch213 = ((u16)(sdram->emc_prerefresh_req_cnt) << 16) | (u16)(sdram->emc_cfg_dig_dll_period);
// 	pmc->scratch214 = (sdram->emc_pmacro_data_pi_ctrl << 10 >> 26 << 26) | ((sdram->emc_pmacro_data_pi_ctrl << 19 >> 31 << 25) | ((sdram->emc_pmacro_data_pi_ctrl << 20 >> 28 << 21) | ((sdram->emc_pmacro_data_pi_ctrl << 27 >> 31 << 20) | ((sdram->emc_pmacro_data_pi_ctrl << 16) & 0xFFFFF | ((sdram->emc_pmacro_ddll_bypass >> 31 << 15) | ((2 * sdram->emc_pmacro_ddll_bypass >> 31 << 14) | ((4 * sdram->emc_pmacro_ddll_bypass >> 31 << 13) | ((16 * sdram->emc_pmacro_ddll_bypass >> 31 << 12) | ((32 * sdram->emc_pmacro_ddll_bypass >> 31 << 11) | ((sdram->emc_pmacro_ddll_bypass << 6 >> 31 << 10) | ((sdram->emc_pmacro_ddll_bypass << 7 >> 31 << 9) | ((sdram->emc_pmacro_ddll_bypass << 15 >> 31 << 8) | ((sdram->emc_pmacro_ddll_bypass << 16 >> 31 << 7) | ((sdram->emc_pmacro_ddll_bypass << 17 >> 31 << 6) | (32 * (sdram->emc_pmacro_ddll_bypass << 18 >> 31) | (16 * (sdram->emc_pmacro_ddll_bypass << 20 >> 31) | (8 * (sdram->emc_pmacro_ddll_bypass << 21 >> 31) | (4 * (sdram->emc_pmacro_ddll_bypass << 22 >> 31) | (2 * (sdram->emc_pmacro_ddll_bypass << 23 >> 31) | (sdram->emc_pmacro_ddll_bypass & 1 | 2 * (pmc->scratch214 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFF0FFFF) & 0xFFEFFFFF) & 0xFE1FFFFF) & 0xFDFFFFFF) & 0x3FFFFFF;
// 	pmc->scratch215 = (sdram->emc_pmacro_cmd_pi_ctrl << 10 >> 26 << 10) | ((sdram->emc_pmacro_cmd_pi_ctrl << 19 >> 31 << 9) | (32 * (sdram->emc_pmacro_cmd_pi_ctrl << 20 >> 28) | (16 * (sdram->emc_pmacro_cmd_pi_ctrl << 27 >> 31) | (sdram->emc_pmacro_cmd_pi_ctrl & 0xF | 16 * (pmc->scratch215 >> 4)) & 0xFFFFFFEF) & 0xFFFFFE1F) & 0xFFFFFDFF) & 0xFFFF03FF;
// 	tmp = (sdram->emc_pmacro_data_pad_tx_ctrl << 7 >> 31 << 24) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 8 >> 31 << 23) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 9 >> 31 << 22) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 10 >> 31 << 21) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 15 >> 31 << 20) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 16 >> 31 << 19) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 21 >> 31 << 18) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 25 >> 31 << 17) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 26 >> 31 << 16) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 15) & 0xFFFF | ((2 * sdram->emc_pmacro_cmd_pad_tx_ctrl >> 31 << 14) | ((4 * sdram->emc_pmacro_cmd_pad_tx_ctrl >> 31 << 13) | ((8 * sdram->emc_pmacro_cmd_pad_tx_ctrl >> 31 << 12) | ((16 * sdram->emc_pmacro_cmd_pad_tx_ctrl >> 31 << 11) | ((32 * sdram->emc_pmacro_cmd_pad_tx_ctrl >> 31 << 10) | ((sdram->emc_pmacro_cmd_pad_tx_ctrl << 6 >> 31 << 9) | ((sdram->emc_pmacro_cmd_pad_tx_ctrl << 7 >> 31 << 8) | ((sdram->emc_pmacro_cmd_pad_tx_ctrl << 8 >> 31 << 7) | ((sdram->emc_pmacro_cmd_pad_tx_ctrl << 9 >> 31 << 6) | (32 * (sdram->emc_pmacro_cmd_pad_tx_ctrl << 10 >> 31) | (16 * (sdram->emc_pmacro_cmd_pad_tx_ctrl << 15 >> 31) | (8 * (sdram->emc_pmacro_cmd_pad_tx_ctrl << 16 >> 31) | (4 * (sdram->emc_pmacro_cmd_pad_tx_ctrl << 21 >> 31) | (2 * (sdram->emc_pmacro_cmd_pad_tx_ctrl << 25 >> 31) | ((sdram->emc_pmacro_cmd_pad_tx_ctrl << 26 >> 31) | 2 * (pmc->scratch216 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF) & 0xFFFFFFBF) & 0xFFFFFF7F) & 0xFFFFFEFF) & 0xFFFFFDFF) & 0xFFFFFBFF) & 0xFFFFF7FF) & 0xFFFFEFFF) & 0xFFFFDFFF) & 0xFFFFBFFF) & 0xFFFF7FFF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFFBFFFF) & 0xFFF7FFFF) & 0xFFEFFFFF) & 0xFFDFFFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF;

// 	s(emc_pin_gpio, 1:0, scratch9, 31:30);
// 	s(emc_pin_gpio_enable, 1:0, scratch10, 31:30);
// 	s(emc_dev_select, 1:0, scratch11, 31:30);
// 	s(emc_zcal_warm_cold_boot_enables, 1:0, scratch12, 31:30);
// 	s(emc_cfg_dig_dll_period_warm_boot, 1:0, scratch13, 31:30);
// 	s32(emc_bct_spare13, scratch45);
// 	s32(emc_bct_spare12, scratch46);
// 	s32(emc_bct_spare7, scratch47);
// 	s32(emc_bct_spare6, scratch48);
// 	s32(emc_bct_spare5, scratch50);
// 	s32(emc_bct_spare4, scratch51);
// 	s32(emc_bct_spare3, scratch56);
// 	s32(emc_bct_spare2, scratch57);
// 	s32(emc_bct_spare1, scratch58);
// 	s32(emc_bct_spare0, scratch59);
// 	s32(emc_bct_spare9, scratch60);
// 	s32(emc_bct_spare8, scratch61);
// 	s32(boot_rom_patch_data, scratch62);
// 	s32(boot_rom_patch_control, scratch63);
// 	s(mc_clken_override_allwarm_boot, 0:0, scratch65, 31:31);
// 	pmc->scratch66 = pmc->scratch66 & 0x1FFFFFFF | ((u8)(sdram->emc_extra_refresh_num) << 29);
// 	pmc->scratch72 = pmc->scratch72 & 0x8FFFFFFF | ((u16)(sdram->pmc_io_dpd3_req_wait) << 28) & 0x70000000;
// 	pmc->scratch72 = ((2 * pmc->scratch72) >> 1) | ((u16)(sdram->emc_clken_override_allwarm_boot) << 31);
// 	pmc->scratch73 = pmc->scratch73 & 0x8FFFFFFF | ((u8)(sdram->memory_type) << 28) & 0x70000000;
// 	pmc->scratch73 = ((2 * pmc->scratch73) >> 1) | (sdram->emc_mrs_warm_boot_enable << 31);
// 	pmc->scratch74 = pmc->scratch74 & 0x8FFFFFFF | (sdram->pmc_io_dpd4_req_wait << 28) & 0x70000000;
// 	pmc->scratch74 = ((2 * pmc->scratch74) >> 1) | (sdram->clear_clock2_mc1 << 31);
// 	pmc->scratch75 = pmc->scratch75 & 0xEFFFFFFF | (sdram->emc_warm_boot_extramode_reg_write_enable << 28) & 0x10000000;
// 	pmc->scratch75 = pmc->scratch75 & 0xDFFFFFFF | (sdram->clk_rst_pllm_misc20_override_enable << 29) & 0x20000000;
// 	pmc->scratch75 = pmc->scratch75 & 0xBFFFFFFF | ((u16)(sdram->emc_dbg_write_mux) << 30) & 0x40000000;
// 	pmc->scratch75 = ((2 * pmc->scratch75) >> 1) | ((u16)(sdram->ahb_arbitration_xbar_ctrl_meminit_done) << 31);
// 	pmc->scratch90 = pmc->scratch90 & 0xFFFFFF | (sdram->emc_timing_control_wait << 24);
// 	pmc->scratch91 = pmc->scratch91 & 0xFFFFFF | (sdram->emc_zcal_warm_boot_wait << 24);
// 	pmc->scratch92 = pmc->scratch92 & 0xFFFFFF | (sdram->warm_boot_wait << 24);
// 	pmc->scratch93 = pmc->scratch93 & 0xFFFFFF | ((u16)(sdram->emc_pin_program_wait) << 24);
// 	pmc->scratch114 = pmc->scratch114 & 0x3FFFFF | ((u16)(sdram->emc_auto_cal_wait) << 22);
// 	pmc->scratch215 = (u16)pmc->scratch215 | ((u16)(sdram->swizzle_rank_byte_encode) << 16);
// 	pmc->scratch216 = (2 * sdram->emc_pmacro_data_pad_tx_ctrl >> 31 << 30) | ((4 * sdram->emc_pmacro_data_pad_tx_ctrl >> 31 << 29) | ((8 * sdram->emc_pmacro_data_pad_tx_ctrl >> 31 << 28) | ((16 * sdram->emc_pmacro_data_pad_tx_ctrl >> 31 << 27) | ((32 * sdram->emc_pmacro_data_pad_tx_ctrl >> 31 << 26) | ((sdram->emc_pmacro_data_pad_tx_ctrl << 6 >> 31 << 25) | tmp & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF;
// 	s(emc_mrw_lpddr2zcal_warm_boot, 23:16, scratch5, 7:0);
// 	s(emc_mrw_lpddr2zcal_warm_boot, 7:0, scratch5, 15:8);
// 	s(emc_warm_boot_mrw_extra, 23:16, scratch5, 23:16);
// 	s(emc_warm_boot_mrw_extra, 7:0, scratch5, 31:24);
// 	s(emc_mrw_lpddr2zcal_warm_boot, 31:30, scratch6, 1:0);
// 	s(emc_warm_boot_mrw_extra, 31:30, scratch6, 3:2);
// 	s(emc_mrw_lpddr2zcal_warm_boot, 27:26, scratch6, 5:4);
// 	s(emc_warm_boot_mrw_extra, 27:26, scratch6, 7:6);
// 	s(EmcMrw6, 27:0, scratch8, 27:0);
// 	s(EmcMrw6, 31:30, scratch8, 29:28);
// 	s(EmcMrw8, 27:0, scratch9, 27:0);
// 	s(EmcMrw8, 31:30, scratch9, 29:28);
// 	s(EmcMrw9, 27:0, scratch10, 27:0);
// 	s(EmcMrw9, 31:30, scratch10, 29:28);
// 	s(EmcMrw10, 27:0, scratch11, 27:0);
// 	s(EmcMrw10, 31:30, scratch11, 29:28);
// 	s(EmcMrw12, 27:0, scratch12, 27:0);
// 	s(EmcMrw12, 31:30, scratch12, 29:28);
// 	s(EmcMrw13, 27:0, scratch13, 27:0);
// 	s(EmcMrw13, 31:30, scratch13, 29:28);
// 	s(EmcMrw14, 27:0, scratch14, 27:0);
// 	s(EmcMrw14, 31:30, scratch14, 29:28);
// 	s(EmcMrw1, 7:0, scratch15, 7:0);
// 	s(EmcMrw1, 23:16, scratch15, 15:8);
// 	s(EmcMrw1, 27:26, scratch15, 17:16);
// 	s(EmcMrw1, 31:30, scratch15, 19:18);
// 	s(emc_warm_boot_mrw_extra, 7:0, scratch16, 7:0);
// 	s(emc_warm_boot_mrw_extra, 23:16, scratch16, 15:8);
// 	s(emc_warm_boot_mrw_extra, 27:26, scratch16, 17:16);
// 	s(emc_warm_boot_mrw_extra, 31:30, scratch16, 19:18);
// 	s(emc_mrw2, 7:0, scratch17, 7:0);
// 	s(emc_mrw2, 23:16, scratch17, 15:8);
// 	s(emc_mrw2, 27:26, scratch17, 17:16);
// 	s(emc_mrw2, 31:30, scratch17, 19:18);
// 	pmc->scratch18 = (sdram->emc_mrw3 >> 30 << 18) | ((16 * sdram->emc_mrw3 >> 31 << 17) | ((32 * sdram->emc_mrw3 >> 31 << 16) | ((sdram->emc_mrw3 << 8 >> 24 << 8) | ((u8)sdram->emc_mrw3 | (pmc->scratch18 >> 8 << 8)) & 0xFFFF00FF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFF3FFFF;
// 	pmc->scratch19 = (sdram->emc_mrw4 >> 30 << 18) | ((16 * sdram->emc_mrw4 >> 31 << 17) | ((32 * sdram->emc_mrw4 >> 31 << 16) | ((sdram->emc_mrw4 << 8 >> 24 << 8) | ((u8)sdram->emc_mrw4 | (pmc->scratch19 >> 8 << 8)) & 0xFFFF00FF) & 0xFFFEFFFF) & 0xFFFDFFFF) & 0xFFF3FFFF;
// 	s32(emc_cmd_mapping_byte, secure_scratch8);
// 	s32(emc_pmacro_brick_mapping0, secure_scratch9);
// 	s32(emc_pmacro_brick_mapping1, secure_scratch10);
// 	s32(emc_pmacro_brick_mapping2, secure_scratch11);
// 	s32(mc_video_protect_gpu_override0, secure_scratch12);
// 	pmc->secure_scratch13 = ((u16)(sdram->emc_adr_cfg) << 31) | (2 * ((((u16)(sdram->mc_untranslated_region_check) << 22) >> 31 << 30) | ((((u16)(sdram->mc_untranslated_region_check) << 23) >> 31 << 29) | (((u16)(sdram->mc_untranslated_region_check) << 28) & 0x1FFFFFFF | ((2 * sdram->emc_cmd_mapping_cmd0_0 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd0_0 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd0_0 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd0_0 & 0x7F | (pmc->secure_scratch13 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch14 = (sdram->mc_video_protect_write_access << 30 >> 31 << 31) | (2 * ((sdram->mc_video_protect_write_access << 30) | ((sdram->mc_video_protect_bom_adr_hi << 30 >> 2) | ((2 * sdram->emc_cmd_mapping_cmd0_1 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd0_1 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd0_1 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd0_1 & 0x7F | (pmc->secure_scratch14 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xCFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch15 = ((u16)(sdram->mc_mts_carveout_adr_hi) << 30) | (4 * ((sdram->mc_sec_carveout_adr_hi << 28) | ((2 * sdram->emc_cmd_mapping_cmd1_0 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd1_0 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd1_0 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd1_0 & 0x7F | (pmc->secure_scratch15 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->secure_scratch16 = (sdram->mc_generalized_carveout3_bom_hi << 30) | (4 * ((sdram->mc_generalized_carveout5_bom_hi << 28) | ((2 * sdram->emc_cmd_mapping_cmd1_1 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd1_1 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd1_1 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd1_1 & 0x7F | (pmc->secure_scratch16 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->secure_scratch17 = ((u16)(sdram->mc_generalized_carveout4_bom_hi) << 30) | (4 * (((u16)(sdram->mc_generalized_carveout2_bom_hi) << 28) | ((2 * sdram->emc_cmd_mapping_cmd2_0 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd2_0 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd2_0 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd2_0 & 0x7F | (pmc->secure_scratch17 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xCFFFFFFF) >> 2);
// 	pmc->secure_scratch18 = (sdram->emc_fbio_cfg8 << 16 >> 31 << 31) | (2 * (((u16)(sdram->emc_fbio_spare) << 30 >> 31 << 30) | ((sdram->mc_generalized_carveout1_bom_hi << 30 >> 2) | ((2 * sdram->emc_cmd_mapping_cmd2_1 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd2_1 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd2_1 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd2_1 & 0x7F | (pmc->secure_scratch18 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xCFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch19 = (sdram->mc_video_protect_vpr_override << 31) | (2 * (((u16)(sdram->mc_mts_carveout_reg_ctrl) << 30) | ((sdram->mc_sec_carveout_protect_write_access << 31 >> 2) | (((u16)(sdram->mc_emem_adr_cfg) << 28) & 0x1FFFFFFF | ((2 * sdram->emc_cmd_mapping_cmd3_0 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd3_0 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd3_0 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd3_0 & 0x7F | (pmc->secure_scratch19 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch20 = (sdram->mc_generalized_carveout2_cfg0 << 25 >> 28 << 28) | ((2 * sdram->emc_cmd_mapping_cmd3_1 >> 25 << 21) | ((sdram->emc_cmd_mapping_cmd3_1 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd3_1 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd3_1 & 0x7F | (pmc->secure_scratch20 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xF01FFFFF) & 0xFFFFFFF;
// 	pmc->secure_scratch39 = (sdram->mc_video_protect_vpr_override << 30 >> 31 << 31) | (2 * ((sdram->mc_generalized_carveout2_cfg0 << 21 >> 28 << 27) | ((32 * sdram->mc_generalized_carveout4_cfg0 >> 31 << 26) | ((sdram->mc_generalized_carveout4_cfg0 << 6 >> 31 << 25) | ((sdram->mc_generalized_carveout4_cfg0 << 7 >> 31 << 24) | ((sdram->mc_generalized_carveout4_cfg0 << 8 >> 31 << 23) | ((sdram->mc_generalized_carveout4_cfg0 << 9 >> 31 << 22) | ((sdram->mc_generalized_carveout4_cfg0 << 10 >> 28 << 18) | ((sdram->mc_generalized_carveout4_cfg0 << 14 >> 28 << 14) | ((sdram->mc_generalized_carveout4_cfg0 << 18 >> 29 << 11) | ((sdram->mc_generalized_carveout4_cfg0 << 21 >> 28 << 7) | (8 * (sdram->mc_generalized_carveout4_cfg0 << 25 >> 28) | (4 * (sdram->mc_generalized_carveout4_cfg0 << 29 >> 31) | (2 * (sdram->mc_generalized_carveout4_cfg0 << 30 >> 31) | (sdram->mc_generalized_carveout4_cfg0 & 1 | 2 * (pmc->secure_scratch39 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFF87) & 0xFFFFF87F) & 0xFFFFC7FF) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0x87FFFFFF) >> 1);
// 	pmc->secure_scratch40 = (sdram->mc_video_protect_vpr_override << 29 >> 31 << 31) | (2 * ((sdram->mc_generalized_carveout2_cfg0 << 14 >> 28 << 27) | ((32 * sdram->mc_generalized_carveout5_cfg0 >> 31 << 26) | ((sdram->mc_generalized_carveout5_cfg0 << 6 >> 31 << 25) | ((sdram->mc_generalized_carveout5_cfg0 << 7 >> 31 << 24) | ((sdram->mc_generalized_carveout5_cfg0 << 8 >> 31 << 23) | ((sdram->mc_generalized_carveout5_cfg0 << 9 >> 31 << 22) | ((sdram->mc_generalized_carveout5_cfg0 << 10 >> 28 << 18) | ((sdram->mc_generalized_carveout5_cfg0 << 14 >> 28 << 14) | ((sdram->mc_generalized_carveout5_cfg0 << 18 >> 29 << 11) | ((sdram->mc_generalized_carveout5_cfg0 << 21 >> 28 << 7) | (8 * (sdram->mc_generalized_carveout5_cfg0 << 25 >> 28) | (4 * (sdram->mc_generalized_carveout5_cfg0 << 29 >> 31) | (2 * (sdram->mc_generalized_carveout5_cfg0 << 30 >> 31) | (sdram->mc_generalized_carveout5_cfg0 & 1 | 2 * (pmc->secure_scratch40 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFF87) & 0xFFFFF87F) & 0xFFFFC7FF) & 0xFFFC3FFF) & 0xFFC3FFFF) & 0xFFBFFFFF) & 0xFF7FFFFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0x87FFFFFF) >> 1);
// 	pmc->secure_scratch41 = (sdram->mc_generalized_carveout2_cfg0 << 18 >> 29 << 29) | ((sdram->mc_generalized_carveout2_cfg0 << 10 >> 28 << 25) | ((16 * sdram->emc_cmd_mapping_cmd0_2 >> 28 << 21) | ((sdram->emc_cmd_mapping_cmd0_2 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd0_2 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd0_2 & 0x7F | (pmc->secure_scratch41 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xFE1FFFFF) & 0xE1FFFFFF) & 0x1FFFFFFF;
// 	pmc->secure_scratch42 = ((u16)(sdram->mc_generalized_carveout1_cfg0) << 18 >> 29 << 29) | (((u16)(sdram->mc_generalized_carveout1_cfg0) << 25 >> 28 << 25) | ((16 * sdram->emc_cmd_mapping_cmd1_2 >> 28 << 21) | ((sdram->emc_cmd_mapping_cmd1_2 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd1_2 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd1_2 & 0x7F | (pmc->secure_scratch42 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xFE1FFFFF) & 0xE1FFFFFF) & 0x1FFFFFFF;
// 	pmc->secure_scratch43 = ((u16)(sdram->mc_generalized_carveout3_cfg0) << 18 >> 29 << 29) | (((u16)(sdram->mc_generalized_carveout1_cfg0) << 21 >> 28 << 25) | ((16 * sdram->emc_cmd_mapping_cmd2_2 >> 28 << 21) | ((sdram->emc_cmd_mapping_cmd2_2 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd2_2 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd2_2 & 0x7F | (pmc->secure_scratch43 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xFE1FFFFF) & 0xE1FFFFFF) & 0x1FFFFFFF;
// 	pmc->secure_scratch44 = (sdram->mc_video_protect_vpr_override << 24 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override << 25 >> 31 << 30) | ((sdram->mc_video_protect_vpr_override << 28 >> 31 << 29) | ((sdram->mc_generalized_carveout1_cfg0 << 14 >> 28 << 25) | ((16 * sdram->emc_cmd_mapping_cmd3_2 >> 28 << 21) | ((sdram->emc_cmd_mapping_cmd3_2 << 9 >> 25 << 14) | ((sdram->emc_cmd_mapping_cmd3_2 << 17 >> 25 << 7) | (sdram->emc_cmd_mapping_cmd3_2 & 0x7F | (pmc->secure_scratch44 >> 7 << 7)) & 0xFFFFC07F) & 0xFFE03FFF) & 0xFE1FFFFF) & 0xE1FFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	s(mc_emem_adr_cfg_channel_mask, 31:9, secure_scratch45, 22:0);
// 	s(mc_emem_adr_cfg_dev0, 2:0, secure_scratch45, 25:23);
// 	s(mc_emem_adr_cfg_dev0, 9:8, secure_scratch45, 27:26);
// 	s(mc_emem_adr_cfg_dev0, 19:16, secure_scratch45, 31:28);
// 	pmc->secure_scratch46 = (sdram->mc_video_protect_vpr_override << 23 >> 31 << 31) | (2 * ((sdram->mc_emem_adr_cfg_dev1 << 12 >> 28 << 27) | ((sdram->mc_emem_adr_cfg_dev1 << 22 >> 30 << 25) | ((sdram->mc_emem_adr_cfg_dev1 << 22) & 0x1FFFFFF | ((sdram->mc_emem_adr_cfg_bank_mask0 >> 10) | (pmc->secure_scratch46 >> 22 << 22)) & 0xFE3FFFFF) & 0xF9FFFFFF) & 0x87FFFFFF) >> 1);
// 	pmc->secure_scratch47 = (sdram->mc_video_protect_vpr_override << 20 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override << 22 >> 31 << 30) | (((u8)(sdram->mc_generalized_carveout3_cfg0) << 25 >> 28 << 26) | ((sdram->mc_generalized_carveout1_cfg0 << 10 >> 28 << 22) | ((sdram->mc_emem_adr_cfg_bank_mask1 >> 10) | (pmc->secure_scratch47 >> 22 << 22)) & 0xFC3FFFFF) & 0xC3FFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch48 = (sdram->mc_video_protect_vpr_override << 16 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override << 17 >> 31 << 30) | ((sdram->mc_generalized_carveout3_cfg0 << 14 >> 28 << 26) | ((sdram->mc_generalized_carveout3_cfg0 << 21 >> 28 << 22) | ((sdram->mc_emem_adr_cfg_bank_mask2 >> 10) | (pmc->secure_scratch48 >> 22 << 22)) & 0xFC3FFFFF) & 0xC3FFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch49 = (sdram->mc_video_protect_vpr_override << 14 >> 31 << 31) | (2 * ((sdram->mc_emem_cfg >> 31 << 30) | ((sdram->mc_emem_cfg << 18 >> 2) | (sdram->mc_video_protect_gpu_override1 & 0xFFFF | (pmc->secure_scratch49 >> 16 << 16)) & 0xC000FFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch50 = (sdram->mc_video_protect_vpr_override << 12 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override << 13 >> 31 << 30) | ((sdram->mc_generalized_carveout1_bom >> 17 << 15) | ((sdram->mc_generalized_carveout3_bom >> 17) | (pmc->secure_scratch50 >> 15 << 15)) & 0xC0007FFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch51 = (sdram->mc_video_protect_vpr_override << 10 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override << 11 >> 31 << 30) | ((sdram->mc_generalized_carveout2_bom >> 17 << 15) | ((sdram->mc_generalized_carveout4_bom >> 17) | (pmc->secure_scratch51 >> 15 << 15)) & 0xC0007FFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch52 = (sdram->mc_video_protect_vpr_override << 9 >> 31 << 31) | (2 * ((sdram->mc_generalized_carveout3_cfg0 << 10 >> 28 << 27) | ((sdram->mc_video_protect_bom >> 20 << 15) | ((sdram->mc_generalized_carveout5_bom >> 17) | (pmc->secure_scratch52 >> 15 << 15)) & 0xF8007FFF) & 0x87FFFFFF) >> 1);
// 	pmc->secure_scratch53 = (sdram->mc_video_protect_vpr_override1 << 27 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override1 << 30 >> 31 << 30) | ((sdram->mc_video_protect_vpr_override1 << 31 >> 2) | ((sdram->mc_video_protect_vpr_override >> 31 << 28) | ((2 * sdram->mc_video_protect_vpr_override >> 31 << 27) | ((4 * sdram->mc_video_protect_vpr_override >> 31 << 26) | ((32 * sdram->mc_video_protect_vpr_override >> 31 << 25) | ((sdram->mc_video_protect_vpr_override << 8 >> 31 << 24) | ((sdram->mc_sec_carveout_bom >> 20 << 12) | (sdram->mc_video_protect_size_mb & 0xFFF | (pmc->secure_scratch53 >> 12 << 12)) & 0xFF000FFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch54 = (sdram->mc_video_protect_vpr_override1 << 19 >> 31 << 31) | (2 * ((sdram->mc_video_protect_vpr_override1 << 20 >> 31 << 30) | ((sdram->mc_video_protect_vpr_override1 << 21 >> 31 << 29) | ((sdram->mc_video_protect_vpr_override1 << 22 >> 31 << 28) | ((sdram->mc_video_protect_vpr_override1 << 23 >> 31 << 27) | ((sdram->mc_video_protect_vpr_override1 << 24 >> 31 << 26) | ((sdram->mc_video_protect_vpr_override1 << 25 >> 31 << 25) | ((sdram->mc_video_protect_vpr_override1 << 26 >> 31 << 24) | ((sdram->mc_mts_carveout_bom >> 20 << 12) | (sdram->mc_sec_carveout_size_mb & 0xFFF | (pmc->secure_scratch54 >> 12 << 12)) & 0xFF000FFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch55 = (sdram->mc_generalized_carveout2_cfg0 << 30 >> 31 << 31) | (2 * ((sdram->mc_generalized_carveout2_cfg0 << 30) | ((32 * sdram->mc_video_protect_vpr_override1 >> 31 << 29) | ((sdram->mc_video_protect_vpr_override1 << 6 >> 31 << 28) | ((sdram->mc_video_protect_vpr_override1 << 15 >> 31 << 27) | ((sdram->mc_video_protect_vpr_override1 << 16 >> 31 << 26) | ((sdram->mc_video_protect_vpr_override1 << 17 >> 31 << 25) | ((sdram->mc_video_protect_vpr_override1 << 18 >> 31 << 24) | (((u16)(sdram->mc_generalized_carveout4_size_128kb) << 12) & 0xFFFFFF | (sdram->mc_mts_carveout_size_mb & 0xFFF | (pmc->secure_scratch55 >> 12 << 12)) & 0xFF000FFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch56 = ((u16)(sdram->mc_generalized_carveout1_cfg0) << 30 >> 31 << 31) | (2 * (((u16)(sdram->mc_generalized_carveout1_cfg0) << 30) | ((32 * sdram->mc_generalized_carveout2_cfg0 >> 31 << 29) | ((sdram->mc_generalized_carveout2_cfg0 << 6 >> 31 << 28) | ((sdram->mc_generalized_carveout2_cfg0 << 7 >> 31 << 27) | ((sdram->mc_generalized_carveout2_cfg0 << 8 >> 31 << 26) | ((sdram->mc_generalized_carveout2_cfg0 << 9 >> 31 << 25) | ((sdram->mc_generalized_carveout2_cfg0 << 29 >> 31 << 24) | (((u16)(sdram->mc_generalized_carveout2_size_128kb) << 12) & 0xFFFFFF | (sdram->mc_generalized_carveout3_size_128kb & 0xFFF | (pmc->secure_scratch56 >> 12 << 12)) & 0xFF000FFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);
// 	pmc->secure_scratch57 = ((u8)(sdram->mc_generalized_carveout3_cfg0) << 30 >> 31 << 31) | (2 * (((u8)(sdram->mc_generalized_carveout3_cfg0) << 30) | ((32 * sdram->mc_generalized_carveout1_cfg0 >> 31 << 29) | ((sdram->mc_generalized_carveout1_cfg0 << 6 >> 31 << 28) | ((sdram->mc_generalized_carveout1_cfg0 << 7 >> 31 << 27) | ((sdram->mc_generalized_carveout1_cfg0 << 8 >> 31 << 26) | ((sdram->mc_generalized_carveout1_cfg0 << 9 >> 31 << 25) | ((sdram->mc_generalized_carveout1_cfg0 << 29 >> 31 << 24) | ((sdram->mc_generalized_carveout5_size_128kb << 12) & 0xFFFFFF | (sdram->mc_generalized_carveout1_size_128kb & 0xFFF | (pmc->secure_scratch57 >> 12 << 12)) & 0xFF000FFF) & 0xFEFFFFFF) & 0xFDFFFFFF) & 0xFBFFFFFF) & 0xF7FFFFFF) & 0xEFFFFFFF) & 0xDFFFFFFF) & 0xBFFFFFFF) >> 1);

// 	s32(mc_generalized_carveout1_access0, secure_scratch59);
// 	s32(mc_generalized_carveout1_access1, secure_scratch60);
// 	s32(mc_generalized_carveout1_access2, secure_scratch61);
// 	s32(mc_generalized_carveout1_access3, secure_scratch62);
// 	s32(mc_generalized_carveout1_access4, secure_scratch63);
// 	s32(mc_generalized_carveout2_access0, secure_scratch64);
// 	s32(mc_generalized_carveout2_access1, secure_scratch65);
// 	s32(mc_generalized_carveout2_access2, secure_scratch66);
// 	s32(mc_generalized_carveout2_access3, secure_scratch67);
// 	s32(mc_generalized_carveout2_access4, secure_scratch68);
// 	s32(mc_generalized_carveout3_access0, secure_scratch69);
// 	s32(mc_generalized_carveout3_access1, secure_scratch70);
// 	s32(mc_generalized_carveout3_access2, secure_scratch71);
// 	s32(mc_generalized_carveout3_access3, secure_scratch72);
// 	s32(mc_generalized_carveout3_access4, secure_scratch73);
// 	s32(mc_generalized_carveout4_access0, secure_scratch74);
// 	s32(mc_generalized_carveout4_access1, secure_scratch75);
// 	s32(mc_generalized_carveout4_access2, secure_scratch76);
// 	s32(mc_generalized_carveout4_access3, secure_scratch77);
// 	s32(mc_generalized_carveout4_access4, secure_scratch78);
// 	s32(mc_generalized_carveout5_access0, secure_scratch79);
// 	s32(mc_generalized_carveout5_access1, secure_scratch80);
// 	s32(mc_generalized_carveout5_access2, secure_scratch81);
// 	s32(mc_generalized_carveout5_access3, secure_scratch82);
// 	s32(mc_generalized_carveout1_force_internal_access0, secure_scratch84);
// 	s32(mc_generalized_carveout1_force_internal_access1, secure_scratch85);
// 	s32(mc_generalized_carveout1_force_internal_access2, secure_scratch86);
// 	s32(mc_generalized_carveout1_force_internal_access3, secure_scratch87);
// 	s32(mc_generalized_carveout1_force_internal_access4, secure_scratch88);
// 	s32(mc_generalized_carveout2_force_internal_access0, secure_scratch89);
// 	s32(mc_generalized_carveout2_force_internal_access1, secure_scratch90);
// 	s32(mc_generalized_carveout2_force_internal_access2, secure_scratch91);
// 	s32(mc_generalized_carveout2_force_internal_access3, secure_scratch92);
// 	s32(mc_generalized_carveout2_force_internal_access4, secure_scratch93);
// 	s32(mc_generalized_carveout3_force_internal_access0, secure_scratch94);
// 	s32(mc_generalized_carveout3_force_internal_access1, secure_scratch95);
// 	s32(mc_generalized_carveout3_force_internal_access2, secure_scratch96);
// 	s32(mc_generalized_carveout3_force_internal_access3, secure_scratch97);
// 	s32(mc_generalized_carveout3_force_internal_access4, secure_scratch98);
// 	s32(mc_generalized_carveout4_force_internal_access0, secure_scratch99);
// 	s32(mc_generalized_carveout4_force_internal_access1, secure_scratch100);
// 	s32(mc_generalized_carveout4_force_internal_access2, secure_scratch101);
// 	s32(mc_generalized_carveout4_force_internal_access3, secure_scratch102);
// 	s32(mc_generalized_carveout4_force_internal_access4, secure_scratch103);
// 	s32(mc_generalized_carveout5_force_internal_access0, secure_scratch104);
// 	s32(mc_generalized_carveout5_force_internal_access1, secure_scratch105);
// 	s32(mc_generalized_carveout5_force_internal_access2, secure_scratch106);
// 	s32(mc_generalized_carveout5_force_internal_access3, secure_scratch107);

// 	pmc->secure_scratch58 = 32 * (32 * sdram->mc_generalized_carveout3_cfg0 >> 31) | (16 * (sdram->mc_generalized_carveout3_cfg0 << 6 >> 31) | (8 * (sdram->mc_generalized_carveout3_cfg0 << 7 >> 31) | (4 * (sdram->mc_generalized_carveout3_cfg0 << 8 >> 31) | (2 * (sdram->mc_generalized_carveout3_cfg0 << 9 >> 31) | ((sdram->mc_generalized_carveout3_cfg0 << 29 >> 31) | 2 * (pmc->secure_scratch58 >> 1)) & 0xFFFFFFFD) & 0xFFFFFFFB) & 0xFFFFFFF7) & 0xFFFFFFEF) & 0xFFFFFFDF;

// 	c32(0, scratch2);
// 	s(pllm_input_divider, 7:0, scratch2, 7:0);
// 	s(pllm_feedback_divider, 7:0, scratch2, 15:8);
// 	s(pllm_post_divider, 4:0, scratch2, 20:16);
// 	s(pllm_kvco, 0:0, scratch2, 17:17);
// 	s(pllm_kcp, 1:0, scratch2, 19:18);

// 	c32(0, scratch35);
// 	s(pllm_setup_control, 15:0, scratch35, 15:0);

// 	c32(0, scratch3);
// 	s(pllm_input_divider, 7:0, scratch3, 7:0);
// 	c(0x3e, scratch3, 15:8);
// 	c(0, scratch3, 20:16);
// 	s(pllm_kvco, 0:0, scratch3, 21:21);
// 	s(pllm_kcp, 1:0, scratch3, 23:22);

// 	c32(0, scratch36);
// 	s(PllMSetupControl, 23:0, scratch36, 23:0);

// 	c32(0, scratch4);
// 	s(pllm_stable_time, 9:0, scratch4, 9:0); // s32(pllm_stable_time, scratch4);, s(pllm_stable_time, 31:0, scratch4, 31:10);
// 	s(pllm_stable_time, 31:0, scratch4, 31:10);
// }

#pragma GCC diagnostic pop

void sdram_lp0_save_params(const void *params)
{
	// u32 chip_id = (APB_MISC(APB_MISC_GP_HIDREV) >> 4) & 0xF;

	// if (chip_id != GP_HIDREV_MAJOR_T210B01)
		_sdram_lp0_save_params_t210(params);
	// else
	// 	_sdram_lp0_save_params_t210b01(params);
}
