//---------------------------------------------------------------------------------------------
// Torque 3D
// Copyright (C) GarageGames.com, Inc.
//---------------------------------------------------------------------------------------------

// Dialog for creating new GUIs.  Allows to enter an object name and
// select a GuiControl class to use for the toplevel object.


//---------------------------------------------------------------------------------------------

function GuiEditorNewGuiDialog::init( %this, %guiName, %guiClass )
{
   %this-->nameField.setValue( %guiName );
   
   // Initialize the class dropdown if we haven't already.
   
   %classDropdown = %this-->classDropdown;
   if( !%classDropdown.size() )
   {
      %classes = enumerateConsoleClassesByCategory( "Gui" );
      %count = getFieldCount( %classes );
      
      for( %i = 0; %i < %count; %i ++ )
      {
         %className = getField( %classes, %i );
         if( GuiEditor.isFilteredClass( %className )
             || !isMemberOfClass( %className, "GuiControl" ) )
            continue;
            
         %classDropdown.add( %className, 0 );
      }
      
      %classDropdown.sort();
   }
   
   %classDropdown.setText( "GuiControl" );
}

//=============================================================================================
//    Event Handlers.
//=============================================================================================

//---------------------------------------------------------------------------------------------

function GuiEditorNewGuiDialog::onWake( %this )
{
   // Center the dialog.

   %root = %this.getRoot();
   %this.setPosition( %root.extent.x / 2 - %this.extent.x / 2, %root.extent.y / 2 - %this.extent.y / 2 );
}

//---------------------------------------------------------------------------------------------

function GuiEditorNewGuiDialog::onOK( %this )
{
   %name = %this-->nameField.getValue();
   %class = %this-->classDropdown.getText();
   
   // Make sure it's a valid object name.
   
   if( %name !$= "" && !isValidObjectName( %name ) )
   {
      MessageBoxOK( "Error",
         "'" @ %name @ "' is not a valid object name." NL
         "" NL
         "Please enter a name that begins with a letter or underscore and is otherwise comprised soletely of letters, digits, and underscores."
      );
      return;
   }
      
   // Make sure we don't clash with an existing object.
   // If there's an existing GUIControl with the name, ask to replace.
   // If there's an existing non-GUIControl with the name, refuse to create.
   
   %existingObject = nameToID( %name );
   if( %existingObject == -1 )
   {
      if( %name $= "RootGroup" )
         %existingObject = RootGroup;
      else
         %existingObject = "";
   }
   %replace = false;
      
   if( %existingObject !$= "" )
   {
      if( %existingObject.isMemberOfClass( "GuiControl" ) )
      {
         %replace = MessageBox( "Warning", "Replace the existing control '" @ %name @ "'?",
            "OkCancel", "Question" ) == $MROk;
      }
      else
         MessageBox( "Error", "An object called '" @ %name @ "' already exists.",
            "Ok", "Stop" );
   }
   
   if( %existingObject !$= "" && %replace )
   {
      %existingObject.delete();
      %existingObject = "";
   }
   
   if( %existingObject $= "" )
   {
      %this.getRoot().popDialog( %this );
      %obj = eval("return new " @ %class @ "(" @ %name @ ");");
      
      GuiEditContent(%obj);
   }
}

//---------------------------------------------------------------------------------------------

function GuiEditorNewGuiDialog::onCancel( %this )
{
   %this.getRoot().popDialog( %this );
}
