//---------------------------------------------------------------------------------------------
// Torque 3D
// Copyright (C) GarageGames.com, Inc.
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------

function inspectObject( %object )
{
   if( !isObject( %object ) )
   {
      error( "inspectObject: no object '" @ %object @ "'" );
      return;
   }
      
   // Create a new object inspector window.
   exec( "./guiObjectInspector.ed.gui" );
   
   if( !isObject( %guiContent) )
   {
      error( "InspectObject: failed to create GUI from 'guiObjectInspector.ed.gui'" );
      return;
   }
   
   // Initialize the inspector.
   
   %guiContent.init( %object );
      
   Canvas.getContent().add( %guiContent );
}

//=============================================================================================
//    GuiObjectInspector
//=============================================================================================

//---------------------------------------------------------------------------------------------

function GuiObjectInspector::init( %this, %object )
{   
   if( !%object.isMemberOfClass( "SimSet" ) )
   {
      // Complete deletely the splitter and the left-side part of the inspector
      // leaving only the field inspector.
      
      %this.add( %this-->panel2 );
      %this-->splitter.delete();
      %this-->inspector.inspect( %object );
      %this-->methodList.init( %object );
   }
   else
   {
      %treeView = %this-->treeView;
      %treeView.inspectorCtrl = %this-->inspector;
      %treeView.methodList = %this-->methodList;

      %treeView.open( %object );
   }
   
   // Populate method list.
   
   // Set window caption.
   
   %caption = "Object Inspector - " @ %object.getId() @ " : " @ %object.getClassName();
   
   %name = %object.getName();
   if( %name !$= "" )
      %caption = %caption @ " - " @ %name;
      
   %this.text = %caption;
}

//---------------------------------------------------------------------------------------------

function GuiObjectInspector::onClose( %this )
{
   // Delete us.
   %this.schedule( 1, "delete" );
}

//=============================================================================================
//    GuiObjectInspectorTree
//=============================================================================================

//---------------------------------------------------------------------------------------------

function GuiObjectInspectorTree::onSelect( %this, %object )
{
   if( isObject( %object ) )
   {
      %this.inspectorCtrl.inspect( %object );
      %this.methodList.init( %object );
   }
}

//=============================================================================================
//    GuiObjectInspectorMethodList
//=============================================================================================

//---------------------------------------------------------------------------------------------

function GuiObjectInspectorMethodList::init( %this, %object )
{
   %this.clear();
   
   %methods = %object.dumpMethods();
   %count = %methods.count();
   %parent = %this.insertItem( 0, "Methods" );
   
   for( %i = 0; %i < %count; %i ++ )
   {
      %name = %methods.getKey( %i );
      %value = %methods.getValue( %i );
      %minArgs = getWord( %value, 0 );
      %maxArgs = getWord( %value, 1 );
      %usage = getWords( %value, 2 );
      
      %id = %this.insertItem( %parent, %name @ " (minArgs=" @ %minArgs @ ", maxArgs=" @ %maxArgs @ ")" );
      %this.setItemTooltip( %id, %usage );
   }
      
   %methods.delete();
   
   if( %object.isMethod( "getDebugInfo" ) )
   {
      %debugInfo = %object.getDebugInfo();      
      %count = %debugInfo.count();
      %parent = %this.insertItem( 0, "Debug Info" );
      
      for( %i = 0; %i < %count; %i ++ )
         %id = %this.insertItem( %parent, %debugInfo.getKey( %i ) @ ": " @ %debugInfo.getValue( %i ) );
      
      %debugInfo.delete();
   }

   %this.sort( 0, true );
}
