//-----------------------------------------------------------------------------
// In-Bounds Trigger
//-----------------------------------------------------------------------------
function InBoundsTrigger::onLeaveTrigger(%this,%trigger,%obj)
{
   // Leaving an in bounds area.
   %obj.getDatablock().onOutOfBounds(%obj);
}

//-----------------------------------------------------------------------------
// Out-of-Bounds Trigger
//-----------------------------------------------------------------------------
function OutOfBoundsTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // Entering an out of bounds area
   %obj.getDatablock().onOutOfBounds(%obj);
}

//-----------------------------------------------------------------------------
// Finish pad Trigger
//-----------------------------------------------------------------------------
function FinishTrigger::onEnterTrigger(%this, %trigger, %obj)
{
   // Entering a finish point
   %obj.getDatablock().onFinishPoint(%obj);
}

//-----------------------------------------------------------------------------
// Check Point Trigger
//-----------------------------------------------------------------------------

function CheckPointTrigger::onEnterTrigger(%this, %trigger, %obj)
{
   // Entering a check point
   %obj.getDatablock().setCheckPoint(%obj, %trigger);
}

//-----------------------------------------------------------------------------
// Help Trigger
//-----------------------------------------------------------------------------

function HelpTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // Leaving an in bounds area.
   commandToClient(%obj.client,'setHelpLine',%trigger.text,1);
}

function HelpTrigger::onLeaveTrigger(%this,%trigger,%obj)
{
   commandToClient(%obj.client,'removeHelpLine');
}