
function getSpawnPosition(%spawnobj)
{
   if (!isObject(%spawnobj))
      return "0 0 0";

   %pos = %spawnobj.getWorldBoxCenter();
   %rotation = getWords(%spawnobj.getTransform(), 3);

   if (isSinglePlayerMode())
      %offset = MatrixMulVector(%spawnobj.getTransform(), "0 0 1.5");
   else
      %offset = MatrixMulVector(%spawnobj.getTransform(), "0 0 0.5");

   %pos = VectorAdd(%pos, %offset);

   return %pos SPC %rotation;
}

function findClosestSpawnPoint(%position)
{
   %spawn = 0;

   // Walk through the groups until we find a valid object
   %spawnGroups = $Game::DefaultPlayerSpawnGroups;
   for (%i = 0; %i < getWordCount(%spawnGroups); %i++)
   {
      %group = getWord(%spawnGroups, %i);

      if (%position !$= "" && isObject(%group))
      {
         %count = %group.getCount();
         if (%count > 0)
         {
            %closest = 0;
            %closestDist = 0;
            for (%j = 0; %j < %count; %j++)
            {
               %spawn = %group.getObject(%j);
               %spawnpos = %spawn.getPosition();
               
               %dist = VectorDist(%spawnpos, %position);
               
               if (%closest == 0 || %dist < %closestDist)
               {
                  %closest = %spawn;
                  %closestDist = %dist;
               }
            }
            %spawn = %closest;
         }
      }
   }
   
   if (!isObject(%spawn))
   {
      // defer to pickSpawnPoint()
      error("Unable to find closest spawn point to position, defering to pickSpawnPoint().  Input position:" SPC %position);
      %spawn = pickSpawnPoint();
   }
   else
   {
      // Use the container system to iterate through all the objects
      // within the spawn radius.
      InitContainerRadiusSearch(%spawn.getPosition(), $Server::PlayerSpawnMinDist, $TypeMasks::PlayerObjectType);

      if (containerSearchNext())
      {
         echo("Player spawn point occupied, picking random spawn");
         // spawn point occupied, get a random one
         %spawn = pickSpawnPoint();
      }
   }
   
   return %spawn;
}