//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// PowerUp base class
//-----------------------------------------------------------------------------

function PowerUp::onPickup(%this,%obj,%user,%amount)
{
   // Dont' pickup the power up if it's the same
   // one we already have.
   if (%user.powerUpData == %this)
      return false;

   // Grab it...
   %user.client.play2d(%this.pickupAudio);
   if (%this.powerUpId)
   {
      if(%obj.showHelpOnPickup)
      {
         %text = avar($Text::PullToUse, %this.useName);
         addHelpLine(%text , false);
      }
   
      %user.setPowerUp(%this);
   }
   Parent::onPickup(%this, %obj, %user, %amount);
   return true;
}

function SuperSpeedItem::onAdd(%this, %obj)
{
   %obj.playThread(0,"Ambient");
}

function BlastItem::onAdd(%this, %obj)
{
   %obj.playThread(0,"Ambient");
   %obj.rotate = 0;
}

function MegaMarbleItem::onAdd(%this, %obj)
{
   %obj.playThread(0,"ambient");
}   

//-----------------------------------------------------------------------------

function TimeTravelItem::getPickupTextData(%this, %obj)
{
  if(%obj.timeBonus !$= "")
      %time = %obj.timeBonus / 1000;
  else
      %time = $Game::TimeTravelBonus / 1000;
  return %time;
}

function TimeTravelItem::onPickup(%this,%obj,%user,%amount)
{
   Parent::onPickup(%this, %obj, %user, %amount);
   if(%obj.timeBonus !$= "")
      %user.client.incBonusTime(%obj.timeBonus);
   else
      %user.client.incBonusTime($Game::TimeTravelBonus);
}

//-----------------------------------------------------------------------------

function AntiGravityItem::onAdd(%this, %obj)
{
   %obj.playThread(0,"Ambient");
}   

function AntiGravityItem::onPickup(%this,%obj,%user,%amount)
{
   %rotation = getWords(%obj.getTransform(),3);
   %ortho = vectorOrthoBasis(%rotation);
   %down = getWords(%ortho,6);
   if (VectorDot(%user.getGravityDir(),%down)<0.9)
   {
      Parent::onPickup(%this, %obj, %user, %amount);
      %user.setGravityDir(%ortho);
   }
}

//-----------------------------------------------------------------------------
// Random powerup

//datablock SFXProfile(PuRandomVoiceSfx)
//{
//   filename    = "~/data/sound/puRandomVoice.wav";
//   description = Audio2D;
//   preload = true;
//};

//datablock ItemData(RandomPowerUpItem)
//{
//   // Mission editor category
//   category = "Powerups";
//   className = "PowerUp";

//   // Basic Item properties
//   shapeFile = "~/data/shapes/items/random.dts";
//   mass = 1;
//   friction = 1;
//   elasticity = 0.3;
//   emap = false;

//   // Dynamic properties defined by the scripts
//   noRespawn = false;
//   maxInventory = 1;
//};

//function RandomPowerUpItem::onPickup(%this,%obj,%user,%amount)
//{
//   %pupIdx = getRandom(1,5);
//   switch (%pupIdx)
//   {
//      case 1:
//         %pup = SuperJumpItem;
//      case 2:
//         %pup = SuperSpeedItem;
//      case 3:
//         %pup = HelicopterItem;
//      case 4:
//         %pup = BlastItem;
//      case 5:
//         %pup = MegaMarbleItem;
//   }
//    return PowerUp::onPickup(%pup.getId(),%obj,%user,%amount);
//}