//-----------------------------------------------------------------------------
// Called once the game has started
//-----------------------------------------------------------------------------
function startGame()
{
    if ($Game::Running)
    {
        error("startGame(): End the game first!");
        return;
    }

    $Game::Running = true;
    $Game::Qualified = false;

   if (MissionInfo.gameMode $= "Hunt" ||  MissionInfo.gameMode $= "Sumo" ||  MissionInfo.gameMode $= "Scrum")
      $Game::Duration = MissionInfo.time;

   onMissionReset();

   resetAvgPlayerCount();
}

//-----------------------------------------------------------------------------
// Called once the game has ended
//-----------------------------------------------------------------------------
function endGame()
{
   if (!$Game::Running)
   {
      error("endGame(): No game running!");
      return;
   }

   // Inform the client the game is over
   for( %clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++ )
   {
      %cl = ClientGroup.getObject( %clientIndex );
      commandToClient(%cl, 'GameEnd');
   }

   // Delete all the temporary mission objects
   resetMission();
   $Game::Running = false;
}