// SERVER LOBBY SCRIPTS

//----------------------------------------------------------------------------
// Create a Lobby singleton
//----------------------------------------------------------------------------
function Create_Lobby()
{
   // If there is a lobby, complain about it
   if(isObject(TheLobby))
   {
      error("Lobby: There should not be a lobby right now...nuking it");
      TheLobby.delete();
   }
   
   new ScriptObject(TheLobby)
   {
      class = "Lobby";
   };
   
   return true;
}

// Used by several game scripts
function serverIsInLobby()
{
   return (MissionInfo.gameMode $= "Lobby");
}

//----------------------------------------------------------------------------
// Lifecycle
//----------------------------------------------------------------------------
function Lobby::onAdd(%this)
{
   echo("Lobby: Created the lobby!");
   
   // HAX -- Set a default next mission.
   %this.setNextMission("levels/curvetest.mis");
   
   // HAX -- 3 seconds of countdown time?
   %this.CountdownTime = 3000;
}

function Lobby::onRemove(%this)
{
   echo("Lobby: Destroyed the lobby!");
}

//----------------------------------------------------------------------------
// Change the ready-state of a player
//----------------------------------------------------------------------------
function Lobby::setReady(%this, %client, %readyState)
{
   // Update the ready state for this client
   %client.isReady = %readyState;

   // Update the attached "Ready" effect state
   if(isObject(%client.player))
   {
      echo("TODO: Change-up the ready effect (particles or whatever)");
   }
   
   // Iterate clients, and see if everyone is ready
   echo("Checking readystates...");
   %isEveryoneReady = true;
   for(%clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++)
   {
      %cl = ClientGroup.getObject(%clientIndex);
      
      if(!%cl.isReady)
      {
         %isEveryoneReady = false;
         break;
      }
      
      echo("   " @ %cl.nameBase @ " readystate: " @ %cl.isReady @ " [" @ %isEveryoneReady @ "]");
   }
   
   %this.setEveryoneReady(%isEveryoneReady);
}
function serverCmdLobbySetReady(%client, %readyState)
{
   TheLobby.setReady(%client, %readyState);
}

//----------------------------------------------------------------------------
// Get/Set everyone ready state
//----------------------------------------------------------------------------
function Lobby::setEveryoneReady(%this, %isEveryoneReady)
{
   // If this is a change from the current state
   if(%this.isEveryoneReady() != %isEveryoneReady)
   {
      // Set ready state
      %this._isEveryoneReady = %isEveryoneReady;
   
      // TODO: Check for ClientGroup.getCount() > some number 
      // such that the host doesn't just start the game right away and start
      // racking up points
      //
      // If everyone is now ready
      if(%this.isEveryoneReady())
      {
         centerPrintAll("Everyone is ready! Mission starting...", 2, 2);
         
         // Start the countdown
         %this.schedule(%this.CountdownTime, startNextMission);
      }
   }
}

function Lobby::isEveryoneReady(%this)
{
   return %this._isEveryoneReady;
}

//----------------------------------------------------------------------------
// Set/get the next mission
//----------------------------------------------------------------------------
function Lobby::setNextMission(%this, %missionFile)
{
   // If this is a true change...
   if (%this.getNextMission() !$= %missionFile)
   {
      // Assign next mission file
      %this._nextMissionFile = %missionFile;
      
      // Inform all clients what the next level will be
      for(%clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++)
      {
         %cl = ClientGroup.getObject(%clientIndex);
         commandToClient(%cl, 'SetNextMission', %missionFile);
      }
      
      // TODO: Change the server-query Mission Name properly
      $Server::MissionName = "The Next Mission in the Lobby";
   }
}
function serverCmdLobbySetLevel(%client, %missionFile)
{
   // Only admins allowed to assign a level
   if (%client.isAdmin)
   {
      TheLobby.setNextMission(%missionFile);   
   }
}

function Lobby::getNextMission(%this)
{
   return %this._nextMissionFile;
}

//----------------------------------------------------------------------------
// Start the next mission
//----------------------------------------------------------------------------
function Lobby::startNextMission(%this)
{
   echo("Lobby: Now starting next mission: " @ %this.getNextMission());
   loadMission(%this.getNextMission());
}

//----------------------------------------------------------------------------
// Lobby Preview Item Methods
//----------------------------------------------------------------------------
function LobbyPreviewItem::onAdd(%this, %obj)
{
   // Assign preview material -- This doesn't work for some reason
   %obj.schedule(0, "setSkinNameMbfDlc", "lobby_level_preview_mat");
}

function LobbyPreviewItem::onPickup(%this,%obj,%user,%amount)
{
   // Don't trigger this twice for this user
   %obj.setCollisionTimeout(%user);
   
   // User just ran into this level, lets assume that means they
   // want to vote for it!
   %missionName = %this.missionName;
   echo(%user @ " just voted for '" @ %missionName @ "' by smashing into it!");
   TheLobby.setNextMission(%missionName);
   
   return true;
}

// Lobby Trigger Methods
function LobbyReadyUpTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // This client is ready!
   %controlClient = %obj.getControllingClient();
   TheLobby.setReady(%controlClient, true);
}